/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core;

import androidx.compose.Emittable;
import androidx.ui.core.ErrorMessages;
import androidx.ui.core.LayoutNode;
import androidx.ui.core.Owner;
import androidx.ui.core.RepaintBoundaryNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010)\u001a\u00020(H\u0016J\u0018\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u0001H\u0016J \u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u00100\u001a\u00020(2\u0006\u0010+\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0011\u00101\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\fH\u0086\u0002J\u001d\u00102\u001a\u00020(2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020(04H\u0086\bJ\u001d\u00105\u001a\u00020(2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020(04H\u0086\bR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000e\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\u0004\u0018\u00010\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0000@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\nR\u0016\u0010#\u001a\u0004\u0018\u00010$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u0082\u0001\u0007$678\b9:\u00a8\u0006;"}, d2={"Landroidx/ui/core/ComponentNode;", "Landroidx/compose/Emittable;", "()V", "children", "", "getChildren$ui_platform_release", "()Ljava/util/List;", "containingLayoutNode", "Landroidx/ui/core/LayoutNode;", "getContainingLayoutNode", "()Landroidx/ui/core/LayoutNode;", "count", "", "getCount", "()I", "depth", "getDepth", "setDepth", "(I)V", "<set-?>", "Landroidx/ui/core/Owner;", "owner", "getOwner", "()Landroidx/ui/core/Owner;", "ownerData", "", "getOwnerData", "()Ljava/lang/Object;", "setOwnerData", "(Ljava/lang/Object;)V", "parent", "getParent", "()Landroidx/ui/core/ComponentNode;", "parentLayoutNode", "getParentLayoutNode", "repaintBoundary", "Landroidx/ui/core/RepaintBoundaryNode;", "getRepaintBoundary", "()Landroidx/ui/core/RepaintBoundaryNode;", "attach", "", "detach", "emitInsertAt", "index", "instance", "emitMove", "from", "to", "emitRemoveAt", "get", "visitChildren", "block", "Lkotlin/Function1;", "visitChildrenReverse", "Landroidx/ui/core/PointerInputNode;", "Landroidx/ui/core/FocusNode;", "Landroidx/ui/core/DrawNode;", "Landroidx/ui/core/SemanticsComponentNode;", "Landroidx/ui/core/DataNode;", "ui-platform_release"})
public abstract class ComponentNode
implements Emittable {
    @NotNull
    private final List<ComponentNode> children;
    @Nullable
    private ComponentNode parent;
    @Nullable
    private Owner owner;
    private int depth;
    @Nullable
    private Object ownerData;

    @NotNull
    public final List<ComponentNode> getChildren$ui_platform_release() {
        return this.children;
    }

    @Nullable
    public final ComponentNode getParent() {
        return this.parent;
    }

    @Nullable
    public final Owner getOwner() {
        return this.owner;
    }

    public final int getDepth() {
        return this.depth;
    }

    public final void setDepth(int n) {
        this.depth = n;
    }

    @Nullable
    public final Object getOwnerData() {
        return this.ownerData;
    }

    public final void setOwnerData(@Nullable Object object) {
        this.ownerData = object;
    }

    public final int getCount() {
        return this.children.size();
    }

    @Nullable
    public LayoutNode getParentLayoutNode() {
        return this.getContainingLayoutNode();
    }

    @Nullable
    protected LayoutNode getContainingLayoutNode() {
        ComponentNode componentNode = this.parent;
        return componentNode != null ? componentNode.getContainingLayoutNode() : null;
    }

    @Nullable
    public RepaintBoundaryNode getRepaintBoundary() {
        ComponentNode componentNode = this.parent;
        return componentNode != null ? componentNode.getRepaintBoundary() : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitChildren(@NotNull Function1<? super ComponentNode, Unit> block) {
        int $i$f$visitChildren = 0;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        int n = 0;
        int n2 = this.getCount();
        while (n < n2) {
            void i;
            block.invoke((Object)this.get((int)i));
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void visitChildrenReverse(@NotNull Function1<? super ComponentNode, Unit> block) {
        int $i$f$visitChildrenReverse = 0;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        int n = this.getCount() - 1;
        boolean bl = false;
        while (n >= 0) {
            void i;
            block.invoke((Object)this.get((int)i));
            --i;
        }
    }

    public void emitInsertAt(int index, @NotNull Emittable instance) {
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        if (!(instance instanceof ComponentNode)) {
            ErrorMessages this_$iv = ErrorMessages.OnlyComponents;
            boolean $i$f$state = false;
            throw (Throwable)new IllegalStateException(this_$iv.getMessage());
        }
        ErrorMessages this_$iv = ErrorMessages.ComponentNodeHasParent;
        boolean check$iv = ((ComponentNode)instance).parent == null;
        boolean $i$f$validateState = false;
        if (!check$iv) {
            ErrorMessages this_$iv$iv = this_$iv;
            boolean $i$f$state = false;
            throw (Throwable)new IllegalStateException(this_$iv$iv.getMessage());
        }
        this_$iv = ErrorMessages.OwnerAlreadyAttached;
        check$iv = ((ComponentNode)instance).owner == null;
        $i$f$validateState = false;
        if (!check$iv) {
            ErrorMessages this_$iv$iv = this_$iv;
            boolean $i$f$state = false;
            throw (Throwable)new IllegalStateException(this_$iv$iv.getMessage());
        }
        ((ComponentNode)instance).parent = this;
        this.children.add(index, (ComponentNode)instance);
        Owner owner = this.owner;
        if (owner != null) {
            ((ComponentNode)instance).attach(owner);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void emitRemoveAt(int index, int count) {
        ErrorMessages errorMessages = ErrorMessages.CountOutOfRange;
        int check$iv = count >= 0 ? 1 : 0;
        boolean $i$f$validateArg = false;
        if (check$iv == 0) {
            String string;
            void this_$iv$iv;
            void this_$iv;
            void var6_7 = this_$iv;
            int[] args$iv$iv = new int[]{count};
            boolean $i$f$arg = false;
            String string2 = this_$iv$iv.getMessage();
            Object[] objectArray = ErrorMessages.access$toAnyArray((ErrorMessages)this_$iv$iv, args$iv$iv);
            Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
            String string4 = string = string3;
            throw (Throwable)new IllegalArgumentException(string4);
        }
        boolean attached = this.owner != null;
        check$iv = index + count - 1;
        int n = index;
        if (check$iv >= n) {
            while (true) {
                void i;
                ComponentNode child = this.children.remove((int)i);
                if (attached) {
                    child.detach();
                }
                child.parent = null;
                if (i == n) break;
                --i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void emitMove(int from, int to, int count) {
        block2: {
            if (from == to) {
                return;
            }
            int n = 0;
            int n2 = count;
            while (n < n2) {
                void i;
                int fromIndex = from > to ? from + i : from;
                int toIndex = from > to ? to + i : to + count - 2;
                ComponentNode child = this.children.remove(fromIndex);
                this.children.add(toIndex, child);
                ++i;
            }
            LayoutNode layoutNode2 = this.getContainingLayoutNode();
            if (layoutNode2 == null) break block2;
            layoutNode2.setLayoutChildrenDirty$ui_platform_release(true);
        }
    }

    @NotNull
    public final ComponentNode get(int index) {
        return this.children.get(index);
    }

    /*
     * WARNING - void declaration
     */
    public void attach(@NotNull Owner owner) {
        ComponentNode this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        ErrorMessages errorMessages = ErrorMessages.OwnerAlreadyAttached;
        boolean check$iv22 = this.owner == null;
        boolean $i$f$validateState = false;
        if (!check$iv22) {
            void this_$iv2;
            void this_$iv$iv = this_$iv2;
            boolean $i$f$state = false;
            throw (Throwable)new IllegalStateException(this_$iv$iv.getMessage());
        }
        ComponentNode parent = this.parent;
        ErrorMessages check$iv22 = ErrorMessages.ParentOwnerMustMatchChild;
        boolean check$iv = parent == null || Intrinsics.areEqual((Object)parent.owner, (Object)owner);
        int $i$f$validateState2 = 0;
        if (!check$iv) {
            void this_$iv$iv = this_$iv;
            boolean $i$f$state = false;
            throw (Throwable)new IllegalStateException(this_$iv$iv.getMessage());
        }
        this.owner = owner;
        ComponentNode componentNode = parent;
        this.depth = (componentNode != null ? componentNode.depth : -1) + 1;
        owner.onAttach(this);
        this_$iv = this;
        boolean $i$f$visitChildren = false;
        $i$f$validateState2 = 0;
        int n = this_$iv.getCount();
        while ($i$f$validateState2 < n) {
            void i$iv;
            ComponentNode child = this_$iv.get((int)i$iv);
            boolean bl = false;
            child.attach(owner);
            ++i$iv;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void detach() {
        ComponentNode this_$iv = this;
        boolean $i$f$visitChildren = false;
        int n = 0;
        int n2 = this_$iv.getCount();
        while (n < n2) {
            void i$iv;
            ComponentNode child = this_$iv.get((int)i$iv);
            boolean bl = false;
            child.detach();
            ++i$iv;
        }
        Owner owner = this.owner;
        if (owner == null) {
            ErrorMessages this_$iv2 = ErrorMessages.OwnerAlreadyDetached;
            boolean $i$f$state = false;
            throw (Throwable)new IllegalStateException(this_$iv2.getMessage());
        }
        Owner owner2 = owner;
        owner2.onDetach(this);
        this.owner = null;
        this.depth = 0;
    }

    private ComponentNode() {
        List list;
        ComponentNode componentNode = this;
        boolean bl = false;
        componentNode.children = list = (List)new ArrayList();
    }

    public /* synthetic */ ComponentNode(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

