/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core;

import androidx.ui.core.ComponentNode;
import androidx.ui.core.FocusNode$WhenMappings;
import androidx.ui.core.LayoutCoordinates;
import androidx.ui.core.Owner;
import androidx.ui.core.Ref;
import androidx.ui.core.focus.FocusNodeUtilsKt;
import androidx.ui.focus.FocusDetailedState;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%H\u0016J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020\u0005H\u0016J\u0006\u0010*\u001a\u00020'J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020'H\u0002J\u0010\u0010-\u001a\u00020\u00052\b\b\u0002\u0010,\u001a\u00020'J\u0018\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020\u00002\u0006\u0010,\u001a\u00020'H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR4\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u001d2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00060"}, d2={"Landroidx/ui/core/FocusNode;", "Landroidx/ui/core/ComponentNode;", "()V", "_recompose", "Lkotlin/Function0;", "", "<set-?>", "Landroidx/ui/focus/FocusDetailedState;", "focusState", "getFocusState", "()Landroidx/ui/focus/FocusDetailedState;", "setFocusState$ui_platform_release", "(Landroidx/ui/focus/FocusDetailedState;)V", "focusableChildren", "", "focusedChild", "layoutCoordinates", "Landroidx/ui/core/LayoutCoordinates;", "layoutCoordinates$annotations", "getLayoutCoordinates", "()Landroidx/ui/core/LayoutCoordinates;", "setLayoutCoordinates", "(Landroidx/ui/core/LayoutCoordinates;)V", "value", "recompose", "getRecompose", "()Lkotlin/jvm/functions/Function0;", "setRecompose", "(Lkotlin/jvm/functions/Function0;)V", "Landroidx/ui/core/Ref;", "ref", "getRef", "()Landroidx/ui/core/Ref;", "setRef", "(Landroidx/ui/core/Ref;)V", "attach", "owner", "Landroidx/ui/core/Owner;", "captureFocus", "", "clearFocus", "detach", "freeFocus", "grantFocus", "propagateFocus", "requestFocus", "requestFocusForChild", "childNode", "ui-platform_release"})
public final class FocusNode
extends ComponentNode {
    private Function0<Unit> _recompose;
    @NotNull
    private FocusDetailedState focusState = FocusDetailedState.Inactive;
    @Nullable
    private LayoutCoordinates layoutCoordinates;
    private final Set<FocusNode> focusableChildren;
    private FocusNode focusedChild;

    @Nullable
    public final Ref<FocusNode> getRef() {
        return null;
    }

    public final void setRef(@Nullable Ref<FocusNode> value) {
        block0: {
            Ref<FocusNode> ref = value;
            if (ref == null) break block0;
            ref.setValue(this);
        }
    }

    @NotNull
    public final Function0<Unit> getRecompose() {
        Function0<Unit> function0 = this._recompose;
        if (function0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_recompose");
        }
        return function0;
    }

    public final void setRecompose(@NotNull Function0<Unit> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this._recompose = value;
    }

    @NotNull
    public final FocusDetailedState getFocusState() {
        return this.focusState;
    }

    public final void setFocusState$ui_platform_release(@NotNull FocusDetailedState focusDetailedState) {
        Intrinsics.checkParameterIsNotNull((Object)focusDetailedState, (String)"<set-?>");
        this.focusState = focusDetailedState;
    }

    public static /* synthetic */ void layoutCoordinates$annotations() {
    }

    @Nullable
    public final LayoutCoordinates getLayoutCoordinates() {
        return this.layoutCoordinates;
    }

    public final void setLayoutCoordinates(@Nullable LayoutCoordinates layoutCoordinates) {
        this.layoutCoordinates = layoutCoordinates;
    }

    @Override
    public void attach(@NotNull Owner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Object object = FocusNodeUtilsKt.findParentFocusNode(this);
        if (object != null && (object = ((FocusNode)object).focusableChildren) != null) {
            object.add(this);
        }
        super.attach(owner);
    }

    @Override
    public void detach() {
        block0: {
            super.detach();
            Object object = FocusNodeUtilsKt.findParentFocusNode(this);
            if (object == null || (object = ((FocusNode)object).focusableChildren) == null) break block0;
            object.remove(this);
        }
    }

    public final void requestFocus(boolean propagateFocus) {
        switch (FocusNode$WhenMappings.$EnumSwitchMapping$0[this.focusState.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return;
            }
            case 4: {
                if (propagateFocus) break;
                FocusNode focusNode = this.focusedChild;
                if (!(focusNode != null ? focusNode.clearFocus() : true)) break;
                this.grantFocus(propagateFocus);
                break;
            }
            case 5: {
                FocusNode focusParent = FocusNodeUtilsKt.findParentFocusNode(this);
                if (focusParent == null) {
                    this.grantFocus(propagateFocus);
                    this.getRecompose().invoke();
                    break;
                }
                focusParent.requestFocusForChild(this, propagateFocus);
            }
        }
    }

    public static /* synthetic */ void requestFocus$default(FocusNode focusNode, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        focusNode.requestFocus(bl);
    }

    public final boolean captureFocus() {
        if (this.focusState == FocusDetailedState.Active) {
            this.focusState = FocusDetailedState.Captured;
            return true;
        }
        return false;
    }

    public final boolean freeFocus() {
        if (this.focusState == FocusDetailedState.Captured) {
            this.focusState = FocusDetailedState.Active;
            return true;
        }
        return false;
    }

    private final void grantFocus(boolean propagateFocus) {
        FocusNode focusedCandidate = (FocusNode)CollectionsKt.firstOrNull((Iterable)this.focusableChildren);
        if (focusedCandidate == null || !propagateFocus) {
            this.focusState = FocusDetailedState.Active;
        } else {
            this.focusState = FocusDetailedState.ActiveParent;
            this.focusedChild = focusedCandidate;
            focusedCandidate.grantFocus(propagateFocus);
            focusedCandidate.getRecompose().invoke();
        }
    }

    private final boolean clearFocus() {
        boolean bl;
        switch (FocusNode$WhenMappings.$EnumSwitchMapping$1[this.focusState.ordinal()]) {
            case 1: {
                this.focusState = FocusDetailedState.Inactive;
                bl = true;
                break;
            }
            case 2: {
                FocusNode focusNode = this.focusedChild;
                if (focusNode != null) {
                    bl = focusNode.clearFocus();
                    break;
                }
                String string = "No Focused Child";
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            case 3: {
                bl = false;
                break;
            }
            case 4: 
            case 5: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean requestFocusForChild(FocusNode childNode, boolean propagateFocus) {
        boolean bl;
        if (!this.focusableChildren.contains(childNode)) {
            String string = "Non child node cannot request focus.";
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        switch (FocusNode$WhenMappings.$EnumSwitchMapping$2[this.focusState.ordinal()]) {
            case 1: {
                this.focusState = FocusDetailedState.ActiveParent;
                this.focusedChild = childNode;
                childNode.grantFocus(propagateFocus);
                this.getRecompose().invoke();
                bl = true;
                break;
            }
            case 2: {
                FocusNode focusNode = this.focusedChild;
                if (focusNode == null) {
                    String string = "no focusedChild found";
                    boolean bl3 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                FocusNode previouslyFocusedNode = focusNode;
                if (previouslyFocusedNode.clearFocus()) {
                    this.focusedChild = childNode;
                    childNode.grantFocus(propagateFocus);
                    previouslyFocusedNode.getRecompose().invoke();
                    childNode.getRecompose().invoke();
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                FocusNode focusParent = FocusNodeUtilsKt.findParentFocusNode(this);
                if (focusParent == null) {
                    FocusNodeUtilsKt.requestFocusForOwner(this);
                    if (FocusNodeUtilsKt.ownerHasFocus(this)) {
                        this.focusState = FocusDetailedState.Active;
                        bl = this.requestFocusForChild(childNode, propagateFocus);
                        break;
                    }
                    bl = false;
                    break;
                }
                if (focusParent.requestFocusForChild(this, false)) {
                    bl = this.requestFocusForChild(childNode, propagateFocus);
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                bl = false;
                break;
            }
            case 5: {
                String string = "non root FocusNode needs a focusable parent";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public FocusNode() {
        super(null);
        Set set;
        FocusNode focusNode = this;
        boolean bl = false;
        focusNode.focusableChildren = set = (Set)new LinkedHashSet();
    }
}

