/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core;

import android.graphics.Outline;
import android.graphics.Path;
import androidx.ui.core.Density;
import androidx.ui.core.Dp;
import androidx.ui.core.Px;
import androidx.ui.core.PxSize;
import androidx.ui.core.RepaintBoundaryNode;
import androidx.ui.engine.geometry.Outline;
import androidx.ui.engine.geometry.RRect;
import androidx.ui.engine.geometry.Rect;
import androidx.ui.engine.geometry.Shape;
import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006J\u0016\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Landroidx/ui/core/OutlineResolver;", "", "density", "Landroidx/ui/core/Density;", "(Landroidx/ui/core/Density;)V", "cachedOutline", "Landroid/graphics/Outline;", "clipToOutline", "", "getClipToOutline", "()Z", "clipToShape", "hasElevation", "hasOutline", "getHasOutline", "manualClipPath", "Landroid/graphics/Path;", "getManualClipPath", "()Landroid/graphics/Path;", "outlinePath", "shape", "Landroidx/ui/engine/geometry/Shape;", "size", "Landroidx/ui/core/PxSize;", "applyTo", "", "outline", "update", "node", "Landroidx/ui/core/RepaintBoundaryNode;", "updateCache", "updateCacheWithPath", "composePath", "Landroidx/ui/graphics/Path;", "updateCacheWithRRect", "rrect", "Landroidx/ui/engine/geometry/RRect;", "updateCacheWithRect", "rect", "Landroidx/ui/engine/geometry/Rect;", "ui-platform_release"})
final class OutlineResolver {
    private final Outline cachedOutline;
    private PxSize size;
    private Shape shape;
    private boolean clipToShape;
    private boolean hasElevation;
    private Path outlinePath;
    private final Density density;

    public final boolean getHasOutline() {
        return !this.cachedOutline.isEmpty();
    }

    public final boolean getClipToOutline() {
        return this.clipToShape && this.getManualClipPath() == null;
    }

    @Nullable
    public final Path getManualClipPath() {
        return this.clipToShape ? this.outlinePath : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull RepaintBoundaryNode node, @NotNull PxSize size) {
        block3: {
            void other$iv;
            void this_$iv;
            void $this$dp$iv22;
            Dp dp;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
            boolean cacheIsDirty = false;
            if (Intrinsics.areEqual((Object)node.getShape(), (Object)this.shape) ^ true) {
                this.shape = node.getShape();
                cacheIsDirty = true;
            }
            if (Intrinsics.areEqual((Object)this.size, (Object)size) ^ true) {
                this.size = size;
                cacheIsDirty = true;
            }
            Dp dp2 = node.getElevation();
            boolean bl = false;
            OutlineResolver outlineResolver = this;
            Dp $this$dp$iv22 = dp = new Dp((float)$this$dp$iv22);
            int n = Float.compare(this_$iv.getValue(), other$iv.getValue());
            outlineResolver.hasElevation = n > 0;
            boolean bl2 = this.clipToShape = this.shape != null && node.getClipToShape();
            if (!cacheIsDirty) break block3;
            this.outlinePath = null;
            Shape shape = this.shape;
            if (shape != null) {
                dp2 = shape;
                boolean bl3 = false;
                boolean bl4 = false;
                Dp it = dp2;
                boolean bl5 = false;
                this.updateCache((Shape)it);
            }
        }
    }

    public final void applyTo(@NotNull Outline outline) {
        Intrinsics.checkParameterIsNotNull((Object)outline, (String)"outline");
        if (this.shape == null) {
            throw (Throwable)new IllegalStateException("Cache is dirty!");
        }
        outline.set(this.cachedOutline);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateCache(Shape shape) {
        androidx.ui.engine.geometry.Outline outline;
        androidx.ui.engine.geometry.Outline outline2;
        void $this$px$iv;
        PxSize this_$iv22 = this.size;
        long value$iv$iv = this_$iv22.getValue();
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv >> 32);
        boolean bl = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n);
        boolean this_$iv22 = false;
        Px px = new Px($this$px$iv$iv);
        Px px2 = new Px((float)$this$px$iv);
        if (Intrinsics.areEqual((Object)px, (Object)px2)) {
            PxSize this_$iv = this.size;
            value$iv$iv = this_$iv.getValue();
            floatCompanionObject = FloatCompanionObject.INSTANCE;
            n = (int)(value$iv$iv & 0xFFFFFFFFL);
            bl = false;
            $this$px$iv$iv = Float.intBitsToFloat(n);
            this_$iv22 = false;
            px = new Px($this$px$iv$iv);
            px2 = new Px((float)$this$px$iv);
            if (Intrinsics.areEqual((Object)px, (Object)px2)) {
                this.cachedOutline.setEmpty();
                return;
            }
        }
        if ((outline2 = (outline = shape.createOutline(this.size, this.density))) instanceof Outline.Rectangle) {
            this.updateCacheWithRect(((Outline.Rectangle)outline).getRect());
        } else if (outline2 instanceof Outline.Rounded) {
            this.updateCacheWithRRect(((Outline.Rounded)outline).getRrect());
        } else if (outline2 instanceof Outline.Generic) {
            this.updateCacheWithPath(((Outline.Generic)outline).getPath());
        }
    }

    private final void updateCacheWithRect(Rect rect) {
        this.cachedOutline.setRect(MathKt.roundToInt((float)rect.getLeft()), MathKt.roundToInt((float)rect.getTop()), MathKt.roundToInt((float)rect.getRight()), MathKt.roundToInt((float)rect.getBottom()));
    }

    private final void updateCacheWithRRect(RRect rrect) {
        float radius = rrect.getTopLeftRadiusX();
        if (radius == rrect.getTopLeftRadiusY() && radius == rrect.getTopRightRadiusX() && radius == rrect.getTopRightRadiusY() && radius == rrect.getBottomRightRadiusX() && radius == rrect.getBottomRightRadiusY() && radius == rrect.getBottomLeftRadiusX() && radius == rrect.getBottomLeftRadiusY()) {
            this.cachedOutline.setRoundRect(MathKt.roundToInt((float)rrect.getLeft()), MathKt.roundToInt((float)rrect.getTop()), MathKt.roundToInt((float)rrect.getRight()), MathKt.roundToInt((float)rrect.getBottom()), radius);
        } else {
            androidx.ui.graphics.Path path = new androidx.ui.graphics.Path(null, 1, null);
            OutlineResolver outlineResolver = this;
            boolean bl = false;
            boolean bl2 = false;
            androidx.ui.graphics.Path $this$apply = path;
            boolean bl3 = false;
            $this$apply.addRRect(rrect);
            androidx.ui.graphics.Path path2 = path;
            outlineResolver.updateCacheWithPath(path2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void updateCacheWithPath(androidx.ui.graphics.Path composePath) {
        Path path = composePath.toFrameworkPath();
        if (this.hasElevation) {
            if (!path.isConvex()) throw (Throwable)new IllegalStateException("Only convex paths can be used for drawing the shadow!");
            this.cachedOutline.setConvexPath(path);
        } else {
            this.cachedOutline.setEmpty();
        }
        this.outlinePath = path;
    }

    public OutlineResolver(@NotNull Density density) {
        Outline outline;
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        this.density = density;
        Outline outline2 = new Outline();
        OutlineResolver outlineResolver = this;
        boolean bl = false;
        boolean bl2 = false;
        Outline $this$apply = outline2;
        boolean bl3 = false;
        $this$apply.setAlpha(1.0f);
        outlineResolver.cachedOutline = outline = outline2;
        this.size = PxSize.Companion.getZero();
    }
}

