/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RecordingCanvas;
import android.graphics.RenderNode;
import androidx.ui.core.AndroidComposeView;
import androidx.ui.core.ComponentNode;
import androidx.ui.core.Density;
import androidx.ui.core.DensityKt;
import androidx.ui.core.DensityScope;
import androidx.ui.core.ElevationHandler;
import androidx.ui.core.OutlineResolver;
import androidx.ui.core.Px;
import androidx.ui.core.PxSize;
import androidx.ui.core.RepaintBoundary;
import androidx.ui.core.RepaintBoundaryNode;
import androidx.ui.graphics.Canvas;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020$H\u0016J\b\u0010*\u001a\u00020$H\u0016J\u0018\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0016J\b\u0010/\u001a\u00020$H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00060"}, d2={"Landroidx/ui/core/RepaintBoundaryRenderNode;", "Landroidx/ui/core/RepaintBoundary;", "ownerView", "Landroidx/ui/core/AndroidComposeView;", "parentElevationHandler", "Landroidx/ui/core/ElevationHandler;", "repaintBoundaryNode", "Landroidx/ui/core/RepaintBoundaryNode;", "(Landroidx/ui/core/AndroidComposeView;Landroidx/ui/core/ElevationHandler;Landroidx/ui/core/RepaintBoundaryNode;)V", "clipPath", "Landroid/graphics/Path;", "density", "Landroidx/ui/core/Density;", "value", "", "dirty", "getDirty", "()Z", "setDirty", "(Z)V", "hasSize", "outline", "Landroid/graphics/Outline;", "outlineResolver", "Landroidx/ui/core/OutlineResolver;", "getOwnerView", "()Landroidx/ui/core/AndroidComposeView;", "getParentElevationHandler", "()Landroidx/ui/core/ElevationHandler;", "renderNode", "Landroid/graphics/RenderNode;", "getRenderNode", "()Landroid/graphics/RenderNode;", "getRepaintBoundaryNode", "()Landroidx/ui/core/RepaintBoundaryNode;", "attach", "", "parent", "callDraw", "canvas", "Landroidx/ui/graphics/Canvas;", "detach", "onParamsChange", "setSize", "width", "", "height", "updateDisplayList", "ui-platform_release"})
@TargetApi(value=29)
final class RepaintBoundaryRenderNode
implements RepaintBoundary {
    private boolean dirty;
    @NotNull
    private final RenderNode renderNode;
    private final Outline outline;
    private final Density density;
    private final OutlineResolver outlineResolver;
    private Path clipPath;
    private boolean hasSize;
    @NotNull
    private final AndroidComposeView ownerView;
    @NotNull
    private final ElevationHandler parentElevationHandler;
    @NotNull
    private final RepaintBoundaryNode repaintBoundaryNode;

    @Override
    public boolean getDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean value) {
        if (value && !this.dirty) {
            this.ownerView.invalidate();
            Collection collection = this.ownerView.getDirtyRepaintBoundaryNodes$ui_platform_release();
            RepaintBoundaryNode repaintBoundaryNode = this.repaintBoundaryNode;
            boolean bl = false;
            collection.add(repaintBoundaryNode);
        }
        this.dirty = value;
    }

    @NotNull
    public final RenderNode getRenderNode() {
        return this.renderNode;
    }

    @Override
    public void setSize(int width, int height) {
        if (width != this.renderNode.getWidth() || height != this.renderNode.getHeight()) {
            this.renderNode.setPosition(0, 0, width, height);
            this.onParamsChange();
        } else if (!this.hasSize) {
            this.onParamsChange();
        }
        this.hasSize = true;
        this.setDirty(true);
    }

    @Override
    public void attach(@Nullable RepaintBoundary parent) {
        this.hasSize = false;
    }

    @Override
    public void detach() {
        block0: {
            ComponentNode componentNode = this.repaintBoundaryNode.getParent();
            if (componentNode == null) break block0;
            ComponentNode componentNode2 = componentNode;
            boolean bl = false;
            boolean bl2 = false;
            ComponentNode it = componentNode2;
            boolean bl3 = false;
            this.ownerView.invalidateRepaintBoundary$ui_platform_release(it);
        }
    }

    @Override
    public void callDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        boolean bl = this.hasSize;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "setSize() should be called before drawing the RepaintBoundary";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this.renderNode.getAlpha() > 0.0f) {
            android.graphics.Canvas androidCanvas = canvas.getNativeCanvas();
            if (androidCanvas.isHardwareAccelerated()) {
                this.updateDisplayList();
                androidCanvas.drawRenderNode(this.renderNode);
            } else {
                this.ownerView.callChildDraw$ui_platform_release(androidCanvas, this.repaintBoundaryNode);
                this.setDirty(false);
            }
        }
    }

    @Override
    public void updateDisplayList() {
        if (this.getDirty() || !this.renderNode.hasDisplayList()) {
            RecordingCanvas recordingCanvas = this.renderNode.beginRecording();
            Intrinsics.checkExpressionValueIsNotNull((Object)recordingCanvas, (String)"renderNode.beginRecording()");
            RecordingCanvas canvas = recordingCanvas;
            Path path = this.clipPath;
            if (path != null) {
                Path path2 = path;
                boolean bl = false;
                boolean bl2 = false;
                Path it = path2;
                boolean bl3 = false;
                canvas.clipPath(it);
            }
            this.ownerView.callChildDraw$ui_platform_release((android.graphics.Canvas)canvas, this.repaintBoundaryNode);
            this.renderNode.endRecording();
            this.setDirty(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onParamsChange() {
        long l;
        void val1$iv$iv;
        void width$iv;
        int $this$px$iv22 = this.renderNode.getWidth();
        Px $this$px$iv22 = new Px((float)$this$px$iv22);
        int $this$px$iv = this.renderNode.getHeight();
        Px height$iv = new Px((float)$this$px$iv);
        float f = width$iv.getValue();
        float val2$iv$iv = height$iv.getValue();
        void var6_10 = val1$iv$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var6_10);
        float f2 = val2$iv$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxSize size = new PxSize(l2);
        this.outlineResolver.update(this.repaintBoundaryNode, size);
        this.renderNode.setClipToOutline(this.outlineResolver.getClipToOutline() && this.outlineResolver.getHasOutline());
        if (this.outlineResolver.getHasOutline()) {
            Outline outline = this.outline;
            RenderNode renderNode = this.renderNode;
            boolean bl3 = false;
            boolean bl4 = false;
            Outline $this$apply = outline;
            boolean bl5 = false;
            this.outlineResolver.applyTo($this$apply);
            Outline outline2 = outline;
            renderNode.setOutline(outline2);
        } else {
            this.renderNode.setOutline(null);
        }
        if (this.outlineResolver.getManualClipPath() != this.clipPath) {
            this.clipPath = this.outlineResolver.getManualClipPath();
            this.setDirty(true);
        }
        this.renderNode.setAlpha(this.repaintBoundaryNode.getOpacity());
        this.renderNode.setElevation(((Number)DensityKt.withDensity((Density)this.density, (Function1)((Function1)new Function1<DensityScope, Float>(this){
            final /* synthetic */ RepaintBoundaryRenderNode this$0;

            public final float invoke(@NotNull DensityScope $this$withDensity) {
                Intrinsics.checkParameterIsNotNull((Object)$this$withDensity, (String)"$receiver");
                return $this$withDensity.toPx(this.this$0.getRepaintBoundaryNode().getElevation()).getValue();
            }
            {
                this.this$0 = repaintBoundaryRenderNode;
                super(1);
            }
        }))).floatValue());
        this.ownerView.invalidate();
    }

    @NotNull
    public final AndroidComposeView getOwnerView() {
        return this.ownerView;
    }

    @Override
    @NotNull
    public ElevationHandler getParentElevationHandler() {
        return this.parentElevationHandler;
    }

    @NotNull
    public final RepaintBoundaryNode getRepaintBoundaryNode() {
        return this.repaintBoundaryNode;
    }

    public RepaintBoundaryRenderNode(@NotNull AndroidComposeView ownerView, @NotNull ElevationHandler parentElevationHandler, @NotNull RepaintBoundaryNode repaintBoundaryNode) {
        RenderNode renderNode;
        Intrinsics.checkParameterIsNotNull((Object)ownerView, (String)"ownerView");
        Intrinsics.checkParameterIsNotNull((Object)parentElevationHandler, (String)"parentElevationHandler");
        Intrinsics.checkParameterIsNotNull((Object)repaintBoundaryNode, (String)"repaintBoundaryNode");
        this.ownerView = ownerView;
        this.parentElevationHandler = parentElevationHandler;
        this.repaintBoundaryNode = repaintBoundaryNode;
        this.dirty = true;
        RenderNode renderNode2 = new RenderNode(this.repaintBoundaryNode.getName());
        RepaintBoundaryRenderNode repaintBoundaryRenderNode = this;
        boolean bl = false;
        boolean bl2 = false;
        RenderNode $this$apply = renderNode2;
        boolean bl3 = false;
        $this$apply.setHasOverlappingRendering(true);
        repaintBoundaryRenderNode.renderNode = renderNode = renderNode2;
        this.outline = new Outline();
        Context context = this.ownerView.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ownerView.context");
        this.density = DensityKt.Density((Context)context);
        this.outlineResolver = new OutlineResolver(this.density);
    }
}

