/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core;

import android.content.Context;
import android.graphics.Outline;
import android.graphics.Path;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewParent;
import androidx.ui.core.AndroidComposeView;
import androidx.ui.core.Density;
import androidx.ui.core.DensityKt;
import androidx.ui.core.DensityScope;
import androidx.ui.core.ElevationHandler;
import androidx.ui.core.ElevationHandler29;
import androidx.ui.core.ElevationHandlerCompat;
import androidx.ui.core.OutlineResolver;
import androidx.ui.core.Px;
import androidx.ui.core.PxSize;
import androidx.ui.core.RepaintBoundary;
import androidx.ui.core.RepaintBoundaryNode;
import androidx.ui.core.RepaintBoundaryView;
import androidx.ui.graphics.Canvas;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000s\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t*\u0001\u0018\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020%H\u0016J\u0010\u0010+\u001a\u00020%2\u0006\u0010(\u001a\u00020,H\u0014J \u0010-\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020,2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0014J\u001e\u0010-\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J0\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u0002052\u0006\u00108\u001a\u000205H\u0014J\b\u00109\u001a\u00020%H\u0016J\u0018\u0010:\u001a\u00020%2\u0006\u0010;\u001a\u0002052\u0006\u0010<\u001a\u000205H\u0016J\b\u0010=\u001a\u00020%H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001dR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006>"}, d2={"Landroidx/ui/core/RepaintBoundaryView;", "Landroid/view/ViewGroup;", "Landroidx/ui/core/RepaintBoundary;", "ownerView", "Landroidx/ui/core/AndroidComposeView;", "ownerElevationHandler", "Landroidx/ui/core/ElevationHandler;", "repaintBoundaryNode", "Landroidx/ui/core/RepaintBoundaryNode;", "(Landroidx/ui/core/AndroidComposeView;Landroidx/ui/core/ElevationHandler;Landroidx/ui/core/RepaintBoundaryNode;)V", "clipPath", "Landroid/graphics/Path;", "density", "Landroidx/ui/core/Density;", "value", "", "dirty", "getDirty", "()Z", "setDirty", "(Z)V", "elevationHandler", "hasSize", "outlineProviderImpl", "androidx/ui/core/RepaintBoundaryView$outlineProviderImpl$1", "Landroidx/ui/core/RepaintBoundaryView$outlineProviderImpl$1;", "outlineResolver", "Landroidx/ui/core/OutlineResolver;", "getOwnerElevationHandler", "()Landroidx/ui/core/ElevationHandler;", "getOwnerView", "()Landroidx/ui/core/AndroidComposeView;", "parentElevationHandler", "getParentElevationHandler", "getRepaintBoundaryNode", "()Landroidx/ui/core/RepaintBoundaryNode;", "attach", "", "parent", "callDraw", "canvas", "Landroidx/ui/graphics/Canvas;", "detach", "dispatchDraw", "Landroid/graphics/Canvas;", "drawChild", "child", "Landroid/view/View;", "drawingTime", "", "onLayout", "changed", "l", "", "t", "r", "b", "onParamsChange", "setSize", "width", "height", "updateDisplayList", "ui-platform_release"})
final class RepaintBoundaryView
extends ViewGroup
implements RepaintBoundary {
    private final Density density;
    private final OutlineResolver outlineResolver;
    private final outlineProviderImpl.1 outlineProviderImpl;
    private Path clipPath;
    private boolean hasSize;
    private boolean dirty;
    private final ElevationHandler elevationHandler;
    @NotNull
    private final AndroidComposeView ownerView;
    @NotNull
    private final ElevationHandler ownerElevationHandler;
    @NotNull
    private final RepaintBoundaryNode repaintBoundaryNode;

    @Override
    public boolean getDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean value) {
        if (value && !this.dirty) {
            this.invalidate();
        }
        this.dirty = value;
    }

    @Override
    @NotNull
    public ElevationHandler getParentElevationHandler() {
        ViewParent parentView = this.getParent();
        return parentView instanceof RepaintBoundaryView ? ((RepaintBoundaryView)parentView).elevationHandler : this.ownerElevationHandler;
    }

    @Override
    public void setSize(int width, int height) {
        if (width != this.getWidth() || height != this.getHeight()) {
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
            this.measure(widthSpec, heightSpec);
            this.layout(0, 0, width, height);
            this.onParamsChange();
        } else if (!this.hasSize) {
            this.onParamsChange();
        }
        this.hasSize = true;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    @Override
    public void callDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        ViewParent parentView = this.getParent();
        long drawingTime = this.getDrawingTime();
        if (parentView instanceof RepaintBoundaryView) {
            ((RepaintBoundaryView)parentView).drawChild(canvas, (View)this, drawingTime);
        } else {
            this.ownerView.drawChild$ui_platform_release(canvas, (View)this, drawingTime);
        }
        this.setDirty(false);
    }

    @Override
    public void detach() {
        block1: {
            ViewParent viewParent = this.getParent();
            if (!(viewParent instanceof ViewGroup)) {
                viewParent = null;
            }
            ViewGroup viewGroup = (ViewGroup)viewParent;
            if (viewGroup == null) break block1;
            viewGroup.removeView((View)this);
        }
    }

    public final void drawChild(@NotNull Canvas canvas, @NotNull View child, long drawingTime) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        super.drawChild(canvas.getNativeCanvas(), child, drawingTime);
    }

    protected boolean drawChild(@NotNull android.graphics.Canvas canvas, @NotNull View child, long drawingTime) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        if (this.elevationHandler.handleDrawChild(canvas, child)) {
            return false;
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    protected void dispatchDraw(@NotNull android.graphics.Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.ownerView.measureAndLayout$ui_platform_release();
        boolean bl = this.hasSize;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "setSize() should be called before drawing the RepaintBoundary";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Path clipPath = this.clipPath;
        if (clipPath != null) {
            canvas.save();
            canvas.clipPath(clipPath);
        }
        if (!this.ownerView.isObservingModels$ui_platform_release()) {
            this.ownerView.watchDraw$ui_platform_release(canvas, this.repaintBoundaryNode);
        } else {
            this.ownerView.callChildDraw$ui_platform_release(canvas, this.repaintBoundaryNode);
        }
        if (clipPath != null) {
            canvas.restore();
        }
        this.setDirty(false);
    }

    @Override
    public void attach(@Nullable RepaintBoundary parent) {
        if (parent != null) {
            ((RepaintBoundaryView)parent).addView((View)this);
        } else {
            this.ownerView.addView((View)this);
        }
        this.hasSize = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onParamsChange() {
        long l;
        void val1$iv$iv;
        void height$iv;
        void width$iv;
        void $this$px$iv32;
        void $this$px$iv22;
        Px px;
        int n = this.getWidth();
        RepaintBoundaryNode repaintBoundaryNode = this.repaintBoundaryNode;
        OutlineResolver outlineResolver = this.outlineResolver;
        Px $this$px$iv22 = px = new Px((float)$this$px$iv22);
        int n2 = this.getHeight();
        Px $this$px$iv32 = px = new Px((float)$this$px$iv32);
        float f = width$iv.getValue();
        float val2$iv$iv = height$iv.getValue();
        void var5_10 = val1$iv$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_10);
        float f2 = val2$iv$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        px = new PxSize(l2);
        outlineResolver.update(repaintBoundaryNode, (PxSize)px);
        this.setClipToOutline(this.outlineResolver.getClipToOutline());
        this.setOutlineProvider(this.outlineResolver.getHasOutline() ? (ViewOutlineProvider)this.outlineProviderImpl : null);
        if (this.outlineResolver.getManualClipPath() != this.clipPath) {
            this.clipPath = this.outlineResolver.getManualClipPath();
            this.setDirty(true);
        }
        this.setAlpha(this.repaintBoundaryNode.getOpacity());
        this.setElevation(((Number)DensityKt.withDensity((Density)this.density, (Function1)((Function1)new Function1<DensityScope, Float>(this){
            final /* synthetic */ RepaintBoundaryView this$0;

            public final float invoke(@NotNull DensityScope $this$withDensity) {
                Intrinsics.checkParameterIsNotNull((Object)$this$withDensity, (String)"$receiver");
                return $this$withDensity.toPx(this.this$0.getRepaintBoundaryNode().getElevation()).getValue();
            }
            {
                this.this$0 = repaintBoundaryView;
                super(1);
            }
        }))).floatValue());
    }

    @Override
    public void updateDisplayList() {
    }

    @NotNull
    public final AndroidComposeView getOwnerView() {
        return this.ownerView;
    }

    @NotNull
    public final ElevationHandler getOwnerElevationHandler() {
        return this.ownerElevationHandler;
    }

    @NotNull
    public final RepaintBoundaryNode getRepaintBoundaryNode() {
        return this.repaintBoundaryNode;
    }

    public RepaintBoundaryView(@NotNull AndroidComposeView ownerView, @NotNull ElevationHandler ownerElevationHandler, @NotNull RepaintBoundaryNode repaintBoundaryNode) {
        Intrinsics.checkParameterIsNotNull((Object)ownerView, (String)"ownerView");
        Intrinsics.checkParameterIsNotNull((Object)ownerElevationHandler, (String)"ownerElevationHandler");
        Intrinsics.checkParameterIsNotNull((Object)repaintBoundaryNode, (String)"repaintBoundaryNode");
        super(ownerView.getContext());
        this.ownerView = ownerView;
        this.ownerElevationHandler = ownerElevationHandler;
        this.repaintBoundaryNode = repaintBoundaryNode;
        this.setTag(this.repaintBoundaryNode.getName());
        this.setClipChildren(false);
        this.setWillNotDraw(false);
        this.setId(View.generateViewId());
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.density = DensityKt.Density((Context)context);
        this.outlineResolver = new OutlineResolver(this.density);
        this.outlineProviderImpl = new ViewOutlineProvider(this){
            final /* synthetic */ RepaintBoundaryView this$0;

            public void getOutline(@NotNull View view, @NotNull Outline outline) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                Intrinsics.checkParameterIsNotNull((Object)outline, (String)"outline");
                RepaintBoundaryView.access$getOutlineResolver$p(this.this$0).applyTo(outline);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.dirty = true;
        this.elevationHandler = Build.VERSION.SDK_INT >= 29 ? (ElevationHandler)new ElevationHandler29() : (ElevationHandler)new ElevationHandlerCompat(this, (Function1<? super android.graphics.Canvas, Unit>)((Function1)new Function1<android.graphics.Canvas, Unit>(this){
            final /* synthetic */ RepaintBoundaryView this$0;

            public final void invoke(@NotNull android.graphics.Canvas canvas) {
                Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
                RepaintBoundaryView.access$dispatchDraw$s2061281146(this.this$0, canvas);
            }
            {
                this.this$0 = repaintBoundaryView;
                super(1);
            }
        }));
    }

    public static final /* synthetic */ OutlineResolver access$getOutlineResolver$p(RepaintBoundaryView $this) {
        return $this.outlineResolver;
    }

    public static final /* synthetic */ void access$dispatchDraw$s2061281146(RepaintBoundaryView $this, android.graphics.Canvas p0) {
        super.dispatchDraw(p0);
    }
}

