/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core.pointerinput;

import androidx.ui.core.ComponentNodesKt;
import androidx.ui.core.IntPx;
import androidx.ui.core.IntPxPosition;
import androidx.ui.core.IntPxSize;
import androidx.ui.core.LayoutNode;
import androidx.ui.core.PointerEventPass;
import androidx.ui.core.PointerInputChange;
import androidx.ui.core.PointerInputData;
import androidx.ui.core.PointerInputNode;
import androidx.ui.core.Px;
import androidx.ui.core.PxPosition;
import androidx.ui.core.pointerinput.Node;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ,\u0010!\u001a\u00020\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010&J\u000e\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u000eJ\u0006\u0010*\u001a\u00020\u001fJ\u000e\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u0014J\u0006\u0010-\u001a\u00020\u001fJ\b\u0010.\u001a\u00020/H\u0016J \u00100\u001a\u00020\u001f*\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020$0#2\u0006\u00101\u001a\u00020\u000eH\u0002J0\u00102\u001a\u00020\u001f*\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020$0#2\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J9\u00105\u001a\u00020\u001f\"\u0004\b\u0000\u00106\"\u0004\b\u0001\u00107*\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002H70#2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u0002H7\u0012\u0004\u0012\u0002H709H\u0082\bJ \u0010:\u001a\u00020\u001f*\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020$0#2\u0006\u00101\u001a\u00020\u000eH\u0002R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006;"}, d2={"Landroidx/ui/core/pointerinput/Node;", "", "pointerInputNode", "Landroidx/ui/core/PointerInputNode;", "layoutNode", "Landroidx/ui/core/LayoutNode;", "(Landroidx/ui/core/PointerInputNode;Landroidx/ui/core/LayoutNode;)V", "children", "", "getChildren", "()Ljava/util/Set;", "getLayoutNode", "()Landroidx/ui/core/LayoutNode;", "offset", "Landroidx/ui/core/IntPxPosition;", "getOffset", "()Landroidx/ui/core/IntPxPosition;", "setOffset", "(Landroidx/ui/core/IntPxPosition;)V", "pointerIds", "", "getPointerIds", "getPointerInputNode", "()Landroidx/ui/core/PointerInputNode;", "size", "Landroidx/ui/core/IntPxSize;", "getSize", "()Landroidx/ui/core/IntPxSize;", "setSize", "(Landroidx/ui/core/IntPxSize;)V", "clear", "", "dispatchCancel", "dispatchChanges", "pointerInputChanges", "", "Landroidx/ui/core/PointerInputChange;", "downPass", "Landroidx/ui/core/PointerEventPass;", "upPass", "refreshPositionInformation", "additionalPointerOffset", "removeDetachedPointerInputNodes", "removePointerId", "pointerId", "removePointerInputNodesWithNoLayoutNodeDescendants", "toString", "", "addOffset", "position", "dispatchToPointerInputNode", "node", "pass", "replaceEverything", "K", "V", "f", "Lkotlin/Function1;", "subtractOffset", "ui-platform_release"})
public final class Node {
    @NotNull
    private final Set<Integer> pointerIds;
    @NotNull
    private final Set<Node> children;
    @NotNull
    private IntPxPosition offset;
    @NotNull
    private IntPxSize size;
    @Nullable
    private final PointerInputNode pointerInputNode;
    @Nullable
    private final LayoutNode layoutNode;

    @NotNull
    public final Set<Integer> getPointerIds() {
        return this.pointerIds;
    }

    @NotNull
    public final Set<Node> getChildren() {
        return this.children;
    }

    @NotNull
    public final IntPxPosition getOffset() {
        return this.offset;
    }

    public final void setOffset(@NotNull IntPxPosition intPxPosition) {
        Intrinsics.checkParameterIsNotNull((Object)intPxPosition, (String)"<set-?>");
        this.offset = intPxPosition;
    }

    @NotNull
    public final IntPxSize getSize() {
        return this.size;
    }

    public final void setSize(@NotNull IntPxSize intPxSize) {
        Intrinsics.checkParameterIsNotNull((Object)intPxSize, (String)"<set-?>");
        this.size = intPxSize;
    }

    public final void dispatchChanges(@NotNull Map<Integer, PointerInputChange> pointerInputChanges, @NotNull PointerEventPass downPass, @Nullable PointerEventPass upPass) {
        Map it;
        Map relevantChanges;
        Map $this$filterTo$iv;
        Map map;
        Map map2;
        Intrinsics.checkParameterIsNotNull(pointerInputChanges, (String)"pointerInputChanges");
        Intrinsics.checkParameterIsNotNull((Object)downPass, (String)"downPass");
        if (this.pointerInputNode == null) {
            map2 = pointerInputChanges;
        } else {
            map = pointerInputChanges;
            boolean bl = false;
            Map destination$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Map map3 = $this$filterTo$iv;
            boolean bl2 = false;
            Iterator<Map.Entry<Integer, PointerInputChange>> iterator = map3.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, PointerInputChange> element$iv;
                Map.Entry<Integer, PointerInputChange> entry = element$iv = iterator.next();
                boolean bl3 = false;
                if (!this.pointerIds.contains(entry.getKey())) continue;
                destination$iv.put(element$iv.getKey(), element$iv.getValue());
            }
            map2 = relevantChanges = destination$iv;
        }
        if (relevantChanges.isEmpty()) {
            throw (Throwable)new IllegalStateException("Currently, HitPathTracker is operating under the assumption that there should never be a circumstance in which it is tracking a PointerInputNode where when it receives pointerInputChanges, none are relevant to that PointerInputNode.  This assumption may not hold true in the future, but currently it assumes it can abide by this contract.");
        }
        if (this.pointerInputNode != null) {
            $this$filterTo$iv = relevantChanges;
            boolean destination$iv = false;
            boolean bl = false;
            it = $this$filterTo$iv;
            boolean bl4 = false;
            this.subtractOffset(it, this.offset);
            this.dispatchToPointerInputNode(it, this.pointerInputNode, downPass, this.size);
            this.addOffset(it, this.offset);
        }
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it2 = (Node)element$iv;
            boolean bl = false;
            it2.dispatchChanges(relevantChanges, downPass, upPass);
        }
        if (this.pointerInputNode != null && upPass != null) {
            map = relevantChanges;
            boolean bl = false;
            boolean bl5 = false;
            it = map;
            boolean bl6 = false;
            this.subtractOffset(it, this.offset);
            this.dispatchToPointerInputNode(it, this.pointerInputNode, upPass, this.size);
            this.addOffset(it, this.offset);
        }
        pointerInputChanges.putAll(relevantChanges);
    }

    public final void dispatchCancel() {
        block1: {
            Iterable $this$forEach$iv = this.children;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node it = (Node)element$iv;
                boolean bl = false;
                it.dispatchCancel();
            }
            Function0<Unit> function0 = this.pointerInputNode;
            if (function0 == null || (function0 = function0.getCancelHandler()) == null) break block1;
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
    }

    public final void clear() {
        this.children.clear();
    }

    public final void removeDetachedPointerInputNodes() {
        CollectionsKt.removeAll((Iterable)this.children, (Function1)removeDetachedPointerInputNodes.1.INSTANCE);
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            it.removeDetachedPointerInputNodes();
        }
    }

    public final void removePointerInputNodesWithNoLayoutNodeDescendants() {
        CollectionsKt.removeAll((Iterable)this.children, (Function1)removePointerInputNodesWithNoLayoutNodeDescendants.1.INSTANCE);
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            it.removePointerInputNodesWithNoLayoutNodeDescendants();
        }
    }

    public final void removePointerId(int pointerId) {
        Node it;
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Node)element$iv;
            boolean bl = false;
            it.pointerIds.remove(pointerId);
        }
        CollectionsKt.removeAll((Iterable)this.children, (Function1)removePointerId.2.INSTANCE);
        $this$forEach$iv = this.children;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Node)element$iv;
            boolean bl = false;
            it.removePointerId(pointerId);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void refreshPositionInformation(@NotNull IntPxPosition additionalPointerOffset) {
        Intrinsics.checkParameterIsNotNull((Object)additionalPointerOffset, (String)"additionalPointerOffset");
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void height$iv;
            void width$iv;
            void $this$ipx$iv52;
            void $this$ipx$iv42;
            int val1$iv$iv;
            long l;
            void y$iv22;
            void x$iv22;
            void $this$ipx$iv32;
            void $this$ipx$iv22;
            IntPx intPx;
            void maxY;
            void maxX;
            void minY;
            void minX;
            Node child = (Node)element$iv;
            boolean bl = false;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = Integer.MAX_VALUE;
            Ref.IntRef intRef2 = new Ref.IntRef();
            intRef2.element = Integer.MAX_VALUE;
            Ref.IntRef intRef3 = new Ref.IntRef();
            intRef3.element = Integer.MIN_VALUE;
            Ref.IntRef intRef4 = new Ref.IntRef();
            intRef4.element = Integer.MIN_VALUE;
            PointerInputNode pointerInputNode = child.pointerInputNode;
            if (pointerInputNode != null) {
                ComponentNodesKt.visitLayoutChildren(pointerInputNode, (Function1<? super LayoutNode, Unit>)((Function1)new Function1<LayoutNode, Unit>((Ref.IntRef)minX, (Ref.IntRef)minY, (Ref.IntRef)maxX, (Ref.IntRef)maxY, additionalPointerOffset){
                    final /* synthetic */ Ref.IntRef $minX;
                    final /* synthetic */ Ref.IntRef $minY;
                    final /* synthetic */ Ref.IntRef $maxX;
                    final /* synthetic */ Ref.IntRef $maxY;
                    final /* synthetic */ IntPxPosition $additionalPointerOffset$inlined;
                    {
                        this.$minX = intRef;
                        this.$minY = intRef2;
                        this.$maxX = intRef3;
                        this.$maxY = intRef4;
                        this.$additionalPointerOffset$inlined = intPxPosition;
                        super(1);
                    }

                    public final void invoke(@NotNull LayoutNode layoutChild) {
                        int n;
                        IntPxPosition globalPosition;
                        Intrinsics.checkParameterIsNotNull((Object)layoutChild, (String)"layoutChild");
                        IntPxPosition this_$iv = globalPosition = ComponentNodesKt.positionRelativeToRoot(layoutChild);
                        long value$iv$iv = this_$iv.getValue();
                        int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
                        this_$iv = this.$additionalPointerOffset$inlined;
                        int n2 = new IntPx($this$ipx$iv$iv).getValue();
                        value$iv$iv = this_$iv.getValue();
                        $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
                        IntPx intPx = new IntPx($this$ipx$iv$iv);
                        int x = n2 + intPx.getValue();
                        IntPxPosition this_$iv2 = globalPosition;
                        long value$iv$iv2 = this_$iv2.getValue();
                        int $this$ipx$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
                        this_$iv2 = this.$additionalPointerOffset$inlined;
                        n2 = new IntPx($this$ipx$iv$iv2).getValue();
                        value$iv$iv2 = this_$iv2.getValue();
                        $this$ipx$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
                        intPx = new IntPx($this$ipx$iv$iv2);
                        int y = n2 + intPx.getValue();
                        int n3 = this.$minX.element;
                        Ref.IntRef intRef = this.$minX;
                        int n4 = 0;
                        intRef.element = n = Math.min(n3, x);
                        n3 = this.$minY.element;
                        intRef = this.$minY;
                        n4 = 0;
                        intRef.element = n = Math.min(n3, y);
                        n3 = this.$maxX.element;
                        n4 = x + layoutChild.getWidth().getValue();
                        intRef = this.$maxX;
                        boolean bl = false;
                        intRef.element = n = Math.max(n3, n4);
                        n3 = this.$maxY.element;
                        n4 = y + layoutChild.getHeight().getValue();
                        intRef = this.$maxY;
                        bl = false;
                        intRef.element = n = Math.max(n3, n4);
                    }
                }));
            }
            int n = minX.element;
            Node node = child;
            IntPx $this$ipx$iv22 = intPx = new IntPx((int)$this$ipx$iv22);
            int n2 = minY.element;
            IntPx $this$ipx$iv32 = intPx = new IntPx((int)$this$ipx$iv32);
            int n3 = x$iv22.getValue();
            int val2$iv$iv = y$iv22.getValue();
            long l2 = l = (long)val1$iv$iv << 32 | (long)val2$iv$iv & 0xFFFFFFFFL;
            intPx = new IntPxPosition(l2);
            node.offset = intPx;
            int x$iv22 = maxX.element - minX.element;
            node = child;
            IntPx $this$ipx$iv42 = intPx = new IntPx((int)$this$ipx$iv42);
            int y$iv22 = maxY.element - minY.element;
            IntPx $this$ipx$iv52 = intPx = new IntPx((int)$this$ipx$iv52);
            val1$iv$iv = width$iv.getValue();
            val2$iv$iv = height$iv.getValue();
            l2 = l = (long)val1$iv$iv << 32 | (long)val2$iv$iv & 0xFFFFFFFFL;
            intPx = new IntPxSize(l2);
            node.size = intPx;
            child.refreshPositionInformation(additionalPointerOffset);
        }
    }

    @NotNull
    public String toString() {
        return "Node(pointerInputNode=" + this.pointerInputNode + ", children=" + this.children + ", " + "pointerIds=" + this.pointerIds + ')';
    }

    private final void dispatchToPointerInputNode(@NotNull Map<Integer, PointerInputChange> $this$dispatchToPointerInputNode, PointerInputNode node, PointerEventPass pass, IntPxSize size) {
        Iterable $this$forEach$iv = (Iterable)node.getPointerInputHandler().invoke((Object)CollectionsKt.toList((Iterable)$this$dispatchToPointerInputNode.values()), (Object)pass, (Object)size);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PointerInputChange it = (PointerInputChange)element$iv;
            boolean bl = false;
            $this$dispatchToPointerInputNode.put(it.getId(), it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addOffset(@NotNull Map<Integer, PointerInputChange> $this$addOffset, IntPxPosition position) {
        if (Intrinsics.areEqual((Object)position, (Object)IntPxPosition.Companion.getOrigin()) ^ true) {
            void $this$replaceEverything$iv;
            Map<Integer, PointerInputChange> map = $this$addOffset;
            Node this_$iv = this;
            boolean $i$f$replaceEverything = false;
            void var6_6 = $this$replaceEverything$iv;
            boolean bl = false;
            for (Map.Entry entry : var6_6.entrySet()) {
                PxPosition pxPosition;
                PxPosition pxPosition2;
                PxPosition pxPosition3;
                long l;
                long l2;
                long v2$iv$iv$iv;
                boolean bl2;
                float f;
                long v1$iv$iv$iv;
                void val1$iv$iv$iv;
                void y$iv$iv;
                void x$iv$iv;
                int $this$ipx$iv$iv$iv;
                long value$iv$iv$iv;
                long value$iv$iv$iv2;
                Px this_$iv$iv;
                IntPx other$iv$iv;
                IntPxPosition this_$iv$iv2;
                IntPxPosition other$iv;
                void var17_17;
                int n;
                PointerInputData pointerInputData;
                PointerInputData pointerInputData2;
                void it;
                PointerInputChange pointerInputChange = (PointerInputChange)entry.getValue();
                Map.Entry entry2 = entry;
                boolean bl3 = false;
                void v0 = it;
                int n2 = 0;
                PointerInputData pointerInputData3 = it.getCurrent();
                PointerInputData pointerInputData4 = null;
                if (it.getCurrent().getPosition() != null) {
                    PxPosition this_$iv2;
                    IntPxPosition intPxPosition = position;
                    pointerInputData2 = pointerInputData4;
                    pointerInputData = pointerInputData3;
                    n = n2;
                    var17_17 = v0;
                    Px this_$iv$iv22 = this_$iv2;
                    long value$iv$iv$iv3 = this_$iv$iv22.getValue();
                    FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
                    int n3 = (int)(value$iv$iv$iv3 >> 32);
                    int n4 = 0;
                    float $this$px$iv$iv$iv342 = Float.intBitsToFloat(n3);
                    this_$iv$iv22 = new Px($this$px$iv$iv$iv342);
                    this_$iv$iv2 = other$iv;
                    long value$iv$iv$iv22 = this_$iv$iv2.getValue();
                    int $this$ipx$iv$iv$iv232 = (int)(value$iv$iv$iv22 >> 32);
                    other$iv$iv = new IntPx($this$ipx$iv$iv$iv232);
                    this_$iv$iv = new Px(this_$iv$iv.getValue() + (float)other$iv$iv.getValue());
                    this_$iv$iv2 = this_$iv2;
                    value$iv$iv$iv2 = this_$iv$iv2.getValue();
                    FloatCompanionObject $this$ipx$iv$iv$iv232 = FloatCompanionObject.INSTANCE;
                    n4 = (int)(value$iv$iv$iv2 & 0xFFFFFFFFL);
                    boolean $this$px$iv$iv$iv342 = false;
                    float $this$px$iv$iv$iv232 = Float.intBitsToFloat(n4);
                    this_$iv$iv2 = new Px($this$px$iv$iv$iv232);
                    IntPxPosition this_$iv$iv3 = other$iv;
                    value$iv$iv$iv = this_$iv$iv3.getValue();
                    $this$ipx$iv$iv$iv = (int)(value$iv$iv$iv & 0xFFFFFFFFL);
                    IntPx other$iv$iv232 = new IntPx($this$ipx$iv$iv$iv);
                    this_$iv$iv2 = new Px(this_$iv$iv2.getValue() + (float)other$iv$iv232.getValue());
                    float other$iv$iv232 = x$iv$iv.getValue();
                    float val2$iv$iv$iv22 = y$iv$iv.getValue();
                    $this$px$iv$iv$iv342 = val1$iv$iv$iv;
                    boolean $this$px$iv$iv$iv232 = false;
                    v1$iv$iv$iv = Float.floatToIntBits($this$px$iv$iv$iv342);
                    f = val2$iv$iv$iv22;
                    bl2 = false;
                    v2$iv$iv$iv = Float.floatToIntBits(f);
                    l = l2 = v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL;
                    pxPosition3 = new PxPosition(l);
                    v0 = var17_17;
                    n2 = n;
                    pointerInputData3 = pointerInputData;
                    pointerInputData4 = pointerInputData2;
                    pxPosition2 = pxPosition3;
                } else {
                    pxPosition2 = null;
                }
                PointerInputData pointerInputData5 = PointerInputData.copy$default((PointerInputData)pointerInputData3, pointerInputData4, pxPosition2, (boolean)false, (int)5, null);
                PointerInputData pointerInputData6 = it.getPrevious();
                PxPosition pxPosition4 = null;
                if (it.getPrevious().getPosition() != null) {
                    void this_$iv2;
                    other$iv = position;
                    pxPosition3 = pxPosition4;
                    pointerInputData2 = pointerInputData6;
                    pointerInputData = pointerInputData5;
                    n = n2;
                    var17_17 = v0;
                    this_$iv$iv = this_$iv2;
                    long value$iv$iv$iv3 = this_$iv$iv.getValue();
                    FloatCompanionObject val2$iv$iv$iv22 = FloatCompanionObject.INSTANCE;
                    int $this$ipx$iv$iv$iv232 = (int)(value$iv$iv$iv3 >> 32);
                    $this$ipx$iv$iv$iv = 0;
                    float $this$px$iv$iv$iv = Float.intBitsToFloat($this$ipx$iv$iv$iv232);
                    this_$iv$iv = new Px($this$px$iv$iv$iv);
                    this_$iv$iv2 = other$iv;
                    value$iv$iv$iv2 = this_$iv$iv2.getValue();
                    int $this$ipx$iv$iv$iv2 = (int)(value$iv$iv$iv2 >> 32);
                    other$iv$iv = new IntPx($this$ipx$iv$iv$iv2);
                    this_$iv$iv = new Px(this_$iv$iv.getValue() + (float)other$iv$iv.getValue());
                    this_$iv$iv2 = this_$iv2;
                    value$iv$iv$iv2 = this_$iv$iv2.getValue();
                    FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
                    $this$ipx$iv$iv$iv = (int)(value$iv$iv$iv2 & 0xFFFFFFFFL);
                    boolean bl4 = false;
                    float $this$px$iv$iv$iv2 = Float.intBitsToFloat($this$ipx$iv$iv$iv);
                    this_$iv$iv2 = new Px($this$px$iv$iv$iv2);
                    IntPxPosition this_$iv$iv4 = other$iv;
                    value$iv$iv$iv = this_$iv$iv4.getValue();
                    $this$ipx$iv$iv$iv = (int)(value$iv$iv$iv & 0xFFFFFFFFL);
                    IntPx other$iv$iv42 = new IntPx($this$ipx$iv$iv$iv);
                    this_$iv$iv2 = new Px(this_$iv$iv2.getValue() + (float)other$iv$iv42.getValue());
                    float other$iv$iv42 = x$iv$iv.getValue();
                    float val2$iv$iv$iv = y$iv$iv.getValue();
                    void var24_27 = val1$iv$iv$iv;
                    boolean bl5 = false;
                    v1$iv$iv$iv = Float.floatToIntBits((float)var24_27);
                    f = val2$iv$iv$iv;
                    bl2 = false;
                    v2$iv$iv$iv = Float.floatToIntBits(f);
                    l = l2 = v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL;
                    PxPosition pxPosition5 = new PxPosition(l);
                    v0 = var17_17;
                    n2 = n;
                    pointerInputData5 = pointerInputData;
                    pointerInputData6 = pointerInputData2;
                    pxPosition4 = pxPosition3;
                    pxPosition = pxPosition5;
                } else {
                    pxPosition = null;
                }
                PointerInputChange pointerInputChange2 = PointerInputChange.copy$default((PointerInputChange)v0, (int)n2, (PointerInputData)pointerInputData5, (PointerInputData)PointerInputData.copy$default((PointerInputData)pointerInputData6, pxPosition4, pxPosition, (boolean)false, (int)5, null), null, (int)9, null);
                entry2.setValue(pointerInputChange2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void subtractOffset(@NotNull Map<Integer, PointerInputChange> $this$subtractOffset, IntPxPosition position) {
        void val1$iv$iv$iv;
        long l;
        void x$iv$iv;
        void this_$iv;
        IntPxPosition intPxPosition = position;
        Map<Integer, PointerInputChange> map = $this$subtractOffset;
        Node node = this;
        IntPx this_$iv$iv = this_$iv;
        long value$iv$iv$iv = this_$iv$iv.getValue();
        int $this$ipx$iv$iv$iv = (int)(value$iv$iv$iv >> 32);
        this_$iv$iv = new IntPx($this$ipx$iv$iv$iv).unaryMinus();
        void this_$iv$iv2 = this_$iv;
        long value$iv$iv$iv2 = this_$iv$iv2.getValue();
        int $this$ipx$iv$iv$iv2 = (int)(value$iv$iv$iv2 & 0xFFFFFFFFL);
        IntPx y$iv$iv = new IntPx($this$ipx$iv$iv$iv2).unaryMinus();
        int n = x$iv$iv.getValue();
        int val2$iv$iv$iv = y$iv$iv.getValue();
        long l2 = l = (long)val1$iv$iv$iv << 32 | (long)val2$iv$iv$iv & 0xFFFFFFFFL;
        IntPxPosition intPxPosition2 = new IntPxPosition(l2);
        node.addOffset(map, intPxPosition2);
    }

    private final <K, V> void replaceEverything(@NotNull Map<K, V> $this$replaceEverything, Function1<? super V, ? extends V> f) {
        int $i$f$replaceEverything = 0;
        Map<K, V> map = $this$replaceEverything;
        boolean bl = false;
        for (Map.Entry<K, Object> entry : map.entrySet()) {
            entry.setValue(f.invoke(entry.getValue()));
        }
    }

    @Nullable
    public final PointerInputNode getPointerInputNode() {
        return this.pointerInputNode;
    }

    @Nullable
    public final LayoutNode getLayoutNode() {
        return this.layoutNode;
    }

    /*
     * WARNING - void declaration
     */
    public Node(@Nullable PointerInputNode pointerInputNode, @Nullable LayoutNode layoutNode2) {
        void val1$iv$iv;
        long l;
        void height$iv;
        void width$iv;
        void $this$ipx$iv32;
        void $this$ipx$iv22;
        Set set;
        this.pointerInputNode = pointerInputNode;
        this.layoutNode = layoutNode2;
        Node node = this;
        boolean bl = false;
        node.pointerIds = set = (Set)new LinkedHashSet();
        node = this;
        bl = false;
        node.children = set = (Set)new LinkedHashSet();
        this.offset = IntPxPosition.Companion.getOrigin();
        bl = false;
        node = this;
        Set $this$ipx$iv22 = set = new IntPx((int)$this$ipx$iv22);
        boolean bl2 = false;
        Set $this$ipx$iv32 = set = new IntPx((int)$this$ipx$iv32);
        int n = width$iv.getValue();
        int val2$iv$iv = height$iv.getValue();
        long l2 = l = (long)val1$iv$iv << 32 | (long)val2$iv$iv & 0xFFFFFFFFL;
        set = new IntPxSize(l2);
        node.size = set;
    }

    public /* synthetic */ Node(PointerInputNode pointerInputNode, LayoutNode layoutNode2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pointerInputNode = null;
        }
        if ((n & 2) != 0) {
            layoutNode2 = null;
        }
        this(pointerInputNode, layoutNode2);
    }

    public Node() {
        this(null, null, 3, null);
    }
}

