/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core.semantics;

import androidx.ui.semantics.SemanticsPropertyKey;
import androidx.ui.semantics.SemanticsPropertyReceiver;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u0019J\u001d\u0010\u001a\u001a\u00020\b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u0004H\u0086\u0002J\u0006\u0010\u001d\u001a\u00020\u0000J\"\u0010\u001e\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u001fJ-\u0010 \u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u00042\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001b0\"\u00a2\u0006\u0002\u0010#J1\u0010$\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u00042\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001b0\"\u00a2\u0006\u0002\u0010#J!\u0010%\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00030&H\u0096\u0002J*\u0010'\u001a\u00020\u0017\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u00042\u0006\u0010\u000f\u001a\u0002H\u001bH\u0096\u0002\u00a2\u0006\u0002\u0010(R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR$\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\fR$\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\n\"\u0004\b\u0013\u0010\fR \u0010\u0014\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Landroidx/ui/core/semantics/SemanticsConfiguration;", "Landroidx/ui/semantics/SemanticsPropertyReceiver;", "", "", "Landroidx/ui/semantics/SemanticsPropertyKey;", "", "()V", "explicitChildNodes", "", "getExplicitChildNodes", "()Z", "setExplicitChildNodes", "(Z)V", "hasBeenAnnotated", "getHasBeenAnnotated", "value", "isMergingSemanticsOfDescendants", "setMergingSemanticsOfDescendants", "isSemanticBoundary", "setSemanticBoundary", "props", "", "absorb", "", "other", "absorb$ui_platform_release", "contains", "T", "key", "copy", "get", "(Landroidx/ui/semantics/SemanticsPropertyKey;)Ljava/lang/Object;", "getOrElse", "defaultValue", "Lkotlin/Function0;", "(Landroidx/ui/semantics/SemanticsPropertyKey;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getOrElseNullable", "iterator", "", "set", "(Landroidx/ui/semantics/SemanticsPropertyKey;Ljava/lang/Object;)V", "ui-platform_release"})
public final class SemanticsConfiguration
implements SemanticsPropertyReceiver,
Iterable<Map.Entry<? extends SemanticsPropertyKey<?>, ? extends Object>>,
KMappedMarker {
    private final Map<SemanticsPropertyKey<?>, Object> props;
    private boolean isSemanticBoundary;
    private boolean explicitChildNodes;
    private boolean isMergingSemanticsOfDescendants;

    public final <T> T get(@NotNull SemanticsPropertyKey<T> key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Map<SemanticsPropertyKey<?>, Object> map = this.props;
        boolean bl = false;
        Object object = map.get(key);
        if (object == null) {
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException("Key not present: " + key + " - consider getOrElse or getOrNull");
        }
        return (T)object;
    }

    public final <T> T getOrElse(@NotNull SemanticsPropertyKey<T> key, @NotNull Function0<? extends T> defaultValue) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        Map<SemanticsPropertyKey<?>, Object> map = this.props;
        boolean bl = false;
        Object object = map.get(key);
        if (object == null) {
            object = defaultValue.invoke();
        }
        return (T)object;
    }

    @Nullable
    public final <T> T getOrElseNullable(@NotNull SemanticsPropertyKey<T> key, @NotNull Function0<? extends T> defaultValue) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        Map<SemanticsPropertyKey<?>, Object> map = this.props;
        boolean bl = false;
        Object object = map.get(key);
        if (object == null) {
            object = defaultValue.invoke();
        }
        return (T)object;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<SemanticsPropertyKey<?>, Object>> iterator() {
        Map<SemanticsPropertyKey<?>, Object> map = this.props;
        boolean bl = false;
        return map.entrySet().iterator();
    }

    public <T> void set(@NotNull SemanticsPropertyKey<T> key, T value) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        this.props.put(key, value);
    }

    public final <T> boolean contains(@NotNull SemanticsPropertyKey<T> key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        return this.props.containsKey(key);
    }

    public final boolean isSemanticBoundary() {
        return this.isSemanticBoundary;
    }

    public final void setSemanticBoundary(boolean value) {
        boolean bl = !this.isMergingSemanticsOfDescendants || value;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.isSemanticBoundary = value;
    }

    public final boolean getExplicitChildNodes() {
        return this.explicitChildNodes;
    }

    public final void setExplicitChildNodes(boolean bl) {
        this.explicitChildNodes = bl;
    }

    public final boolean isMergingSemanticsOfDescendants() {
        return this.isMergingSemanticsOfDescendants;
    }

    public final void setMergingSemanticsOfDescendants(boolean value) {
        if (value) {
            boolean bl = this.isSemanticBoundary;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        this.isMergingSemanticsOfDescendants = value;
    }

    public final boolean getHasBeenAnnotated() {
        return this.props.isEmpty();
    }

    public final void absorb$ui_platform_release(@NotNull SemanticsConfiguration other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        boolean bl = !this.explicitChildNodes;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!other.getHasBeenAnnotated()) {
            return;
        }
        Map<SemanticsPropertyKey<?>, Object> map = other.props;
        boolean bl5 = false;
        for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : map.entrySet()) {
            SemanticsPropertyKey<?> key = entry.getKey();
            if (this.props.containsKey(key)) {
                if (key == null) {
                    throw new TypeCastException("null cannot be cast to non-null type androidx.ui.semantics.SemanticsPropertyKey<kotlin.Any?>");
                }
                this.props.put(key, key.merge(this.props.get(key), entry.getValue()));
                continue;
            }
            this.props.put(key, entry.getValue());
        }
    }

    @NotNull
    public final SemanticsConfiguration copy() {
        SemanticsConfiguration copy = new SemanticsConfiguration();
        copy.setSemanticBoundary(this.isSemanticBoundary);
        copy.explicitChildNodes = this.explicitChildNodes;
        copy.setMergingSemanticsOfDescendants(this.isMergingSemanticsOfDescendants);
        copy.props.putAll(this.props);
        return copy;
    }

    public SemanticsConfiguration() {
        Map map;
        SemanticsConfiguration semanticsConfiguration = this;
        boolean bl = false;
        semanticsConfiguration.props = map = (Map)new LinkedHashMap();
    }
}

