/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core.semantics;

import androidx.ui.core.semantics.SemanticsConfiguration;
import androidx.ui.core.semantics.SemanticsOwner;
import androidx.ui.engine.geometry.Rect;
import androidx.ui.semantics.AccessibilityAction;
import androidx.ui.semantics.SemanticsPropertyKey;
import java.util.Collection;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 T2\u00020\u0001:\u0001TB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0000H\u0002J\u0010\u0010>\u001a\u00020<2\u0006\u0010'\u001a\u00020&H\u0002J1\u0010?\u001a\u00020\u0007\"\u000e\b\u0000\u0010@*\b\u0012\u0004\u0012\u00020<0A2\u0012\u0010B\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H@0D0CH\u0000\u00a2\u0006\u0002\bEJ\b\u0010F\u001a\u00020<H\u0002J\u0010\u0010G\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0000H\u0002J\b\u0010H\u001a\u00020<H\u0002J\u000e\u0010I\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0000J\u0006\u0010J\u001a\u00020<J/\u0010K\u001a\u00020<2%\u0010L\u001a!\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\bN\u0012\b\bO\u0012\u0004\b\b(P\u0012\u0004\u0012\u00020\u00070Mj\u0002`QH\u0002J4\u0010R\u001a\u00020\u00072%\u0010L\u001a!\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\bN\u0012\b\bO\u0012\u0004\b\b(P\u0012\u0004\u0012\u00020\u00070Mj\u0002`QH\u0000\u00a2\u0006\u0002\bSR\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010\u001e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\tR$\u0010 \u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\t\"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\tR\u001e\u0010$\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\tR\"\u0010'\u001a\u0004\u0018\u00010&2\b\u0010\u0017\u001a\u0004\u0018\u00010&@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001c\u00105\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00102\"\u0004\b7\u00104R$\u00108\u001a\u0002002\u0006\u0010\u001f\u001a\u000200@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00102\"\u0004\b:\u00104\u00a8\u0006U"}, d2={"Landroidx/ui/core/semantics/SemanticsNode;", "", "()V", "id", "", "(I)V", "attached", "", "getAttached", "()Z", "children", "", "getChildren", "()Ljava/util/List;", "setChildren", "(Ljava/util/List;)V", "childrenCount", "getChildrenCount", "()I", "config", "Landroidx/ui/core/semantics/SemanticsConfiguration;", "getConfig", "()Landroidx/ui/core/semantics/SemanticsConfiguration;", "<set-?>", "depth", "getDepth", "dirty", "hasChildren", "getHasChildren", "getId", "isInvisible", "value", "isMergedIntoParent", "setMergedIntoParent", "(Z)V", "isPartOfNodeMerging", "mergeAllDescendantsIntoThisNode", "getMergeAllDescendantsIntoThisNode", "Landroidx/ui/core/semantics/SemanticsOwner;", "owner", "getOwner", "()Landroidx/ui/core/semantics/SemanticsOwner;", "parent", "getParent", "()Landroidx/ui/core/semantics/SemanticsNode;", "setParent", "(Landroidx/ui/core/semantics/SemanticsNode;)V", "parentPaintClipRect", "Landroidx/ui/engine/geometry/Rect;", "getParentPaintClipRect", "()Landroidx/ui/engine/geometry/Rect;", "setParentPaintClipRect", "(Landroidx/ui/engine/geometry/Rect;)V", "parentSemanticsClipRect", "getParentSemanticsClipRect", "setParentSemanticsClipRect", "rect", "getRect", "setRect", "adoptChild", "", "child", "attach", "canPerformAction", "T", "Lkotlin/Function;", "action", "Landroidx/ui/semantics/SemanticsPropertyKey;", "Landroidx/ui/semantics/AccessibilityAction;", "canPerformAction$ui_platform_release", "detach", "dropChild", "markDirty", "redepthChild", "redepthChildren", "visitChildren", "visitor", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "node", "Landroidx/ui/core/semantics/SemanticsNodeVisitor;", "visitDescendants", "visitDescendants$ui_platform_release", "Companion", "ui-platform_release"})
public final class SemanticsNode {
    @NotNull
    private Rect rect;
    @Nullable
    private Rect parentSemanticsClipRect;
    @Nullable
    private Rect parentPaintClipRect;
    private boolean isMergedIntoParent;
    private boolean mergeAllDescendantsIntoThisNode;
    @NotNull
    private List<SemanticsNode> children;
    @Nullable
    private SemanticsOwner owner;
    @Nullable
    private SemanticsNode parent;
    private int depth;
    @NotNull
    private final SemanticsConfiguration config;
    private boolean dirty;
    private final int id;
    private static int lastIdentifier;
    public static final Companion Companion;

    @NotNull
    public final Rect getRect() {
        return this.rect;
    }

    public final void setRect(@NotNull Rect value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)this.rect, (Object)value) ^ true) {
            this.rect = value;
            this.markDirty();
        }
    }

    @Nullable
    public final Rect getParentSemanticsClipRect() {
        return this.parentSemanticsClipRect;
    }

    public final void setParentSemanticsClipRect(@Nullable Rect rect) {
        this.parentSemanticsClipRect = rect;
    }

    @Nullable
    public final Rect getParentPaintClipRect() {
        return this.parentPaintClipRect;
    }

    public final void setParentPaintClipRect(@Nullable Rect rect) {
        this.parentPaintClipRect = rect;
    }

    public final boolean isInvisible() {
        return !this.isMergedIntoParent && this.rect.isEmpty();
    }

    public final boolean isMergedIntoParent() {
        return this.isMergedIntoParent;
    }

    public final void setMergedIntoParent(boolean value) {
        if (this.isMergedIntoParent == value) {
            return;
        }
        this.isMergedIntoParent = value;
        this.markDirty();
    }

    public final boolean isPartOfNodeMerging() {
        return this.mergeAllDescendantsIntoThisNode || this.isMergedIntoParent;
    }

    public final boolean getMergeAllDescendantsIntoThisNode() {
        return this.mergeAllDescendantsIntoThisNode;
    }

    @NotNull
    public final List<SemanticsNode> getChildren() {
        return this.children;
    }

    public final void setChildren(@NotNull List<SemanticsNode> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.children = list;
    }

    public final boolean getHasChildren() {
        Collection collection = this.children;
        boolean bl = false;
        return !collection.isEmpty();
    }

    public final int getChildrenCount() {
        return this.children.size();
    }

    private final void adoptChild(SemanticsNode child) {
        boolean bl = child.parent == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean $i$f$ifDebug = false;
        boolean bl5 = false;
        SemanticsNode node = this;
        while (true) {
            SemanticsNode semanticsNode = node;
            if (semanticsNode == null) {
                Intrinsics.throwNpe();
            }
            if (semanticsNode.parent == null) break;
            node = node.parent;
        }
        boolean bl6 = Intrinsics.areEqual((Object)node, (Object)child) ^ true;
        boolean bl7 = false;
        boolean bl8 = false;
        if (_Assertions.ENABLED && !bl6) {
            boolean bl9 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        child.parent = this;
        if (this.getAttached()) {
            SemanticsOwner semanticsOwner = this.owner;
            if (semanticsOwner == null) {
                Intrinsics.throwNpe();
            }
            child.attach(semanticsOwner);
        }
        this.redepthChild(child);
    }

    private final void dropChild(SemanticsNode child) {
        boolean bl = Intrinsics.areEqual((Object)child.parent, (Object)this);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = child.getAttached() == this.getAttached();
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        child.parent = null;
        if (this.getAttached()) {
            child.detach();
        }
    }

    private final void visitChildren(Function1<? super SemanticsNode, Boolean> visitor) {
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SemanticsNode it = (SemanticsNode)element$iv;
            boolean bl = false;
            if (((Boolean)visitor.invoke((Object)it)).booleanValue()) continue;
            return;
        }
    }

    public final boolean visitDescendants$ui_platform_release(@NotNull Function1<? super SemanticsNode, Boolean> visitor) {
        Intrinsics.checkParameterIsNotNull(visitor, (String)"visitor");
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SemanticsNode it = (SemanticsNode)element$iv;
            boolean bl = false;
            if (((Boolean)visitor.invoke((Object)it)).booleanValue() && it.visitDescendants$ui_platform_release(visitor)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final SemanticsOwner getOwner() {
        return this.owner;
    }

    public final boolean getAttached() {
        return this.owner != null;
    }

    @Nullable
    public final SemanticsNode getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable SemanticsNode semanticsNode) {
        this.parent = semanticsNode;
    }

    public final int getDepth() {
        return this.depth;
    }

    @NotNull
    public final SemanticsConfiguration getConfig() {
        return this.config;
    }

    public final void redepthChild(@NotNull SemanticsNode child) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        boolean bl = Intrinsics.areEqual((Object)child.owner, (Object)this.owner);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (child.depth <= this.depth) {
            child.depth = this.depth + 1;
            child.redepthChildren();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void redepthChildren() {
        void $this$forEach$iv;
        Iterable iterable = this.children;
        SemanticsNode semanticsNode = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SemanticsNode p1 = (SemanticsNode)element$iv;
            boolean bl = false;
            semanticsNode.redepthChild(p1);
        }
    }

    private final void attach(SemanticsOwner owner) {
        boolean bl = this.owner == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.owner = owner;
        bl = !owner.getNodes$ui_platform_release().containsKey(this.id);
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        owner.getNodes$ui_platform_release().put(this.id, this);
        owner.getDetachedNodes$ui_platform_release().remove(this);
        if (this.dirty) {
            this.dirty = false;
            this.markDirty();
        }
        List<SemanticsNode> list = this.children;
        bl2 = false;
        bl3 = false;
        List<SemanticsNode> it = list;
        boolean bl6 = false;
        for (SemanticsNode child : it) {
            child.attach(owner);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void detach() {
        var1_1 = this.owner != null;
        var2_5 = false;
        var3_7 = false;
        if (_Assertions.ENABLED && !var1_1) {
            var4_8 = false;
            var4_9 = "Assertion failed";
            throw (Throwable)new AssertionError((Object)var4_9);
        }
        v0 = this.owner;
        if (v0 == null) {
            Intrinsics.throwNpe();
        }
        var1_2 = v0;
        var2_5 = false;
        var3_7 = false;
        it = var1_2;
        $i$a$-let-SemanticsNode$detach$1 = false;
        var6_14 = it.getNodes$ui_platform_release().containsKey(this.id);
        var7_15 = false;
        var8_16 = false;
        if (_Assertions.ENABLED && !var6_14) {
            var9_17 = false;
            var9_18 = "Assertion failed";
            throw (Throwable)new AssertionError((Object)var9_18);
        }
        var6_14 = it.getDetachedNodes$ui_platform_release().contains(this) == false;
        var7_15 = false;
        var8_16 = false;
        if (_Assertions.ENABLED && !var6_14) {
            var9_19 = false;
            var9_20 = "Assertion failed";
            throw (Throwable)new AssertionError((Object)var9_20);
        }
        it.getNodes$ui_platform_release().remove(this.id);
        it.getDetachedNodes$ui_platform_release().add(this);
        this.owner = null;
        if (this.parent == null) ** GOTO lbl-1000
        v1 = this.getAttached();
        v2 = this.parent;
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        if (v1 == v2.getAttached()) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        var1_3 = v3;
        var2_5 = false;
        var3_7 = false;
        if (_Assertions.ENABLED && !var1_3) {
            var4_11 = false;
            var4_12 = "Assertion failed";
            throw (Throwable)new AssertionError((Object)var4_12);
        }
        for (SemanticsNode child : this.children) {
            if (!Intrinsics.areEqual((Object)child.parent, (Object)this)) continue;
            child.detach();
        }
        this.markDirty();
    }

    private final void markDirty() {
        if (this.dirty) {
            return;
        }
        this.dirty = true;
        if (this.getAttached()) {
            SemanticsOwner semanticsOwner = this.owner;
            if (semanticsOwner == null) {
                Intrinsics.throwNpe();
            }
            SemanticsOwner semanticsOwner2 = semanticsOwner;
            boolean bl = false;
            boolean bl2 = false;
            SemanticsOwner it = semanticsOwner2;
            boolean bl3 = false;
            boolean bl4 = !it.getDetachedNodes$ui_platform_release().contains(this);
            boolean bl5 = false;
            boolean bl6 = false;
            if (_Assertions.ENABLED && !bl4) {
                boolean bl7 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            it.getDirtyNodes$ui_platform_release().add(this);
        }
    }

    public final <T extends Function<? extends Unit>> boolean canPerformAction$ui_platform_release(@NotNull SemanticsPropertyKey<AccessibilityAction<T>> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        return this.config.contains(action);
    }

    public final int getId() {
        return this.id;
    }

    private SemanticsNode(int id) {
        this.id = id;
        this.rect = Rect.Companion.getZero();
        this.children = CollectionsKt.emptyList();
        this.config = new SemanticsConfiguration();
    }

    public SemanticsNode() {
        this(SemanticsNode.Companion.generateNewId());
    }

    static {
        Companion = new Companion(null);
    }

    public /* synthetic */ SemanticsNode(int id, DefaultConstructorMarker $constructor_marker) {
        this(id);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\b\u0010\b\u001a\u00020\u0004H\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/ui/core/semantics/SemanticsNode$Companion;", "", "()V", "lastIdentifier", "", "debugResetSemanticsIdCounter", "", "debugResetSemanticsIdCounter$ui_platform_release", "generateNewId", "root", "Landroidx/ui/core/semantics/SemanticsNode;", "owner", "Landroidx/ui/core/semantics/SemanticsOwner;", "ui-platform_release"})
    public static final class Companion {
        private final int generateNewId() {
            lastIdentifier = lastIdentifier + 1;
            return lastIdentifier;
        }

        @NotNull
        public final SemanticsNode root(@NotNull SemanticsOwner owner) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            SemanticsNode node = new SemanticsNode(0, null);
            node.attach(owner);
            return node;
        }

        public final void debugResetSemanticsIdCounter$ui_platform_release() {
            lastIdentifier = 0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

