/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core.text;

import android.content.Context;
import android.graphics.Typeface;
import androidx.core.content.res.ResourcesCompat;
import androidx.ui.text.font.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/ui/core/text/AndroidFontResourceLoader;", "Landroidx/ui/text/font/Font$ResourceLoader;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "load", "Landroid/graphics/Typeface;", "font", "Landroidx/ui/text/font/Font;", "ui-platform_release"})
public final class AndroidFontResourceLoader
implements Font.ResourceLoader {
    private final Context context;

    @NotNull
    public Typeface load(@NotNull Font font) {
        Intrinsics.checkParameterIsNotNull((Object)font, (String)"font");
        int resId = this.context.getResources().getIdentifier(StringsKt.substringBefore$default((String)font.getName(), (String)".", null, (int)2, null), "font", this.context.getPackageName());
        Typeface typeface = ResourcesCompat.getFont((Context)this.context, (int)resId);
        if (typeface == null) {
            Intrinsics.throwNpe();
        }
        return typeface;
    }

    public AndroidFontResourceLoader(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

