/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.input;

import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.VisibleForTesting;
import androidx.ui.input.BackspaceKeyEditOp;
import androidx.ui.input.CommitTextEditOp;
import androidx.ui.input.DeleteSurroundingTextEditOp;
import androidx.ui.input.DeleteSurroundingTextInCodePointsEditOp;
import androidx.ui.input.EditOperation;
import androidx.ui.input.FinishComposingTextEditOp;
import androidx.ui.input.ImeAction;
import androidx.ui.input.InputEventListener;
import androidx.ui.input.InputState;
import androidx.ui.input.InputStateKt;
import androidx.ui.input.MoveCursorEditOp;
import androidx.ui.input.RecordingInputConnectionKt;
import androidx.ui.input.SetComposingRegionEditOp;
import androidx.ui.input.SetComposingTextEditOp;
import androidx.ui.input.SetSelectionEditOp;
import androidx.ui.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\u0012\u0010 \u001a\u00020\u00102\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\"\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\b2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0012\u0010)\u001a\u00020\u00102\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u001a\u0010,\u001a\u00020\u00102\b\u0010!\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\bH\u0016J\u0018\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\bH\u0016J\u0018\u00102\u001a\u00020\u00102\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\bH\u0016J\b\u00103\u001a\u00020\u0010H\u0016J\b\u00104\u001a\u00020\u0010H\u0016J\u0010\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\bH\u0016J\u001a\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010&\u001a\u00020\bH\u0016J\n\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u0010\u0010=\u001a\u00020-2\u0006\u0010&\u001a\u00020\bH\u0016J\u0018\u0010>\u001a\u00020-2\u0006\u0010?\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0016J\u0018\u0010@\u001a\u00020-2\u0006\u0010?\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0016J\u0010\u0010A\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\bH\u0016J\u0010\u0010C\u001a\u00020\u00102\u0006\u0010D\u001a\u00020\bH\u0016J\u001c\u0010E\u001a\u00020\u00102\b\u0010F\u001a\u0004\u0018\u00010G2\b\u0010H\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010I\u001a\u00020\u00102\u0006\u0010J\u001a\u00020\u0010H\u0016J\u0010\u0010K\u001a\u00020\u00102\u0006\u0010L\u001a\u00020\bH\u0016J\u0010\u0010M\u001a\u00020\u00102\u0006\u0010N\u001a\u00020OH\u0016J\u0018\u0010P\u001a\u00020\u00102\u0006\u0010Q\u001a\u00020\b2\u0006\u0010R\u001a\u00020\bH\u0016J\u001a\u0010S\u001a\u00020\u00102\b\u0010!\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\bH\u0016J\u0018\u0010T\u001a\u00020\u00102\u0006\u0010Q\u001a\u00020\b2\u0006\u0010R\u001a\u00020\bH\u0016J\u001e\u0010U\u001a\u00020\u001a2\u0006\u0010V\u001a\u00020\u00032\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00038\u0000@@X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006["}, d2={"Landroidx/ui/input/RecordingInputConnection;", "Landroid/view/inputmethod/InputConnection;", "initState", "Landroidx/ui/input/InputState;", "eventListener", "Landroidx/ui/input/InputEventListener;", "(Landroidx/ui/input/InputState;Landroidx/ui/input/InputEventListener;)V", "batchDepth", "", "currentExtractedTextRequestToken", "editOps", "", "Landroidx/ui/input/EditOperation;", "getEventListener", "()Landroidx/ui/input/InputEventListener;", "extractedTextMonitorMode", "", "value", "inputState", "inputState$annotations", "()V", "getInputState$ui_platform_release", "()Landroidx/ui/input/InputState;", "setInputState$ui_platform_release", "(Landroidx/ui/input/InputState;)V", "addEditOpWithBatch", "", "editOp", "beginBatchEdit", "clearMetaKeyStates", "states", "closeConnection", "commitCompletion", "text", "Landroid/view/inputmethod/CompletionInfo;", "commitContent", "inputContentInfo", "Landroid/view/inputmethod/InputContentInfo;", "flags", "opts", "Landroid/os/Bundle;", "commitCorrection", "correctionInfo", "Landroid/view/inputmethod/CorrectionInfo;", "commitText", "", "newCursorPosition", "deleteSurroundingText", "beforeLength", "afterLength", "deleteSurroundingTextInCodePoints", "endBatchEdit", "finishComposingText", "getCursorCapsMode", "reqModes", "getExtractedText", "Landroid/view/inputmethod/ExtractedText;", "request", "Landroid/view/inputmethod/ExtractedTextRequest;", "getHandler", "Landroid/os/Handler;", "getSelectedText", "getTextAfterCursor", "maxChars", "getTextBeforeCursor", "performContextMenuAction", "id", "performEditorAction", "editorAction", "performPrivateCommand", "action", "", "data", "reportFullscreenMode", "enabled", "requestCursorUpdates", "cursorUpdateMode", "sendKeyEvent", "event", "Landroid/view/KeyEvent;", "setComposingRegion", "start", "end", "setComposingText", "setSelection", "updateInputState", "state", "imm", "Landroid/view/inputmethod/InputMethodManager;", "view", "Landroid/view/View;", "ui-platform_release"})
public final class RecordingInputConnection
implements InputConnection {
    private int batchDepth;
    @NotNull
    private InputState inputState;
    private int currentExtractedTextRequestToken;
    private boolean extractedTextMonitorMode;
    private final List<EditOperation> editOps;
    @NotNull
    private final InputEventListener eventListener;

    @VisibleForTesting
    public static /* synthetic */ void inputState$annotations() {
    }

    @NotNull
    public final InputState getInputState$ui_platform_release() {
        return this.inputState;
    }

    public final void setInputState$ui_platform_release(@NotNull InputState value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("New InputState has set: " + value + " -> " + this.inputState));
        }
        this.inputState = value;
    }

    public final void updateInputState(@NotNull InputState state, @NotNull InputMethodManager imm, @NotNull View view) {
        int candidateEnd;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)imm, (String)"imm");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        InputState prev = this.inputState;
        InputState next = state;
        this.setInputState$ui_platform_release(next);
        if (Intrinsics.areEqual((Object)prev, (Object)next)) {
            return;
        }
        if (this.extractedTextMonitorMode) {
            imm.updateExtractedText(view, this.currentExtractedTextRequestToken, InputStateKt.toExtractedText(next));
        }
        TextRange textRange = next.getComposition();
        int candidateStart = textRange != null ? textRange.getMin() : -1;
        TextRange textRange2 = next.getComposition();
        int n = candidateEnd = textRange2 != null ? textRange2.getMax() : -1;
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("updateSelection(" + "selection = (" + next.getSelection().getMin() + ',' + next.getSelection().getMax() + "), " + "compoairion = (" + candidateStart + ", " + candidateEnd + ')'));
        }
        imm.updateSelection(view, next.getSelection().getMin(), next.getSelection().getMax(), candidateStart, candidateEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addEditOpWithBatch(EditOperation editOp) {
        this.beginBatchEdit();
        try {
            this.editOps.add(editOp);
        }
        finally {
            this.endBatchEdit();
        }
    }

    public boolean beginBatchEdit() {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)"beginBatchEdit()");
        }
        int n = this.batchDepth;
        this.batchDepth = n + 1;
        return true;
    }

    public boolean endBatchEdit() {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)"endBatchEdit()");
        }
        int n = this.batchDepth;
        this.batchDepth = n + -1;
        if (this.batchDepth == 0) {
            Collection collection = this.editOps;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.eventListener.onEditOperations(CollectionsKt.toList((Iterable)this.editOps));
                this.editOps.clear();
            }
        }
        return this.batchDepth > 0;
    }

    public void closeConnection() {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)"closeConnection()");
        }
        this.editOps.clear();
        this.batchDepth = 0;
    }

    public boolean commitText(@Nullable CharSequence text, int newCursorPosition) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("commitText(\"" + text + "\", " + newCursorPosition + ')'));
        }
        this.addEditOpWithBatch((EditOperation)new CommitTextEditOp(String.valueOf(text), newCursorPosition));
        return true;
    }

    public boolean setComposingRegion(int start, int end) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("setComposingRegion(" + start + ", " + end + ')'));
        }
        this.addEditOpWithBatch((EditOperation)new SetComposingRegionEditOp(start, end));
        return true;
    }

    public boolean setComposingText(@Nullable CharSequence text, int newCursorPosition) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("setComposingText(\"" + text + "\", " + newCursorPosition + ')'));
        }
        this.addEditOpWithBatch((EditOperation)new SetComposingTextEditOp(String.valueOf(text), newCursorPosition));
        return true;
    }

    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("deleteSurroundingTextInCodePoints(" + beforeLength + ", " + afterLength + ')'));
        }
        this.addEditOpWithBatch((EditOperation)new DeleteSurroundingTextInCodePointsEditOp(beforeLength, afterLength));
        return true;
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("deleteSurroundingText(" + beforeLength + ", " + afterLength + ')'));
        }
        this.addEditOpWithBatch((EditOperation)new DeleteSurroundingTextEditOp(beforeLength, afterLength));
        return true;
    }

    public boolean setSelection(int start, int end) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("setSelection(" + start + ", " + end + ')'));
        }
        this.addEditOpWithBatch((EditOperation)new SetSelectionEditOp(start, end));
        return true;
    }

    public boolean finishComposingText() {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)"finishComposingText()");
        }
        this.addEditOpWithBatch((EditOperation)new FinishComposingTextEditOp());
        return true;
    }

    public boolean sendKeyEvent(@NotNull KeyEvent event) {
        EditOperation editOperation;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("sendKeyEvent(" + event + ')'));
        }
        if (event.getAction() != 0) {
            return true;
        }
        switch (event.getKeyCode()) {
            case 67: {
                editOperation = (EditOperation)new BackspaceKeyEditOp();
                break;
            }
            case 21: {
                editOperation = (EditOperation)new MoveCursorEditOp(-1);
                break;
            }
            case 22: {
                editOperation = (EditOperation)new MoveCursorEditOp(1);
                break;
            }
            default: {
                char[] cArray = Character.toChars(event.getUnicodeChar());
                Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"Character.toChars(event.getUnicodeChar())");
                char[] cArray2 = cArray;
                boolean bl = false;
                String string = new String(cArray2);
                int n = 1;
                String string2 = string;
                editOperation = (EditOperation)new CommitTextEditOp(string2, n);
            }
        }
        EditOperation op = editOperation;
        this.addEditOpWithBatch(op);
        return true;
    }

    @NotNull
    public CharSequence getTextBeforeCursor(int maxChars, int flags) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("getTextBeforeCursor(" + maxChars + ", " + flags + ')'));
        }
        return this.inputState.getTextBeforeSelection(maxChars);
    }

    @NotNull
    public CharSequence getTextAfterCursor(int maxChars, int flags) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("getTextAfterCursor(" + maxChars + ", " + flags + ')'));
        }
        return this.inputState.getTextAfterSelection(maxChars);
    }

    @NotNull
    public CharSequence getSelectedText(int flags) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("getSelectedText(" + flags + ')'));
        }
        return this.inputState.getSelectedText();
    }

    public boolean requestCursorUpdates(int cursorUpdateMode) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("requestCursorUpdates(" + cursorUpdateMode + ')'));
        }
        Log.w((String)RecordingInputConnectionKt.access$getTAG$p(), (String)"requestCursorUpdates is not supported");
        return false;
    }

    @NotNull
    public ExtractedText getExtractedText(@Nullable ExtractedTextRequest request, int flags) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("getExtractedText(" + request + ", " + flags + ')'));
        }
        boolean bl = this.extractedTextMonitorMode = (flags & 1) != 0;
        if (this.extractedTextMonitorMode) {
            ExtractedTextRequest extractedTextRequest = request;
            this.currentExtractedTextRequestToken = extractedTextRequest != null ? extractedTextRequest.token : 0;
        }
        return InputStateKt.toExtractedText(this.inputState);
    }

    public boolean performContextMenuAction(int id) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("performContextMenuAction(" + id + ')'));
        }
        Log.w((String)RecordingInputConnectionKt.access$getTAG$p(), (String)"performContextMenuAction is not supported");
        return false;
    }

    public boolean performEditorAction(int editorAction) {
        ImeAction imeAction;
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("performEditorAction(" + editorAction + ')'));
        }
        switch (editorAction) {
            case 0: {
                imeAction = ImeAction.Unspecified;
                break;
            }
            case 6: {
                imeAction = ImeAction.Done;
                break;
            }
            case 4: {
                imeAction = ImeAction.Send;
                break;
            }
            case 3: {
                imeAction = ImeAction.Search;
                break;
            }
            case 7: {
                imeAction = ImeAction.Previous;
                break;
            }
            case 5: {
                imeAction = ImeAction.Next;
                break;
            }
            case 2: {
                imeAction = ImeAction.Go;
                break;
            }
            default: {
                Log.w((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("IME sends unsupported Editor Action: " + editorAction));
                imeAction = ImeAction.Unspecified;
            }
        }
        ImeAction imeAction2 = imeAction;
        this.eventListener.onImeAction(imeAction2);
        return true;
    }

    public boolean commitCompletion(@Nullable CompletionInfo text) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            CompletionInfo completionInfo = text;
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("commitCompletion(" + (completionInfo != null ? completionInfo.getText() : null) + ')'));
        }
        return false;
    }

    public boolean commitCorrection(@Nullable CorrectionInfo correctionInfo) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("commitCorrection(" + correctionInfo + ')'));
        }
        return false;
    }

    @Nullable
    public Handler getHandler() {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)"getHandler()");
        }
        return null;
    }

    public boolean clearMetaKeyStates(int states) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("clearMetaKeyStates(" + states + ')'));
        }
        return false;
    }

    public boolean reportFullscreenMode(boolean enabled) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("reportFullscreenMode(" + enabled + ')'));
        }
        return false;
    }

    public int getCursorCapsMode(int reqModes) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("getCursorCapsMode(" + reqModes + ')'));
        }
        return TextUtils.getCapsMode((CharSequence)this.inputState.getText(), (int)this.inputState.getSelection().getMin(), (int)reqModes);
    }

    public boolean performPrivateCommand(@Nullable String action, @Nullable Bundle data) {
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("performPrivateCommand(" + action + ", " + data + ')'));
        }
        return true;
    }

    public boolean commitContent(@NotNull InputContentInfo inputContentInfo, int flags, @Nullable Bundle opts) {
        Intrinsics.checkParameterIsNotNull((Object)inputContentInfo, (String)"inputContentInfo");
        if (RecordingInputConnectionKt.access$getDEBUG$p()) {
            Log.d((String)RecordingInputConnectionKt.access$getTAG$p(), (String)("commitContent(" + inputContentInfo + ", " + flags + ", " + opts + ')'));
        }
        return false;
    }

    @NotNull
    public final InputEventListener getEventListener() {
        return this.eventListener;
    }

    public RecordingInputConnection(@NotNull InputState initState, @NotNull InputEventListener eventListener) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)initState, (String)"initState");
        Intrinsics.checkParameterIsNotNull((Object)eventListener, (String)"eventListener");
        this.eventListener = eventListener;
        this.inputState = initState;
        RecordingInputConnection recordingInputConnection = this;
        boolean bl = false;
        recordingInputConnection.editOps = list = (List)new ArrayList();
    }
}

