/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.input;

import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import androidx.ui.engine.geometry.Rect;
import androidx.ui.input.EditOperation;
import androidx.ui.input.ImeAction;
import androidx.ui.input.InputEventListener;
import androidx.ui.input.InputState;
import androidx.ui.input.KeyboardType;
import androidx.ui.input.PlatformTextInputService;
import androidx.ui.input.RecordingInputConnection;
import androidx.ui.input.TextInputServiceAndroid;
import androidx.ui.input.TextInputServiceAndroid$WhenMappings;
import androidx.ui.text.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010\u001d\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\u0006\u0010\u001f\u001a\u00020\u0006J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0016H\u0016J\b\u0010%\u001a\u00020\u0013H\u0016JN\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0018\u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u00130\u00102\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00130\u0010H\u0016J\b\u0010(\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Landroidx/ui/input/TextInputServiceAndroid;", "Landroidx/ui/input/PlatformTextInputService;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "editorHasFocus", "", "ic", "Landroidx/ui/input/RecordingInputConnection;", "imeAction", "Landroidx/ui/input/ImeAction;", "imm", "Landroid/view/inputmethod/InputMethodManager;", "keyboardType", "Landroidx/ui/input/KeyboardType;", "onEditCommand", "Lkotlin/Function1;", "", "Landroidx/ui/input/EditOperation;", "", "onImeActionPerformed", "state", "Landroidx/ui/input/InputState;", "getView", "()Landroid/view/View;", "createInputConnection", "Landroid/view/inputmethod/InputConnection;", "outAttrs", "Landroid/view/inputmethod/EditorInfo;", "fillEditorInfo", "outInfo", "isEditorFocused", "notifyFocusedRect", "rect", "Landroidx/ui/engine/geometry/Rect;", "onStateUpdated", "model", "showSoftwareKeyboard", "startInput", "initModel", "stopInput", "ui-platform_release"})
public final class TextInputServiceAndroid
implements PlatformTextInputService {
    private boolean editorHasFocus;
    private Function1<? super List<? extends EditOperation>, Unit> onEditCommand;
    private Function1<? super ImeAction, Unit> onImeActionPerformed;
    private InputState state;
    private KeyboardType keyboardType;
    private ImeAction imeAction;
    private RecordingInputConnection ic;
    private InputMethodManager imm;
    @NotNull
    private final View view;

    @Nullable
    public final InputConnection createInputConnection(@NotNull EditorInfo outAttrs) {
        Intrinsics.checkParameterIsNotNull((Object)outAttrs, (String)"outAttrs");
        if (!this.editorHasFocus) {
            return null;
        }
        this.fillEditorInfo(this.keyboardType, this.imeAction, outAttrs);
        RecordingInputConnection recordingInputConnection = new RecordingInputConnection(this.state, new InputEventListener(this){
            final /* synthetic */ TextInputServiceAndroid this$0;

            public void onEditOperations(@NotNull List<? extends EditOperation> editOps) {
                Intrinsics.checkParameterIsNotNull(editOps, (String)"editOps");
                TextInputServiceAndroid.access$getOnEditCommand$p(this.this$0).invoke(editOps);
            }

            public void onImeAction(@NotNull ImeAction imeAction) {
                Intrinsics.checkParameterIsNotNull((Object)imeAction, (String)"imeAction");
                TextInputServiceAndroid.access$getOnImeActionPerformed$p(this.this$0).invoke((Object)imeAction);
            }
            {
                this.this$0 = $outer;
            }
        });
        boolean bl = false;
        boolean bl2 = false;
        RecordingInputConnection it = recordingInputConnection;
        boolean bl3 = false;
        this.ic = it;
        return recordingInputConnection;
    }

    public final boolean isEditorFocused() {
        return this.editorHasFocus;
    }

    public void startInput(@NotNull InputState initModel, @NotNull KeyboardType keyboardType, @NotNull ImeAction imeAction, @NotNull Function1<? super List<? extends EditOperation>, Unit> onEditCommand2, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed2) {
        Intrinsics.checkParameterIsNotNull((Object)initModel, (String)"initModel");
        Intrinsics.checkParameterIsNotNull((Object)keyboardType, (String)"keyboardType");
        Intrinsics.checkParameterIsNotNull((Object)imeAction, (String)"imeAction");
        Intrinsics.checkParameterIsNotNull(onEditCommand2, (String)"onEditCommand");
        Intrinsics.checkParameterIsNotNull(onImeActionPerformed2, (String)"onImeActionPerformed");
        Object object = this.view.getContext().getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        this.imm = (InputMethodManager)object;
        this.editorHasFocus = true;
        this.state = initModel;
        this.keyboardType = keyboardType;
        this.imeAction = imeAction;
        this.onEditCommand = onEditCommand2;
        this.onImeActionPerformed = onImeActionPerformed2;
        this.view.requestFocus();
        this.view.post(new Runnable(this){
            final /* synthetic */ TextInputServiceAndroid this$0;

            public final void run() {
                TextInputServiceAndroid.access$getImm$p(this.this$0).restartInput(this.this$0.getView());
                TextInputServiceAndroid.access$getImm$p(this.this$0).showSoftInput(this.this$0.getView(), 0);
            }
            {
                this.this$0 = textInputServiceAndroid;
            }
        });
    }

    public void stopInput() {
        this.editorHasFocus = false;
        this.onEditCommand = stopInput.1.INSTANCE;
        this.onImeActionPerformed = stopInput.2.INSTANCE;
        InputMethodManager inputMethodManager = this.imm;
        if (inputMethodManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imm");
        }
        inputMethodManager.restartInput(this.view);
    }

    public void showSoftwareKeyboard() {
        InputMethodManager inputMethodManager = this.imm;
        if (inputMethodManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imm");
        }
        inputMethodManager.showSoftInput(this.view, 0);
    }

    public void onStateUpdated(@NotNull InputState model) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            this.state = model;
            RecordingInputConnection recordingInputConnection = this.ic;
            if (recordingInputConnection == null) break block1;
            InputMethodManager inputMethodManager = this.imm;
            if (inputMethodManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imm");
            }
            recordingInputConnection.updateInputState(this.state, inputMethodManager, this.view);
        }
    }

    public void notifyFocusedRect(@NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        this.view.requestRectangleOnScreen(new android.graphics.Rect(MathKt.roundToInt((float)rect.getLeft()), MathKt.roundToInt((float)rect.getTop()), MathKt.roundToInt((float)rect.getRight()), MathKt.roundToInt((float)rect.getBottom())));
    }

    private final void fillEditorInfo(KeyboardType keyboardType, ImeAction imeAction, EditorInfo outInfo) {
        int n;
        switch (TextInputServiceAndroid$WhenMappings.$EnumSwitchMapping$0[imeAction.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 5: {
                n = 7;
                break;
            }
            case 6: {
                n = 3;
                break;
            }
            case 7: {
                n = 4;
                break;
            }
            case 8: {
                n = 6;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unknown ImeAction: " + imeAction);
            }
        }
        outInfo.imeOptions = n;
        switch (TextInputServiceAndroid$WhenMappings.$EnumSwitchMapping$1[keyboardType.ordinal()]) {
            case 1: {
                outInfo.inputType = 1;
                break;
            }
            case 2: {
                outInfo.inputType = 1;
                outInfo.imeOptions |= Integer.MIN_VALUE;
                break;
            }
            case 3: {
                outInfo.inputType = 2;
                break;
            }
            case 4: {
                outInfo.inputType = 3;
                break;
            }
            case 5: {
                outInfo.inputType = 17;
                break;
            }
            case 6: {
                outInfo.inputType = 33;
                break;
            }
            case 7: {
                outInfo.inputType = 129;
                break;
            }
            case 8: {
                outInfo.inputType = 18;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unknown KeyboardType: " + keyboardType);
            }
        }
        outInfo.imeOptions = outInfo.imeOptions | outInfo.imeOptions | 0x2000000;
    }

    @NotNull
    public final View getView() {
        return this.view;
    }

    public TextInputServiceAndroid(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.view = view;
        this.onEditCommand = onEditCommand.1.INSTANCE;
        this.onImeActionPerformed = onImeActionPerformed.1.INSTANCE;
        this.state = new InputState("", new TextRange(0, 0), null, 4, null);
        this.keyboardType = KeyboardType.Text;
        this.imeAction = ImeAction.Unspecified;
    }

    public static final /* synthetic */ Function1 access$getOnEditCommand$p(TextInputServiceAndroid $this) {
        return $this.onEditCommand;
    }

    public static final /* synthetic */ void access$setOnEditCommand$p(TextInputServiceAndroid $this, Function1 function1) {
        $this.onEditCommand = function1;
    }

    public static final /* synthetic */ Function1 access$getOnImeActionPerformed$p(TextInputServiceAndroid $this) {
        return $this.onImeActionPerformed;
    }

    public static final /* synthetic */ void access$setOnImeActionPerformed$p(TextInputServiceAndroid $this, Function1 function1) {
        $this.onImeActionPerformed = function1;
    }

    public static final /* synthetic */ InputMethodManager access$getImm$p(TextInputServiceAndroid $this) {
        InputMethodManager inputMethodManager = $this.imm;
        if (inputMethodManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imm");
        }
        return inputMethodManager;
    }

    public static final /* synthetic */ void access$setImm$p(TextInputServiceAndroid $this, InputMethodManager inputMethodManager) {
        $this.imm = inputMethodManager;
    }
}

