/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Choreographer;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.compose.Recomposer;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.ui.core.SemanticsTreeNode;
import androidx.ui.core.SemanticsTreeProvider;
import androidx.ui.core.semantics.SemanticsConfiguration;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.SemanticsTreeInteraction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0004/012B(\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0015\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0010\u00a2\u0006\u0002\b\u001eJ\r\u0010\u001f\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b J\u001c\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\"0\u0005H\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0002J\u001d\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0010\u00a2\u0006\u0002\b,J\r\u0010-\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b.R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Landroidx/ui/test/android/AndroidSemanticsTreeInteraction;", "Landroidx/ui/test/SemanticsTreeInteraction;", "throwOnRecomposeTimeOut", "", "selector", "Lkotlin/Function1;", "Landroidx/ui/core/semantics/SemanticsConfiguration;", "Lkotlin/ExtensionFunctionType;", "(ZLkotlin/jvm/functions/Function1;)V", "defaultRecomposeWaitTimeMs", "", "hadPendingChangesAfterLastAction", "getHadPendingChangesAfterLastAction$ui_test_release", "()Z", "setHadPendingChangesAfterLastAction$ui_test_release", "(Z)V", "handler", "Landroid/os/Handler;", "collectSemanticTreeProviders", "Landroidx/ui/test/android/AndroidSemanticsTreeInteraction$AggregatedSemanticTreeProvider;", "contentViewGroup", "Landroid/view/ViewGroup;", "contains", "semanticsConfiguration", "contains$ui_test_release", "findActivityAndTreeProvider", "Landroidx/ui/test/android/AndroidSemanticsTreeInteraction$CollectedInfo;", "findAllMatching", "", "Landroidx/ui/test/SemanticsNodeInteraction;", "findAllMatching$ui_test_release", "findOne", "findOne$ui_test_release", "performAction", "", "action", "Landroidx/ui/core/SemanticsTreeProvider;", "scheduleIdleCheck", "latch", "Ljava/util/concurrent/CountDownLatch;", "sendClick", "x", "", "y", "sendClick$ui_test_release", "waitForIdleCompose", "waitForIdleCompose$ui_test_release", "AggregatedSemanticTreeProvider", "CollectedInfo", "RecomposeTimeOutException", "ViewForwarder", "ui-test_release"})
public final class AndroidSemanticsTreeInteraction
extends SemanticsTreeInteraction {
    private final boolean throwOnRecomposeTimeOut;
    private final Function1<SemanticsConfiguration, Boolean> selector;
    public boolean hadPendingChangesAfterLastAction;
    private final long defaultRecomposeWaitTimeMs;
    private final Handler handler;

    public AndroidSemanticsTreeInteraction(boolean throwOnRecomposeTimeOut, @NotNull Function1<? super SemanticsConfiguration, Boolean> selector) {
        Intrinsics.checkParameterIsNotNull(selector, (String)"selector");
        this.throwOnRecomposeTimeOut = throwOnRecomposeTimeOut;
        this.selector = selector;
        this.defaultRecomposeWaitTimeMs = 1000L;
        this.handler = new Handler(Looper.getMainLooper());
    }

    public final boolean getHadPendingChangesAfterLastAction$ui_test_release() {
        return this.hadPendingChangesAfterLastAction;
    }

    public final void setHadPendingChangesAfterLastAction$ui_test_release(boolean bl) {
        this.hadPendingChangesAfterLastAction = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SemanticsNodeInteraction> findAllMatching$ui_test_release() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        this.waitForIdleCompose$ui_test_release();
        Iterable iterable = this.findActivityAndTreeProvider().getTreeProvider().getAllSemanticNodes();
        AndroidSemanticsTreeInteraction androidSemanticsTreeInteraction = this;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SemanticsTreeNode semanticsTreeNode = (SemanticsTreeNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            SemanticsNodeInteraction semanticsNodeInteraction = new SemanticsNodeInteraction((SemanticsTreeNode)it, androidSemanticsTreeInteraction);
            collection.add(semanticsNodeInteraction);
        }
        $this$map$iv = (List)destination$iv$iv;
        androidSemanticsTreeInteraction = this;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SemanticsNodeInteraction node = (SemanticsNodeInteraction)element$iv$iv;
            if (!((Boolean)androidSemanticsTreeInteraction.selector.invoke((Object)node.getSemanticsTreeNode$ui_test_release().getData())).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public SemanticsNodeInteraction findOne$ui_test_release() {
        List<SemanticsNodeInteraction> foundNodes = this.findAllMatching$ui_test_release();
        if (foundNodes.size() != 1) {
            throw (Throwable)((Object)new AssertionError((Object)("Found '" + foundNodes.size() + "' nodes but exactly '1' was expected!")));
        }
        return (SemanticsNodeInteraction)CollectionsKt.first(foundNodes);
    }

    private final void performAction(Function1<? super SemanticsTreeProvider, Unit> action) {
        CollectedInfo collectedInfo = this.findActivityAndTreeProvider();
        this.handler.post(new Runnable(action, collectedInfo){
            private final /* synthetic */ CollectedInfo $collectedInfo;
            private final /* synthetic */ Function1<SemanticsTreeProvider, Unit> $action;
            {
                Intrinsics.checkParameterIsNotNull($action, (String)"$action");
                Intrinsics.checkParameterIsNotNull((Object)$collectedInfo, (String)"$collectedInfo");
                this.$action = $action;
                this.$collectedInfo = $collectedInfo;
            }

            public void run() {
                this.$action.invoke((Object)this.$collectedInfo.getTreeProvider());
            }
        });
        this.setHadPendingChangesAfterLastAction$ui_test_release(this.waitForIdleCompose$ui_test_release());
    }

    @Override
    public boolean waitForIdleCompose$ui_test_release() {
        if (Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper())) {
            throw (Throwable)new Exception("Cannot be run on UI thread.");
        }
        Ref.BooleanRef hadPendingChanges = new Ref.BooleanRef();
        hadPendingChanges.element = false;
        CountDownLatch latch = new CountDownLatch(1);
        this.handler.post(new Runnable(hadPendingChanges, this, latch){
            private final /* synthetic */ Ref.BooleanRef $hadPendingChanges;
            private final /* synthetic */ CountDownLatch $latch;
            private final /* synthetic */ AndroidSemanticsTreeInteraction $this;
            {
                Intrinsics.checkParameterIsNotNull((Object)$hadPendingChanges, (String)"$hadPendingChanges");
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$this");
                Intrinsics.checkParameterIsNotNull((Object)$latch, (String)"$latch");
                this.$this = $receiver;
                this.$latch = $latch;
                this.$hadPendingChanges = $hadPendingChanges;
            }

            public void run() {
                this.$hadPendingChanges.element = Recomposer.Companion.hasPendingChanges();
                if (this.$hadPendingChanges.element) {
                    AndroidSemanticsTreeInteraction.access$scheduleIdleCheck(this.$this, this.$latch);
                } else {
                    this.$latch.countDown();
                }
            }
        });
        boolean succeeded = latch.await(this.defaultRecomposeWaitTimeMs, TimeUnit.MILLISECONDS);
        if (this.throwOnRecomposeTimeOut && !succeeded) {
            throw (Throwable)new RecomposeTimeOutException();
        }
        return hadPendingChanges.element;
    }

    private final void scheduleIdleCheck(CountDownLatch latch) {
        Choreographer.getInstance().postFrameCallback(new Choreographer.FrameCallback(this, latch){
            private final /* synthetic */ AndroidSemanticsTreeInteraction $this;
            private final /* synthetic */ CountDownLatch $latch;
            {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$this");
                Intrinsics.checkParameterIsNotNull((Object)$latch, (String)"$latch");
                this.$latch = $latch;
                this.$this = $receiver;
            }

            @SuppressLint(value={"SyntheticAccessor"})
            public void doFrame(long frameTimeNanos) {
                if (Recomposer.Companion.hasPendingChanges()) {
                    AndroidSemanticsTreeInteraction.access$scheduleIdleCheck(this.$this, this.$latch);
                } else {
                    this.$latch.countDown();
                }
            }
        });
    }

    @Override
    public void sendClick$ui_test_release(float x, float y) {
        this.performAction((Function1<? super SemanticsTreeProvider, Unit>)((Function1)new Function1<SemanticsTreeProvider, Unit>(x, y){
            final /* synthetic */ float $x;
            final /* synthetic */ float $y;
            {
                this.$x = $x;
                this.$y = $y;
            }

            public final /* synthetic */ void invoke(@NotNull SemanticsTreeProvider p1) {
                AndroidSemanticsTreeInteraction.access$sendClick$lambda-2(this.$x, this.$y, p1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains$ui_test_release(@NotNull SemanticsConfiguration semanticsConfiguration) {
        boolean bl;
        block3: {
            void $this$any$iv;
            Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"semanticsConfiguration");
            this.waitForIdleCompose$ui_test_release();
            Iterable iterable = this.findActivityAndTreeProvider().getTreeProvider().getAllSemanticNodes();
            SemanticsConfiguration semanticsConfiguration2 = semanticsConfiguration;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SemanticsTreeNode it = (SemanticsTreeNode)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getData(), (Object)semanticsConfiguration2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final CollectedInfo findActivityAndTreeProvider() {
        View view;
        ViewForwarder viewForwarder = new ViewForwarder();
        Espresso.onView((Matcher)ViewMatchers.withId((int)0x1020002)).check((ViewAssertion)viewForwarder);
        if (viewForwarder.getViewFound() == null) {
            throw (Throwable)new IllegalArgumentException("Couldn't find a Compose root in the view hierarchy. Are you using Compose in your Activity?");
        }
        View view2 = viewForwarder.getViewFound();
        if (view2 == null) {
            Intrinsics.throwNpe();
            view = null;
        } else {
            view = view2;
        }
        ViewGroup view3 = (ViewGroup)view;
        return new CollectedInfo(view3.getContext(), this.collectSemanticTreeProviders(view3));
    }

    private final AggregatedSemanticTreeProvider collectSemanticTreeProviders(ViewGroup contentViewGroup) {
        boolean bl = false;
        Set collectedRoots = new LinkedHashSet();
        AndroidSemanticsTreeInteraction.collectSemanticTreeProviders$collectSemanticTreeProvidersInternal(collectedRoots, contentViewGroup);
        return new AggregatedSemanticTreeProvider(collectedRoots);
    }

    private static final void sendClick$lambda-2(float $x, float $y, SemanticsTreeProvider treeProvider) {
        MotionEvent eventDown = MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)10L, (int)0, (float)$x, (float)$y, (int)0);
        treeProvider.sendEvent(eventDown);
        eventDown.recycle();
        MotionEvent eventUp = MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)10L, (int)1, (float)$x, (float)$y, (int)0);
        treeProvider.sendEvent(eventUp);
        eventUp.recycle();
    }

    private static final void collectSemanticTreeProviders$collectSemanticTreeProvidersInternal(Set<SemanticsTreeProvider> $collectedRoots, ViewGroup parent) {
        block2: {
            int n = parent.getChildCount();
            int n2 = 0;
            int n3 = n + -1;
            int n4 = 1;
            if (n == Integer.MIN_VALUE || n2 > n3) break block2;
            do {
                int index = n2;
                n2 += n4;
                View child = parent.getChildAt(index);
                if (child instanceof SemanticsTreeProvider) {
                    $collectedRoots.add((SemanticsTreeProvider)child);
                    continue;
                }
                if (!(child instanceof ViewGroup)) continue;
                AndroidSemanticsTreeInteraction.collectSemanticTreeProviders$collectSemanticTreeProvidersInternal($collectedRoots, (ViewGroup)child);
            } while (n2 <= n3);
        }
    }

    public static final /* synthetic */ void access$scheduleIdleCheck(AndroidSemanticsTreeInteraction $this, CountDownLatch latch) {
        $this.scheduleIdleCheck(latch);
    }

    public static final /* synthetic */ void access$sendClick$lambda-2(float $x, float $y, SemanticsTreeProvider treeProvider) {
        AndroidSemanticsTreeInteraction.sendClick$lambda-2($x, $y, treeProvider);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/ui/test/android/AndroidSemanticsTreeInteraction$AggregatedSemanticTreeProvider;", "Landroidx/ui/core/SemanticsTreeProvider;", "collectedRoots", "", "(Ljava/util/Set;)V", "getAllSemanticNodes", "", "Landroidx/ui/core/SemanticsTreeNode;", "sendEvent", "", "event", "Landroid/view/MotionEvent;", "ui-test_release"})
    private static final class AggregatedSemanticTreeProvider
    implements SemanticsTreeProvider {
        private final Set<SemanticsTreeProvider> collectedRoots;

        public AggregatedSemanticTreeProvider(@NotNull Set<? extends SemanticsTreeProvider> collectedRoots) {
            Intrinsics.checkParameterIsNotNull(collectedRoots, (String)"collectedRoots");
            this.collectedRoots = collectedRoots;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<SemanticsTreeNode> getAllSemanticNodes() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.collectedRoots;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                SemanticsTreeProvider it = (SemanticsTreeProvider)element$iv$iv;
                Iterable list$iv$iv = it.getAllSemanticNodes();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public void sendEvent(@NotNull MotionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            ((SemanticsTreeProvider)CollectionsKt.first((Iterable)this.collectedRoots)).sendEvent(event);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Landroidx/ui/test/android/AndroidSemanticsTreeInteraction$ViewForwarder;", "Landroidx/test/espresso/ViewAssertion;", "()V", "viewFound", "Landroid/view/View;", "getViewFound", "()Landroid/view/View;", "setViewFound", "(Landroid/view/View;)V", "check", "", "view", "noViewFoundException", "Landroidx/test/espresso/NoMatchingViewException;", "ui-test_release"})
    private static final class ViewForwarder
    implements ViewAssertion {
        @Nullable
        public View viewFound;

        @Nullable
        public final View getViewFound() {
            return this.viewFound;
        }

        public final void setViewFound(@Nullable View view) {
            this.viewFound = view;
        }

        public void check(@Nullable View view, @Nullable NoMatchingViewException noViewFoundException) {
            this.setViewFound(view);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Landroidx/ui/test/android/AndroidSemanticsTreeInteraction$RecomposeTimeOutException;", "", "()V", "ui-test_release"})
    public static final class RecomposeTimeOutException
    extends Throwable {
        public RecomposeTimeOutException() {
            super("Waiting for recompose has exceeded the timeout!");
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Landroidx/ui/test/android/AndroidSemanticsTreeInteraction$CollectedInfo;", "", "context", "Landroid/content/Context;", "treeProvider", "Landroidx/ui/core/SemanticsTreeProvider;", "(Landroid/content/Context;Landroidx/ui/core/SemanticsTreeProvider;)V", "getContext", "()Landroid/content/Context;", "getTreeProvider", "()Landroidx/ui/core/SemanticsTreeProvider;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ui-test_release"})
    private static final class CollectedInfo {
        @NotNull
        public final Context context;
        @NotNull
        public final SemanticsTreeProvider treeProvider;

        public CollectedInfo(@NotNull Context context, @NotNull SemanticsTreeProvider treeProvider) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)treeProvider, (String)"treeProvider");
            this.context = context;
            this.treeProvider = treeProvider;
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        @NotNull
        public final SemanticsTreeProvider getTreeProvider() {
            return this.treeProvider;
        }

        @NotNull
        public final Context component1() {
            return this.getContext();
        }

        @NotNull
        public final SemanticsTreeProvider component2() {
            return this.getTreeProvider();
        }

        @NotNull
        public final CollectedInfo copy(@NotNull Context context, @NotNull SemanticsTreeProvider treeProvider) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)treeProvider, (String)"treeProvider");
            return new CollectedInfo(context, treeProvider);
        }

        public static /* synthetic */ CollectedInfo copy$default(CollectedInfo this_, Context context, SemanticsTreeProvider treeProvider, int $mask0, Object $handler) {
            Context context2 = ($mask0 & 1) != 0 ? this_.getContext() : context;
            SemanticsTreeProvider semanticsTreeProvider = ($mask0 & 2) != 0 ? this_.getTreeProvider() : treeProvider;
            return this_.copy(context2, semanticsTreeProvider);
        }

        @NotNull
        public String toString() {
            return "CollectedInfo(context=" + this.getContext() + ", treeProvider=" + this.getTreeProvider() + ")";
        }

        public int hashCode() {
            int n = 0;
            n = this.getContext().hashCode();
            n = n * 31 + this.getTreeProvider().hashCode();
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CollectedInfo)) {
                return false;
            }
            CollectedInfo collectedInfo = (CollectedInfo)other;
            if (!Intrinsics.areEqual((Object)this.getContext(), (Object)collectedInfo.getContext())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.getTreeProvider(), (Object)collectedInfo.getTreeProvider());
        }
    }
}

