/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.ComponentNode;
import androidx.ui.core.ComponentNodesKt;
import androidx.ui.core.IntPx;
import androidx.ui.core.LayoutNode;
import androidx.ui.core.Px;
import androidx.ui.core.PxPosition;
import androidx.ui.core.RepaintBoundaryNode;
import androidx.ui.core.SemanticsTreeNode;
import androidx.ui.core.semantics.SemanticsConfiguration;
import androidx.ui.core.semantics.SemanticsConfigurationKt;
import androidx.ui.engine.geometry.Rect;
import androidx.ui.foundation.selection.ToggleableState;
import androidx.ui.foundation.semantics.FoundationSemanticsProperties;
import androidx.ui.semantics.SemanticsProperties;
import androidx.ui.semantics.SemanticsPropertiesKt;
import androidx.ui.semantics.SemanticsPropertyKey;
import androidx.ui.semantics.SemanticsPropertyReceiver;
import androidx.ui.test.FiltersKt;
import androidx.ui.test.GoldenSemanticsKt;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.SemanticsTreeInteraction;
import androidx.ui.test.SemanticsTreeInteractionKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001f\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\tH\u0000\u001a\n\u0010\r\u001a\u00020\t*\u00020\t\u001a\n\u0010\u000e\u001a\u00020\t*\u00020\t\u001a\n\u0010\u000f\u001a\u00020\t*\u00020\t\u001a\n\u0010\u0010\u001a\u00020\t*\u00020\t\u001a\n\u0010\u0011\u001a\u00020\t*\u00020\t\u001a\n\u0010\u0012\u001a\u00020\t*\u00020\t\u001a\n\u0010\u0013\u001a\u00020\t*\u00020\t\u001a\n\u0010\u0014\u001a\u00020\t*\u00020\t\u001a\f\u0010\u0015\u001a\u00020\t*\u00020\tH\u0000\u001a\n\u0010\u0016\u001a\u00020\t*\u00020\t\u001a\f\u0010\u0017\u001a\u00020\t*\u00020\tH\u0000\u001a\n\u0010\u0018\u001a\u00020\t*\u00020\t\u001a\n\u0010\u0019\u001a\u00020\t*\u00020\t\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\t\u001a\u0012\u0010\u001b\u001a\u00020\t*\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0004\u001a\u0012\u0010\u001d\u001a\u00020\t*\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\f\u0010 \u001a\u00020\u0005*\u00020\tH\u0002\u001a\u0014\u0010!\u001a\u00020\u0005*\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002\u001a2\u0010%\u001a\u00020\u0001*\u00020\t2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0\u00032\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u001a2\u0010(\u001a\u00020\u0001*\u00020\t2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0\u00032\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a8\u0006)"}, d2={"assertDoesNotExist", "", "selector", "Lkotlin/Function1;", "Landroidx/ui/core/semantics/SemanticsConfiguration;", "", "Lkotlin/ExtensionFunctionType;", "assertCountEquals", "", "Landroidx/ui/test/SemanticsNodeInteraction;", "count", "", "assertExists", "assertHasClickAction", "assertHasNoClickAction", "assertIsDisplayed", "assertIsHidden", "assertIsInMutuallyExclusiveGroup", "assertIsNotDisplayed", "assertIsOff", "assertIsOn", "assertIsSelectable", "assertIsSelected", "assertIsToggleable", "assertIsUnselected", "assertIsVisible", "assertNoLongerExists", "assertSemanticsIsEqualTo", "expectedProperties", "assertValueEquals", "value", "", "checkIsDisplayed", "contains", "Landroidx/ui/core/LayoutNode;", "rectangle", "Landroidx/ui/engine/geometry/Rect;", "verify", "assertionMessage", "condition", "verifyHierarchy", "ui-test_release"})
public final class AssertionsKt {
    public static final void assertDoesNotExist(@NotNull Function1<? super SemanticsConfiguration, Boolean> selector) {
        Intrinsics.checkParameterIsNotNull(selector, (String)"selector");
        List<SemanticsNodeInteraction> foundNodes = ((SemanticsTreeInteraction)SemanticsTreeInteractionKt.getSemanticsTreeInteractionFactory().invoke(selector)).findAllMatching$ui_test_release();
        Collection collection = foundNodes;
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw new AssertionError((Object)("Found '" + foundNodes.size() + "' components that match, expected '0' components"));
        }
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsVisible(@NotNull SemanticsNodeInteraction $this$assertIsVisible) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsVisible, (String)"<this>");
        AssertionsKt.verifyHierarchy($this$assertIsVisible, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(){

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "The component is not visible!";
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(){

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return !Intrinsics.areEqual((Object)((Boolean)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)it, (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getHidden())), (Object)true);
            }
        }));
        return $this$assertIsVisible;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsHidden(@NotNull SemanticsNodeInteraction $this$assertIsHidden) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsHidden, (String)"<this>");
        AssertionsKt.verifyHierarchy($this$assertIsHidden, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(){

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "The component is visible!";
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(){

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)((Boolean)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)it, (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getHidden())), (Object)true);
            }
        }));
        return $this$assertIsHidden;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsDisplayed(@NotNull SemanticsNodeInteraction $this$assertIsDisplayed) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsDisplayed, (String)"<this>");
        AssertionsKt.verify($this$assertIsDisplayed, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(){

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "The component is not displayed!";
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>($this$assertIsDisplayed){
            private final /* synthetic */ SemanticsNodeInteraction $this$assertIsDisplayed;
            {
                this.$this$assertIsDisplayed = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return AssertionsKt.access$checkIsDisplayed$0(this.$this$assertIsDisplayed);
            }
        }));
        return $this$assertIsDisplayed;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotDisplayed(@NotNull SemanticsNodeInteraction $this$assertIsNotDisplayed) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsNotDisplayed, (String)"<this>");
        AssertionsKt.verify($this$assertIsNotDisplayed, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(){

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "The component is displayed!";
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>($this$assertIsNotDisplayed){
            private final /* synthetic */ SemanticsNodeInteraction $this$assertIsNotDisplayed;
            {
                this.$this$assertIsNotDisplayed = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return !AssertionsKt.access$checkIsDisplayed$0(this.$this$assertIsNotDisplayed);
            }
        }));
        return $this$assertIsNotDisplayed;
    }

    public static final void assertNoLongerExists(@NotNull SemanticsNodeInteraction $this$assertNoLongerExists) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertNoLongerExists, (String)"<this>");
        if ($this$assertNoLongerExists.getSemanticsTreeInteraction$ui_test_release().contains$ui_test_release($this$assertNoLongerExists.getSemanticsTreeNode$ui_test_release().getData())) {
            throw new AssertionError((Object)"Assert failed: The component does exist!");
        }
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsOn(@NotNull SemanticsNodeInteraction $this$assertIsOn) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsOn, (String)"<this>");
        AssertionsKt.assertIsToggleable($this$assertIsOn);
        AssertionsKt.verify($this$assertIsOn, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(){

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "Component is toggled off, expected it to be toggled on";
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(){

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)((ToggleableState)it.get(FoundationSemanticsProperties.INSTANCE.getToggleableState())), (Object)ToggleableState.On);
            }
        }));
        return $this$assertIsOn;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsOff(@NotNull SemanticsNodeInteraction $this$assertIsOff) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsOff, (String)"<this>");
        AssertionsKt.assertIsToggleable($this$assertIsOff);
        AssertionsKt.verify($this$assertIsOff, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(){

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "Component is toggled on, expected it to be toggled off";
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(){

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)((ToggleableState)it.get(FoundationSemanticsProperties.INSTANCE.getToggleableState())), (Object)ToggleableState.Off);
            }
        }));
        return $this$assertIsOff;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsSelected(@NotNull SemanticsNodeInteraction $this$assertIsSelected) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsSelected, (String)"<this>");
        AssertionsKt.assertIsSelectable($this$assertIsSelected);
        AssertionsKt.verify($this$assertIsSelected, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(){

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "Component is unselected, expected it to be selected";
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(){

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (Boolean)it.get(FoundationSemanticsProperties.INSTANCE.getSelected());
            }
        }));
        return $this$assertIsSelected;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsUnselected(@NotNull SemanticsNodeInteraction $this$assertIsUnselected) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsUnselected, (String)"<this>");
        AssertionsKt.assertIsSelectable($this$assertIsUnselected);
        AssertionsKt.verify($this$assertIsUnselected, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(){

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "Component is selected, expected it to be unselected";
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(){

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (Boolean)it.get(FoundationSemanticsProperties.INSTANCE.getSelected()) == false;
            }
        }));
        return $this$assertIsUnselected;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsInMutuallyExclusiveGroup(@NotNull SemanticsNodeInteraction $this$assertIsInMutuallyExclusiveGroup) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsInMutuallyExclusiveGroup, (String)"<this>");
        AssertionsKt.verify($this$assertIsInMutuallyExclusiveGroup, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(){

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "The component is expected to be in a mutually exclusive group, but it's not!";
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(){

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return FiltersKt.isInMutuallyExclusiveGroup(it);
            }
        }));
        return $this$assertIsInMutuallyExclusiveGroup;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertValueEquals(@NotNull SemanticsNodeInteraction $this$assertValueEquals, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertValueEquals, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        AssertionsKt.verify($this$assertValueEquals, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(value){
            private final /* synthetic */ String $value;
            {
                this.$value = $value;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                return "Expected value: " + this.$value + ", Actual value: " + SemanticsPropertiesKt.getAccessibilityValue((SemanticsPropertyReceiver)((SemanticsPropertyReceiver)node));
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(value){
            private final /* synthetic */ String $value;
            {
                this.$value = $value;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)((String)it.getOrElse(SemanticsProperties.INSTANCE.getAccessibilityValue(), new Function0(this.$value){
                    private final /* synthetic */ String $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final Void invoke() {
                        throw new AssertionError((Object)("Expected value: " + this.$value + ", but had none"));
                    }
                })), (Object)this.$value);
            }
        }));
        return $this$assertValueEquals;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertSemanticsIsEqualTo(@NotNull SemanticsNodeInteraction $this$assertSemanticsIsEqualTo, @NotNull SemanticsConfiguration expectedProperties) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertSemanticsIsEqualTo, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)expectedProperties, (String)"expectedProperties");
        AssertionsKt.assertExists($this$assertSemanticsIsEqualTo);
        GoldenSemanticsKt.assertEquals($this$assertSemanticsIsEqualTo.getSemanticsTreeNode$ui_test_release().getData(), expectedProperties);
        return $this$assertSemanticsIsEqualTo;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertHasClickAction(@NotNull SemanticsNodeInteraction $this$assertHasClickAction) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertHasClickAction, (String)"<this>");
        AssertionsKt.verify($this$assertHasClickAction, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(){

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "Component is not clickable, expected it to be clickable";
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(){

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return FiltersKt.getHasClickAction(it);
            }
        }));
        return $this$assertHasClickAction;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertHasNoClickAction(@NotNull SemanticsNodeInteraction $this$assertHasNoClickAction) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertHasNoClickAction, (String)"<this>");
        AssertionsKt.verify($this$assertHasNoClickAction, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(){

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "Component is clickable, expected it to not be clickable";
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(){

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return !FiltersKt.getHasClickAction(it);
            }
        }));
        return $this$assertHasNoClickAction;
    }

    @NotNull
    public static final List<SemanticsNodeInteraction> assertCountEquals(@NotNull List<SemanticsNodeInteraction> $this$assertCountEquals, int count) {
        Intrinsics.checkParameterIsNotNull($this$assertCountEquals, (String)"<this>");
        if ($this$assertCountEquals.size() != count) {
            throw new AssertionError((Object)("Found '" + $this$assertCountEquals.size() + "' nodes but exactly '" + count + "' was expected!"));
        }
        return $this$assertCountEquals;
    }

    public static final void verify(@NotNull SemanticsNodeInteraction $this$verify, @NotNull Function1<? super SemanticsConfiguration, String> assertionMessage, @NotNull Function1<? super SemanticsConfiguration, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull((Object)$this$verify, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(assertionMessage, (String)"assertionMessage");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        AssertionsKt.assertExists($this$verify);
        if (!((Boolean)condition.invoke((Object)$this$verify.getSemanticsTreeNode$ui_test_release().getData())).booleanValue()) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Assert failed: ", (Object)((String)assertionMessage.invoke((Object)$this$verify.getSemanticsTreeNode$ui_test_release().getData()))));
        }
    }

    public static final void verifyHierarchy(@NotNull SemanticsNodeInteraction $this$verifyHierarchy, @NotNull Function1<? super SemanticsConfiguration, String> assertionMessage, @NotNull Function1<? super SemanticsConfiguration, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull((Object)$this$verifyHierarchy, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(assertionMessage, (String)"assertionMessage");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        AssertionsKt.assertExists($this$verifyHierarchy);
        for (SemanticsTreeNode node = $this$verifyHierarchy.getSemanticsTreeNode$ui_test_release(); node != null; node = node.getParent()) {
            if (!((Boolean)condition.invoke((Object)node.getData())).booleanValue()) {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"Assert failed: ", (Object)((String)assertionMessage.invoke((Object)$this$verifyHierarchy.getSemanticsTreeNode$ui_test_release().getData()))));
            }
        }
    }

    public static final void assertExists(@NotNull SemanticsNodeInteraction $this$assertExists) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertExists, (String)"<this>");
        if (!$this$assertExists.getSemanticsTreeInteraction$ui_test_release().contains$ui_test_release($this$assertExists.getSemanticsTreeNode$ui_test_release().getData())) {
            throw new AssertionError((Object)"The component does not exist!");
        }
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsToggleable(@NotNull SemanticsNodeInteraction $this$assertIsToggleable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsToggleable, (String)"<this>");
        AssertionsKt.verify($this$assertIsToggleable, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(){

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "Component is not toggleable, expected it to be toggleable";
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(){

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return FiltersKt.isToggleable(it);
            }
        }));
        return $this$assertIsToggleable;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsSelectable(@NotNull SemanticsNodeInteraction $this$assertIsSelectable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsSelectable, (String)"<this>");
        AssertionsKt.verify($this$assertIsSelectable, (Function1<? super SemanticsConfiguration, String>)((Function1)new Function1<SemanticsConfiguration, String>(){

            @NotNull
            public final String invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "Component is not selectable, expected it to be selectable";
            }
        }), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(){

            public final boolean invoke(@NotNull SemanticsConfiguration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (Boolean)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)it, (SemanticsPropertyKey)FoundationSemanticsProperties.INSTANCE.getSelected()) != null;
            }
        }));
        return $this$assertIsSelectable;
    }

    private static final boolean checkIsDisplayed(SemanticsNodeInteraction $this$checkIsDisplayed) {
        if ($this$checkIsDisplayed.getSemanticsTreeNode$ui_test_release().findClosestParentNode((Function1)new Function1<ComponentNode, Boolean>(){

            public final boolean invoke(@NotNull ComponentNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it instanceof LayoutNode && !((LayoutNode)it).isPlaced();
            }
        }) != null) {
            return false;
        }
        Rect globalRect = $this$checkIsDisplayed.getSemanticsTreeNode$ui_test_release().getGlobalRect();
        SemanticsTreeInteraction semanticsTreeInteraction = $this$checkIsDisplayed.getSemanticsTreeInteraction$ui_test_release();
        Rect rect = globalRect;
        if (rect == null) {
            Intrinsics.throwNpe();
        }
        if (!semanticsTreeInteraction.isInScreenBounds$ui_test_release(rect)) {
            return false;
        }
        ComponentNode repaintBoundaryNode2 = $this$checkIsDisplayed.getSemanticsTreeNode$ui_test_release().findClosestParentNode((Function1)new Function1<ComponentNode, Boolean>(){

            public final boolean invoke(@NotNull ComponentNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it instanceof RepaintBoundaryNode && ((RepaintBoundaryNode)it).getClipToShape();
            }
        });
        if (repaintBoundaryNode2 == null) {
            return true;
        }
        LayoutNode layoutNode2 = repaintBoundaryNode2.getParentLayoutNode();
        if (layoutNode2 == null) {
            throw new AssertionError((Object)"Semantic Node has no parent layout to check for visibility layout");
        }
        LayoutNode layoutNode3 = layoutNode2;
        return AssertionsKt.contains(layoutNode3, globalRect);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean contains(LayoutNode $this$contains, Rect rectangle) {
        IntPx $this$toPx$iv;
        PxPosition this_$iv;
        PxPosition globalPositionTopLeft;
        long l;
        void val1$iv$iv;
        PxPosition y$iv;
        void x$iv;
        void $this$px$iv32;
        void $this$px$iv22;
        Px px;
        boolean bl = false;
        LayoutNode layoutNode2 = $this$contains;
        Px $this$px$iv22 = px = new Px((float)$this$px$iv22);
        boolean bl2 = false;
        Px $this$px$iv32 = px = new Px((float)$this$px$iv32);
        float f = x$iv.getValue();
        float val2$iv$iv = y$iv.getValue();
        void var7_13 = val1$iv$iv;
        int n = 0;
        long v1$iv$iv = Float.floatToIntBits((float)var7_13);
        float f2 = val2$iv$iv;
        boolean bl3 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        px = new PxPosition(l2);
        y$iv = globalPositionTopLeft = ComponentNodesKt.localToGlobal$default((LayoutNode)layoutNode2, (PxPosition)px, (boolean)false, (int)2, null);
        layoutNode2 = Rect.Companion;
        long value$iv$iv = this_$iv.getValue();
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv >> 32);
        boolean bl4 = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n);
        px = new Px($this$px$iv$iv);
        this_$iv = globalPositionTopLeft;
        float f3 = px.getValue();
        value$iv$iv = this_$iv.getValue();
        floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv & 0xFFFFFFFFL);
        bl4 = false;
        $this$px$iv$iv = Float.intBitsToFloat(n);
        Px px2 = new Px($this$px$iv$iv);
        this_$iv = $this$contains.getWidth();
        float f4 = px2.getValue();
        int $this$px$iv$iv2 = $this$toPx$iv.getValue();
        Px px3 = new Px((float)$this$px$iv$iv2);
        $this$toPx$iv = $this$contains.getHeight();
        float f5 = px3.getValue() + 1.0f;
        $this$px$iv$iv2 = $this$toPx$iv.getValue();
        Px px4 = new Px((float)$this$px$iv$iv2);
        Rect rect = layoutNode2.fromLTWH(f3, f4, f5, px4.getValue() + 1.0f);
        return rect.contains(rectangle.getTopLeft()) && rect.contains(rectangle.getBottomRight());
    }

    public static final /* synthetic */ boolean access$checkIsDisplayed$0(SemanticsNodeInteraction $receiver) {
        return AssertionsKt.checkIsDisplayed($receiver);
    }
}

