/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.compose.Compose;
import androidx.compose.Composer;
import androidx.compose.CompositionContext;
import androidx.compose.CompositionReference;
import androidx.compose.Emittable;
import androidx.compose.FrameManager;
import androidx.compose.ObserveKt;
import androidx.compose.Recomposer;
import androidx.compose.ViewComposer;
import androidx.compose.ViewComposerCommonKt;
import androidx.compose.ViewComposerKt;
import androidx.compose.ViewComposition;
import androidx.compose.ViewValidator;
import androidx.compose.frames.FramesKt;
import androidx.ui.core.AndroidComposeView;
import androidx.ui.core.WrapperKt;
import androidx.ui.test.ComposeBenchmarkScope;
import androidx.ui.test.ComposeBenchmarkScopeKt;
import androidx.ui.test.ComposeTestCase;
import androidx.ui.test.android.AndroidComposeTestCaseRunnerKt;
import androidx.ui.test.android.DrawCapture;
import androidx.ui.test.android.PictureCapture;
import androidx.ui.test.android.RenderNodeCapture;
import androidx.ui.test.android.SimulationState;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0016\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\b\u0010*\u001a\u00020(H\u0016J\b\u0010+\u001a\u00020(H\u0016J\b\u0010,\u001a\u00020(H\u0016J\b\u0010-\u001a\u00020(H\u0016J\b\u0010.\u001a\u00020(H\u0016J\b\u0010/\u001a\u00020(H\u0016J\b\u00100\u001a\u00020(H\u0016J\r\u00101\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u00020#H\u0002J\b\u00104\u001a\u00020\u0010H\u0016J\b\u00105\u001a\u00020\u0010H\u0002J\b\u00106\u001a\u00020(H\u0016J\b\u00107\u001a\u00020(H\u0016J\b\u00108\u001a\u00020(H\u0016J\u0018\u00109\u001a\u00020(2\u0006\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u0015H\u0016J\b\u0010<\u001a\u00020(H\u0016J\b\u0010=\u001a\u00020(H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\u000f\u001a\u0004\u0018\u00010#@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006>"}, d2={"Landroidx/ui/test/android/AndroidComposeTestCaseRunner;", "T", "Landroidx/ui/test/ComposeTestCase;", "Landroidx/ui/test/ComposeBenchmarkScope;", "testCaseFactory", "Lkotlin/Function0;", "activity", "Landroid/app/Activity;", "(Lkotlin/jvm/functions/Function0;Landroid/app/Activity;)V", "canvas", "Landroid/graphics/Canvas;", "capture", "Landroidx/ui/test/android/DrawCapture;", "compositionContext", "Landroidx/compose/CompositionContext;", "<set-?>", "", "didLastRecomposeHaveChanges", "getDidLastRecomposeHaveChanges", "()Z", "measuredHeight", "", "getMeasuredHeight", "()I", "measuredWidth", "getMeasuredWidth", "recomposer", "Landroidx/compose/Recomposer;", "screenHeightSpec", "screenWithSpec", "simulationState", "Landroidx/ui/test/android/SimulationState;", "supportsRenderNode", "testCase", "Landroidx/ui/test/ComposeTestCase;", "Landroid/view/ViewGroup;", "view", "getView$ui_test_release", "()Landroid/view/ViewGroup;", "capturePreviewPictureToActivity", "", "createTestCase", "disposeContent", "doFrame", "draw", "drawFinish", "drawPrepare", "drawToBitmap", "emitContent", "getTestCase", "()Landroidx/ui/test/ComposeTestCase;", "getView", "hasPendingChanges", "hasPendingChangesInFrame", "invalidateViews", "layout", "measure", "measureWithSpec", "widthSpec", "heightSpec", "recompose", "requestLayout", "ui-test_release"})
public final class AndroidComposeTestCaseRunner<T extends ComposeTestCase>
implements ComposeBenchmarkScope<T> {
    private final Function0<T> testCaseFactory;
    private final Activity activity;
    private ViewGroup view;
    private CompositionContext compositionContext;
    private boolean didLastRecomposeHaveChanges;
    private final boolean supportsRenderNode;
    private final int screenWithSpec;
    private final int screenHeightSpec;
    private final DrawCapture capture;
    private Canvas canvas;
    private Recomposer recomposer;
    private SimulationState simulationState;
    private T testCase;

    public AndroidComposeTestCaseRunner(@NotNull Function0<? extends T> testCaseFactory, @NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull(testCaseFactory, (String)"testCaseFactory");
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        this.testCaseFactory = testCaseFactory;
        this.activity = activity;
        this.supportsRenderNode = Build.VERSION.SDK_INT >= 29;
        this.capture = this.supportsRenderNode ? (DrawCapture)new RenderNodeCapture() : (DrawCapture)new PictureCapture();
        this.simulationState = SimulationState.Initialized;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int height = displayMetrics.heightPixels;
        int width = displayMetrics.widthPixels;
        this.screenWithSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE);
        this.screenHeightSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE);
    }

    @Override
    public int getMeasuredWidth() {
        ViewGroup viewGroup = this.getView$ui_test_release();
        if (viewGroup == null) {
            Intrinsics.throwNpe();
        }
        return viewGroup.getMeasuredWidth();
    }

    @Override
    public int getMeasuredHeight() {
        ViewGroup viewGroup = this.getView$ui_test_release();
        if (viewGroup == null) {
            Intrinsics.throwNpe();
        }
        return viewGroup.getMeasuredHeight();
    }

    @Nullable
    public final ViewGroup getView$ui_test_release() {
        return this.view;
    }

    @Override
    public boolean getDidLastRecomposeHaveChanges() {
        return this.didLastRecomposeHaveChanges;
    }

    @Override
    public void createTestCase() {
        boolean bl = this.getView$ui_test_release() == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "Content was already set!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.testCase == null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            String string = "Content was already set!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.testCase = (ComposeTestCase)this.testCaseFactory.invoke();
        this.simulationState = SimulationState.TestCaseCreated;
    }

    @Override
    public void emitContent() {
        boolean bl = this.getView$ui_test_release() == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "Content was already set!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.testCase != null && Intrinsics.areEqual((Object)((Object)this.simulationState), (Object)((Object)SimulationState.TestCaseCreated));
        bl2 = false;
        bl3 = false;
        if (!bl) {
            String string = "Need to call onPreEmitContent before emitContent!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.recomposer = Recomposer.Companion.current();
        CompositionContext compositionContext = WrapperKt.setContent((Activity)this.activity, (Function0)((Function0)new Function0<Unit>(this){
            private final /* synthetic */ AndroidComposeTestCaseRunner<T> $this$emitContent;
            {
                this.$this$emitContent = $receiver;
                super(0);
            }

            public final void invoke() {
                ObserveKt.Observe((Function0)((Function0)new Function0<Unit>(this.$this$emitContent){
                    private final /* synthetic */ AndroidComposeTestCaseRunner<T> $this$emitContent;
                    {
                        this.$this$emitContent = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void this_$iv;
                        ViewComposition viewComposition = ViewComposerKt.getComposer();
                        ComposeTestCase composeTestCase = AndroidComposeTestCaseRunner.access$prop$getTestCase$0(this.$this$emitContent);
                        if (composeTestCase == null) {
                            Intrinsics.throwNpe();
                        }
                        ComposeTestCase composeTestCase2 = composeTestCase;
                        ViewComposition viewComposition2 = viewComposition;
                        Integer key$iv = 1453914880;
                        boolean $i$f$call = false;
                        ViewComposer viewComposer = this_$iv.getComposer();
                        boolean bl = false;
                        boolean bl2 = false;
                        ViewComposer $this$with$iv = viewComposer;
                        boolean bl3 = false;
                        $this$with$iv.startGroup((Object)key$iv);
                        ViewValidator $this$invoke_u24lambda_u2d0 = new ViewValidator((Composer)this_$iv.getComposer());
                        if (true || $this$with$iv.getInserting()) {
                            $this$with$iv.startGroup(ViewComposerCommonKt.getInvocation());
                            composeTestCase2.emitContent();
                            $this$with$iv.endGroup();
                        } else {
                            $this$with$iv.skipCurrentGroup();
                        }
                        $this$with$iv.endGroup();
                    }
                }));
            }
        }));
        if (compositionContext == null) {
            Intrinsics.throwNpe();
        }
        this.compositionContext = compositionContext;
        FrameManager.INSTANCE.nextFrame();
        AndroidComposeView androidComposeView = AndroidComposeTestCaseRunnerKt.access$findComposeView$1(this.activity);
        if (androidComposeView == null) {
            Intrinsics.throwNpe();
        }
        this.view = (ViewGroup)androidComposeView;
        this.simulationState = SimulationState.EmitContentDone;
    }

    @Override
    public boolean hasPendingChanges() {
        block0: {
            if (!Recomposer.Companion.hasPendingChanges() && !this.hasPendingChangesInFrame()) break block0;
            FrameManager.INSTANCE.nextFrame();
        }
        return Recomposer.Companion.hasPendingChanges();
    }

    private final boolean hasPendingChangesInFrame() {
        return FramesKt.getInFrame() && FramesKt.currentFrame().hasPendingChanges();
    }

    @Override
    public void measure() {
        this.getView().measure(this.screenWithSpec, this.screenHeightSpec);
        this.simulationState = SimulationState.MeasureDone;
    }

    @Override
    public void measureWithSpec(int widthSpec, int heightSpec) {
        this.getView().measure(widthSpec, heightSpec);
        this.simulationState = SimulationState.MeasureDone;
    }

    @Override
    public void drawPrepare() {
        boolean bl = Intrinsics.areEqual((Object)((Object)this.simulationState), (Object)((Object)SimulationState.LayoutDone)) || Intrinsics.areEqual((Object)((Object)this.simulationState), (Object)((Object)SimulationState.DrawDone));
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "Draw can be only executed after layout or draw, current state is '" + (Object)((Object)this.simulationState) + "'";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.canvas = this.capture.beginRecording(this.getView().getWidth(), this.getView().getHeight());
        this.simulationState = SimulationState.DrawPrepared;
    }

    @Override
    public void draw() {
        boolean bl = Intrinsics.areEqual((Object)((Object)this.simulationState), (Object)((Object)SimulationState.DrawPrepared));
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "You need to call 'drawPrepare' before calling 'draw'.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.getView().draw(this.canvas);
        this.simulationState = SimulationState.DrawInProgress;
    }

    @Override
    public void drawFinish() {
        boolean bl = Intrinsics.areEqual((Object)((Object)this.simulationState), (Object)((Object)SimulationState.DrawInProgress));
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "You need to call 'draw' before calling 'drawFinish'.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.capture.endRecording();
        this.simulationState = SimulationState.DrawDone;
    }

    @Override
    public void drawToBitmap() {
        this.drawPrepare();
        this.draw();
        this.drawFinish();
    }

    @Override
    public void requestLayout() {
        this.getView().requestLayout();
    }

    @Override
    public void layout() {
        boolean bl = Intrinsics.areEqual((Object)((Object)this.simulationState), (Object)((Object)SimulationState.MeasureDone));
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "Layout can be only executed after measure, current state is '" + (Object)((Object)this.simulationState) + "'";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ViewGroup view = this.getView();
        view.layout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        this.simulationState = SimulationState.LayoutDone;
    }

    @Override
    public void recompose() {
        if (this.hasPendingChanges()) {
            this.didLastRecomposeHaveChanges = true;
            Recomposer recomposer = this.recomposer;
            if (recomposer == null) {
                Intrinsics.throwNpe();
            }
            recomposer.recomposeSync();
        } else {
            this.didLastRecomposeHaveChanges = false;
        }
        this.simulationState = SimulationState.RecomposeDone;
    }

    @Override
    public void doFrame() {
        if (this.getView$ui_test_release() == null) {
            ComposeBenchmarkScopeKt.setupContent(this);
        }
        this.recompose();
        this.measure();
        this.layout();
        this.drawToBitmap();
    }

    @Override
    public void invalidateViews() {
        AndroidComposeTestCaseRunnerKt.access$invalidateViews$2((View)this.getView());
    }

    @Override
    public void disposeContent() {
        if (this.getView$ui_test_release() == null) {
            return;
        }
        ViewGroup viewGroup = this.getView$ui_test_release();
        if (viewGroup == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.ui.core.AndroidComposeView");
        }
        Compose.INSTANCE.disposeComposition((Emittable)((AndroidComposeView)viewGroup).getRoot(), (Context)this.activity, (CompositionReference)null);
        ViewGroup viewGroup2 = (ViewGroup)this.activity.findViewById(0x1020002);
        if (viewGroup2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup rootView = viewGroup2;
        rootView.removeAllViews();
        this.view = null;
        this.testCase = null;
        this.simulationState = SimulationState.Initialized;
    }

    @Override
    public void capturePreviewPictureToActivity() {
        Bitmap bitmap;
        boolean bl = this.getMeasuredWidth() > 0 && this.getMeasuredHeight() > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "Preview can't be used on empty view. Did you run measure & layout before calling it?";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Picture picture = new Picture();
        Canvas canvas = picture.beginRecording(this.getView().getMeasuredWidth(), this.getView().getMeasuredHeight());
        this.getView().draw(canvas);
        picture.endRecording();
        ImageView imageView = new ImageView((Context)this.activity);
        if (Build.VERSION.SDK_INT >= 28) {
            bitmap = Bitmap.createBitmap((Picture)picture);
        } else {
            int width = RangesKt.coerceAtLeast((int)picture.getWidth(), (int)1);
            int height = RangesKt.coerceAtLeast((int)picture.getHeight(), (int)1);
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            new Canvas(bitmap).drawPicture(picture);
        }
        imageView.setImageBitmap(bitmap);
        this.activity.setContentView((View)imageView);
    }

    private final ViewGroup getView() {
        boolean bl = this.getView$ui_test_release() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "View was not set! Call setupContent first!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ViewGroup viewGroup = this.getView$ui_test_release();
        if (viewGroup == null) {
            Intrinsics.throwNpe();
        }
        return viewGroup;
    }

    @Override
    @NotNull
    public T getTestCase() {
        T t = this.testCase;
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return t;
    }

    public static final /* synthetic */ ComposeTestCase access$prop$getTestCase$0(AndroidComposeTestCaseRunner $this) {
        return $this.testCase;
    }
}

