/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.semantics.SemanticsConfiguration;
import androidx.ui.semantics.SemanticsPropertyKey;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B&\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0004J\t\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0004R\"\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Landroidx/ui/test/SemanticsPredicate;", "", "description", "", "condition", "Lkotlin/Function1;", "Landroidx/ui/core/semantics/SemanticsConfiguration;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getCondition", "()Lkotlin/jvm/functions/Function1;", "getDescription", "()Ljava/lang/String;", "and", "other", "not", "or", "Companion", "ui-test_release"})
public final class SemanticsPredicate {
    private final String description;
    private final Function1<SemanticsConfiguration, Boolean> condition;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SemanticsPredicate(@NotNull String description, @NotNull Function1<? super SemanticsConfiguration, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        this.description = description;
        this.condition = condition;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final Function1<SemanticsConfiguration, Boolean> getCondition() {
        return this.condition;
    }

    @NotNull
    public final SemanticsPredicate and(@NotNull SemanticsPredicate other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        String desc = "(" + this.getDescription() + ") && (" + other.getDescription() + ")";
        return new SemanticsPredicate(desc, (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(this, other){
            private final /* synthetic */ SemanticsPredicate $this$and;
            private final /* synthetic */ SemanticsPredicate $other;
            {
                this.$this$and = $receiver;
                this.$other = $other;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                return (Boolean)this.$this$and.getCondition().invoke((Object)semanticsConfiguration) != false && (Boolean)this.$other.getCondition().invoke((Object)semanticsConfiguration) != false;
            }
        }));
    }

    @NotNull
    public final SemanticsPredicate or(@NotNull SemanticsPredicate other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        String desc = "(" + this.getDescription() + ") || (" + other.getDescription() + ")";
        return new SemanticsPredicate(desc, (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(this, other){
            private final /* synthetic */ SemanticsPredicate $this$or;
            private final /* synthetic */ SemanticsPredicate $other;
            {
                this.$this$or = $receiver;
                this.$other = $other;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                return (Boolean)this.$this$or.getCondition().invoke((Object)semanticsConfiguration) != false || (Boolean)this.$other.getCondition().invoke((Object)semanticsConfiguration) != false;
            }
        }));
    }

    @NotNull
    public final SemanticsPredicate not() {
        String desc = "NOT (" + this.getDescription() + ")";
        return new SemanticsPredicate(desc, (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(this){
            private final /* synthetic */ SemanticsPredicate $this$not;
            {
                this.$this$not = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                return (Boolean)this.$this$not.getCondition().invoke((Object)semanticsConfiguration) == false;
            }
        }));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007J\u001a\u0010\u000b\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\u00a8\u0006\f"}, d2={"Landroidx/ui/test/SemanticsPredicate$Companion;", "", "()V", "expectValue", "Landroidx/ui/test/SemanticsPredicate;", "T", "key", "Landroidx/ui/semantics/SemanticsPropertyKey;", "expectedValue", "(Landroidx/ui/semantics/SemanticsPropertyKey;Ljava/lang/Object;)Landroidx/ui/test/SemanticsPredicate;", "keyIsDefined", "keyNotDefined", "ui-test_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> SemanticsPredicate expectValue(@NotNull SemanticsPropertyKey<T> key, T expectedValue) {
            Intrinsics.checkParameterIsNotNull(key, (String)"key");
            return new SemanticsPredicate(key.getName() + " = '" + expectedValue + "'", (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(key, expectedValue){
                private final /* synthetic */ SemanticsPropertyKey<T> $key;
                private final /* synthetic */ T $expectedValue;
                {
                    this.$key = $key;
                    this.$expectedValue = $expectedValue;
                    super(1);
                }

                public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                    Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                    return Intrinsics.areEqual((Object)semanticsConfiguration.getOrElseNullable(this.$key, new Function0(){

                        @Nullable
                        public final Void invoke() {
                            return null;
                        }
                    }), this.$expectedValue);
                }
            }));
        }

        @NotNull
        public final <T> SemanticsPredicate keyIsDefined(@NotNull SemanticsPropertyKey<T> key) {
            Intrinsics.checkParameterIsNotNull(key, (String)"key");
            return new SemanticsPredicate(Intrinsics.stringPlus((String)key.getName(), (Object)" is defined"), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(key){
                private final /* synthetic */ SemanticsPropertyKey<T> $key;
                {
                    this.$key = $key;
                    super(1);
                }

                public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                    Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                    return semanticsConfiguration.contains(this.$key);
                }
            }));
        }

        @NotNull
        public final <T> SemanticsPredicate keyNotDefined(@NotNull SemanticsPropertyKey<T> key) {
            Intrinsics.checkParameterIsNotNull(key, (String)"key");
            return new SemanticsPredicate(Intrinsics.stringPlus((String)key.getName(), (Object)" is NOT defined"), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(key){
                private final /* synthetic */ SemanticsPropertyKey<T> $key;
                {
                    this.$key = $key;
                    super(1);
                }

                public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                    Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                    return !semanticsConfiguration.contains(this.$key);
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

