/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.graphics.Bitmap;
import android.os.Handler;
import android.view.PixelCopy;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.ui.geometry.Rect;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u00a8\u0006\b"}, d2={"captureRegionToBitmap", "Landroid/graphics/Bitmap;", "globalRect", "Landroidx/ui/geometry/Rect;", "handler", "Landroid/os/Handler;", "window", "Landroid/view/Window;", "ui-test_release"})
public final class WindowCaptureKt {
    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureRegionToBitmap(@NotNull Rect globalRect, @NotNull Handler handler, @NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)globalRect, (String)"globalRect");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        Bitmap destBitmap = Bitmap.createBitmap((int)MathKt.roundToInt((float)globalRect.getWidth()), (int)MathKt.roundToInt((float)globalRect.getHeight()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        android.graphics.Rect srcRect = new android.graphics.Rect(MathKt.roundToInt((float)globalRect.getLeft()), MathKt.roundToInt((float)globalRect.getTop()), MathKt.roundToInt((float)globalRect.getRight()), MathKt.roundToInt((float)globalRect.getBottom()));
        CountDownLatch latch = new CountDownLatch(1);
        Ref.IntRef copyResult = new Ref.IntRef();
        copyResult.element = 0;
        PixelCopy.OnPixelCopyFinishedListener onCopyFinished2 = new PixelCopy.OnPixelCopyFinishedListener(copyResult, latch){
            private final /* synthetic */ Ref.IntRef $copyResult;
            private final /* synthetic */ CountDownLatch $latch;
            {
                this.$copyResult = $copyResult;
                this.$latch = $latch;
            }

            public void onPixelCopyFinished(int result) {
                this.$copyResult.element = result;
                this.$latch.countDown();
            }
        };
        PixelCopy.request((Window)window, (android.graphics.Rect)srcRect, (Bitmap)destBitmap, (PixelCopy.OnPixelCopyFinishedListener)onCopyFinished2, (Handler)handler);
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Failed waiting for PixelCopy!");
        }
        if (copyResult.element != 0) {
            throw new AssertionError((Object)"PixelCopy failed!");
        }
        return destBitmap;
    }
}

