/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import android.os.Handler;
import android.os.Looper;
import androidx.ui.core.ComponentNode;
import androidx.ui.core.ComponentNodesKt;
import androidx.ui.core.LayoutCoordinates;
import androidx.ui.core.LayoutNode;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.semantics.AccessibilityAction;
import androidx.ui.semantics.SemanticsActions;
import androidx.ui.semantics.SemanticsPropertyKey;
import androidx.ui.test.ErrorMessagesKt;
import androidx.ui.test.FiltersKt;
import androidx.ui.test.GestureScope;
import androidx.ui.test.GestureScopeKt;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxBounds;
import androidx.ui.unit.PxPosition;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0002\u001a$\u0010\u0004\u001a\u00020\u0001*\u00020\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00030\b0\u0007\u001aB\u0010\u0004\u001a\u00020\u0001\"\u000e\b\u0000\u0010\t*\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\b0\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00010\f\u001a\n\u0010\r\u001a\u00020\u0005*\u00020\u0005\u001a#\u0010\u000e\u001a\u00020\u0005*\u00020\u00052\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\b\u0011\u001a\n\u0010\u0012\u001a\u00020\u0005*\u00020\u0005\u00a8\u0006\u0013"}, d2={"runOnUiThread", "", "action", "Lkotlin/Function0;", "callSemanticsAction", "Landroidx/ui/test/SemanticsNodeInteraction;", "key", "Landroidx/ui/semantics/SemanticsPropertyKey;", "Landroidx/ui/semantics/AccessibilityAction;", "T", "Lkotlin/Function;", "invocation", "Lkotlin/Function1;", "doClick", "doGesture", "block", "Landroidx/ui/test/GestureScope;", "Lkotlin/ExtensionFunctionType;", "doScrollTo", "ui-test_release"})
public final class ActionsKt {
    @NotNull
    public static final SemanticsNodeInteraction doClick(@NotNull SemanticsNodeInteraction $this$doClick) {
        Intrinsics.checkParameterIsNotNull((Object)$this$doClick, (String)"<this>");
        return ActionsKt.doGesture($this$doClick, (Function1<? super GestureScope, Unit>)((Function1)new Function1<GestureScope, Unit>(){

            public final void invoke(@NotNull GestureScope gestureScope) {
                Intrinsics.checkParameterIsNotNull((Object)gestureScope, (String)"<this>");
                GestureScopeKt.sendClick(gestureScope);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SemanticsNodeInteraction doScrollTo(@NotNull SemanticsNodeInteraction $this$doScrollTo) {
        long l;
        void val1$iv$iv;
        void y$iv;
        void x$iv;
        void $this$px$iv32;
        void $this$px$iv22;
        Px px;
        Intrinsics.checkParameterIsNotNull((Object)$this$doScrollTo, (String)"<this>");
        String errorMessageOnFail = "Failed to perform doScrollTo.";
        SemanticsNode node = $this$doScrollTo.fetchSemanticsNode(errorMessageOnFail);
        SemanticsNode semanticsNode = ComponentNodesKt.findClosestParentNode((SemanticsNode)node, (Function1)((Function1)new Function1<SemanticsNode, Boolean>(){

            public final boolean invoke(@NotNull SemanticsNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (Boolean)FiltersKt.hasScrollAction().getCondition().invoke((Object)it.getConfig());
            }
        }));
        if (semanticsNode == null) {
            throw new AssertionError((Object)"Semantic Node has no parent layout with a Scroll SemanticsAction");
        }
        SemanticsNode scrollableSemanticsNode2 = semanticsNode;
        PxBounds globalRect = node.getGlobalBounds();
        LayoutNode layoutNode2 = ComponentNodesKt.findLastLayoutChild((ComponentNode)scrollableSemanticsNode2.getComponentNode(), (Function1)((Function1)new Function1<LayoutNode, Boolean>(){

            public final boolean invoke(@NotNull LayoutNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return true;
            }
        }));
        if (layoutNode2 == null) {
            throw new AssertionError((Object)"No Layout Node found!");
        }
        LayoutNode layoutNode3 = layoutNode2;
        boolean bl = false;
        LayoutCoordinates layoutCoordinates = layoutNode3.getCoordinates();
        Px $this$px$iv22 = px = new Px((float)$this$px$iv22);
        boolean bl2 = false;
        Px $this$px$iv32 = px = new Px((float)$this$px$iv32);
        float f = x$iv.getValue();
        float val2$iv$iv = y$iv.getValue();
        boolean $i$f$packFloats = false;
        void var12_16 = val1$iv$iv;
        boolean bl3 = false;
        long v1$iv$iv = Float.floatToIntBits((float)var12_16);
        float f2 = val2$iv$iv;
        boolean bl4 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        px = new PxPosition(l2);
        PxPosition position = layoutCoordinates.localToGlobal((PxPosition)px);
        ActionsKt.runOnUiThread((Function0<Unit>)((Function0)new Function0<Unit>(scrollableSemanticsNode2, globalRect, position){
            private final /* synthetic */ SemanticsNode $scrollableSemanticsNode;
            private final /* synthetic */ PxBounds $globalRect;
            private final /* synthetic */ PxPosition $position;
            {
                this.$scrollableSemanticsNode = $scrollableSemanticsNode;
                this.$globalRect = $globalRect;
                this.$position = $position;
                super(0);
            }

            public final void invoke() {
                Px px;
                PxPosition other$iv;
                Px this_$iv;
                Px px2;
                Px this_$iv2;
                Px px3 = this.$globalRect.getLeft();
                PxPosition pxPosition = this.$position;
                Function2 function2 = (Function2)((AccessibilityAction)this.$scrollableSemanticsNode.getConfig().get(SemanticsActions.Companion.getScrollTo())).getAction();
                long value$iv$iv = this_$iv2.getValue();
                boolean $i$f$unpackFloat1 = false;
                FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
                int n = (int)(value$iv$iv >> 32);
                boolean bl = false;
                float $this$px$iv$iv = Float.intBitsToFloat(n);
                this_$iv2 = px2 = new Px($this$px$iv$iv);
                px2 = new Px(this_$iv.getValue() - other$iv.getValue());
                this_$iv = this.$globalRect.getTop();
                other$iv = this.$position;
                value$iv$iv = this_$iv2.getValue();
                boolean $i$f$unpackFloat2 = false;
                floatCompanionObject = FloatCompanionObject.INSTANCE;
                n = (int)(value$iv$iv & 0xFFFFFFFFL);
                bl = false;
                $this$px$iv$iv = Float.intBitsToFloat(n);
                this_$iv2 = px = new Px($this$px$iv$iv);
                px = new Px(this_$iv.getValue() - other$iv.getValue());
                function2.invoke((Object)px2, (Object)px);
            }
        }));
        return $this$doScrollTo;
    }

    @NotNull
    public static final SemanticsNodeInteraction doGesture(@NotNull SemanticsNodeInteraction $this$doGesture, @NotNull Function1<? super GestureScope, Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$this$doGesture, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        GestureScope scope = new GestureScope($this$doGesture);
        block.invoke((Object)scope);
        return $this$doGesture;
    }

    public static final <T extends Function<? extends Unit>> void callSemanticsAction(@NotNull SemanticsNodeInteraction $this$callSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<T>> key, @NotNull Function1<? super T, Unit> invocation) {
        Intrinsics.checkParameterIsNotNull((Object)$this$callSemanticsAction, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull(invocation, (String)"invocation");
        SemanticsNode node = $this$callSemanticsAction.fetchSemanticsNode("Failed to call " + key.getName() + " action.");
        if (!node.getConfig().contains(key)) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage("Failed to call " + key.getName() + " action as it is not defined on the node.", $this$callSemanticsAction.getSemanticsTreeInteraction$ui_test_release().getSelector(), node));
        }
        ActionsKt.runOnUiThread((Function0<Unit>)((Function0)new Function0<Unit>(invocation, node, key){
            private final /* synthetic */ Function1<T, Unit> $invocation;
            private final /* synthetic */ SemanticsNode $node;
            private final /* synthetic */ SemanticsPropertyKey<AccessibilityAction<T>> $key;
            {
                this.$invocation = $invocation;
                this.$node = $node;
                this.$key = $key;
                super(0);
            }

            public final void invoke() {
                this.$invocation.invoke((Object)((AccessibilityAction)this.$node.getConfig().get(this.$key)).getAction());
            }
        }));
    }

    public static final void callSemanticsAction(@NotNull SemanticsNodeInteraction $this$callSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<Function0<Unit>>> key) {
        Intrinsics.checkParameterIsNotNull((Object)$this$callSemanticsAction, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        ActionsKt.callSemanticsAction($this$callSemanticsAction, key, (Function1)new Function1<Function0<? extends Unit>, Unit>(){

            public final void invoke(@NotNull Function0<Unit> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                it.invoke();
            }
        });
    }

    private static final void runOnUiThread(Function0<Unit> action) {
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            action.invoke();
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(action, latch){
            private final /* synthetic */ Function0<Unit> $action;
            private final /* synthetic */ CountDownLatch $latch;
            {
                this.$action = $action;
                this.$latch = $latch;
            }

            public void run() {
                this.$action.invoke();
                this.$latch.countDown();
            }
        });
        boolean success = latch.await(1000L, TimeUnit.MILLISECONDS);
        if (!success) {
            throw new TimeoutException("Timeout has occurred when waiting for an action to be performed.");
        }
    }
}

