/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.ComponentNode;
import androidx.ui.core.ComponentNodesKt;
import androidx.ui.core.LayoutCoordinates;
import androidx.ui.core.LayoutNode;
import androidx.ui.core.RepaintBoundaryNode;
import androidx.ui.core.semantics.SemanticsConfiguration;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Rect;
import androidx.ui.test.ErrorMessagesKt;
import androidx.ui.test.FiltersKt;
import androidx.ui.test.GoldenSemanticsKt;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.SemanticsPredicate;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxBounds;
import androidx.ui.unit.PxPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a'\u0010\u0004\u001a\u0002H\u0005\"\u000e\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u00020\u00010\u0006*\u0002H\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0012\u0010\u001a\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019\u001a\f\u0010\u001e\u001a\u00020\u001f*\u00020\u0001H\u0002\u001a\u0014\u0010 \u001a\u00020\u001f*\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006$"}, d2={"assert", "Landroidx/ui/test/SemanticsNodeInteraction;", "predicate", "Landroidx/ui/test/SemanticsPredicate;", "assertCountEquals", "T", "", "expectedSize", "", "(Ljava/util/Collection;I)Ljava/util/Collection;", "assertHasClickAction", "assertHasNoClickAction", "assertIsDisplayed", "assertIsHidden", "assertIsInMutuallyExclusiveGroup", "assertIsNotDisplayed", "assertIsNotHidden", "assertIsOff", "assertIsOn", "assertIsSelectable", "assertIsSelected", "assertIsToggleable", "assertIsUnselected", "assertLabelEquals", "value", "", "assertSemanticsIsEqualTo", "expectedProperties", "Landroidx/ui/core/semantics/SemanticsConfiguration;", "assertValueEquals", "checkIsDisplayed", "", "contains", "Landroidx/ui/core/LayoutNode;", "rectangle", "Landroidx/ui/unit/PxBounds;", "ui-test_release"})
public final class AssertionsKt {
    @NotNull
    public static final SemanticsNodeInteraction assertIsHidden(@NotNull SemanticsNodeInteraction $this$assertIsHidden) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsHidden, (String)"<this>");
        return AssertionsKt.assert($this$assertIsHidden, FiltersKt.isHidden());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotHidden(@NotNull SemanticsNodeInteraction $this$assertIsNotHidden) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsNotHidden, (String)"<this>");
        return AssertionsKt.assert($this$assertIsNotHidden, FiltersKt.isNotHidden());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsDisplayed(@NotNull SemanticsNodeInteraction $this$assertIsDisplayed) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsDisplayed, (String)"<this>");
        if (!AssertionsKt.checkIsDisplayed($this$assertIsDisplayed)) {
            throw new AssertionError((Object)"Assert failed: The component is not displayed!");
        }
        return $this$assertIsDisplayed;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotDisplayed(@NotNull SemanticsNodeInteraction $this$assertIsNotDisplayed) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsNotDisplayed, (String)"<this>");
        if (AssertionsKt.checkIsDisplayed($this$assertIsNotDisplayed)) {
            throw new AssertionError((Object)"Assert failed: The component is displayed!");
        }
        return $this$assertIsNotDisplayed;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsOn(@NotNull SemanticsNodeInteraction $this$assertIsOn) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsOn, (String)"<this>");
        return AssertionsKt.assert($this$assertIsOn, FiltersKt.isOn());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsOff(@NotNull SemanticsNodeInteraction $this$assertIsOff) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsOff, (String)"<this>");
        return AssertionsKt.assert($this$assertIsOff, FiltersKt.isOff());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsSelected(@NotNull SemanticsNodeInteraction $this$assertIsSelected) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsSelected, (String)"<this>");
        return AssertionsKt.assert($this$assertIsSelected, FiltersKt.isSelected());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsUnselected(@NotNull SemanticsNodeInteraction $this$assertIsUnselected) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsUnselected, (String)"<this>");
        return AssertionsKt.assert($this$assertIsUnselected, FiltersKt.isUnselected());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsToggleable(@NotNull SemanticsNodeInteraction $this$assertIsToggleable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsToggleable, (String)"<this>");
        return AssertionsKt.assert($this$assertIsToggleable, FiltersKt.isToggleable());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsSelectable(@NotNull SemanticsNodeInteraction $this$assertIsSelectable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsSelectable, (String)"<this>");
        return AssertionsKt.assert($this$assertIsSelectable, FiltersKt.isSelectable());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsInMutuallyExclusiveGroup(@NotNull SemanticsNodeInteraction $this$assertIsInMutuallyExclusiveGroup) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertIsInMutuallyExclusiveGroup, (String)"<this>");
        return AssertionsKt.assert($this$assertIsInMutuallyExclusiveGroup, FiltersKt.isInMutuallyExclusiveGroup());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertLabelEquals(@NotNull SemanticsNodeInteraction $this$assertLabelEquals, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertLabelEquals, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return AssertionsKt.assert($this$assertLabelEquals, FiltersKt.hasText$default(value, false, 2, null));
    }

    @NotNull
    public static final SemanticsNodeInteraction assertValueEquals(@NotNull SemanticsNodeInteraction $this$assertValueEquals, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertValueEquals, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return AssertionsKt.assert($this$assertValueEquals, FiltersKt.hasValue(value));
    }

    @NotNull
    public static final SemanticsNodeInteraction assertSemanticsIsEqualTo(@NotNull SemanticsNodeInteraction $this$assertSemanticsIsEqualTo, @NotNull SemanticsConfiguration expectedProperties) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertSemanticsIsEqualTo, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)expectedProperties, (String)"expectedProperties");
        String errorMessageOnFail = "Failed to assert semantics is equal";
        GoldenSemanticsKt.assertEquals($this$assertSemanticsIsEqualTo.fetchSemanticsNode(errorMessageOnFail).getConfig(), expectedProperties);
        return $this$assertSemanticsIsEqualTo;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertHasClickAction(@NotNull SemanticsNodeInteraction $this$assertHasClickAction) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertHasClickAction, (String)"<this>");
        return AssertionsKt.assert($this$assertHasClickAction, FiltersKt.hasClickAction());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertHasNoClickAction(@NotNull SemanticsNodeInteraction $this$assertHasNoClickAction) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertHasNoClickAction, (String)"<this>");
        return AssertionsKt.assert($this$assertHasNoClickAction, FiltersKt.hasNoClickAction());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends Collection<? extends SemanticsNodeInteraction>> T assertCountEquals(@NotNull T $this$assertCountEquals, int expectedSize) {
        Intrinsics.checkParameterIsNotNull($this$assertCountEquals, (String)"<this>");
        if ($this$assertCountEquals.size() != expectedSize) {
            Collection<SemanticsNode> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = $this$assertCountEquals;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                SemanticsNodeInteraction semanticsNodeInteraction = (SemanticsNodeInteraction)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                SemanticsPredicate semanticsPredicate = it.getSemanticsTreeInteraction$ui_test_release().getSelector();
                collection2.add(semanticsPredicate);
            }
            List selectors = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            SemanticsPredicate selector = selectors.size() == 1 ? (SemanticsPredicate)CollectionsKt.first((List)selectors) : (SemanticsPredicate)null;
            Iterable $i$f$map22 = $this$assertCountEquals;
            SemanticsPredicate semanticsPredicate = selector;
            String string = "Failed to assert count of nodes.";
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SemanticsNodeInteraction semanticsNodeInteraction = (SemanticsNodeInteraction)item$iv$iv;
                collection = destination$iv$iv2;
                SemanticsNode semanticsNode = it.fetchSemanticsNode("");
                collection.add(semanticsNode);
            }
            collection = (List)destination$iv$iv2;
            String string2 = ErrorMessagesKt.buildErrorMessageForCountMismatch(string, semanticsPredicate, (List<SemanticsNode>)collection, expectedSize);
            throw new AssertionError((Object)string2);
        }
        return $this$assertCountEquals;
    }

    @NotNull
    public static final SemanticsNodeInteraction assert(@NotNull SemanticsNodeInteraction $this$assert, @NotNull SemanticsPredicate predicate) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assert, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)predicate, (String)"predicate");
        String errorMessageOnFail = "Failed to assert the following: (" + predicate.getDescription() + ")";
        SemanticsNode node = $this$assert.fetchSemanticsNode(errorMessageOnFail);
        if (!((Boolean)predicate.getCondition().invoke((Object)node.getConfig())).booleanValue()) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForPredicateFail($this$assert.getSemanticsTreeInteraction$ui_test_release().getSelector(), node, predicate));
        }
        return $this$assert;
    }

    private static final boolean checkIsDisplayed(SemanticsNodeInteraction $this$checkIsDisplayed) {
        String errorMessageOnFail = "Failed to perform isDisplayed check.";
        SemanticsNode node = $this$checkIsDisplayed.fetchSemanticsNode(errorMessageOnFail);
        if (ComponentNodesKt.findClosestParentNode((ComponentNode)node.getComponentNode(), (Function1)((Function1)new Function1<ComponentNode, Boolean>(){

            public final boolean invoke(@NotNull ComponentNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it instanceof LayoutNode && !((LayoutNode)it).isPlaced();
            }
        })) != null) {
            return false;
        }
        PxBounds globalRect = node.getGlobalBounds();
        if (!$this$checkIsDisplayed.getSemanticsTreeInteraction$ui_test_release().isInScreenBounds$ui_test_release(globalRect)) {
            return false;
        }
        ComponentNode repaintBoundaryNode2 = ComponentNodesKt.findClosestParentNode((ComponentNode)node.getComponentNode(), (Function1)((Function1)new Function1<ComponentNode, Boolean>(){

            public final boolean invoke(@NotNull ComponentNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it instanceof RepaintBoundaryNode && ((RepaintBoundaryNode)it).getClipToShape();
            }
        }));
        if (repaintBoundaryNode2 == null) {
            return true;
        }
        LayoutNode layoutNode2 = repaintBoundaryNode2.getParentLayoutNode();
        if (layoutNode2 == null) {
            throw new AssertionError((Object)"Semantic Node has no parent layout to check for visibility layout");
        }
        LayoutNode layoutNode3 = layoutNode2;
        return AssertionsKt.contains(layoutNode3, globalRect);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean contains(LayoutNode $this$contains, PxBounds rectangle) {
        IntPx $this$toPx$iv;
        PxPosition this_$iv;
        PxPosition globalPositionTopLeft;
        long l;
        void val1$iv$iv;
        PxPosition y$iv;
        void x$iv;
        void $this$px$iv32;
        void $this$px$iv22;
        Px px;
        boolean bl = false;
        LayoutCoordinates layoutCoordinates = $this$contains.getCoordinates();
        Px $this$px$iv22 = px = new Px((float)$this$px$iv22);
        boolean bl2 = false;
        Px $this$px$iv32 = px = new Px((float)$this$px$iv32);
        float f = x$iv.getValue();
        float val2$iv$iv = y$iv.getValue();
        boolean $i$f$packFloats = false;
        void var8_14 = val1$iv$iv;
        int n = 0;
        long v1$iv$iv = Float.floatToIntBits((float)var8_14);
        float f2 = val2$iv$iv;
        boolean bl3 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        px = new PxPosition(l2);
        y$iv = globalPositionTopLeft = layoutCoordinates.localToGlobal((PxPosition)px);
        layoutCoordinates = Rect.Companion;
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv >> 32);
        boolean bl4 = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n);
        px = new Px($this$px$iv$iv);
        this_$iv = globalPositionTopLeft;
        float f3 = px.getValue();
        value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat2 = false;
        floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv & 0xFFFFFFFFL);
        bl4 = false;
        $this$px$iv$iv = Float.intBitsToFloat(n);
        Px px2 = new Px($this$px$iv$iv);
        this_$iv = $this$contains.getWidth();
        float f4 = px2.getValue();
        int $this$px$iv$iv2 = $this$toPx$iv.getValue();
        Px px3 = new Px((float)$this$px$iv$iv2);
        $this$toPx$iv = $this$contains.getHeight();
        float f5 = px3.getValue() + 1.0f;
        $this$px$iv$iv2 = $this$toPx$iv.getValue();
        Px px4 = new Px((float)$this$px$iv$iv2);
        Rect rect = layoutCoordinates.fromLTWH(f3, f4, f5, px4.getValue() + 1.0f);
        return rect.contains(new Offset(rectangle.getLeft().getValue(), rectangle.getTop().getValue())) && rect.contains(new Offset(rectangle.getRight().getValue(), rectangle.getBottom().getValue()));
    }
}

