/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.semantics.SemanticsConfiguration;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.semantics.SemanticsPropertyKey;
import androidx.ui.test.SemanticsPredicate;
import androidx.ui.unit.PxBounds;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u001a \u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0001H\u0000\u001a \u0010\f\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u001a \u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u0014*\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\f\u0010\u0019\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\u0012\u0010\u0019\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0000\u00a8\u0006\u001b"}, d2={"buildErrorMessageForCountMismatch", "", "errorMessage", "selector", "Landroidx/ui/test/SemanticsPredicate;", "foundNodes", "", "Landroidx/ui/core/semantics/SemanticsNode;", "expectedCount", "", "buildErrorMessageForNodeMissingInTree", "lastSeenSemantics", "buildErrorMessageForPredicateFail", "node", "predicate", "buildGeneralErrorMessage", "pxBoundsToShortString", "bounds", "Landroidx/ui/unit/PxBounds;", "appendConfigInfo", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "config", "Landroidx/ui/core/semantics/SemanticsConfiguration;", "toStringInfo", "", "ui-test_release"})
public final class ErrorMessagesKt {
    @NotNull
    public static final String buildErrorMessageForCountMismatch(@NotNull String errorMessage, @Nullable SemanticsPredicate selector, @NotNull List<SemanticsNode> foundNodes, int expectedCount) {
        StringBuilder sb;
        block2: {
            StringBuilder stringBuilder;
            boolean bl;
            String string;
            Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
            Intrinsics.checkParameterIsNotNull(foundNodes, (String)"foundNodes");
            sb = new StringBuilder();
            sb.append(errorMessage);
            sb.append("\n");
            sb.append("Reason: ");
            StringBuilder stringBuilder2 = expectedCount == 0 ? sb.append("Did not expect any node") : (expectedCount == 1 ? sb.append("Expected exactly '1' node") : sb.append("Expected '" + expectedCount + "' nodes"));
            StringBuilder stringBuilder3 = foundNodes.isEmpty() ? sb.append(" but could not find any") : sb.append(" but found '" + foundNodes.size() + "'");
            StringBuilder stringBuilder4 = selector != null ? (foundNodes.size() <= 1 ? sb.append(" node that satisfies: (" + selector.getDescription() + ")") : sb.append(" nodes that satisfy: (" + selector.getDescription() + ")")) : sb.append(".");
            StringsKt.appendln((StringBuilder)sb);
            Object object = foundNodes;
            boolean bl2 = false;
            if (!(!object.isEmpty())) break block2;
            if (foundNodes.size() == 1) {
                object = sb;
                string = "Node found:";
                bl = false;
                StringBuilder stringBuilder5 = ((StringBuilder)object).append(string);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
                stringBuilder = StringsKt.appendln((StringBuilder)stringBuilder5);
            } else {
                object = sb;
                string = "Nodes found:";
                bl = false;
                StringBuilder stringBuilder6 = ((StringBuilder)object).append(string);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
                stringBuilder = StringsKt.appendln((StringBuilder)stringBuilder6);
            }
            object = sb;
            string = ErrorMessagesKt.toStringInfo((Collection<SemanticsNode>)foundNodes);
            bl = false;
            StringBuilder stringBuilder7 = ((StringBuilder)object).append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder7, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder7);
        }
        return sb.toString();
    }

    @NotNull
    public static final String buildErrorMessageForNodeMissingInTree(@NotNull String errorMessage, @NotNull SemanticsPredicate selector, @NotNull String lastSeenSemantics) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        Intrinsics.checkParameterIsNotNull((Object)lastSeenSemantics, (String)"lastSeenSemantics");
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        sb.append("\n");
        StringBuilder stringBuilder = sb;
        String string = "The node is no longer in the tree, last known semantics:";
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        stringBuilder = sb;
        boolean bl2 = false;
        StringBuilder stringBuilder3 = stringBuilder.append(lastSeenSemantics);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        sb.append("Original selector: ");
        stringBuilder = sb;
        String string2 = selector.getDescription();
        bl = false;
        StringBuilder stringBuilder4 = stringBuilder.append(string2);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        return sb.toString();
    }

    @NotNull
    public static final String buildErrorMessageForPredicateFail(@NotNull SemanticsPredicate selector, @NotNull SemanticsNode node, @NotNull SemanticsPredicate predicate) {
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)predicate, (String)"predicate");
        return ErrorMessagesKt.buildGeneralErrorMessage("Failed to assert that node satisfies the following condition: (" + predicate.getDescription() + ")", selector, node);
    }

    @NotNull
    public static final String buildGeneralErrorMessage(@NotNull String errorMessage, @NotNull SemanticsPredicate selector, @NotNull SemanticsNode node) {
        StringBuilder sb;
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        StringBuilder stringBuilder = sb = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(errorMessage);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        stringBuilder = sb;
        String string = "Semantics of the node:";
        boolean bl2 = false;
        StringBuilder stringBuilder3 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        stringBuilder = sb;
        string = ErrorMessagesKt.toStringInfo(node);
        bl2 = false;
        StringBuilder stringBuilder4 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        sb.append("Selector used: (");
        sb.append(selector.getDescription());
        stringBuilder = sb;
        string = ")";
        bl2 = false;
        StringBuilder stringBuilder5 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder5);
        return sb.toString();
    }

    @NotNull
    public static final String toStringInfo(@NotNull Collection<SemanticsNode> $this$toStringInfo) {
        Intrinsics.checkParameterIsNotNull($this$toStringInfo, (String)"<this>");
        Ref.ObjectRef sb = new Ref.ObjectRef();
        sb.element = new StringBuilder();
        Ref.IntRef i = new Ref.IntRef();
        i.element = 1;
        Iterable $this$forEach$iv = $this$toStringInfo;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SemanticsNode it = (SemanticsNode)element$iv;
            if ($this$toStringInfo.size() > 1) {
                ((StringBuilder)sb.element).append(i.element);
                ((StringBuilder)sb.element).append(") ");
            }
            ((StringBuilder)sb.element).append(ErrorMessagesKt.toStringInfo(it));
            if (i.element < $this$toStringInfo.size()) {
                StringsKt.appendln((StringBuilder)((StringBuilder)sb.element));
            }
            ++i.element;
            int cfr_ignored_0 = i.element;
        }
        return ((StringBuilder)sb.element).toString();
    }

    @NotNull
    public static final String toStringInfo(@NotNull SemanticsNode $this$toStringInfo) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toStringInfo, (String)"<this>");
        StringBuilder sb = new StringBuilder();
        sb.append("Id: " + $this$toStringInfo.getId() + ", Position: ");
        StringBuilder stringBuilder = sb;
        String string = ErrorMessagesKt.pxBoundsToShortString($this$toStringInfo.getGlobalBounds());
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        ErrorMessagesKt.appendConfigInfo(sb, $this$toStringInfo.getConfig());
        return sb.toString();
    }

    private static final String pxBoundsToShortString(PxBounds bounds) {
        return "LTRB(" + bounds.getLeft() + ", " + bounds.getTop() + ", " + bounds.getRight() + ", " + bounds.getBottom() + ")";
    }

    private static final void appendConfigInfo(StringBuilder $this$appendConfigInfo, SemanticsConfiguration config) {
        block3: {
            String prefix = "- ";
            String separator = "\n";
            int startLength = $this$appendConfigInfo.length();
            Iterator iterator = config.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                boolean bl = false;
                SemanticsPropertyKey key = (SemanticsPropertyKey)entry2.getKey();
                Map.Entry entry3 = entry;
                boolean bl2 = false;
                Object value = entry3.getValue();
                $this$appendConfigInfo.append(prefix);
                $this$appendConfigInfo.append(key.getName());
                $this$appendConfigInfo.append(" = '");
                $this$appendConfigInfo.append(value);
                $this$appendConfigInfo.append("'");
                $this$appendConfigInfo.append(separator);
            }
            if (config.isSemanticBoundary()) {
                $this$appendConfigInfo.append(prefix);
                $this$appendConfigInfo.append("Boundary = 'true'");
                $this$appendConfigInfo.append(separator);
            }
            if (config.isMergingSemanticsOfDescendants()) {
                $this$appendConfigInfo.append(prefix);
                $this$appendConfigInfo.append("MergeDescendants = 'true'");
                $this$appendConfigInfo.append(separator);
            }
            if ($this$appendConfigInfo.length() <= startLength) break block3;
            $this$appendConfigInfo.setLength($this$appendConfigInfo.length() - separator.length());
        }
    }
}

