/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.semantics.SemanticsConfiguration;
import androidx.ui.core.semantics.SemanticsConfigurationKt;
import androidx.ui.foundation.selection.ToggleableState;
import androidx.ui.foundation.semantics.FoundationSemanticsProperties;
import androidx.ui.semantics.SemanticsActions;
import androidx.ui.semantics.SemanticsProperties;
import androidx.ui.semantics.SemanticsPropertyKey;
import androidx.ui.test.SemanticsPredicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0007\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0007\u001a\u0006\u0010\u0010\u001a\u00020\u0001\u001a\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u0006\u0010\u0017\u001a\u00020\u0001\u001a\u0006\u0010\u0018\u001a\u00020\u0001\u00a8\u0006\u0019"}, d2={"hasClickAction", "Landroidx/ui/test/SemanticsPredicate;", "hasNoClickAction", "hasNoScrollAction", "hasScrollAction", "hasSubstring", "substring", "", "ignoreCase", "", "hasTestTag", "testTag", "hasText", "text", "hasValue", "value", "isHidden", "isInMutuallyExclusiveGroup", "isNotHidden", "isOff", "isOn", "isSelectable", "isSelected", "isToggleable", "isUnselected", "ui-test_release"})
public final class FiltersKt {
    @NotNull
    public static final SemanticsPredicate isToggleable() {
        return SemanticsPredicate.Companion.keyIsDefined(FoundationSemanticsProperties.INSTANCE.getToggleableState());
    }

    @NotNull
    public static final SemanticsPredicate isOn() {
        return SemanticsPredicate.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getToggleableState(), ToggleableState.On);
    }

    @NotNull
    public static final SemanticsPredicate isOff() {
        return SemanticsPredicate.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getToggleableState(), ToggleableState.Off);
    }

    @NotNull
    public static final SemanticsPredicate isSelectable() {
        return SemanticsPredicate.Companion.keyIsDefined(FoundationSemanticsProperties.INSTANCE.getSelected());
    }

    @NotNull
    public static final SemanticsPredicate isSelected() {
        return SemanticsPredicate.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getSelected(), true);
    }

    @NotNull
    public static final SemanticsPredicate isUnselected() {
        return SemanticsPredicate.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getSelected(), false);
    }

    @NotNull
    public static final SemanticsPredicate hasClickAction() {
        return SemanticsPredicate.Companion.keyIsDefined(SemanticsActions.Companion.getOnClick());
    }

    @NotNull
    public static final SemanticsPredicate hasNoClickAction() {
        return SemanticsPredicate.Companion.keyNotDefined(SemanticsActions.Companion.getOnClick());
    }

    @NotNull
    public static final SemanticsPredicate hasScrollAction() {
        return SemanticsPredicate.Companion.keyIsDefined(SemanticsActions.Companion.getScrollTo());
    }

    @NotNull
    public static final SemanticsPredicate hasNoScrollAction() {
        return SemanticsPredicate.Companion.keyNotDefined(SemanticsActions.Companion.getScrollTo());
    }

    @NotNull
    public static final SemanticsPredicate hasText(@NotNull String text, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return new SemanticsPredicate(SemanticsProperties.INSTANCE.getAccessibilityLabel().getName() + " = '" + text + "' (ignoreCase: " + ignoreCase + ")", (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(text, ignoreCase){
            private final /* synthetic */ String $text;
            private final /* synthetic */ boolean $ignoreCase;
            {
                this.$text = $text;
                this.$ignoreCase = $ignoreCase;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                return StringsKt.equals((String)((String)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)semanticsConfiguration, (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getAccessibilityLabel())), (String)this.$text, (boolean)this.$ignoreCase);
            }
        }));
    }

    public static /* synthetic */ SemanticsPredicate hasText$default(@NotNull String text, boolean ignoreCase, int $mask0, @Nullable Object $handler) {
        boolean bl = ($mask0 & 2) != 0 ? false : ignoreCase;
        return FiltersKt.hasText(text, bl);
    }

    @NotNull
    public static final SemanticsPredicate hasSubstring(@NotNull String substring, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)substring, (String)"substring");
        return new SemanticsPredicate(SemanticsProperties.INSTANCE.getAccessibilityLabel().getName() + ".contains(" + substring + ", " + ignoreCase + ")", (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(substring, ignoreCase){
            private final /* synthetic */ String $substring;
            private final /* synthetic */ boolean $ignoreCase;
            {
                this.$substring = $substring;
                this.$ignoreCase = $ignoreCase;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                String string = (String)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)semanticsConfiguration, (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getAccessibilityLabel());
                Boolean bl = string == null ? (Boolean)null : Boolean.valueOf(StringsKt.contains((CharSequence)string, (CharSequence)this.$substring, (boolean)this.$ignoreCase));
                return bl == null ? false : bl;
            }
        }));
    }

    public static /* synthetic */ SemanticsPredicate hasSubstring$default(@NotNull String substring, boolean ignoreCase, int $mask0, @Nullable Object $handler) {
        boolean bl = ($mask0 & 2) != 0 ? false : ignoreCase;
        return FiltersKt.hasSubstring(substring, bl);
    }

    @NotNull
    public static final SemanticsPredicate hasValue(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return SemanticsPredicate.Companion.expectValue(SemanticsProperties.INSTANCE.getAccessibilityValue(), value);
    }

    @NotNull
    public static final SemanticsPredicate hasTestTag(@NotNull String testTag) {
        Intrinsics.checkParameterIsNotNull((Object)testTag, (String)"testTag");
        return SemanticsPredicate.Companion.expectValue(SemanticsProperties.INSTANCE.getTestTag(), testTag);
    }

    @NotNull
    public static final SemanticsPredicate isInMutuallyExclusiveGroup() {
        return SemanticsPredicate.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getInMutuallyExclusiveGroup(), true);
    }

    @NotNull
    public static final SemanticsPredicate isHidden() {
        return SemanticsPredicate.Companion.expectValue(SemanticsProperties.INSTANCE.getHidden(), true);
    }

    @NotNull
    public static final SemanticsPredicate isNotHidden() {
        return SemanticsPredicate.Companion.expectValue(SemanticsProperties.INSTANCE.getHidden(), false);
    }
}

