/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.semantics.SemanticsConfiguration;
import androidx.ui.semantics.SemanticsPropertyKey;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bJ\u0011\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0004J\t\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0004R\"\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Landroidx/ui/test/SemanticsPredicate;", "", "description", "", "condition", "Lkotlin/Function1;", "Landroidx/ui/core/semantics/SemanticsConfiguration;", "", "Lkotlin/ExtensionFunctionType;", "getCondition", "()Lkotlin/jvm/functions/Function1;", "getDescription", "()Ljava/lang/String;", "and", "other", "not", "or", "Companion", "ui-test_release"})
public final class SemanticsPredicate {
    private final String description;
    private final Function1<SemanticsConfiguration, Boolean> condition;
    private static final SemanticsPredicate any;
    @NotNull
    public static final Companion Companion;

    public SemanticsPredicate(@NotNull String description, @NotNull Function1<? super SemanticsConfiguration, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        this.description = description;
        this.condition = condition;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final Function1<SemanticsConfiguration, Boolean> getCondition() {
        return this.condition;
    }

    @NotNull
    public final SemanticsPredicate and(@NotNull SemanticsPredicate other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        String desc = "(" + this.getDescription() + ") && (" + other.getDescription() + ")";
        return new SemanticsPredicate(desc, (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(this, other){
            private final /* synthetic */ SemanticsPredicate $this$and;
            private final /* synthetic */ SemanticsPredicate $other;
            {
                this.$this$and = $receiver;
                this.$other = $other;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                return (Boolean)this.$this$and.getCondition().invoke((Object)semanticsConfiguration) != false && (Boolean)this.$other.getCondition().invoke((Object)semanticsConfiguration) != false;
            }
        }));
    }

    @NotNull
    public final SemanticsPredicate or(@NotNull SemanticsPredicate other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        String desc = "(" + this.getDescription() + ") || (" + other.getDescription() + ")";
        return new SemanticsPredicate(desc, (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(this, other){
            private final /* synthetic */ SemanticsPredicate $this$or;
            private final /* synthetic */ SemanticsPredicate $other;
            {
                this.$this$or = $receiver;
                this.$other = $other;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                return (Boolean)this.$this$or.getCondition().invoke((Object)semanticsConfiguration) != false || (Boolean)this.$other.getCondition().invoke((Object)semanticsConfiguration) != false;
            }
        }));
    }

    @NotNull
    public final SemanticsPredicate not() {
        String desc = "NOT (" + this.getDescription() + ")";
        return new SemanticsPredicate(desc, (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(this){
            private final /* synthetic */ SemanticsPredicate $this$not;
            {
                this.$this$not = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                return (Boolean)this.$this$not.getCondition().invoke((Object)semanticsConfiguration) == false;
            }
        }));
    }

    static {
        Companion = new Companion(null);
        any = new SemanticsPredicate("Any", (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(){

            public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                return true;
            }
        }));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002J'\u0010\u0006\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\n\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\f\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tJ\u001a\u0010\r\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"Landroidx/ui/test/SemanticsPredicate$Companion;", "", "any", "Landroidx/ui/test/SemanticsPredicate;", "getAny", "()Landroidx/ui/test/SemanticsPredicate;", "expectValue", "T", "key", "Landroidx/ui/semantics/SemanticsPropertyKey;", "expectedValue", "(Landroidx/ui/semantics/SemanticsPropertyKey;Ljava/lang/Object;)Landroidx/ui/test/SemanticsPredicate;", "keyIsDefined", "keyNotDefined", "ui-test_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SemanticsPredicate getAny() {
            return any;
        }

        @NotNull
        public final <T> SemanticsPredicate expectValue(@NotNull SemanticsPropertyKey<T> key, T expectedValue) {
            Intrinsics.checkParameterIsNotNull(key, (String)"key");
            return new SemanticsPredicate(key.getName() + " = '" + expectedValue + "'", (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(key, expectedValue){
                private final /* synthetic */ SemanticsPropertyKey<T> $key;
                private final /* synthetic */ T $expectedValue;
                {
                    this.$key = $key;
                    this.$expectedValue = $expectedValue;
                    super(1);
                }

                public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                    Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                    return Intrinsics.areEqual((Object)semanticsConfiguration.getOrElseNullable(this.$key, new Function0(){

                        @Nullable
                        public final Void invoke() {
                            return null;
                        }
                    }), this.$expectedValue);
                }
            }));
        }

        @NotNull
        public final <T> SemanticsPredicate keyIsDefined(@NotNull SemanticsPropertyKey<T> key) {
            Intrinsics.checkParameterIsNotNull(key, (String)"key");
            return new SemanticsPredicate(Intrinsics.stringPlus((String)key.getName(), (Object)" is defined"), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(key){
                private final /* synthetic */ SemanticsPropertyKey<T> $key;
                {
                    this.$key = $key;
                    super(1);
                }

                public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                    Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                    return semanticsConfiguration.contains(this.$key);
                }
            }));
        }

        @NotNull
        public final <T> SemanticsPredicate keyNotDefined(@NotNull SemanticsPropertyKey<T> key) {
            Intrinsics.checkParameterIsNotNull(key, (String)"key");
            return new SemanticsPredicate(Intrinsics.stringPlus((String)key.getName(), (Object)" is NOT defined"), (Function1<? super SemanticsConfiguration, Boolean>)((Function1)new Function1<SemanticsConfiguration, Boolean>(key){
                private final /* synthetic */ SemanticsPropertyKey<T> $key;
                {
                    this.$key = $key;
                    super(1);
                }

                public final boolean invoke(@NotNull SemanticsConfiguration semanticsConfiguration) {
                    Intrinsics.checkParameterIsNotNull((Object)semanticsConfiguration, (String)"<this>");
                    return !semanticsConfiguration.contains(this.$key);
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

