/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.test.InputDispatcher;
import androidx.ui.test.SemanticsPredicate;
import androidx.ui.test.SemanticsTreeInteraction;
import androidx.ui.test.android.AndroidInputDispatcher;
import androidx.ui.test.android.CollectedProviders;
import androidx.ui.test.android.SynchronizedTreeCollector;
import androidx.ui.test.android.WindowCaptureKt;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxBounds;
import androidx.ui.unit.PxKt;
import androidx.ui.unit.PxPosition;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\n\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0011\u00a2\u0006\u0002\b\nJ\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0010\u00a2\u0006\u0002\b\rJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0010\u00a2\u0006\u0002\b\u0012J!\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00140\u0016H\u0010\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/ui/test/android/AndroidSemanticsTreeInteraction;", "Landroidx/ui/test/SemanticsTreeInteraction;", "selector", "Landroidx/ui/test/SemanticsPredicate;", "handler", "Landroid/os/Handler;", "captureNodeToBitmap", "Landroid/graphics/Bitmap;", "node", "Landroidx/ui/core/semantics/SemanticsNode;", "captureNodeToBitmap$ui_test_release", "getAllSemanticsNodes", "", "getAllSemanticsNodes$ui_test_release", "isInScreenBounds", "", "rectangle", "Landroidx/ui/unit/PxBounds;", "isInScreenBounds$ui_test_release", "sendInput", "", "action", "Lkotlin/Function1;", "Landroidx/ui/test/InputDispatcher;", "sendInput$ui_test_release", "ui-test_release"})
public final class AndroidSemanticsTreeInteraction
extends SemanticsTreeInteraction {
    private final Handler handler;

    public AndroidSemanticsTreeInteraction(@NotNull SemanticsPredicate selector) {
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        super(selector);
        this.handler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void sendInput$ui_test_release(@NotNull Function1<? super InputDispatcher, Unit> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        action.invoke((Object)new AndroidInputDispatcher(SynchronizedTreeCollector.INSTANCE.collectSemanticsProviders$ui_test_release()));
    }

    @Override
    @NotNull
    public List<SemanticsNode> getAllSemanticsNodes$ui_test_release() {
        return SynchronizedTreeCollector.INSTANCE.collectSemanticsProviders$ui_test_release().getAllSemanticNodes();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInScreenBounds$ui_test_release(@NotNull PxBounds rectangle) {
        PxPosition this_$iv;
        boolean $this$px$iv;
        long l;
        void val1$iv$iv;
        void y$iv;
        void x$iv22;
        Intrinsics.checkParameterIsNotNull((Object)rectangle, (String)"rectangle");
        DisplayMetrics displayMetrics = SynchronizedTreeCollector.INSTANCE.collectSemanticsProviders$ui_test_release().findActivity().getResources().getDisplayMetrics();
        int $this$px$iv22 = displayMetrics.widthPixels;
        Px $this$px$iv22 = new Px((float)$this$px$iv22);
        int $this$px$iv32 = displayMetrics.heightPixels;
        Px $this$px$iv32 = new Px((float)$this$px$iv32);
        float f = x$iv22.getValue();
        float val2$iv$iv = y$iv.getValue();
        boolean $i$f$packFloats = false;
        void var9_15 = val1$iv$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var9_15);
        float f2 = val2$iv$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxPosition bottomRight = new PxPosition(l2);
        boolean x$iv22 = false;
        Px px = rectangle.getTop();
        Px px2 = new Px((float)$this$px$iv);
        if (px.compareTo(px2) < 0) return false;
        $this$px$iv = false;
        px = rectangle.getLeft();
        if (px.compareTo(px2 = new Px((float)$this$px$iv)) < 0) return false;
        PxPosition $this$px$iv4 = bottomRight;
        px = rectangle.getRight();
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv >> 32);
        bl = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n);
        px2 = new Px($this$px$iv$iv);
        if (px.compareTo(px2) > 0) return false;
        this_$iv = bottomRight;
        px = rectangle.getBottom();
        value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat2 = false;
        floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv & 0xFFFFFFFFL);
        bl = false;
        $this$px$iv$iv = Float.intBitsToFloat(n);
        px2 = new Px($this$px$iv$iv);
        if (px.compareTo(px2) > 0) return false;
        return true;
    }

    @Override
    @RequiresApi(value=26)
    @NotNull
    public Bitmap captureNodeToBitmap$ui_test_release(@NotNull SemanticsNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        CollectedProviders collectedInfo = SynchronizedTreeCollector.INSTANCE.collectSemanticsProviders$ui_test_release();
        boolean exists = this.contains$ui_test_release(node.getId());
        if (!exists) {
            throw new AssertionError((Object)"The required node is no longer in the tree!");
        }
        Window window = collectedInfo.findActivity().getWindow();
        return WindowCaptureKt.captureRegionToBitmap(PxKt.toRect((PxBounds)node.getGlobalBounds()), this.handler, window);
    }
}

