/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.ComponentNode;
import androidx.ui.core.ComponentNodesKt;
import androidx.ui.core.LayoutCoordinates;
import androidx.ui.core.LayoutNode;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.semantics.AccessibilityAction;
import androidx.ui.semantics.SemanticsActions;
import androidx.ui.semantics.SemanticsPropertyKey;
import androidx.ui.test.ErrorMessagesKt;
import androidx.ui.test.FiltersKt;
import androidx.ui.test.GestureScope;
import androidx.ui.test.GestureScopeKt;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.SynchronizationKt;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxPosition;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0018\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00060\u00050\u0004\u001aB\u0010\u0000\u001a\u00020\u0001\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00050\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00010\n\u001a\n\u0010\u000b\u001a\u00020\u0002*\u00020\u0002\u001a#\u0010\f\u001a\u00020\u0002*\u00020\u00022\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\u0002\b\u000f\u001a\n\u0010\u0010\u001a\u00020\u0002*\u00020\u0002\u00a8\u0006\u0011"}, d2={"callSemanticsAction", "", "Landroidx/ui/test/SemanticsNodeInteraction;", "key", "Landroidx/ui/semantics/SemanticsPropertyKey;", "Landroidx/ui/semantics/AccessibilityAction;", "Lkotlin/Function0;", "T", "Lkotlin/Function;", "invocation", "Lkotlin/Function1;", "doClick", "doGesture", "block", "Landroidx/ui/test/GestureScope;", "Lkotlin/ExtensionFunctionType;", "doScrollTo", "ui-test_release"})
public final class ActionsKt {
    @NotNull
    public static final SemanticsNodeInteraction doClick(@NotNull SemanticsNodeInteraction $this$doClick) {
        Intrinsics.checkParameterIsNotNull((Object)$this$doClick, (String)"<this>");
        return ActionsKt.doGesture($this$doClick, (Function1<? super GestureScope, Unit>)((Function1)new Function1<GestureScope, Unit>(){

            public final void invoke(@NotNull GestureScope gestureScope) {
                Intrinsics.checkParameterIsNotNull((Object)gestureScope, (String)"<this>");
                GestureScopeKt.sendClick(gestureScope);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SemanticsNodeInteraction doScrollTo(@NotNull SemanticsNodeInteraction $this$doScrollTo) {
        long l;
        void val1$iv$iv;
        void y$iv;
        void x$iv;
        void $this$px$iv32;
        void $this$px$iv22;
        Px px;
        Intrinsics.checkParameterIsNotNull((Object)$this$doScrollTo, (String)"<this>");
        String errorMessageOnFail = "Failed to perform doScrollTo.";
        SemanticsNode node = $this$doScrollTo.fetchSemanticsNode(errorMessageOnFail);
        SemanticsNode semanticsNode = ComponentNodesKt.findClosestParentNode((SemanticsNode)node, (Function1)((Function1)new Function1<SemanticsNode, Boolean>(){

            public final boolean invoke(@NotNull SemanticsNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (Boolean)FiltersKt.hasScrollAction().getCondition().invoke((Object)it);
            }
        }));
        if (semanticsNode == null) {
            throw new AssertionError((Object)"Semantic Node has no parent layout with a Scroll SemanticsAction");
        }
        SemanticsNode scrollableSemanticsNode2 = semanticsNode;
        PxPosition globalPosition = node.getGlobalPosition();
        LayoutNode layoutNode2 = ComponentNodesKt.findLastLayoutChild((ComponentNode)scrollableSemanticsNode2.getComponentNode(), (Function1)((Function1)new Function1<LayoutNode, Boolean>(){

            public final boolean invoke(@NotNull LayoutNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return true;
            }
        }));
        if (layoutNode2 == null) {
            throw new AssertionError((Object)"No Layout Node found!");
        }
        LayoutNode layoutNode3 = layoutNode2;
        boolean bl = false;
        LayoutCoordinates layoutCoordinates = layoutNode3.getCoordinates();
        Px $this$px$iv22 = px = new Px((float)$this$px$iv22);
        boolean bl2 = false;
        Px $this$px$iv32 = px = new Px((float)$this$px$iv32);
        float f = x$iv.getValue();
        float val2$iv$iv = y$iv.getValue();
        boolean $i$f$packFloats = false;
        void var12_16 = val1$iv$iv;
        boolean bl3 = false;
        long v1$iv$iv = Float.floatToIntBits((float)var12_16);
        float f2 = val2$iv$iv;
        boolean bl4 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        px = new PxPosition(l2);
        PxPosition position = layoutCoordinates.localToGlobal((PxPosition)px);
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(scrollableSemanticsNode2, globalPosition, position){
            private final /* synthetic */ SemanticsNode $scrollableSemanticsNode;
            private final /* synthetic */ PxPosition $globalPosition;
            private final /* synthetic */ PxPosition $position;
            {
                this.$scrollableSemanticsNode = $scrollableSemanticsNode;
                this.$globalPosition = $globalPosition;
                this.$position = $position;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                Px px;
                void other$iv;
                Px this_$iv;
                Px px2;
                Px this_$iv2;
                PxPosition pxPosition = this.$globalPosition;
                Function2 function2 = (Function2)((AccessibilityAction)this.$scrollableSemanticsNode.getConfig().get(SemanticsActions.Companion.getScrollTo())).getAction();
                long value$iv$iv22 = this_$iv2.getValue();
                boolean $i$f$unpackFloat1 = false;
                FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
                int n = (int)(value$iv$iv22 >> 32);
                int n2 = 0;
                float $this$px$iv$iv22 = Float.intBitsToFloat(n);
                this_$iv2 = px2 = new Px($this$px$iv$iv22);
                PxPosition value$iv$iv22 = this.$position;
                long value$iv$iv = this_$iv.getValue();
                boolean $i$f$unpackFloat32 = false;
                FloatCompanionObject floatCompanionObject2 = FloatCompanionObject.INSTANCE;
                n2 = (int)(value$iv$iv >> 32);
                boolean $this$px$iv$iv22 = false;
                float $this$px$iv$iv = Float.intBitsToFloat(n2);
                this_$iv = px2 = new Px($this$px$iv$iv);
                px2 = new Px(this_$iv2.getValue() - other$iv.getValue());
                this_$iv2 = this.$globalPosition;
                long value$iv$iv32 = this_$iv2.getValue();
                boolean $i$f$unpackFloat2 = false;
                FloatCompanionObject $i$f$unpackFloat32 = FloatCompanionObject.INSTANCE;
                int n3 = (int)(value$iv$iv32 & 0xFFFFFFFFL);
                n2 = 0;
                float $this$px$iv$iv3 = Float.intBitsToFloat(n3);
                this_$iv2 = px = new Px($this$px$iv$iv3);
                PxPosition value$iv$iv32 = this.$position;
                value$iv$iv = this_$iv.getValue();
                boolean $i$f$unpackFloat22 = false;
                FloatCompanionObject floatCompanionObject3 = FloatCompanionObject.INSTANCE;
                n2 = (int)(value$iv$iv & 0xFFFFFFFFL);
                boolean bl = false;
                $this$px$iv$iv = Float.intBitsToFloat(n2);
                this_$iv = px = new Px($this$px$iv$iv);
                px = new Px(this_$iv2.getValue() - other$iv.getValue());
                function2.invoke((Object)px2, (Object)px);
            }
        });
        return $this$doScrollTo;
    }

    @NotNull
    public static final SemanticsNodeInteraction doGesture(@NotNull SemanticsNodeInteraction $this$doGesture, @NotNull Function1<? super GestureScope, Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$this$doGesture, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        GestureScope scope = new GestureScope($this$doGesture);
        block.invoke((Object)scope);
        return $this$doGesture;
    }

    public static final <T extends Function<? extends Unit>> void callSemanticsAction(@NotNull SemanticsNodeInteraction $this$callSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<T>> key, @NotNull Function1<? super T, Unit> invocation) {
        Intrinsics.checkParameterIsNotNull((Object)$this$callSemanticsAction, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull(invocation, (String)"invocation");
        SemanticsNode node = $this$callSemanticsAction.fetchSemanticsNode("Failed to call " + key.getName() + " action.");
        if (!node.getConfig().contains(key)) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage("Failed to call " + key.getName() + " action as it is not defined on the node.", $this$callSemanticsAction.getSemanticsTreeInteraction$ui_test_release().getSelector(), node));
        }
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(invocation, node, key){
            private final /* synthetic */ Function1<T, Unit> $invocation;
            private final /* synthetic */ SemanticsNode $node;
            private final /* synthetic */ SemanticsPropertyKey<AccessibilityAction<T>> $key;
            {
                this.$invocation = $invocation;
                this.$node = $node;
                this.$key = $key;
                super(0);
            }

            public final void invoke() {
                this.$invocation.invoke((Object)((AccessibilityAction)this.$node.getConfig().get(this.$key)).getAction());
            }
        });
    }

    public static final void callSemanticsAction(@NotNull SemanticsNodeInteraction $this$callSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<Function0<Unit>>> key) {
        Intrinsics.checkParameterIsNotNull((Object)$this$callSemanticsAction, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        ActionsKt.callSemanticsAction($this$callSemanticsAction, key, (Function1)new Function1<Function0<? extends Unit>, Unit>(){

            public final void invoke(@NotNull Function0<Unit> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                it.invoke();
            }
        });
    }
}

