/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Path;
import android.os.Handler;
import android.view.View;
import androidx.annotation.RequiresApi;
import androidx.ui.foundation.shape.RectangleShapeKt;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.AndroidPath;
import androidx.ui.graphics.AndroidPathKt;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.Outline;
import androidx.ui.graphics.OutlineKt;
import androidx.ui.graphics.Shape;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.android.WindowCaptureKt;
import androidx.ui.unit.Density;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxPosition;
import androidx.ui.unit.IntPxSize;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxSize;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000p\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u001a(\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u001a8\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u0011\u001a;\u0010\u0013\u001a\u00020\t*\u00020\n2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152#\u0010\u0016\u001a\u001f\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0011\u001az\u0010\u001b\u001a\u00020\t*\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\f2\b\b\u0002\u0010\"\u001a\u00020\u001f2\b\b\u0002\u0010#\u001a\u00020\u00042\b\b\u0002\u0010$\u001a\u00020\u00042\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u00042\b\b\u0002\u0010&\u001a\u00020\u00042\b\b\u0002\u0010'\u001a\u00020\u0004\u001a\f\u0010(\u001a\u00020\n*\u00020)H\u0007\u001a\f\u0010(\u001a\u00020\n*\u00020*H\u0007\u001a\u0012\u0010+\u001a\u00020,*\u00020-2\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0015\u0010.\u001a\u00020/*\u00020\u00042\u0006\u0010.\u001a\u00020\u0004H\u0082\u0004\u00a8\u00060"}, d2={"pixelCloserToCenter", "Landroidx/ui/geometry/Offset;", "offset", "shapeSizeX", "Landroidx/ui/unit/Px;", "shapeSizeY", "delta", "pixelFartherFromCenter", "assertPixelColor", "", "Landroid/graphics/Bitmap;", "expected", "Landroidx/ui/graphics/Color;", "x", "", "y", "error", "Lkotlin/Function1;", "", "assertPixels", "expectedSize", "Landroidx/ui/unit/IntPxSize;", "expectedColorProvider", "Landroidx/ui/unit/IntPxPosition;", "Lkotlin/ParameterName;", "name", "pos", "assertShape", "density", "Landroidx/ui/unit/Density;", "shape", "Landroidx/ui/graphics/Shape;", "shapeColor", "backgroundColor", "backgroundShape", "sizeX", "sizeY", "centerX", "centerY", "shapeOverlapPixelCount", "captureToBitmap", "Landroid/view/View;", "Landroidx/ui/test/SemanticsNodeInteraction;", "contains", "", "Landroidx/ui/graphics/Path;", "until", "Lkotlin/ranges/IntRange;", "ui-test_release"})
public final class BitmapHelpersKt {
    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureToBitmap(@NotNull SemanticsNodeInteraction $this$captureToBitmap) {
        Intrinsics.checkParameterIsNotNull((Object)$this$captureToBitmap, (String)"<this>");
        String errorMessageOnFail = "Failed to capture a node to bitmap.";
        return $this$captureToBitmap.getSemanticsTreeInteraction$ui_test_release().captureNodeToBitmap$ui_test_release($this$captureToBitmap.fetchSemanticsNode(errorMessageOnFail));
    }

    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureToBitmap(@NotNull View $this$captureToBitmap) {
        Intrinsics.checkParameterIsNotNull((Object)$this$captureToBitmap, (String)"<this>");
        int[] nArray = new int[]{0, 0};
        int[] locationOnScreen = nArray;
        $this$captureToBitmap.getLocationOnScreen(locationOnScreen);
        float x = locationOnScreen[0];
        float y = locationOnScreen[1];
        Rect bounds = new Rect(x, y, x + (float)$this$captureToBitmap.getWidth(), y + (float)$this$captureToBitmap.getHeight());
        Handler handler = $this$captureToBitmap.getHandler();
        Activity activity = BitmapHelpersKt.captureToBitmap$getActivity($this$captureToBitmap.getContext());
        if (activity == null) {
            Intrinsics.throwNpe();
        }
        return WindowCaptureKt.captureRegionToBitmap(bounds, handler, activity.getWindow());
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertPixels(@NotNull Bitmap $this$assertPixels, @Nullable IntPxSize expectedSize, @NotNull Function1<? super IntPxPosition, Color> expectedColorProvider) {
        block6: {
            block4: {
                block5: {
                    IntPxSize this_$iv;
                    Intrinsics.checkParameterIsNotNull((Object)$this$assertPixels, (String)"<this>");
                    Intrinsics.checkParameterIsNotNull(expectedColorProvider, (String)"expectedColorProvider");
                    if (expectedSize == null) break block4;
                    IntPxSize intPxSize = expectedSize;
                    int n = $this$assertPixels.getWidth();
                    long value$iv$iv = this_$iv.getValue();
                    boolean $i$f$unpackInt1 = false;
                    int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
                    IntPx intPx = new IntPx($this$ipx$iv$iv);
                    if (n != intPx.getValue()) break block5;
                    this_$iv = expectedSize;
                    n = $this$assertPixels.getHeight();
                    value$iv$iv = this_$iv.getValue();
                    boolean $i$f$unpackInt2 = false;
                    $this$ipx$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                    intPx = new IntPx($this$ipx$iv$iv);
                    if (n == intPx.getValue()) break block4;
                }
                throw new AssertionError((Object)("Bitmap size is wrong! Expected '" + expectedSize + "' but got '" + $this$assertPixels.getWidth() + " x " + $this$assertPixels.getHeight() + "'"));
            }
            int n = $this$assertPixels.getWidth();
            int n2 = 0;
            int n3 = n + -1;
            if (n == Integer.MIN_VALUE || n2 > n3) break block6;
            do {
                int x = n2++;
                int n4 = $this$assertPixels.getHeight();
                int n5 = 0;
                int n6 = n4 + -1;
                if (n4 == Integer.MIN_VALUE || n5 > n6) continue;
                do {
                    void val1$iv$iv;
                    void y$iv;
                    void x$iv;
                    int y = n5++;
                    int $this$ipx$iv22 = x;
                    IntPx $this$ipx$iv22 = new IntPx($this$ipx$iv22);
                    int $this$ipx$iv32 = y;
                    IntPx $this$ipx$iv32 = new IntPx($this$ipx$iv32);
                    int n7 = x$iv.getValue();
                    int val2$iv$iv = y$iv.getValue();
                    boolean $i$f$packInts = false;
                    long l = (long)val1$iv$iv << 32 | (long)val2$iv$iv & 0xFFFFFFFFL;
                    long l2 = l;
                    IntPxPosition pxPos = new IntPxPosition(l2);
                    Color expectedClr = (Color)expectedColorProvider.invoke((Object)pxPos);
                    if (expectedClr == null) continue;
                    BitmapHelpersKt.assertPixelColor$default($this$assertPixels, expectedClr, x, y, null, 8, null);
                } while (n5 <= n6);
            } while (n2 <= n3);
        }
    }

    public static /* synthetic */ void assertPixels$default(@NotNull Bitmap $this$assertPixels_u24default, @Nullable IntPxSize expectedSize, @NotNull Function1 expectedColorProvider, int $mask0, @Nullable Object $handler) {
        IntPxSize intPxSize = ($mask0 & 1) != 0 ? (IntPxSize)null : expectedSize;
        BitmapHelpersKt.assertPixels($this$assertPixels_u24default, intPxSize, (Function1<? super IntPxPosition, Color>)expectedColorProvider);
    }

    public static final void assertPixelColor(@NotNull Bitmap $this$assertPixelColor, @NotNull Color expected, int x, int y, @NotNull Function1<? super Color, String> error) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertPixelColor, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        Intrinsics.checkParameterIsNotNull(error, (String)"error");
        Color color = ColorKt.Color((int)$this$assertPixelColor.getPixel(x, y));
        String errorString = (String)error.invoke((Object)color);
        Assert.assertEquals((String)errorString, (float)expected.getRed(), (float)color.getRed(), (float)0.02f);
        Assert.assertEquals((String)errorString, (float)expected.getGreen(), (float)color.getGreen(), (float)0.02f);
        Assert.assertEquals((String)errorString, (float)expected.getBlue(), (float)color.getBlue(), (float)0.02f);
        Assert.assertEquals((String)errorString, (float)expected.getAlpha(), (float)color.getAlpha(), (float)0.02f);
    }

    public static /* synthetic */ void assertPixelColor$default(@NotNull Bitmap $this$assertPixelColor_u24default, @NotNull Color expected, int x, int y, @Nullable Function1 error, int $mask0, @Nullable Object $handler) {
        Function1 function1 = ($mask0 & 8) != 0 ? (Function1)new Function1<Color, String>(x, y, expected){
            private final /* synthetic */ int $x;
            private final /* synthetic */ int $y;
            private final /* synthetic */ Color $expected;
            {
                this.$x = $x;
                this.$y = $y;
                this.$expected = $expected;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull Color color) {
                Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
                return "Pixel(" + this.$x + ", " + this.$y + ") expected to be " + this.$expected + ", but was " + color;
            }
        } : error;
        BitmapHelpersKt.assertPixelColor($this$assertPixelColor_u24default, expected, x, y, (Function1<? super Color, String>)function1);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean contains(@NotNull androidx.ui.graphics.Path $this$contains, @NotNull Offset offset) {
        void $this$asAndroidPath$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$contains, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
        Path path = new Path();
        path.addRect(offset.getDx() - 0.01f, offset.getDy() - 0.01f, offset.getDx() + 0.01f, offset.getDy() + 0.01f, Path.Direction.CW);
        androidx.ui.graphics.Path path2 = $this$contains;
        Path path3 = path;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        Path path4 = ((AndroidPath)$this$asAndroidPath$iv).getInternalPath();
        if (path3.op(path4, Path.Op.INTERSECT)) {
            return !path.isEmpty();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertShape(@NotNull Bitmap $this$assertShape, @NotNull Density density, @NotNull Shape shape, @NotNull Color shapeColor, @NotNull Color backgroundColor, @NotNull Shape backgroundShape, @NotNull Px sizeX, @NotNull Px sizeY, @NotNull Px shapeSizeX, @NotNull Px shapeSizeY, @NotNull Px centerX, @NotNull Px centerY, @NotNull Px shapeOverlapPixelCount) {
        block3: {
            int x;
            Px this_$iv;
            Px this_$iv2;
            long l;
            void val1$iv$iv;
            Px px;
            Px this_$iv3;
            Px this_$iv4;
            Px px2;
            long l2;
            void val1$iv$iv2;
            void $this$px$iv;
            void $this$px$iv32;
            Px this_$iv5;
            void this_$iv6;
            Intrinsics.checkParameterIsNotNull((Object)$this$assertShape, (String)"<this>");
            Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            Intrinsics.checkParameterIsNotNull((Object)shapeColor, (String)"shapeColor");
            Intrinsics.checkParameterIsNotNull((Object)backgroundColor, (String)"backgroundColor");
            Intrinsics.checkParameterIsNotNull((Object)backgroundShape, (String)"backgroundShape");
            Intrinsics.checkParameterIsNotNull((Object)sizeX, (String)"sizeX");
            Intrinsics.checkParameterIsNotNull((Object)sizeY, (String)"sizeY");
            Intrinsics.checkParameterIsNotNull((Object)shapeSizeX, (String)"shapeSizeX");
            Intrinsics.checkParameterIsNotNull((Object)shapeSizeY, (String)"shapeSizeY");
            Intrinsics.checkParameterIsNotNull((Object)centerX, (String)"centerX");
            Intrinsics.checkParameterIsNotNull((Object)centerY, (String)"centerY");
            Intrinsics.checkParameterIsNotNull((Object)shapeOverlapPixelCount, (String)"shapeOverlapPixelCount");
            int $this$px$iv2 = $this$assertShape.getWidth();
            Px width = new Px((float)$this$px$iv2);
            int $this$px$iv222 = $this$assertShape.getHeight();
            Px height = new Px((float)$this$px$iv222);
            Px $this$px$iv222 = centerX;
            Px px3 = sizeX;
            int other$iv = 2;
            Px other$iv2 = new Px(this_$iv6.getValue() / (float)other$iv);
            Assert.assertTrue((new Px(this_$iv5.getValue() + other$iv2.getValue()).compareTo(width) <= 0 ? 1 : 0) != 0);
            this_$iv5 = centerX;
            other$iv2 = sizeX;
            other$iv = 2;
            other$iv2 = new Px(this_$iv6.getValue() / (float)other$iv);
            boolean this_$iv22 = false;
            Px px4 = new Px(this_$iv5.getValue() - other$iv2.getValue());
            Px px5 = new Px((float)$this$px$iv32);
            Assert.assertTrue((px4.compareTo(px5) >= 0 ? 1 : 0) != 0);
            Px $this$px$iv32 = centerY;
            other$iv2 = sizeY;
            other$iv = 2;
            other$iv2 = new Px(this_$iv6.getValue() / (float)other$iv);
            Assert.assertTrue((new Px(this_$iv.getValue() + other$iv2.getValue()).compareTo(height) <= 0 ? 1 : 0) != 0);
            this_$iv = centerY;
            other$iv2 = sizeY;
            other$iv = 2;
            other$iv2 = new Px(this_$iv6.getValue() / (float)other$iv);
            boolean this_$iv32 = false;
            px4 = new Px(this_$iv.getValue() - other$iv2.getValue());
            px5 = new Px((float)$this$px$iv);
            Assert.assertTrue((px4.compareTo(px5) >= 0 ? 1 : 0) != 0);
            px4 = shape;
            float other$iv22 = shapeSizeX.getValue();
            float val2$iv$iv = shapeSizeY.getValue();
            boolean $i$f$packFloats22 = false;
            void var19_32 = val1$iv$iv2;
            boolean bl = false;
            long v1$iv$iv = Float.floatToIntBits((float)var19_32);
            float f = val2$iv$iv;
            boolean bl2 = false;
            long v2$iv$iv3 = Float.floatToIntBits(f);
            long l3 = l2 = v1$iv$iv << 32 | v2$iv$iv3 & 0xFFFFFFFFL;
            px5 = new PxSize(l3);
            Outline outline = px4.createOutline((PxSize)px5, density);
            androidx.ui.graphics.Path path = AndroidPathKt.Path();
            OutlineKt.addOutline((androidx.ui.graphics.Path)path, (Outline)outline);
            Px $i$f$packFloats22 = centerX;
            Px px6 = shapeSizeX;
            float other$iv3 = 2.0f;
            Px other$iv4 = px2 = new Px(this_$iv4.getValue() / other$iv3);
            px2 = new Px(this_$iv3.getValue() - other$iv4.getValue());
            this_$iv3 = centerY;
            other$iv4 = shapeSizeY;
            other$iv3 = 2.0f;
            float f2 = px2.getValue();
            this_$iv4 = px = new Px(this_$iv4.getValue() / other$iv3);
            px = new Px(this_$iv3.getValue() - other$iv4.getValue());
            float f3 = px.getValue();
            float f4 = f2;
            Offset shapeOffset = new Offset(f4, f3);
            androidx.ui.graphics.Path backgroundPath = AndroidPathKt.Path();
            px5 = backgroundShape;
            px4 = backgroundPath;
            float other$iv32 = sizeX.getValue();
            float val2$iv$iv22 = sizeY.getValue();
            boolean $i$f$packFloats32 = false;
            void var22_62 = val1$iv$iv;
            boolean bl3 = false;
            long v1$iv$iv2 = Float.floatToIntBits((float)var22_62);
            float f5 = val2$iv$iv22;
            int n = 0;
            long v2$iv$iv2 = Float.floatToIntBits(f5);
            long l4 = l = v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL;
            PxSize pxSize = new PxSize(l4);
            OutlineKt.addOutline((androidx.ui.graphics.Path)px4, (Outline)px5.createOutline(pxSize, density));
            Px val2$iv$iv22 = centerX;
            Px $i$f$packFloats32 = sizeX;
            int other$iv5 = 2;
            Px other$iv6 = new Px(this_$iv2.getValue() / (float)other$iv5);
            Px px7 = new Px(this_$iv.getValue() - other$iv6.getValue());
            this_$iv = centerX;
            other$iv6 = sizeX;
            other$iv5 = 2;
            px4 = px7;
            this_$iv2 = px5 = new Px(this_$iv2.getValue() / (float)other$iv5);
            px5 = new Px(this_$iv.getValue() + other$iv6.getValue());
            IntRange intRange = BitmapHelpersKt.until(px4, px5);
            int n2 = intRange.getFirst();
            int n3 = intRange.getLast();
            int n4 = intRange.getStep();
            if ((n4 <= 0 || n2 > n3) && (n4 >= 0 || n3 > n2)) break block3;
            do {
                int y;
                Px this_$iv7;
                Px this_$iv8;
                x = n2;
                n2 += n4;
                Px v2$iv$iv3 = centerY;
                Px px8 = sizeY;
                int other$iv7 = 2;
                Px other$iv8 = new Px(this_$iv8.getValue() / (float)other$iv7);
                Px px9 = new Px(this_$iv7.getValue() - other$iv8.getValue());
                this_$iv7 = centerY;
                other$iv8 = sizeY;
                other$iv7 = 2;
                px4 = px9;
                this_$iv8 = px5 = new Px(this_$iv8.getValue() / (float)other$iv7);
                px5 = new Px(this_$iv7.getValue() + other$iv8.getValue());
                IntRange intRange2 = BitmapHelpersKt.until(px4, px5);
                int n5 = intRange2.getFirst();
                int n6 = intRange2.getLast();
                n = intRange2.getStep();
                if ((n <= 0 || n5 > n6) && (n >= 0 || n6 > n5)) continue;
                do {
                    boolean isOutside;
                    y = n5;
                    n5 += n;
                    Offset point = new Offset((float)x, (float)y);
                    if (!BitmapHelpersKt.contains(backgroundPath, BitmapHelpersKt.pixelFartherFromCenter(point, sizeX, sizeY, shapeOverlapPixelCount))) continue;
                    Offset offset = point.minus(shapeOffset);
                    boolean isInside = BitmapHelpersKt.contains(path, BitmapHelpersKt.pixelFartherFromCenter(offset, shapeSizeX, shapeSizeY, shapeOverlapPixelCount));
                    boolean bl4 = isOutside = !BitmapHelpersKt.contains(path, BitmapHelpersKt.pixelCloserToCenter(offset, shapeSizeX, shapeSizeY, shapeOverlapPixelCount));
                    if (isInside) {
                        BitmapHelpersKt.assertPixelColor$default($this$assertShape, shapeColor, x, y, null, 8, null);
                        continue;
                    }
                    if (!isOutside) continue;
                    BitmapHelpersKt.assertPixelColor$default($this$assertShape, backgroundColor, x, y, null, 8, null);
                } while (y != n6);
            } while (x != n3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void assertShape$default(@NotNull Bitmap $this$assertShape_u24default, @NotNull Density density, @NotNull Shape shape, @NotNull Color shapeColor, @NotNull Color backgroundColor, @Nullable Shape backgroundShape, @Nullable Px sizeX, @Nullable Px sizeY, @Nullable Px shapeSizeX, @Nullable Px shapeSizeY, @Nullable Px centerX, @Nullable Px centerY, @Nullable Px shapeOverlapPixelCount, int $mask0, @Nullable Object $handler) {
        Px px;
        Px px2;
        Px px3;
        Px px4;
        Px px5;
        Px px6;
        Px px7;
        Px px8;
        Px px9;
        Shape shape2;
        Shape shape3 = shape2 = ($mask0 & 0x10) != 0 ? RectangleShapeKt.getRectangleShape() : backgroundShape;
        if (($mask0 & 0x20) != 0) {
            float $this$px$iv = $this$assertShape_u24default.getWidth();
            px9 = new Px($this$px$iv);
        } else {
            px9 = px8 = sizeX;
        }
        if (($mask0 & 0x40) != 0) {
            float $this$px$iv = $this$assertShape_u24default.getHeight();
            px7 = new Px($this$px$iv);
        } else {
            px7 = sizeY;
        }
        Px px10 = px7;
        Px px11 = ($mask0 & 0x80) != 0 ? px8 : shapeSizeX;
        Px px12 = px6 = ($mask0 & 0x100) != 0 ? px10 : shapeSizeY;
        if (($mask0 & 0x200) != 0) {
            void this_$iv;
            int $this$px$iv22 = $this$assertShape_u24default.getWidth();
            Px $this$px$iv22 = new Px((float)$this$px$iv22);
            float other$iv = 2.0f;
            px5 = new Px(this_$iv.getValue() / other$iv);
        } else {
            px5 = px4 = centerX;
        }
        if (($mask0 & 0x400) != 0) {
            void this_$iv;
            int $this$px$iv32 = $this$assertShape_u24default.getHeight();
            Px $this$px$iv32 = new Px((float)$this$px$iv32);
            float other$iv = 2.0f;
            px3 = new Px(this_$iv.getValue() / other$iv);
        } else {
            px3 = px2 = centerY;
        }
        if (($mask0 & 0x800) != 0) {
            boolean $this$px$iv = true;
            px = new Px((float)$this$px$iv);
        } else {
            px = shapeOverlapPixelCount;
        }
        Px px13 = px;
        BitmapHelpersKt.assertShape($this$assertShape_u24default, density, shape, shapeColor, backgroundColor, shape2, px8, px10, px11, px6, px4, px2, px13);
    }

    private static final IntRange until(Px $this$until, Px until) {
        Px $this$round$iv = $this$until;
        float f = $this$round$iv.getValue();
        boolean bl = false;
        int from = (Float.isInfinite(f) ? IntPx.Companion.getInfinity() : new IntPx(MathKt.roundToInt((float)$this$round$iv.getValue()))).getValue();
        Px $this$round$iv2 = until;
        float f2 = $this$round$iv2.getValue();
        boolean bl2 = false;
        int to = (Float.isInfinite(f2) ? IntPx.Companion.getInfinity() : new IntPx(MathKt.roundToInt((float)$this$round$iv2.getValue()))).getValue();
        if (from <= Integer.MIN_VALUE) {
            return IntRange.Companion.getEMPTY();
        }
        return new IntRange(from, to - 1);
    }

    private static final Offset pixelCloserToCenter(Offset offset, Px shapeSizeX, Px shapeSizeY, Px delta) {
        float x;
        float centerX = shapeSizeX.getValue() / 2.0f;
        float centerY = shapeSizeY.getValue() / 2.0f;
        float d = delta.getValue();
        float f = offset.getDx() > centerX ? offset.getDx() - d : (x = offset.getDx() < centerX ? offset.getDx() + d : offset.getDx());
        float y = offset.getDy() > centerY ? offset.getDy() - d : (offset.getDy() < centerY ? offset.getDy() + d : offset.getDy());
        return new Offset(x, y);
    }

    private static final Offset pixelFartherFromCenter(Offset offset, Px shapeSizeX, Px shapeSizeY, Px delta) {
        float x;
        float centerX = shapeSizeX.getValue() / 2.0f;
        float centerY = shapeSizeY.getValue() / 2.0f;
        float d = delta.getValue();
        float f = offset.getDx() > centerX ? offset.getDx() + d : (x = offset.getDx() < centerX ? offset.getDx() - d : offset.getDx());
        float y = offset.getDy() > centerY ? offset.getDy() + d : (offset.getDy() < centerY ? offset.getDy() - d : offset.getDy());
        return new Offset(x, y);
    }

    private static final Activity captureToBitmap$getActivity(Context $this$captureToBitmap_u24getActivity) {
        Context context = $this$captureToBitmap_u24getActivity;
        return context instanceof Activity ? (Activity)$this$captureToBitmap_u24getActivity : (context instanceof ContextWrapper ? BitmapHelpersKt.captureToBitmap$getActivity(((ContextWrapper)$this$captureToBitmap_u24getActivity).getBaseContext()) : (Activity)null);
    }
}

