/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.semantics.SemanticsConfiguration;
import androidx.ui.core.semantics.SemanticsConfigurationKt;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.foundation.selection.ToggleableState;
import androidx.ui.foundation.semantics.FoundationSemanticsProperties;
import androidx.ui.semantics.SemanticsActions;
import androidx.ui.semantics.SemanticsProperties;
import androidx.ui.semantics.SemanticsPropertyKey;
import androidx.ui.test.SemanticsPredicate;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u0006\u0010\f\u001a\u00020\u0006\u001a\u0006\u0010\r\u001a\u00020\u0006\u001a\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0006\u0010\u000f\u001a\u00020\u0006\u001a\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0012\u001a\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0012\u001a\u0006\u0010\u001b\u001a\u00020\u0006\u001a\u0006\u0010\u001c\u001a\u00020\u0006\u001a\u0006\u0010\u001d\u001a\u00020\u0006\u001a\u0006\u0010\u001e\u001a\u00020\u0006\u001a\u0006\u0010\u001f\u001a\u00020\u0006\u001a\u0006\u0010 \u001a\u00020\u0006\u001a\u0006\u0010!\u001a\u00020\u0006\u001a\u0006\u0010\"\u001a\u00020\u0006\u001a\u0006\u0010#\u001a\u00020\u0006\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006$"}, d2={"ancestors", "", "Landroidx/ui/core/semantics/SemanticsNode;", "getAncestors", "(Landroidx/ui/core/semantics/SemanticsNode;)Ljava/lang/Iterable;", "hasAnyAncestorThat", "Landroidx/ui/test/SemanticsPredicate;", "predicate", "hasAnyChildThat", "hasAnyDescendantThat", "hasAnySiblingThat", "hasClickAction", "hasNoClickAction", "hasNoScrollAction", "hasParentThat", "hasScrollAction", "hasSubstring", "substring", "", "ignoreCase", "", "hasTestTag", "testTag", "hasText", "text", "hasValue", "value", "isHidden", "isInMutuallyExclusiveGroup", "isNotHidden", "isOff", "isOn", "isSelectable", "isSelected", "isToggleable", "isUnselected", "ui-test_release"})
public final class FiltersKt {
    @NotNull
    public static final SemanticsPredicate isToggleable() {
        return SemanticsPredicate.Companion.keyIsDefined(FoundationSemanticsProperties.INSTANCE.getToggleableState());
    }

    @NotNull
    public static final SemanticsPredicate isOn() {
        return SemanticsPredicate.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getToggleableState(), ToggleableState.On);
    }

    @NotNull
    public static final SemanticsPredicate isOff() {
        return SemanticsPredicate.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getToggleableState(), ToggleableState.Off);
    }

    @NotNull
    public static final SemanticsPredicate isSelectable() {
        return SemanticsPredicate.Companion.keyIsDefined(FoundationSemanticsProperties.INSTANCE.getSelected());
    }

    @NotNull
    public static final SemanticsPredicate isSelected() {
        return SemanticsPredicate.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getSelected(), true);
    }

    @NotNull
    public static final SemanticsPredicate isUnselected() {
        return SemanticsPredicate.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getSelected(), false);
    }

    @NotNull
    public static final SemanticsPredicate hasClickAction() {
        return SemanticsPredicate.Companion.keyIsDefined(SemanticsActions.Companion.getOnClick());
    }

    @NotNull
    public static final SemanticsPredicate hasNoClickAction() {
        return SemanticsPredicate.Companion.keyNotDefined(SemanticsActions.Companion.getOnClick());
    }

    @NotNull
    public static final SemanticsPredicate hasScrollAction() {
        return SemanticsPredicate.Companion.keyIsDefined(SemanticsActions.Companion.getScrollTo());
    }

    @NotNull
    public static final SemanticsPredicate hasNoScrollAction() {
        return SemanticsPredicate.Companion.keyNotDefined(SemanticsActions.Companion.getScrollTo());
    }

    @NotNull
    public static final SemanticsPredicate hasText(@NotNull String text, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return new SemanticsPredicate(SemanticsProperties.INSTANCE.getAccessibilityLabel().getName() + " = '" + text + "' (ignoreCase: " + ignoreCase + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(text, ignoreCase){
            private final /* synthetic */ String $text;
            private final /* synthetic */ boolean $ignoreCase;
            {
                this.$text = $text;
                this.$ignoreCase = $ignoreCase;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                Intrinsics.checkParameterIsNotNull((Object)semanticsNode, (String)"<this>");
                return StringsKt.equals((String)((String)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)semanticsNode.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getAccessibilityLabel())), (String)this.$text, (boolean)this.$ignoreCase);
            }
        }));
    }

    public static /* synthetic */ SemanticsPredicate hasText$default(@NotNull String text, boolean ignoreCase, int $mask0, @Nullable Object $handler) {
        boolean bl = ($mask0 & 2) != 0 ? false : ignoreCase;
        return FiltersKt.hasText(text, bl);
    }

    @NotNull
    public static final SemanticsPredicate hasSubstring(@NotNull String substring, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)substring, (String)"substring");
        return new SemanticsPredicate(SemanticsProperties.INSTANCE.getAccessibilityLabel().getName() + ".contains(" + substring + ", " + ignoreCase + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(substring, ignoreCase){
            private final /* synthetic */ String $substring;
            private final /* synthetic */ boolean $ignoreCase;
            {
                this.$substring = $substring;
                this.$ignoreCase = $ignoreCase;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                Intrinsics.checkParameterIsNotNull((Object)semanticsNode, (String)"<this>");
                String string = (String)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)semanticsNode.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getAccessibilityLabel());
                Boolean bl = string == null ? (Boolean)null : Boolean.valueOf(StringsKt.contains((CharSequence)string, (CharSequence)this.$substring, (boolean)this.$ignoreCase));
                return bl == null ? false : bl;
            }
        }));
    }

    public static /* synthetic */ SemanticsPredicate hasSubstring$default(@NotNull String substring, boolean ignoreCase, int $mask0, @Nullable Object $handler) {
        boolean bl = ($mask0 & 2) != 0 ? false : ignoreCase;
        return FiltersKt.hasSubstring(substring, bl);
    }

    @NotNull
    public static final SemanticsPredicate hasValue(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return SemanticsPredicate.Companion.expectValue(SemanticsProperties.INSTANCE.getAccessibilityValue(), value);
    }

    @NotNull
    public static final SemanticsPredicate hasTestTag(@NotNull String testTag) {
        Intrinsics.checkParameterIsNotNull((Object)testTag, (String)"testTag");
        return SemanticsPredicate.Companion.expectValue(SemanticsProperties.INSTANCE.getTestTag(), testTag);
    }

    @NotNull
    public static final SemanticsPredicate isInMutuallyExclusiveGroup() {
        return SemanticsPredicate.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getInMutuallyExclusiveGroup(), true);
    }

    @NotNull
    public static final SemanticsPredicate isHidden() {
        return SemanticsPredicate.Companion.expectValue(SemanticsProperties.INSTANCE.getHidden(), true);
    }

    @NotNull
    public static final SemanticsPredicate isNotHidden() {
        return SemanticsPredicate.Companion.expectValue(SemanticsProperties.INSTANCE.getHidden(), false);
    }

    @NotNull
    public static final SemanticsPredicate hasParentThat(@NotNull SemanticsPredicate predicate) {
        Intrinsics.checkParameterIsNotNull((Object)predicate, (String)"predicate");
        return new SemanticsPredicate("hasAnyParentThat(" + predicate.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(predicate){
            private final /* synthetic */ SemanticsPredicate $predicate;
            {
                this.$predicate = $predicate;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                Boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)semanticsNode, (String)"<this>");
                SemanticsNode semanticsNode2 = semanticsNode.getParent();
                if (semanticsNode2 == null) {
                    bl = null;
                } else {
                    SemanticsNode semanticsNode3 = semanticsNode2;
                    SemanticsPredicate semanticsPredicate = this.$predicate;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    SemanticsNode $this$invoke_u24lambda_u2d0 = semanticsNode3;
                    bl = (boolean)((Boolean)semanticsPredicate.getCondition().invoke((Object)$this$invoke_u24lambda_u2d0));
                }
                Boolean bl4 = bl;
                return bl4 == null ? false : bl4;
            }
        }));
    }

    @NotNull
    public static final SemanticsPredicate hasAnyChildThat(@NotNull SemanticsPredicate predicate) {
        Intrinsics.checkParameterIsNotNull((Object)predicate, (String)"predicate");
        return new SemanticsPredicate("hasAnyChildThat(" + predicate.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(predicate){
            private final /* synthetic */ SemanticsPredicate $predicate;
            {
                this.$predicate = $predicate;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                boolean bl;
                block3: {
                    void $this$any$iv;
                    Intrinsics.checkParameterIsNotNull((Object)semanticsNode, (String)"<this>");
                    Iterable iterable = semanticsNode.getChildren();
                    SemanticsPredicate semanticsPredicate = this.$predicate;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            SemanticsNode it = (SemanticsNode)element$iv;
                            if (!((Boolean)semanticsPredicate.getCondition().invoke((Object)it)).booleanValue()) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
    }

    @NotNull
    public static final SemanticsPredicate hasAnySiblingThat(@NotNull SemanticsPredicate predicate) {
        Intrinsics.checkParameterIsNotNull((Object)predicate, (String)"predicate");
        return new SemanticsPredicate("hasAnySiblingThat(" + predicate.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(predicate){
            private final /* synthetic */ SemanticsPredicate $predicate;
            {
                this.$predicate = $predicate;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                Boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)semanticsNode, (String)"<this>");
                SemanticsNode node = semanticsNode;
                SemanticsNode semanticsNode2 = semanticsNode.getParent();
                if (semanticsNode2 == null) {
                    bl = null;
                } else {
                    boolean bl2;
                    block5: {
                        SemanticsNode semanticsNode3 = semanticsNode2;
                        SemanticsPredicate semanticsPredicate = this.$predicate;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        SemanticsNode $this$invoke_u24lambda_u2d1 = semanticsNode3;
                        Iterable $this$any$iv = $this$invoke_u24lambda_u2d1.getChildren();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                SemanticsNode it = (SemanticsNode)element$iv;
                                if (!(it.getId() != node.getId() && (Boolean)semanticsPredicate.getCondition().invoke((Object)it) != false)) continue;
                                bl2 = true;
                                break block5;
                            }
                            bl2 = false;
                        }
                    }
                    bl = bl2;
                }
                Boolean bl5 = bl;
                return bl5 == null ? false : bl5;
            }
        }));
    }

    @NotNull
    public static final SemanticsPredicate hasAnyAncestorThat(@NotNull SemanticsPredicate predicate) {
        Intrinsics.checkParameterIsNotNull((Object)predicate, (String)"predicate");
        return new SemanticsPredicate("hasAnyAncestorThat(" + predicate.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(predicate){
            private final /* synthetic */ SemanticsPredicate $predicate;
            {
                this.$predicate = $predicate;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                boolean bl;
                block3: {
                    void $this$any$iv;
                    Intrinsics.checkParameterIsNotNull((Object)semanticsNode, (String)"<this>");
                    Iterable iterable = FiltersKt.access$getAncestors$0(semanticsNode);
                    SemanticsPredicate semanticsPredicate = this.$predicate;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            SemanticsNode it = (SemanticsNode)element$iv;
                            if (!((Boolean)semanticsPredicate.getCondition().invoke((Object)it)).booleanValue()) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
    }

    @NotNull
    public static final SemanticsPredicate hasAnyDescendantThat(@NotNull SemanticsPredicate predicate) {
        Intrinsics.checkParameterIsNotNull((Object)predicate, (String)"predicate");
        return new SemanticsPredicate("hasAnyDescendantThat(" + predicate.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(predicate){
            private final /* synthetic */ SemanticsPredicate $predicate;
            {
                this.$predicate = $predicate;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                boolean bl;
                block3: {
                    void $this$any$iv;
                    Intrinsics.checkParameterIsNotNull((Object)semanticsNode, (String)"<this>");
                    Iterable iterable = semanticsNode.getChildren();
                    SemanticsPredicate semanticsPredicate = this.$predicate;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            SemanticsNode it = (SemanticsNode)element$iv;
                            if (!FiltersKt.access$hasAnyDescendantThat$checkIfSubtreeMatches$1(semanticsPredicate, it)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
    }

    private static final Iterable<SemanticsNode> getAncestors(SemanticsNode $this$ancestors) {
        return new Iterable<SemanticsNode>($this$ancestors){
            private final /* synthetic */ SemanticsNode $this$get-ancestors;
            {
                this.$this$get-ancestors = $receiver;
            }

            @NotNull
            public Iterator<SemanticsNode> iterator() {
                return new Iterator<SemanticsNode>(this.$this$get-ancestors){
                    private SemanticsNode next;
                    private final /* synthetic */ SemanticsNode $this$get-ancestors;
                    {
                        this.$this$get-ancestors = $receiver;
                        this.next = this.$this$get-ancestors.getParent();
                    }

                    @Nullable
                    public final SemanticsNode getNext() {
                        return this.next;
                    }

                    public final void setNext(@Nullable SemanticsNode semanticsNode) {
                        this.next = semanticsNode;
                    }

                    public boolean hasNext() {
                        return this.getNext() != null;
                    }

                    @NotNull
                    public SemanticsNode next() {
                        SemanticsNode semanticsNode = this.getNext();
                        if (semanticsNode == null) {
                            Intrinsics.throwNpe();
                        }
                        SemanticsNode semanticsNode2 = semanticsNode;
                        boolean bl = false;
                        boolean bl2 = false;
                        SemanticsNode it = semanticsNode2;
                        this.setNext(it.getParent());
                        return semanticsNode2;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    private static final boolean hasAnyDescendantThat$checkIfSubtreeMatches(SemanticsPredicate predicate, SemanticsNode node) {
        boolean bl;
        block4: {
            if (((Boolean)predicate.getCondition().invoke((Object)node)).booleanValue()) {
                return true;
            }
            Iterable $this$any$iv = node.getChildren();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SemanticsNode it = (SemanticsNode)element$iv;
                    if (!FiltersKt.hasAnyDescendantThat$checkIfSubtreeMatches(predicate, it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ Iterable access$getAncestors$0(SemanticsNode $receiver) {
        return FiltersKt.getAncestors($receiver);
    }

    public static final /* synthetic */ boolean access$hasAnyDescendantThat$checkIfSubtreeMatches$1(SemanticsPredicate predicate, SemanticsNode node) {
        return FiltersKt.hasAnyDescendantThat$checkIfSubtreeMatches(predicate, node);
    }
}

