/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.annotation.FloatRange;
import androidx.ui.core.gesture.ConstantsKt;
import androidx.ui.test.GestureScope;
import androidx.ui.test.InputDispatcher;
import androidx.ui.unit.Duration;
import androidx.ui.unit.Durations;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxSize;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxBounds;
import androidx.ui.unit.PxPosition;
import androidx.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\n\u001a4\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0005\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u0006\u001a\u0012\u0010\u001a\u001a\u00020\u001b*\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0005\u001a\n\u0010\u001c\u001a\u00020\u001b*\u00020\u0006\u001a\u0012\u0010\u001c\u001a\u00020\u001b*\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0005\u001a\n\u0010\u001d\u001a\u00020\u001b*\u00020\u0006\u001a\u0012\u0010\u001d\u001a\u00020\u001b*\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0005\u001a$\u0010\u001e\u001a\u00020\u001b*\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u0001\u001a\n\u0010\u001f\u001a\u00020\u001b*\u00020\u0006\u001a\n\u0010 \u001a\u00020\u001b*\u00020\u0006\u001a\n\u0010!\u001a\u00020\u001b*\u00020\u0006\u001a\n\u0010\"\u001a\u00020\u001b*\u00020\u0006\u001a.\u0010#\u001a\u00020\u001b*\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0001\u0010$\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"doubleClickDelay", "Landroidx/ui/unit/Duration;", "edgeFuzzFactor", "", "center", "Landroidx/ui/unit/PxPosition;", "Landroidx/ui/test/GestureScope;", "getCenter", "(Landroidx/ui/test/GestureScope;)Landroidx/ui/unit/PxPosition;", "globalBounds", "Landroidx/ui/unit/PxBounds;", "getGlobalBounds", "(Landroidx/ui/test/GestureScope;)Landroidx/ui/unit/PxBounds;", "size", "Landroidx/ui/unit/IntPxSize;", "getSize", "(Landroidx/ui/test/GestureScope;)Landroidx/ui/unit/IntPxSize;", "createFunctionForVelocity", "Lkotlin/Function1;", "", "duration", "start", "end", "velocity", "localToGlobal", "position", "sendClick", "", "sendDoubleClick", "sendLongClick", "sendSwipe", "sendSwipeDown", "sendSwipeLeft", "sendSwipeRight", "sendSwipeUp", "sendSwipeWithVelocity", "endVelocity", "ui-test_release"})
public final class GestureScopeKt {
    private static final float edgeFuzzFactor = 0.083f;
    private static final Duration doubleClickDelay = Durations.getMilliseconds((int)145);

    @NotNull
    public static final IntPxSize getSize(@NotNull GestureScope $this$size) {
        Intrinsics.checkParameterIsNotNull((Object)$this$size, (String)"<this>");
        GestureScope this_$iv = $this$size;
        return this_$iv.getSemanticsNodeInteraction$ui_test_release().fetchSemanticsNode("Failed to perform a gesture.").getSize();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PxPosition getCenter(@NotNull GestureScope $this$center) {
        long l;
        void val1$iv$iv$iv;
        void y$iv$iv;
        void x$iv$iv;
        void x$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$center, (String)"<this>");
        IntPxSize this_$iv = GestureScopeKt.getSize($this$center);
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackInt1 = false;
        int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
        this_$iv = new IntPx($this$ipx$iv$iv).div(2);
        IntPxSize this_$iv2 = GestureScopeKt.getSize($this$center);
        long value$iv$iv2 = this_$iv2.getValue();
        boolean $i$f$unpackInt2 = false;
        int $this$ipx$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        IntPx y$iv = new IntPx($this$ipx$iv$iv2).div(2);
        Px $this$toPx$iv$iv = x$iv;
        int $this$px$iv$iv$iv = $this$toPx$iv$iv.getValue();
        $this$toPx$iv$iv = new Px((float)$this$px$iv$iv$iv);
        IntPx $this$toPx$iv$iv2 = y$iv;
        int $this$px$iv$iv$iv22 = $this$toPx$iv$iv2.getValue();
        $this$toPx$iv$iv2 = new Px((float)$this$px$iv$iv$iv22);
        float $this$px$iv$iv$iv22 = x$iv$iv.getValue();
        float val2$iv$iv$iv = y$iv$iv.getValue();
        boolean $i$f$packFloats = false;
        void var8_13 = val1$iv$iv$iv;
        boolean bl = false;
        long v1$iv$iv$iv = Float.floatToIntBits((float)var8_13);
        float f = val2$iv$iv$iv;
        boolean bl2 = false;
        long v2$iv$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL;
        return new PxPosition(l2);
    }

    @NotNull
    public static final PxBounds getGlobalBounds(@NotNull GestureScope $this$globalBounds) {
        Intrinsics.checkParameterIsNotNull((Object)$this$globalBounds, (String)"<this>");
        GestureScope this_$iv = $this$globalBounds;
        return this_$iv.getSemanticsNodeInteraction$ui_test_release().fetchSemanticsNode("Failed to perform a gesture.").getGlobalBounds();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PxPosition localToGlobal(@NotNull GestureScope $this$localToGlobal, @NotNull PxPosition position) {
        long l;
        void val1$iv$iv$iv;
        void y$iv$iv;
        void x$iv$iv;
        void other$iv;
        void this_$iv;
        long l2;
        void val1$iv$iv;
        PxPosition x$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$localToGlobal, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        PxBounds bounds = GestureScopeKt.getGlobalBounds($this$localToGlobal);
        PxPosition pxPosition = position;
        Px px = bounds.getLeft();
        Px y$iv = bounds.getTop();
        float f = x$iv.getValue();
        float val2$iv$iv = y$iv.getValue();
        boolean $i$f$packFloats = false;
        void var9_11 = val1$iv$iv;
        int n = 0;
        long v1$iv$iv322 = Float.floatToIntBits((float)var9_11);
        float f2 = val2$iv$iv;
        boolean bl = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l3 = l2 = v1$iv$iv322 << 32 | v2$iv$iv & 0xFFFFFFFFL;
        x$iv = new PxPosition(l3);
        Px this_$iv$iv = this_$iv;
        long value$iv$iv$iv = this_$iv$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv$iv >> 32);
        int v1$iv$iv322 = 0;
        float $this$px$iv$iv$iv = Float.intBitsToFloat(n);
        this_$iv$iv = new Px($this$px$iv$iv$iv);
        Px this_$iv$iv2 = other$iv;
        long value$iv$iv$iv2 = this_$iv$iv2.getValue();
        boolean $i$f$unpackFloat12 = false;
        FloatCompanionObject floatCompanionObject2 = FloatCompanionObject.INSTANCE;
        v1$iv$iv322 = (int)(value$iv$iv$iv2 >> 32);
        int n2 = 0;
        float $this$px$iv$iv$iv2 = Float.intBitsToFloat(v1$iv$iv322);
        Px other$iv$iv = new Px($this$px$iv$iv$iv2);
        this_$iv$iv = new Px(this_$iv$iv.getValue() + other$iv$iv.getValue());
        this_$iv$iv2 = this_$iv;
        value$iv$iv$iv2 = this_$iv$iv2.getValue();
        boolean $i$f$unpackFloat2 = false;
        floatCompanionObject2 = FloatCompanionObject.INSTANCE;
        v1$iv$iv322 = (int)(value$iv$iv$iv2 & 0xFFFFFFFFL);
        n2 = 0;
        $this$px$iv$iv$iv2 = Float.intBitsToFloat(v1$iv$iv322);
        this_$iv$iv2 = new Px($this$px$iv$iv$iv2);
        void this_$iv$iv3 = other$iv;
        long value$iv$iv$iv3 = this_$iv$iv3.getValue();
        boolean $i$f$unpackFloat22 = false;
        FloatCompanionObject v1$iv$iv322 = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv$iv3 & 0xFFFFFFFFL);
        boolean bl2 = false;
        float $this$px$iv$iv$iv3 = Float.intBitsToFloat(n2);
        Px other$iv$iv22 = new Px($this$px$iv$iv$iv3);
        this_$iv$iv2 = new Px(this_$iv$iv2.getValue() + other$iv$iv22.getValue());
        float other$iv$iv22 = x$iv$iv.getValue();
        float val2$iv$iv$iv = y$iv$iv.getValue();
        boolean $i$f$packFloats2 = false;
        void var12_32 = val1$iv$iv$iv;
        bl2 = false;
        long v1$iv$iv$iv = Float.floatToIntBits((float)var12_32);
        float f3 = val2$iv$iv$iv;
        boolean bl3 = false;
        long v2$iv$iv$iv = Float.floatToIntBits(f3);
        long l4 = l = v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL;
        return new PxPosition(l4);
    }

    public static final void sendClick(@NotNull GestureScope $this$sendClick, @NotNull PxPosition position) {
        Intrinsics.checkParameterIsNotNull((Object)$this$sendClick, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        $this$sendClick.getSemanticsNodeInteraction$ui_test_release().sendInput$ui_test_release((Function1<? super InputDispatcher, Unit>)((Function1)new Function1<InputDispatcher, Unit>($this$sendClick, position){
            private final /* synthetic */ GestureScope $this$sendClick;
            private final /* synthetic */ PxPosition $position;
            {
                this.$this$sendClick = $receiver;
                this.$position = $position;
                super(1);
            }

            public final void invoke(@NotNull InputDispatcher it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.sendClick(GestureScopeKt.localToGlobal(this.$this$sendClick, this.$position));
            }
        }));
    }

    public static final void sendClick(@NotNull GestureScope $this$sendClick) {
        Intrinsics.checkParameterIsNotNull((Object)$this$sendClick, (String)"<this>");
        GestureScopeKt.sendClick($this$sendClick, GestureScopeKt.getCenter($this$sendClick));
    }

    public static final void sendLongClick(@NotNull GestureScope $this$sendLongClick, @NotNull PxPosition position) {
        Intrinsics.checkParameterIsNotNull((Object)$this$sendLongClick, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        GestureScopeKt.sendSwipe($this$sendLongClick, position, position, ConstantsKt.getLongPressTimeout().plus(Durations.getMilliseconds((int)100)));
    }

    public static final void sendLongClick(@NotNull GestureScope $this$sendLongClick) {
        Intrinsics.checkParameterIsNotNull((Object)$this$sendLongClick, (String)"<this>");
        GestureScopeKt.sendLongClick($this$sendLongClick, GestureScopeKt.getCenter($this$sendLongClick));
    }

    public static final void sendDoubleClick(@NotNull GestureScope $this$sendDoubleClick, @NotNull PxPosition position) {
        Intrinsics.checkParameterIsNotNull((Object)$this$sendDoubleClick, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        PxPosition globalPosition = GestureScopeKt.localToGlobal($this$sendDoubleClick, position);
        $this$sendDoubleClick.getSemanticsNodeInteraction$ui_test_release().sendInput$ui_test_release((Function1<? super InputDispatcher, Unit>)((Function1)new Function1<InputDispatcher, Unit>(globalPosition){
            private final /* synthetic */ PxPosition $globalPosition;
            {
                this.$globalPosition = $globalPosition;
                super(1);
            }

            public final void invoke(@NotNull InputDispatcher it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.sendClick(this.$globalPosition);
                it.delay(GestureScopeKt.access$prop$getDoubleClickDelay$0());
                it.sendClick(this.$globalPosition);
            }
        }));
    }

    public static final void sendDoubleClick(@NotNull GestureScope $this$sendDoubleClick) {
        Intrinsics.checkParameterIsNotNull((Object)$this$sendDoubleClick, (String)"<this>");
        GestureScopeKt.sendDoubleClick($this$sendDoubleClick, GestureScopeKt.getCenter($this$sendDoubleClick));
    }

    public static final void sendSwipe(@NotNull GestureScope $this$sendSwipe, @NotNull PxPosition start, @NotNull PxPosition end, @NotNull Duration duration) {
        Intrinsics.checkParameterIsNotNull((Object)$this$sendSwipe, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        PxPosition globalStart = GestureScopeKt.localToGlobal($this$sendSwipe, start);
        PxPosition globalEnd = GestureScopeKt.localToGlobal($this$sendSwipe, end);
        $this$sendSwipe.getSemanticsNodeInteraction$ui_test_release().sendInput$ui_test_release((Function1<? super InputDispatcher, Unit>)((Function1)new Function1<InputDispatcher, Unit>(globalStart, globalEnd, duration){
            private final /* synthetic */ PxPosition $globalStart;
            private final /* synthetic */ PxPosition $globalEnd;
            private final /* synthetic */ Duration $duration;
            {
                this.$globalStart = $globalStart;
                this.$globalEnd = $globalEnd;
                this.$duration = $duration;
                super(1);
            }

            public final void invoke(@NotNull InputDispatcher it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.sendSwipe(this.$globalStart, this.$globalEnd, this.$duration);
            }
        }));
    }

    public static /* synthetic */ void sendSwipe$default(@NotNull GestureScope $this$sendSwipe_u24default, @NotNull PxPosition start, @NotNull PxPosition end, @Nullable Duration duration, int $mask0, @Nullable Object $handler) {
        Duration duration2 = ($mask0 & 4) != 0 ? Durations.getMilliseconds((int)200) : duration;
        GestureScopeKt.sendSwipe($this$sendSwipe_u24default, start, end, duration2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void sendSwipeWithVelocity(@NotNull GestureScope $this$sendSwipeWithVelocity, @NotNull PxPosition start, @NotNull PxPosition end, @FloatRange(from=0.0) float endVelocity, @NotNull Duration duration) {
        PxPosition this_$iv;
        PxPosition this_$iv2;
        PxPosition delta;
        long l;
        void val1$iv$iv$iv;
        void y$iv$iv;
        void x$iv$iv;
        PxPosition this_$iv3;
        Intrinsics.checkParameterIsNotNull((Object)$this$sendSwipeWithVelocity, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        boolean bl = endVelocity >= 0.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "Velocity cannot be " + endVelocity + ", it must be positive";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = duration.compareTo(Durations.getMilliseconds((int)25)) >= 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            String string = "Duration must be at least 25ms because velocity requires at least 3 input events";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        PxPosition globalStart = GestureScopeKt.localToGlobal($this$sendSwipeWithVelocity, start);
        PxPosition globalEnd = GestureScopeKt.localToGlobal($this$sendSwipeWithVelocity, end);
        PxPosition this_$iv$iv = this_$iv3 = end;
        long value$iv$iv$iv = this_$iv$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv$iv >> 32);
        int n2 = 0;
        float $this$px$iv$iv$iv322 = Float.intBitsToFloat(n);
        this_$iv$iv = new Px($this$px$iv$iv$iv322);
        PxPosition this_$iv$iv2 = start;
        long value$iv$iv$iv2 = this_$iv$iv2.getValue();
        boolean $i$f$unpackFloat12 = false;
        FloatCompanionObject floatCompanionObject2 = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv$iv2 >> 32);
        int $this$px$iv$iv$iv322 = 0;
        float $this$px$iv$iv$iv = Float.intBitsToFloat(n2);
        Px other$iv$iv = new Px($this$px$iv$iv$iv);
        this_$iv$iv = new Px(this_$iv$iv.getValue() - other$iv$iv.getValue());
        this_$iv$iv2 = this_$iv3;
        value$iv$iv$iv2 = this_$iv$iv2.getValue();
        boolean $i$f$unpackFloat32 = false;
        floatCompanionObject2 = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv$iv2 & 0xFFFFFFFFL);
        $this$px$iv$iv$iv322 = 0;
        $this$px$iv$iv$iv = Float.intBitsToFloat(n2);
        this_$iv$iv2 = new Px($this$px$iv$iv$iv);
        PxPosition this_$iv$iv3 = start;
        long value$iv$iv$iv3 = this_$iv$iv3.getValue();
        int $i$f$unpackFloat42 = 0;
        FloatCompanionObject floatCompanionObject3 = FloatCompanionObject.INSTANCE;
        $this$px$iv$iv$iv322 = (int)(value$iv$iv$iv3 & 0xFFFFFFFFL);
        int n3 = 0;
        float $this$px$iv$iv$iv2 = Float.intBitsToFloat($this$px$iv$iv$iv322);
        Px other$iv$iv22 = new Px($this$px$iv$iv$iv2);
        this_$iv$iv2 = new Px(this_$iv$iv2.getValue() - other$iv$iv22.getValue());
        float other$iv$iv22 = x$iv$iv.getValue();
        float val2$iv$iv$iv = y$iv$iv.getValue();
        int $i$f$packFloats = 0;
        void $this$px$iv$iv$iv322 = val1$iv$iv$iv;
        n3 = 0;
        long v1$iv$iv$iv = Float.floatToIntBits((float)$this$px$iv$iv$iv322);
        float f = val2$iv$iv$iv;
        boolean bl4 = false;
        long v2$iv$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL;
        PxPosition this_$iv222 = delta = new PxPosition(l2);
        long value$iv$iv = this_$iv222.getValue();
        boolean $i$f$unpackFloat2 = false;
        FloatCompanionObject $i$f$unpackFloat32 = FloatCompanionObject.INSTANCE;
        $i$f$unpackFloat42 = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$packFloats = 0;
        float $this$px$iv$iv22 = Float.intBitsToFloat($i$f$unpackFloat42);
        float this_$iv222 = new Px($this$px$iv$iv22).getValue();
        PxPosition this_$iv422 = delta;
        long value$iv$iv22 = this_$iv422.getValue();
        $i$f$unpackFloat1 = false;
        FloatCompanionObject $i$f$unpackFloat42 = FloatCompanionObject.INSTANCE;
        $i$f$packFloats = (int)(value$iv$iv22 >> 32);
        boolean $this$px$iv$iv22 = false;
        float $this$px$iv$iv = Float.intBitsToFloat($i$f$packFloats);
        float this_$iv422 = new Px($this$px$iv$iv).getValue();
        boolean value$iv$iv22 = false;
        float theta = (float)Math.atan2(this_$iv222, this_$iv422);
        boolean this_$iv422 = false;
        float vx = (float)Math.cos(theta) * endVelocity / (float)1000;
        value$iv$iv22 = false;
        float vy = (float)Math.sin(theta) * endVelocity / (float)1000;
        long durationMs = Durations.inMilliseconds((Duration)duration);
        $i$f$unpackFloat42 = globalStart;
        long l3 = durationMs;
        long value$iv$iv3 = this_$iv2.getValue();
        boolean $i$f$unpackFloat13 = false;
        FloatCompanionObject value$iv$iv$iv22 = FloatCompanionObject.INSTANCE;
        int n4 = (int)(value$iv$iv3 >> 32);
        n3 = 0;
        float $this$px$iv$iv3 = Float.intBitsToFloat(n4);
        Px px = new Px($this$px$iv$iv3);
        this_$iv2 = globalEnd;
        float f2 = px.getValue();
        value$iv$iv3 = this_$iv2.getValue();
        $i$f$unpackFloat13 = false;
        value$iv$iv$iv22 = FloatCompanionObject.INSTANCE;
        n4 = (int)(value$iv$iv3 >> 32);
        n3 = 0;
        $this$px$iv$iv3 = Float.intBitsToFloat(n4);
        Px px2 = new Px($this$px$iv$iv3);
        Function1<Long, Float> fx = GestureScopeKt.createFunctionForVelocity(l3, f2, px2.getValue(), vx);
        PxPosition value$iv$iv32 = globalStart;
        l3 = durationMs;
        long value$iv$iv4 = this_$iv.getValue();
        boolean $i$f$unpackFloat22 = false;
        FloatCompanionObject floatCompanionObject4 = FloatCompanionObject.INSTANCE;
        n3 = (int)(value$iv$iv4 & 0xFFFFFFFFL);
        boolean bl5 = false;
        float $this$px$iv$iv4 = Float.intBitsToFloat(n3);
        Px px3 = new Px($this$px$iv$iv4);
        this_$iv = globalEnd;
        float f3 = px3.getValue();
        value$iv$iv4 = this_$iv.getValue();
        $i$f$unpackFloat22 = false;
        floatCompanionObject4 = FloatCompanionObject.INSTANCE;
        n3 = (int)(value$iv$iv4 & 0xFFFFFFFFL);
        bl5 = false;
        $this$px$iv$iv4 = Float.intBitsToFloat(n3);
        px2 = new Px($this$px$iv$iv4);
        Function1<Long, Float> fy = GestureScopeKt.createFunctionForVelocity(l3, f3, px2.getValue(), vy);
        $this$sendSwipeWithVelocity.getSemanticsNodeInteraction$ui_test_release().sendInput$ui_test_release((Function1<? super InputDispatcher, Unit>)((Function1)new Function1<InputDispatcher, Unit>(duration, fx, fy){
            private final /* synthetic */ Duration $duration;
            private final /* synthetic */ Function1<Long, Float> $fx;
            private final /* synthetic */ Function1<Long, Float> $fy;
            {
                this.$duration = $duration;
                this.$fx = $fx;
                this.$fy = $fy;
                super(1);
            }

            public final void invoke(@NotNull InputDispatcher it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                InputDispatcher.DefaultImpls.sendSwipe$default(it, (Function1)new Function1<Long, PxPosition>(this.$fx, this.$fy){
                    private final /* synthetic */ Function1<Long, Float> $fx;
                    private final /* synthetic */ Function1<Long, Float> $fy;
                    {
                        this.$fx = $fx;
                        this.$fy = $fy;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final PxPosition invoke(long t) {
                        long l;
                        void val1$iv$iv;
                        void y$iv;
                        void x$iv;
                        float $this$px$iv22 = ((Number)this.$fx.invoke((Object)t)).floatValue();
                        Px $this$px$iv22 = new Px($this$px$iv22);
                        float $this$px$iv32 = ((Number)this.$fy.invoke((Object)t)).floatValue();
                        Px $this$px$iv32 = new Px($this$px$iv32);
                        float f = x$iv.getValue();
                        float val2$iv$iv = y$iv.getValue();
                        boolean $i$f$packFloats = false;
                        void var8_9 = val1$iv$iv;
                        boolean bl = false;
                        long v1$iv$iv = Float.floatToIntBits((float)var8_9);
                        float f2 = val2$iv$iv;
                        boolean bl2 = false;
                        long v2$iv$iv = Float.floatToIntBits(f2);
                        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
                        return new PxPosition(l2);
                    }
                }, this.$duration, null, 4, null);
            }
        }));
    }

    public static /* synthetic */ void sendSwipeWithVelocity$default(@NotNull GestureScope $this$sendSwipeWithVelocity_u24default, @NotNull PxPosition start, @NotNull PxPosition end, @FloatRange(from=0.0) float endVelocity, @Nullable Duration duration, int $mask0, @Nullable Object $handler) {
        Duration duration2 = ($mask0 & 8) != 0 ? Durations.getMilliseconds((int)200) : duration;
        GestureScopeKt.sendSwipeWithVelocity($this$sendSwipeWithVelocity_u24default, start, end, endVelocity, duration2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void sendSwipeUp(@NotNull GestureScope $this$sendSwipeUp) {
        long l;
        float val1$iv$iv;
        void y$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$sendSwipeUp, (String)"<this>");
        PxPosition this_$iv = GestureScopeKt.getCenter($this$sendSwipeUp);
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv >> 32);
        boolean bl = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n);
        Px x = new Px($this$px$iv$iv);
        IntPxSize this_$iv2 = GestureScopeKt.getSize($this$sendSwipeUp);
        long value$iv$iv2 = this_$iv2.getValue();
        boolean $i$f$unpackInt2 = false;
        int $this$ipx$iv$iv = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        IntPx y0 = new IntPx($this$ipx$iv$iv).times(0.917f);
        boolean $this$px$iv = false;
        Px y1 = new Px((float)$this$px$iv);
        IntPx $this$toPx$iv = y0;
        int $this$px$iv$iv22 = $this$toPx$iv.getValue();
        $this$toPx$iv = new Px((float)$this$px$iv$iv22);
        float $this$px$iv$iv22 = x.getValue();
        float val2$iv$iv = y$iv.getValue();
        boolean $i$f$packFloats = false;
        float f = val1$iv$iv;
        boolean bl2 = false;
        long v1$iv$iv = Float.floatToIntBits(f);
        float f2 = val2$iv$iv;
        boolean bl3 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxPosition start = new PxPosition(l2);
        val1$iv$iv = x.getValue();
        val2$iv$iv = y1.getValue();
        $i$f$packFloats = false;
        f = val1$iv$iv;
        bl2 = false;
        v1$iv$iv = Float.floatToIntBits(f);
        f2 = val2$iv$iv;
        bl3 = false;
        v2$iv$iv = Float.floatToIntBits(f2);
        l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxPosition end = new PxPosition(l2);
        GestureScopeKt.sendSwipe($this$sendSwipeUp, start, end, Durations.getMilliseconds((int)200));
    }

    /*
     * WARNING - void declaration
     */
    public static final void sendSwipeDown(@NotNull GestureScope $this$sendSwipeDown) {
        long l;
        void val1$iv$iv;
        void y$iv;
        long l2;
        void val1$iv$iv2;
        void y$iv2;
        Intrinsics.checkParameterIsNotNull((Object)$this$sendSwipeDown, (String)"<this>");
        PxPosition this_$iv = GestureScopeKt.getCenter($this$sendSwipeDown);
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv >> 32);
        boolean bl = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n);
        Px x = new Px($this$px$iv$iv);
        IntPxSize this_$iv2 = GestureScopeKt.getSize($this$sendSwipeDown);
        long value$iv$iv2 = this_$iv2.getValue();
        boolean $i$f$unpackInt2 = false;
        int $this$ipx$iv$iv = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        IntPx y0 = new IntPx($this$ipx$iv$iv).times(0.083f);
        IntPxSize this_$iv3 = GestureScopeKt.getSize($this$sendSwipeDown);
        long value$iv$iv3 = this_$iv3.getValue();
        boolean $i$f$unpackInt22 = false;
        int $this$ipx$iv$iv2 = (int)(value$iv$iv3 & 0xFFFFFFFFL);
        IntPx y1 = new IntPx($this$ipx$iv$iv2);
        IntPx $this$toPx$iv = y0;
        int $this$px$iv$iv22 = $this$toPx$iv.getValue();
        $this$toPx$iv = new Px((float)$this$px$iv$iv22);
        float $this$px$iv$iv22 = x.getValue();
        float val2$iv$iv = y$iv2.getValue();
        boolean $i$f$packFloats = false;
        $this$px$iv$iv = val1$iv$iv2;
        boolean bl2 = false;
        long v1$iv$iv = Float.floatToIntBits($this$px$iv$iv);
        float f = val2$iv$iv;
        boolean bl3 = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l3 = l2 = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxPosition start = new PxPosition(l3);
        IntPx $this$toPx$iv2 = y1;
        int $this$px$iv$iv32 = $this$toPx$iv2.getValue();
        $this$toPx$iv2 = new Px((float)$this$px$iv$iv32);
        float $this$px$iv$iv32 = x.getValue();
        float val2$iv$iv2 = y$iv.getValue();
        boolean $i$f$packFloats2 = false;
        void var10_23 = val1$iv$iv;
        boolean bl4 = false;
        long v1$iv$iv2 = Float.floatToIntBits((float)var10_23);
        float f2 = val2$iv$iv2;
        boolean bl5 = false;
        long v2$iv$iv2 = Float.floatToIntBits(f2);
        long l4 = l = v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL;
        PxPosition end = new PxPosition(l4);
        GestureScopeKt.sendSwipe($this$sendSwipeDown, start, end, Durations.getMilliseconds((int)200));
    }

    /*
     * WARNING - void declaration
     */
    public static final void sendSwipeLeft(@NotNull GestureScope $this$sendSwipeLeft) {
        long l;
        float val1$iv$iv;
        void x$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$sendSwipeLeft, (String)"<this>");
        IntPxSize this_$iv = GestureScopeKt.getSize($this$sendSwipeLeft);
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackInt1 = false;
        int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
        IntPx x0 = new IntPx($this$ipx$iv$iv).times(0.917f);
        boolean $this$px$iv = false;
        Px x1 = new Px((float)$this$px$iv);
        PxPosition this_$iv2 = GestureScopeKt.getCenter($this$sendSwipeLeft);
        long value$iv$iv2 = this_$iv2.getValue();
        boolean $i$f$unpackFloat2 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean bl = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n);
        Px y = new Px($this$px$iv$iv);
        IntPx $this$toPx$iv = x0;
        int $this$px$iv$iv22 = $this$toPx$iv.getValue();
        $this$toPx$iv = new Px((float)$this$px$iv$iv22);
        float $this$px$iv$iv22 = x$iv.getValue();
        float val2$iv$iv = y.getValue();
        boolean $i$f$packFloats = false;
        float f = val1$iv$iv;
        bl = false;
        long v1$iv$iv = Float.floatToIntBits(f);
        float f2 = val2$iv$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxPosition start = new PxPosition(l2);
        val1$iv$iv = x1.getValue();
        val2$iv$iv = y.getValue();
        $i$f$packFloats = false;
        f = val1$iv$iv;
        bl = false;
        v1$iv$iv = Float.floatToIntBits(f);
        f2 = val2$iv$iv;
        bl2 = false;
        v2$iv$iv = Float.floatToIntBits(f2);
        l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxPosition end = new PxPosition(l2);
        GestureScopeKt.sendSwipe($this$sendSwipeLeft, start, end, Durations.getMilliseconds((int)200));
    }

    /*
     * WARNING - void declaration
     */
    public static final void sendSwipeRight(@NotNull GestureScope $this$sendSwipeRight) {
        long l;
        void val1$iv$iv;
        void x$iv;
        long l2;
        void val1$iv$iv2;
        void x$iv2;
        Intrinsics.checkParameterIsNotNull((Object)$this$sendSwipeRight, (String)"<this>");
        IntPxSize this_$iv = GestureScopeKt.getSize($this$sendSwipeRight);
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackInt1 = false;
        int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
        IntPx x0 = new IntPx($this$ipx$iv$iv).times(0.083f);
        IntPxSize this_$iv2 = GestureScopeKt.getSize($this$sendSwipeRight);
        long value$iv$iv2 = this_$iv2.getValue();
        boolean $i$f$unpackInt12 = false;
        int $this$ipx$iv$iv2 = (int)(value$iv$iv2 >> 32);
        IntPx x1 = new IntPx($this$ipx$iv$iv2);
        PxPosition this_$iv3 = GestureScopeKt.getCenter($this$sendSwipeRight);
        long value$iv$iv3 = this_$iv3.getValue();
        boolean $i$f$unpackFloat2 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv3 & 0xFFFFFFFFL);
        boolean bl = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n);
        Px y = new Px($this$px$iv$iv);
        IntPx $this$toPx$iv = x0;
        int $this$px$iv$iv22 = $this$toPx$iv.getValue();
        $this$toPx$iv = new Px((float)$this$px$iv$iv22);
        float $this$px$iv$iv22 = x$iv2.getValue();
        float val2$iv$iv = y.getValue();
        boolean $i$f$packFloats = false;
        void var9_21 = val1$iv$iv2;
        bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var9_21);
        float f = val2$iv$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l3 = l2 = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxPosition start = new PxPosition(l3);
        IntPx $this$toPx$iv2 = x1;
        int $this$px$iv$iv32 = $this$toPx$iv2.getValue();
        $this$toPx$iv2 = new Px((float)$this$px$iv$iv32);
        float $this$px$iv$iv32 = x$iv.getValue();
        float val2$iv$iv2 = y.getValue();
        boolean $i$f$packFloats2 = false;
        void var10_24 = val1$iv$iv;
        boolean bl3 = false;
        long v1$iv$iv2 = Float.floatToIntBits((float)var10_24);
        float f2 = val2$iv$iv2;
        boolean bl4 = false;
        long v2$iv$iv2 = Float.floatToIntBits(f2);
        long l4 = l = v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL;
        PxPosition end = new PxPosition(l4);
        GestureScopeKt.sendSwipe($this$sendSwipeRight, start, end, Durations.getMilliseconds((int)200));
    }

    private static final Function1<Long, Float> createFunctionForVelocity(long duration, float start, float end, float velocity) {
        float a = (start - end + velocity * (float)duration) / (float)(duration * duration);
        Function1 function2 = (Function1)new Function1<Long, Float>(duration, a, velocity, end){
            private final /* synthetic */ long $duration;
            private final /* synthetic */ float $a;
            private final /* synthetic */ float $velocity;
            private final /* synthetic */ float $end;
            {
                this.$duration = $duration;
                this.$a = $a;
                this.$velocity = $velocity;
                this.$end = $end;
                super(1);
            }

            public final float invoke(long t) {
                long tMinusDuration = t - this.$duration;
                return this.$a * (float)tMinusDuration * (float)tMinusDuration + this.$velocity * (float)tMinusDuration + this.$end;
            }
        };
        float f = ((Number)function2.invoke((Object)1L)).floatValue() - start;
        boolean bl = false;
        float f2 = Math.signum(f);
        f = end - start;
        float f3 = f2;
        bl = false;
        float f4 = Math.signum(f);
        if (f3 == f4) {
            return function2;
        }
        long cutOffTime = duration - (long)100;
        float cutOffValue = ((Number)function2.invoke((Object)cutOffTime)).floatValue();
        float f5 = cutOffValue - start;
        boolean bl2 = false;
        float f6 = Math.signum(f5);
        f5 = end - start;
        f3 = f6;
        bl2 = false;
        f4 = Math.signum(f5);
        boolean bl3 = f3 == f4;
        bl2 = false;
        boolean bl4 = false;
        if (!bl3) {
            String string = "Creating a gesture between " + start + " and " + end + " with a duration of " + duration + " and a resulting velocity of " + velocity + " results in a movement that goes outside of the range [" + start + ".." + end + "]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (Function1)new Function1<Long, Float>(cutOffTime, start, cutOffValue, function2){
            private final /* synthetic */ long $cutOffTime;
            private final /* synthetic */ float $start;
            private final /* synthetic */ float $cutOffValue;
            private final /* synthetic */ Function1<Long, Float> $function;
            {
                this.$cutOffTime = $cutOffTime;
                this.$start = $start;
                this.$cutOffValue = $cutOffValue;
                this.$function = $function;
                super(1);
            }

            public final float invoke(long t) {
                return t < this.$cutOffTime ? MathHelpersKt.lerp((float)this.$start, (float)this.$cutOffValue, (float)((float)t / (float)this.$cutOffTime)) : ((Number)this.$function.invoke((Object)t)).floatValue();
            }
        };
    }

    public static final /* synthetic */ Duration access$prop$getDoubleClickDelay$0() {
        return doubleClickDelay;
    }
}

