/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.activity.ComponentActivity;
import androidx.annotation.RequiresApi;
import androidx.compose.Composable;
import androidx.compose.Composer;
import androidx.compose.ComposerKt;
import androidx.compose.ComposerValidator;
import androidx.compose.Composition;
import androidx.compose.ScopeUpdateScope;
import androidx.test.rule.ActivityTestRule;
import androidx.ui.animation.TransitionKt;
import androidx.ui.core.AndroidOwner;
import androidx.ui.core.WrapperKt;
import androidx.ui.geometry.Rect;
import androidx.ui.test.AnimationClockTestRule;
import androidx.ui.test.ComposeTestCase;
import androidx.ui.test.ComposeTestCaseSetup;
import androidx.ui.test.ComposeTestRule;
import androidx.ui.test.SynchronizationKt;
import androidx.ui.test.android.AndroidComposeTestCaseSetup;
import androidx.ui.test.android.AndroidComposeTestRule;
import androidx.ui.test.android.AndroidOwnerRegistry;
import androidx.ui.test.android.ComposeIdlingResourceKt;
import androidx.ui.test.android.SynchronizedTreeCollector;
import androidx.ui.test.android.WindowCaptureKt;
import androidx.ui.unit.Density;
import androidx.ui.unit.DensityKt;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u000212B\u0018\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020#H\u0017J \u0010$\u001a\u00020%2\u0011\u0010&\u001a\r\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\u0002\b'H\u0016\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.H\u0002J \u0010/\u001a\u00020\u001a2\u0011\u0010&\u001a\r\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\u0002\b'H\u0016\u00a2\u0006\u0002\u00100R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Landroidx/ui/test/android/AndroidComposeTestRule;", "T", "Landroidx/activity/ComponentActivity;", "Landroidx/ui/test/ComposeTestRule;", "activityClass", "Ljava/lang/Class;", "disableTransitions", "", "activityTestRule", "Landroidx/test/rule/ActivityTestRule;", "getActivityTestRule", "()Landroidx/test/rule/ActivityTestRule;", "clockTestRule", "Landroidx/ui/test/AnimationClockTestRule;", "getClockTestRule", "()Landroidx/ui/test/AnimationClockTestRule;", "density", "Landroidx/ui/unit/Density;", "getDensity", "()Landroidx/ui/unit/Density;", "displayMetrics", "Landroid/util/DisplayMetrics;", "getDisplayMetrics", "()Landroid/util/DisplayMetrics;", "disposeContentHook", "Lkotlin/Function0;", "", "handler", "Landroid/os/Handler;", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "captureScreenOnIdle", "Landroid/graphics/Bitmap;", "forGivenContent", "Landroidx/ui/test/ComposeTestCaseSetup;", "composable", "Landroidx/compose/Composable;", "(Lkotlin/jvm/functions/Function1;)Landroidx/ui/test/ComposeTestCaseSetup;", "forGivenTestCase", "testCase", "Landroidx/ui/test/ComposeTestCase;", "onAndroidOwnerCreated", "owner", "Landroidx/ui/core/AndroidOwner;", "setContent", "(Lkotlin/jvm/functions/Function1;)V", "AndroidComposeStatement", "OwnerAttachedListener", "ui-test_release"})
public final class AndroidComposeTestRule<T extends ComponentActivity>
implements ComposeTestRule {
    private final boolean disableTransitions;
    private final ActivityTestRule<T> activityTestRule;
    private final AnimationClockTestRule clockTestRule;
    private final Handler handler;
    private Function0<Unit> disposeContentHook;

    public AndroidComposeTestRule(@NotNull Class<T> activityClass, boolean disableTransitions) {
        Intrinsics.checkParameterIsNotNull(activityClass, (String)"activityClass");
        this.disableTransitions = disableTransitions;
        this.activityTestRule = new ActivityTestRule(activityClass);
        this.clockTestRule = new AnimationClockTestRule();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public /* synthetic */ AndroidComposeTestRule(Class activityClass, boolean disableTransitions, int $mask0, DefaultConstructorMarker $marker) {
        boolean bl = ($mask0 & 2) != 0 ? false : disableTransitions;
        this(activityClass, bl);
    }

    @NotNull
    public final ActivityTestRule<T> getActivityTestRule() {
        return this.activityTestRule;
    }

    @Override
    @NotNull
    public AnimationClockTestRule getClockTestRule() {
        return this.clockTestRule;
    }

    @Override
    @NotNull
    public Density getDensity() {
        return DensityKt.Density((Context)((Context)((ComponentActivity)this.getActivityTestRule().getActivity())));
    }

    @Override
    @NotNull
    public DisplayMetrics getDisplayMetrics() {
        return ((ComponentActivity)this.getActivityTestRule().getActivity()).getResources().getDisplayMetrics();
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @Nullable Description description) {
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Statement activityTestRuleStatement = this.getActivityTestRule().apply(base, description);
        AndroidComposeStatement composeTestRuleStatement = new AndroidComposeStatement(activityTestRuleStatement);
        return this.getClockTestRule().apply(composeTestRuleStatement, description);
    }

    @Override
    public void setContent(@NotNull Function1<? super Composer<N>, Unit> composable) {
        Intrinsics.checkParameterIsNotNull(composable, (String)"composable");
        boolean bl = this.disposeContentHook == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "Cannot call setContent twice per test!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        CountDownLatch drawLatch = new CountDownLatch(1);
        ViewTreeObserver.OnGlobalLayoutListener listener2 = new ViewTreeObserver.OnGlobalLayoutListener(drawLatch, this){
            private final /* synthetic */ CountDownLatch $drawLatch;
            private final /* synthetic */ AndroidComposeTestRule<T> $this$setContent;
            {
                this.$drawLatch = $drawLatch;
                this.$this$setContent = $receiver;
            }

            public void onGlobalLayout() {
                this.$drawLatch.countDown();
                ViewGroup contentViewGroup = (ViewGroup)((ComponentActivity)this.$this$setContent.getActivityTestRule().getActivity()).findViewById(0x1020002);
                contentViewGroup.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        };
        Runnable runnable2 = new Runnable(this, composable, listener2){
            private final /* synthetic */ AndroidComposeTestRule<T> $this$setContent;
            private final /* synthetic */ Function1<Composer<N>, Unit> $composable;
            private final /* synthetic */ setContent.listener.1 $listener;
            {
                this.$this$setContent = $receiver;
                this.$composable = $composable;
                this.$listener = $listener;
            }

            public void run() {
                Composition composition = WrapperKt.setContent((ComponentActivity)((ComponentActivity)this.$this$setContent.getActivityTestRule().getActivity()), this.$composable);
                ViewGroup contentViewGroup = (ViewGroup)((ComponentActivity)this.$this$setContent.getActivityTestRule().getActivity()).findViewById(0x1020002);
                contentViewGroup.getChildAt(0).restoreHierarchyState(new SparseArray());
                contentViewGroup.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.$listener);
                AndroidComposeTestRule.access$prop$setDisposeContentHook$0(this.$this$setContent, (Function0)new Function0<Unit>(composition){
                    private final /* synthetic */ Composition $composition;
                    {
                        this.$composition = $composition;
                        super(0);
                    }

                    public final void invoke() {
                        this.$composition.dispose();
                    }
                });
            }
        };
        this.getActivityTestRule().runOnUiThread(runnable2);
        drawLatch.await(1L, TimeUnit.SECONDS);
    }

    @Override
    @NotNull
    public ComposeTestCaseSetup forGivenContent(@NotNull Function1<? super Composer<N>, Unit> composable) {
        Intrinsics.checkParameterIsNotNull(composable, (String)"composable");
        ComposeTestCase testCase2 = new ComposeTestCase(composable){
            private final /* synthetic */ Function1<Composer<N>, Unit> $composable;
            {
                this.$composable = $composable;
            }

            /*
             * WARNING - void declaration
             */
            @Composable
            public void emitContent(@Nullable Composer<N> $composer) {
                block2: {
                    void this_$iv;
                    $composer.startRestartGroup(-802665094);
                    ScopeUpdateScope scopeUpdateScope = $composer;
                    Object object = this.$composable;
                    ScopeUpdateScope scopeUpdateScope2 = $composer;
                    Integer key$iv = 1778170809;
                    this_$iv.startGroup((Object)key$iv);
                    ComposerValidator $this$emitContent_u24lambda_u2d0 = (ComposerValidator)this_$iv;
                    if ($this$emitContent_u24lambda_u2d0.changed(object) || !this_$iv.getSkipping()) {
                        this_$iv.startGroup((Object)ComposerKt.getInvocation());
                        object.invoke(scopeUpdateScope);
                        this_$iv.endGroup();
                    } else {
                        this_$iv.skipCurrentGroup();
                    }
                    this_$iv.endGroup();
                    scopeUpdateScope = $composer.endRestartGroup();
                    object = this;
                    if (scopeUpdateScope == null) break block2;
                    scopeUpdateScope.updateScope((Function1)new Function1<Composer<?>, Unit>(object, this.$composable){
                        private final /* synthetic */ forGivenContent.testCase.1 $tmp1_rcvr;
                        private final /* synthetic */ Function1<Composer<N>, Unit> $composable;
                        {
                            this.$tmp1_rcvr = $tmp1_rcvr;
                            this.$composable = $composable;
                            super(1);
                        }

                        public final void invoke(@Nullable Composer<N> $composer) {
                            this.$tmp1_rcvr.emitContent($composer);
                        }
                    });
                }
            }

            @Composable
            public /* synthetic */ void emitContent() {
                throw new NotImplementedError("Composable functions cannot be called without a composer. If you are getting this error, it is likely because of a misconfigured compiler");
            }
        };
        return new AndroidComposeTestCaseSetup(testCase2, (ComponentActivity)this.getActivityTestRule().getActivity());
    }

    @Override
    @NotNull
    public ComposeTestCaseSetup forGivenTestCase(@NotNull ComposeTestCase testCase2) {
        Intrinsics.checkParameterIsNotNull((Object)testCase2, (String)"testCase");
        return new AndroidComposeTestCaseSetup(testCase2, (ComponentActivity)this.getActivityTestRule().getActivity());
    }

    @Override
    @RequiresApi(value=26)
    @NotNull
    public Bitmap captureScreenOnIdle() {
        SynchronizedTreeCollector.INSTANCE.waitForIdle$ui_test_release();
        ViewGroup contentView = (ViewGroup)((ComponentActivity)this.getActivityTestRule().getActivity()).findViewById(0x1020002);
        Rect screenRect = Rect.Companion.fromLTWH(0.0f, 0.0f, (float)contentView.getWidth(), (float)contentView.getHeight());
        return WindowCaptureKt.captureRegionToBitmap(screenRect, this.handler, ((ComponentActivity)this.getActivityTestRule().getActivity()).getWindow());
    }

    private final void onAndroidOwnerCreated(AndroidOwner owner) {
        owner.getView().addOnAttachStateChangeListener((View.OnAttachStateChangeListener)new OwnerAttachedListener(owner));
    }

    public static final /* synthetic */ void access$prop$setDisposeContentHook$0(AndroidComposeTestRule $this, Function0 value) {
        $this.disposeContentHook = value;
    }

    public static final /* synthetic */ void access$onAndroidOwnerCreated$2(AndroidComposeTestRule $this, AndroidOwner owner) {
        $this.onAndroidOwnerCreated(owner);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0001J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/ui/test/android/AndroidComposeTestRule$AndroidComposeStatement;", "Lorg/junit/runners/model/Statement;", "base", "afterEvaluate", "", "beforeEvaluate", "evaluate", "ui-test_release"})
    public final class AndroidComposeStatement
    extends Statement {
        private final Statement base;

        public AndroidComposeStatement(Statement base) {
            Intrinsics.checkParameterIsNotNull((Object)AndroidComposeTestRule.this, (String)"$outer");
            Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
            this.base = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() {
            this.beforeEvaluate();
            try {
                this.base.evaluate();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this.afterEvaluate();
            }
        }

        private final void beforeEvaluate() {
            TransitionKt.setTransitionsEnabled((!AndroidComposeTestRule.this.disableTransitions ? 1 : 0) != 0);
            AndroidOwner.Companion.setOnAndroidOwnerCreatedCallback((Function1)new Function1<AndroidOwner, Unit>(AndroidComposeTestRule.this){

                public final void invoke(@NotNull AndroidOwner p0) {
                    Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
                    AndroidComposeTestRule.access$onAndroidOwnerCreated$2((AndroidComposeTestRule)this.receiver, p0);
                }

                @NotNull
                public final /* synthetic */ String getSignature() {
                    return "onAndroidOwnerCreated(Landroidx/ui/core/AndroidOwner;)V";
                }

                @NotNull
                public final /* synthetic */ String getName() {
                    return "onAndroidOwnerCreated";
                }

                @NotNull
                public final /* synthetic */ KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(AndroidComposeTestRule.class);
                }
            });
            ComposeIdlingResourceKt.registerComposeWithEspresso();
        }

        private final void afterEvaluate() {
            block0: {
                TransitionKt.setTransitionsEnabled((boolean)true);
                AndroidOwner.Companion.setOnAndroidOwnerCreatedCallback((Function1)null);
                if (AndroidComposeTestRule.this.disposeContentHook == null) break block0;
                SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(AndroidComposeTestRule.this){
                    private final /* synthetic */ AndroidComposeTestRule<T> $this$AndroidComposeTestRule;
                    {
                        this.$this$AndroidComposeTestRule = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        try {
                            Function0 function0 = AndroidComposeTestRule.access$prop$getDisposeContentHook$3(this.$this$AndroidComposeTestRule);
                            if (function0 == null) {
                                Intrinsics.throwNpe();
                            }
                            function0.invoke();
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            Unit unit = Unit.INSTANCE;
                        }
                        AndroidComposeTestRule.access$prop$setDisposeContentHook$0(this.$this$AndroidComposeTestRule, null);
                    }
                });
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/ui/test/android/AndroidComposeTestRule$OwnerAttachedListener;", "Landroid/view/View$OnAttachStateChangeListener;", "owner", "Landroidx/ui/core/AndroidOwner;", "onViewAttachedToWindow", "", "view", "Landroid/view/View;", "onViewDetachedFromWindow", "ui-test_release"})
    private static final class OwnerAttachedListener
    implements View.OnAttachStateChangeListener {
        private final AndroidOwner owner;

        public OwnerAttachedListener(@NotNull AndroidOwner owner) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            this.owner = owner;
        }

        public void onViewAttachedToWindow(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            AndroidOwnerRegistry.INSTANCE.registerOwner$ui_test_release(this.owner);
        }

        public void onViewDetachedFromWindow(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            AndroidOwnerRegistry.INSTANCE.unregisterOwner$ui_test_release(this.owner);
        }
    }
}

