/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.MotionEvent;
import androidx.ui.test.InputDispatcher;
import androidx.ui.unit.Duration;
import androidx.ui.unit.Durations;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxPosition;
import androidx.ui.util.MathHelpersKt;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.LongRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0014\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J4\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\t2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002J2\u0010\u001c\u001a\u00020\u00052\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Landroidx/ui/test/android/AndroidInputDispatcher;", "Landroidx/ui/test/InputDispatcher;", "sendEvent", "Lkotlin/Function1;", "Landroid/view/MotionEvent;", "", "handler", "Landroid/os/Handler;", "nextDownTime", "", "delay", "duration", "Landroidx/ui/unit/Duration;", "generateDownTime", "sendAndRecycleEvent", "event", "sendClick", "position", "Landroidx/ui/unit/PxPosition;", "sendMotionEvent", "downTime", "eventTime", "action", "", "sendPartialSwipe", "f", "t0", "tN", "sendSwipe", "curve", "keyTimes", "", "sleepUntil", "time", "Companion", "TestRule", "ui-test_release"})
public final class AndroidInputDispatcher
implements InputDispatcher {
    private final Function1<MotionEvent, Unit> sendEvent;
    private final Handler handler;
    private long nextDownTime;
    private static boolean dispatchInRealTime;
    private static long eventPeriod;
    private static final long DownTimeNotSet = -1L;
    @NotNull
    public static final Companion Companion;

    public AndroidInputDispatcher(@NotNull Function1<? super MotionEvent, Unit> sendEvent) {
        Intrinsics.checkParameterIsNotNull(sendEvent, (String)"sendEvent");
        this.sendEvent = sendEvent;
        this.handler = new Handler(Looper.getMainLooper());
        this.nextDownTime = -1L;
    }

    private final long generateDownTime(Duration duration) {
        long downTime = this.nextDownTime == -1L ? SystemClock.uptimeMillis() : this.nextDownTime;
        this.nextDownTime = downTime + Durations.inMilliseconds((Duration)duration);
        return downTime;
    }

    @Override
    public void delay(@NotNull Duration duration) {
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        boolean bl = duration.compareTo(Duration.Companion.getZero()) >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = Intrinsics.stringPlus((String)"duration of a delay can only be positive, not ", (Object)duration);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.generateDownTime(duration);
        this.sleepUntil(this.nextDownTime);
    }

    @Override
    public void sendClick(@NotNull PxPosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        long downTime = this.generateDownTime(Durations.getMilliseconds((long)eventPeriod));
        this.sendMotionEvent(downTime, downTime, 0, position);
        this.sendMotionEvent(downTime, downTime + eventPeriod, 1, position);
    }

    @Override
    public void sendSwipe(@NotNull Function1<? super Long, PxPosition> curve, @NotNull Duration duration, @NotNull List<Long> keyTimes) {
        boolean bl;
        boolean bl2;
        long endTime;
        long startTime;
        block10: {
            boolean bl3;
            boolean $i$f$all;
            block9: {
                Intrinsics.checkParameterIsNotNull(curve, (String)"curve");
                Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
                Intrinsics.checkParameterIsNotNull(keyTimes, (String)"keyTimes");
                startTime = 0L;
                endTime = Durations.inMilliseconds((Duration)duration);
                boolean bl4 = duration.compareTo(Durations.getMilliseconds((int)1)) >= 0;
                boolean bl5 = false;
                bl2 = false;
                if (!bl4) {
                    String string = Intrinsics.stringPlus((String)"duration must be at least 1 millisecond, not ", (Object)duration);
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                LongRange validRange = new LongRange(startTime, endTime);
                Iterable $this$all$iv = keyTimes;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        long it = ((Number)element$iv).longValue();
                        if (validRange.contains(it)) continue;
                        bl3 = false;
                        break block9;
                    }
                    bl3 = true;
                }
            }
            boolean $this$all$iv = bl3;
            $i$f$all = false;
            boolean bl6 = false;
            if (!$this$all$iv) {
                String string = "keyTimes contains timestamps out of range [" + startTime + ".." + endTime + "]: " + keyTimes;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Sequence $this$all$iv2 = SequencesKt.zipWithNext((Sequence)CollectionsKt.asSequence((Iterable)keyTimes), (Function2)((Function2)new Function2<Long, Long, Boolean>(){

                public final boolean invoke(long a, long b) {
                    return a <= b;
                }
            }));
            $i$f$all = false;
            for (Object element$iv : $this$all$iv2) {
                boolean it = (Boolean)element$iv;
                if (it) continue;
                bl = false;
                break block10;
            }
            bl = true;
        }
        boolean $this$all$iv2 = bl;
        bl2 = false;
        boolean bl7 = false;
        if (!$this$all$iv2) {
            String string = Intrinsics.stringPlus((String)"keyTimes must be sorted: ", keyTimes);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long downTime = this.generateDownTime(duration);
        long upTime = downTime + Durations.inMilliseconds((Duration)duration);
        this.sendMotionEvent(downTime, downTime, 0, (PxPosition)curve.invoke((Object)startTime));
        long currTime = startTime;
        int key = 0;
        while (currTime < endTime) {
            while (key < keyTimes.size() && ((Number)keyTimes.get(key)).longValue() <= currTime) {
                int n = key;
                key = n + 1;
            }
            long tNext = key < keyTimes.size() ? ((Number)keyTimes.get(key)).longValue() : endTime;
            this.sendPartialSwipe(downTime, curve, currTime, tNext);
            currTime = tNext;
        }
        this.sendMotionEvent(downTime, upTime, 1, (PxPosition)curve.invoke((Object)endTime));
    }

    private final void sendPartialSwipe(long downTime, Function1<? super Long, PxPosition> f, long t0, long tN) {
        int step = 0;
        int n = 1;
        int n2 = MathKt.roundToInt((float)((float)(tN - t0) / (float)eventPeriod));
        boolean bl = false;
        int steps = Math.max(n, n2);
        while (true) {
            n = step;
            step = n + 1;
            if (n >= steps) break;
            float progress = (float)step / (float)steps;
            long t = MathHelpersKt.lerp((long)t0, (long)tN, (float)progress);
            this.sendMotionEvent(downTime, downTime + t, 2, (PxPosition)f.invoke((Object)t));
        }
    }

    private final void sendMotionEvent(long downTime, long eventTime, int action, PxPosition position) {
        PxPosition this_$iv;
        this.sleepUntil(eventTime);
        PxPosition pxPosition = position;
        int n = action;
        long l = eventTime;
        long l2 = downTime;
        AndroidInputDispatcher androidInputDispatcher = this;
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n2 = (int)(value$iv$iv >> 32);
        boolean bl = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n2);
        Px px = new Px($this$px$iv$iv);
        this_$iv = position;
        float f = px.getValue();
        value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat2 = false;
        floatCompanionObject = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv & 0xFFFFFFFFL);
        bl = false;
        $this$px$iv$iv = Float.intBitsToFloat(n2);
        Px px2 = new Px($this$px$iv$iv);
        androidInputDispatcher.sendAndRecycleEvent(MotionEvent.obtain((long)l2, (long)l, (int)n, (float)f, (float)px2.getValue(), (int)0));
    }

    private final void sleepUntil(long time) {
        block0: {
            long currTime;
            if (!dispatchInRealTime || (currTime = SystemClock.uptimeMillis()) >= time) break block0;
            SystemClock.sleep((long)(time - currTime));
        }
    }

    private final void sendAndRecycleEvent(MotionEvent event) {
        CountDownLatch latch = new CountDownLatch(1);
        this.handler.post(new Runnable(this, event, latch){
            private final /* synthetic */ AndroidInputDispatcher $this$sendAndRecycleEvent;
            private final /* synthetic */ MotionEvent $event;
            private final /* synthetic */ CountDownLatch $latch;
            {
                this.$this$sendAndRecycleEvent = $receiver;
                this.$event = $event;
                this.$latch = $latch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                try {
                    AndroidInputDispatcher.access$prop$getSendEvent$0(this.$this$sendAndRecycleEvent).invoke((Object)this.$event);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this.$event.recycle();
                    this.$latch.countDown();
                }
            }
        });
        boolean bl = latch.await(5L, TimeUnit.SECONDS);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "Event " + event + " was not dispatched in 5 seconds";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    public void sendSwipe(@NotNull PxPosition start, @NotNull PxPosition end, @NotNull Duration duration) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        InputDispatcher.DefaultImpls.sendSwipe(this, start, end, duration);
    }

    static {
        Companion = new Companion(null);
        dispatchInRealTime = true;
        eventPeriod = Durations.inMilliseconds((Duration)Durations.getMilliseconds((int)10));
    }

    public static final /* synthetic */ Function1 access$prop$getSendEvent$0(AndroidInputDispatcher $this) {
        return $this.sendEvent;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/ui/test/android/AndroidInputDispatcher$Companion;", "", "DownTimeNotSet", "", "dispatchInRealTime", "", "eventPeriod", "ui-test_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\r"}, d2={"Landroidx/ui/test/android/AndroidInputDispatcher$TestRule;", "Lorg/junit/rules/TestRule;", "disableDispatchInRealTime", "", "eventPeriodOverride", "", "Ljava/lang/Long;", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "ModifyingStatement", "ui-test_release"})
    public static final class TestRule
    implements org.junit.rules.TestRule {
        private final boolean disableDispatchInRealTime;
        private final Long eventPeriodOverride;

        public TestRule(boolean disableDispatchInRealTime, @Nullable Long eventPeriodOverride) {
            this.disableDispatchInRealTime = disableDispatchInRealTime;
            this.eventPeriodOverride = eventPeriodOverride;
        }

        public /* synthetic */ TestRule(boolean disableDispatchInRealTime, Long eventPeriodOverride, int $mask0, DefaultConstructorMarker $marker) {
            boolean bl = ($mask0 & 1) != 0 ? false : disableDispatchInRealTime;
            Long l = ($mask0 & 2) != 0 ? (Long)null : eventPeriodOverride;
            this(bl, l);
        }

        @NotNull
        public Statement apply(@NotNull Statement base, @Nullable Description description) {
            Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
            return new ModifyingStatement(base);
        }

        public TestRule() {
            this(false, null, 3, null);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0001J\b\u0010\u0003\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/ui/test/android/AndroidInputDispatcher$TestRule$ModifyingStatement;", "Lorg/junit/runners/model/Statement;", "base", "evaluate", "", "ui-test_release"})
        public final class ModifyingStatement
        extends Statement {
            private final Statement base;

            public ModifyingStatement(Statement base) {
                Intrinsics.checkParameterIsNotNull((Object)TestRule.this, (String)"$outer");
                Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
                this.base = base;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() {
                if (TestRule.this.disableDispatchInRealTime) {
                    dispatchInRealTime = false;
                }
                if (TestRule.this.eventPeriodOverride != null) {
                    eventPeriod = TestRule.this.eventPeriodOverride;
                }
                try {
                    this.base.evaluate();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if (TestRule.this.disableDispatchInRealTime) {
                        dispatchInRealTime = true;
                    }
                    if (TestRule.this.eventPeriodOverride != null) {
                        eventPeriod = 10L;
                    }
                }
            }
        }
    }
}

