/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Path;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.AndroidPath;
import androidx.ui.graphics.AndroidPathKt;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.Outline;
import androidx.ui.graphics.OutlineKt;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.RectangleShapeKt;
import androidx.ui.graphics.Shape;
import androidx.ui.test.FindersKt;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.android.CollectedOwners;
import androidx.ui.test.android.SynchronizedTreeCollector;
import androidx.ui.test.android.WindowCaptureKt;
import androidx.ui.unit.Density;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxPosition;
import androidx.ui.unit.IntPxSize;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxBounds;
import androidx.ui.unit.PxKt;
import androidx.ui.unit.PxSize;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u001a2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a2\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\f\u001aB\u0010\u000f\u001a\u00020\u0010*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00180\u0017\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a>\u0010\u001b\u001a\u00020\u0010*\u00020\u00012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2#\u0010\u001e\u001a\u001f\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0017\u00f8\u0001\u0000\u001a\u0084\u0001\u0010#\u001a\u00020\u0010*\u00020\u00012\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\b\b\u0002\u0010*\u001a\u00020'2\b\b\u0002\u0010+\u001a\u00020\b2\b\b\u0002\u0010,\u001a\u00020\b2\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010-\u001a\u00020\b2\b\b\u0002\u0010.\u001a\u00020\b2\b\b\u0002\u0010/\u001a\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b0\u00101\u001a\f\u00102\u001a\u00020\u0001*\u000203H\u0007\u001a\f\u00102\u001a\u00020\u0001*\u000204H\u0007\u001a\u0012\u00105\u001a\u000206*\u0002072\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u001f\u00108\u001a\u000209*\u00020\b2\u0006\u00108\u001a\u00020\bH\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b:\u0010;\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006<"}, d2={"captureNodeToBitmap", "Landroid/graphics/Bitmap;", "node", "Landroidx/ui/core/semantics/SemanticsNode;", "pixelCloserToCenter", "Landroidx/ui/geometry/Offset;", "offset", "shapeSizeX", "Landroidx/ui/unit/Px;", "shapeSizeY", "delta", "pixelCloserToCenter-b7WhLio", "(Landroidx/ui/geometry/Offset;FFF)Landroidx/ui/geometry/Offset;", "pixelFartherFromCenter", "pixelFartherFromCenter-b7WhLio", "assertPixelColor", "", "expected", "Landroidx/ui/graphics/Color;", "x", "", "y", "error", "Lkotlin/Function1;", "", "assertPixelColor-9bBi3KA", "(Landroid/graphics/Bitmap;JIILkotlin/jvm/functions/Function1;)V", "assertPixels", "expectedSize", "Landroidx/ui/unit/IntPxSize;", "expectedColorProvider", "Landroidx/ui/unit/IntPxPosition;", "Lkotlin/ParameterName;", "name", "pos", "assertShape", "density", "Landroidx/ui/unit/Density;", "shape", "Landroidx/ui/graphics/Shape;", "shapeColor", "backgroundColor", "backgroundShape", "sizeX", "sizeY", "centerX", "centerY", "shapeOverlapPixelCount", "assertShape-nbwoFSQ", "(Landroid/graphics/Bitmap;Landroidx/ui/unit/Density;Landroidx/ui/graphics/Shape;JJLandroidx/ui/graphics/Shape;FFFFFFF)V", "captureToBitmap", "Landroid/view/View;", "Landroidx/ui/test/SemanticsNodeInteraction;", "contains", "", "Landroidx/ui/graphics/Path;", "until", "Lkotlin/ranges/IntRange;", "until-qHcltEY", "(FF)Lkotlin/ranges/IntRange;", "ui-test_release"})
public final class BitmapHelpersKt {
    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureNodeToBitmap(@NotNull SemanticsNode node) {
        boolean exists;
        CollectedOwners collectedInfo;
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            collectedInfo = SynchronizedTreeCollector.INSTANCE.collectOwners$ui_test_release();
            Iterable $this$any$iv = FindersKt.getAllSemanticsNodes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SemanticsNode it = (SemanticsNode)element$iv;
                    boolean bl2 = false;
                    if (!(it.getId() == node.getId())) continue;
                    bl = true;
                    break block4;
                }
                bl = exists = false;
            }
        }
        if (!exists) {
            throw new AssertionError((Object)"The required node is no longer in the tree!");
        }
        Window window = collectedInfo.findActivity().getWindow();
        Handler handler = new Handler(Looper.getMainLooper());
        Rect rect = PxKt.toRect((PxBounds)node.getGlobalBounds());
        Window window2 = window;
        Intrinsics.checkNotNullExpressionValue((Object)window2, (String)"window");
        return WindowCaptureKt.captureRegionToBitmap(rect, handler, window2);
    }

    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureToBitmap(@NotNull SemanticsNodeInteraction $this$captureToBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$captureToBitmap, (String)"<this>");
        String errorMessageOnFail = "Failed to capture a node to bitmap.";
        return BitmapHelpersKt.captureNodeToBitmap($this$captureToBitmap.fetchSemanticsNode(errorMessageOnFail));
    }

    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureToBitmap(@NotNull View $this$captureToBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$captureToBitmap, (String)"<this>");
        int[] nArray = new int[]{0, 0};
        int[] locationOnScreen = nArray;
        $this$captureToBitmap.getLocationOnScreen(locationOnScreen);
        float x = locationOnScreen[0];
        float y = locationOnScreen[1];
        Rect bounds = new Rect(x, y, x + (float)$this$captureToBitmap.getWidth(), y + (float)$this$captureToBitmap.getHeight());
        Handler handler = $this$captureToBitmap.getHandler();
        Intrinsics.checkNotNullExpressionValue((Object)handler, (String)"handler");
        Handler handler2 = handler;
        Context context = $this$captureToBitmap.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Activity activity = BitmapHelpersKt.captureToBitmap$getActivity(context);
        Intrinsics.checkNotNull((Object)activity);
        handler = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)handler, (String)"context.getActivity()!!.window");
        return WindowCaptureKt.captureRegionToBitmap(bounds, handler2, (Window)handler);
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertPixels(@NotNull Bitmap $this$assertPixels, @Nullable IntPxSize expectedSize, @NotNull Function1<? super IntPxPosition, Color> expectedColorProvider) {
        block6: {
            block7: {
                IntPxSize this_$iv;
                Intrinsics.checkNotNullParameter((Object)$this$assertPixels, (String)"<this>");
                Intrinsics.checkNotNullParameter(expectedColorProvider, (String)"expectedColorProvider");
                if (expectedSize == null) break block6;
                IntPxSize intPxSize = expectedSize;
                int n = $this$assertPixels.getWidth();
                boolean $i$f$getWidth = false;
                long value$iv$iv = this_$iv.getValue();
                boolean $i$f$unpackInt1 = false;
                int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
                boolean $i$f$getIpx = false;
                int n2 = IntPx.constructor-impl((int)$this$ipx$iv$iv);
                if (n != n2) break block7;
                this_$iv = expectedSize;
                n = $this$assertPixels.getHeight();
                boolean $i$f$getHeight = false;
                value$iv$iv = this_$iv.getValue();
                boolean $i$f$unpackInt2 = false;
                $this$ipx$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                $i$f$getIpx = false;
                n2 = IntPx.constructor-impl((int)$this$ipx$iv$iv);
                if (n == n2) break block6;
            }
            throw new AssertionError((Object)("Bitmap size is wrong! Expected '" + expectedSize + "' but got '" + $this$assertPixels.getWidth() + " x " + $this$assertPixels.getHeight() + "'"));
        }
        int n = $this$assertPixels.getWidth();
        int n3 = 0;
        int n4 = n + -1;
        if (n != Integer.MIN_VALUE && n3 <= n4) {
            do {
                int x = n3++;
                int n5 = $this$assertPixels.getHeight();
                int n6 = 0;
                int n7 = n5 + -1;
                if (n5 == Integer.MIN_VALUE || n6 > n7) continue;
                do {
                    void val1$iv$iv;
                    void x$iv;
                    int y = n6++;
                    int $this$ipx$iv = x;
                    boolean $i$f$getIpx = false;
                    $this$ipx$iv = IntPx.constructor-impl((int)$this$ipx$iv);
                    int $this$ipx$iv2 = y;
                    boolean $i$f$getIpx2 = false;
                    int y$iv = IntPx.constructor-impl((int)$this$ipx$iv2);
                    boolean bl = false;
                    void var15_20 = x$iv;
                    int val2$iv$iv = y$iv;
                    boolean $i$f$packInts = false;
                    long l = (long)val1$iv$iv << 32 | (long)val2$iv$iv & 0xFFFFFFFFL;
                    long l2 = l;
                    IntPxPosition pxPos = new IntPxPosition(l2);
                    Color expectedClr = (Color)expectedColorProvider.invoke((Object)pxPos);
                    if (expectedClr == null) continue;
                    BitmapHelpersKt.assertPixelColor-9bBi3KA$default($this$assertPixels, expectedClr.unbox-impl(), x, y, null, 8, null);
                } while (n6 <= n7);
            } while (n3 <= n4);
        }
    }

    public static /* synthetic */ void assertPixels$default(Bitmap $this$assertPixels_u24default, IntPxSize expectedSize, Function1 expectedColorProvider, int n, Object object) {
        if ((n & 1) != 0) {
            expectedSize = null;
        }
        BitmapHelpersKt.assertPixels($this$assertPixels_u24default, expectedSize, (Function1<? super IntPxPosition, Color>)expectedColorProvider);
    }

    public static final void assertPixelColor-9bBi3KA(@NotNull Bitmap $receiver, long expected, int x, int y, @NotNull Function1<? super Color, String> error) {
        Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
        Intrinsics.checkNotNullParameter(error, (String)"error");
        long color = ColorKt.Color((int)$receiver.getPixel(x, y));
        String errorString = (String)error.invoke((Object)Color.box-impl((long)color));
        Assert.assertEquals((String)errorString, (float)Color.getRed-impl((long)expected), (float)Color.getRed-impl((long)color), (float)0.02f);
        Assert.assertEquals((String)errorString, (float)Color.getGreen-impl((long)expected), (float)Color.getGreen-impl((long)color), (float)0.02f);
        Assert.assertEquals((String)errorString, (float)Color.getBlue-impl((long)expected), (float)Color.getBlue-impl((long)color), (float)0.02f);
        Assert.assertEquals((String)errorString, (float)Color.getAlpha-impl((long)expected), (float)Color.getAlpha-impl((long)color), (float)0.02f);
    }

    public static /* synthetic */ void assertPixelColor-9bBi3KA$default(Bitmap $receiver, long expected, int x, int y, Function1 error, int n, Object object) {
        if ((n & 8) != 0) {
            error = (Function1)new Function1<Color, String>(x, y, expected, null){
                private final /* synthetic */ int $x;
                private final /* synthetic */ int $y;
                private final /* synthetic */ long $expected;
                {
                    this.$x = $x;
                    this.$y = $y;
                    this.$expected = $expected;
                    super(1);
                }

                @NotNull
                public final String invoke(long color) {
                    return "Pixel(" + this.$x + ", " + this.$y + ") expected to be " + Color.toString-impl((long)this.$expected) + ", but was " + Color.toString-impl((long)color);
                }
                {
                    this(n, n2, l);
                }
            };
        }
        BitmapHelpersKt.assertPixelColor-9bBi3KA($receiver, expected, x, y, (Function1<? super Color, String>)error);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean contains(@NotNull Path $this$contains, @NotNull Offset offset) {
        void $this$asAndroidPath$iv;
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        android.graphics.Path path = new android.graphics.Path();
        path.addRect(offset.getDx() - 0.01f, offset.getDy() - 0.01f, offset.getDx() + 0.01f, offset.getDy() + 0.01f, Path.Direction.CW);
        Path path2 = $this$contains;
        android.graphics.Path path3 = path;
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        android.graphics.Path path4 = ((AndroidPath)$this$asAndroidPath$iv).getInternalPath();
        if (path3.op(path4, Path.Op.INTERSECT)) {
            return !path.isEmpty();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertShape-nbwoFSQ(@NotNull Bitmap $receiver, @NotNull Density density, @NotNull Shape shape, long shapeColor, long backgroundColor, @NotNull Shape backgroundShape, float sizeX, float sizeY, float shapeSizeX, float shapeSizeY, float centerX, float centerY, float shapeOverlapPixelCount) {
        float f;
        long l;
        void val1$iv$iv;
        float f2;
        float f3;
        long l2;
        void val1$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)backgroundShape, (String)"backgroundShape");
        int $this$px$iv = $receiver.getWidth();
        boolean $i$f$getPx = false;
        float width = Px.constructor-impl((float)$this$px$iv);
        int $this$px$iv2 = $receiver.getHeight();
        boolean $i$f$getPx2 = false;
        float height = Px.constructor-impl((float)$this$px$iv2);
        int other$iv = 2;
        boolean bl = false;
        float other$iv2 = Px.constructor-impl((float)(sizeX / (float)other$iv));
        boolean bl2 = false;
        Assert.assertTrue((Px.compareTo-NgWp0Z8((float)Px.constructor-impl((float)(centerX + other$iv2)), (float)width) <= 0 ? 1 : 0) != 0);
        other$iv = 2;
        bl = false;
        float other$iv42 = Px.constructor-impl((float)(sizeX / (float)other$iv));
        boolean bl3 = false;
        int other$iv42 = 0;
        float f4 = Px.constructor-impl((float)(centerX - other$iv42));
        $i$f$getPx2 = false;
        float f5 = Px.constructor-impl((float)((float)$this$px$iv));
        Assert.assertTrue((Px.compareTo-NgWp0Z8((float)f4, (float)f5) >= 0 ? 1 : 0) != 0);
        other$iv42 = 2;
        bl = false;
        float other$iv3 = Px.constructor-impl((float)(sizeY / (float)other$iv42));
        bl2 = false;
        Assert.assertTrue((Px.compareTo-NgWp0Z8((float)Px.constructor-impl((float)(centerY + other$iv3)), (float)height) <= 0 ? 1 : 0) != 0);
        other$iv = 2;
        bl = false;
        float other$iv62 = Px.constructor-impl((float)(sizeY / (float)other$iv));
        bl3 = false;
        boolean other$iv62 = false;
        f4 = Px.constructor-impl((float)(centerY - other$iv62));
        $i$f$getPx2 = false;
        f5 = Px.constructor-impl((float)((float)$this$px$iv));
        Assert.assertTrue((Px.compareTo-NgWp0Z8((float)f4, (float)f5) >= 0 ? 1 : 0) != 0);
        Shape shape2 = shape;
        boolean bl4 = false;
        float f6 = shapeSizeX;
        float val2$iv$iv = shapeSizeY;
        boolean $i$f$packFloats = false;
        float f7 = val1$iv$iv2;
        boolean bl5 = false;
        long v1$iv$iv = Float.floatToIntBits(f7);
        float f8 = val2$iv$iv;
        boolean bl6 = false;
        long v2$iv$iv = Float.floatToIntBits(f8);
        long l3 = l2 = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxSize pxSize = new PxSize(l3);
        Outline outline = shape2.createOutline(pxSize, density);
        Path path = AndroidPathKt.Path();
        OutlineKt.addOutline((Path)path, (Outline)outline);
        float other$iv5 = 2.0f;
        $i$f$div-impl = false;
        other$iv5 = f3 = Px.constructor-impl((float)(shapeSizeX / other$iv5));
        $i$f$minus-NgWp0Z8 = false;
        f3 = Px.constructor-impl((float)(centerX - other$iv5));
        other$iv5 = 2.0f;
        $i$f$div-impl = false;
        other$iv5 = f2 = Px.constructor-impl((float)(shapeSizeY / other$iv5));
        $i$f$minus-NgWp0Z8 = false;
        float f9 = f2 = Px.constructor-impl((float)(centerY - other$iv5));
        float f10 = f3;
        Offset shapeOffset = new Offset(f10, f9);
        Path backgroundPath = AndroidPathKt.Path();
        pxSize = backgroundShape;
        shape2 = backgroundPath;
        $i$f$PxSize-qHcltEY = false;
        f7 = sizeX;
        float val2$iv$iv2 = sizeY;
        boolean $i$f$packFloats2 = false;
        void var25_72 = val1$iv$iv;
        boolean bl7 = false;
        long v1$iv$iv2 = Float.floatToIntBits((float)var25_72);
        float f11 = val2$iv$iv2;
        boolean bl8 = false;
        long v2$iv$iv2 = Float.floatToIntBits(f11);
        long l4 = l = v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL;
        PxSize pxSize2 = new PxSize(l4);
        OutlineKt.addOutline((Path)shape2, (Outline)pxSize.createOutline(pxSize2, density));
        int other$iv7 = 2;
        $i$f$div-impl = false;
        float other$iv722 = Px.constructor-impl((float)(sizeX / (float)other$iv7));
        $i$f$minus-NgWp0Z8 = false;
        int other$iv722 = 2;
        float f12 = Px.constructor-impl((float)(centerX - other$iv722));
        $i$f$div-impl = false;
        float other$iv52 = f = Px.constructor-impl((float)(sizeX / (float)other$iv722));
        $i$f$plus-NgWp0Z8 = false;
        f = Px.constructor-impl((float)(centerX + other$iv52));
        IntRange intRange = BitmapHelpersKt.until-qHcltEY(f12, f);
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        int n3 = intRange.getStep();
        if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
            int x;
            do {
                int y;
                x = n;
                n += n3;
                int other$iv8 = 2;
                $i$f$div-impl = false;
                float other$iv92 = Px.constructor-impl((float)(sizeY / (float)other$iv8));
                $i$f$minus-NgWp0Z8 = false;
                int other$iv92 = 2;
                f12 = Px.constructor-impl((float)(centerY - other$iv92));
                $i$f$div-impl = false;
                float other$iv82 = f = Px.constructor-impl((float)(sizeY / (float)other$iv92));
                $i$f$plus-NgWp0Z8 = false;
                f = Px.constructor-impl((float)(centerY + other$iv82));
                IntRange intRange2 = BitmapHelpersKt.until-qHcltEY(f12, f);
                int n4 = intRange2.getFirst();
                int n5 = intRange2.getLast();
                int n6 = intRange2.getStep();
                if ((n6 <= 0 || n4 > n5) && (n6 >= 0 || n5 > n4)) continue;
                do {
                    boolean isOutside;
                    y = n4;
                    n4 += n6;
                    Offset point = new Offset((float)x, (float)y);
                    if (!BitmapHelpersKt.contains(backgroundPath, BitmapHelpersKt.pixelFartherFromCenter-b7WhLio(point, sizeX, sizeY, shapeOverlapPixelCount))) continue;
                    Offset offset = point.minus(shapeOffset);
                    boolean isInside = BitmapHelpersKt.contains(path, BitmapHelpersKt.pixelFartherFromCenter-b7WhLio(offset, shapeSizeX, shapeSizeY, shapeOverlapPixelCount));
                    boolean bl9 = isOutside = !BitmapHelpersKt.contains(path, BitmapHelpersKt.pixelCloserToCenter-b7WhLio(offset, shapeSizeX, shapeSizeY, shapeOverlapPixelCount));
                    if (isInside) {
                        BitmapHelpersKt.assertPixelColor-9bBi3KA$default($receiver, shapeColor, x, y, null, 8, null);
                        continue;
                    }
                    if (!isOutside) continue;
                    BitmapHelpersKt.assertPixelColor-9bBi3KA$default($receiver, backgroundColor, x, y, null, 8, null);
                } while (y != n5);
            } while (x != n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void assertShape-nbwoFSQ$default(Bitmap $receiver, Density density, Shape shape, long shapeColor, long backgroundColor, Shape backgroundShape, float sizeX, float sizeY, float shapeSizeX, float shapeSizeY, float centerX, float centerY, float shapeOverlapPixelCount, int n, Object object) {
        void $this$iv;
        boolean bl;
        boolean $i$f$getPx;
        float $this$px$iv2;
        if ((n & 0x10) != 0) {
            backgroundShape = RectangleShapeKt.getRectangleShape();
        }
        if ((n & 0x20) != 0) {
            $this$px$iv2 = $receiver.getWidth();
            $i$f$getPx = false;
            sizeX = Px.constructor-impl((float)$this$px$iv2);
        }
        if ((n & 0x40) != 0) {
            $this$px$iv2 = $receiver.getHeight();
            $i$f$getPx = false;
            sizeY = Px.constructor-impl((float)$this$px$iv2);
        }
        if ((n & 0x80) != 0) {
            shapeSizeX = sizeX;
        }
        if ((n & 0x100) != 0) {
            shapeSizeY = sizeY;
        }
        if ((n & 0x200) != 0) {
            int $this$px$iv = $receiver.getWidth();
            $i$f$getPx = false;
            $this$px$iv2 = Px.constructor-impl((float)$this$px$iv);
            float other$iv = 2.0f;
            bl = false;
            centerX = Px.constructor-impl((float)($this$iv / other$iv));
        }
        if ((n & 0x400) != 0) {
            $this$px$iv = $receiver.getHeight();
            boolean $i$f$getPx2 = false;
            $this$px$iv2 = Px.constructor-impl((float)$this$px$iv);
            float other$iv = 2.0f;
            bl = false;
            centerY = Px.constructor-impl((float)($this$iv / other$iv));
        }
        if ((n & 0x800) != 0) {
            boolean $this$px$iv3 = true;
            boolean $i$f$getPx3 = false;
            shapeOverlapPixelCount = Px.constructor-impl((float)((float)$this$px$iv3));
        }
        BitmapHelpersKt.assertShape-nbwoFSQ($receiver, density, shape, shapeColor, backgroundColor, backgroundShape, sizeX, sizeY, shapeSizeX, shapeSizeY, centerX, centerY, shapeOverlapPixelCount);
    }

    private static final IntRange until-qHcltEY(float $receiver, float until) {
        int to;
        boolean bl = false;
        float f = $receiver;
        boolean bl2 = false;
        int from = Float.isInfinite(f) ? IntPx.Companion.getInfinity() : IntPx.constructor-impl((int)MathKt.roundToInt((float)$receiver));
        $i$f$round-NgWp0Z8 = false;
        float f2 = until;
        boolean bl3 = false;
        int n = to = Float.isInfinite(f2) ? IntPx.Companion.getInfinity() : IntPx.constructor-impl((int)MathKt.roundToInt((float)until));
        if (from <= Integer.MIN_VALUE) {
            return IntRange.Companion.getEMPTY();
        }
        return new IntRange(from, to - 1);
    }

    private static final Offset pixelCloserToCenter-b7WhLio(Offset offset, float shapeSizeX, float shapeSizeY, float delta) {
        float x;
        float centerX = shapeSizeX / 2.0f;
        float centerY = shapeSizeY / 2.0f;
        float d = delta;
        float f = offset.getDx() > centerX ? offset.getDx() - d : (x = offset.getDx() < centerX ? offset.getDx() + d : offset.getDx());
        float y = offset.getDy() > centerY ? offset.getDy() - d : (offset.getDy() < centerY ? offset.getDy() + d : offset.getDy());
        return new Offset(x, y);
    }

    private static final Offset pixelFartherFromCenter-b7WhLio(Offset offset, float shapeSizeX, float shapeSizeY, float delta) {
        float x;
        float centerX = shapeSizeX / 2.0f;
        float centerY = shapeSizeY / 2.0f;
        float d = delta;
        float f = offset.getDx() > centerX ? offset.getDx() + d : (x = offset.getDx() < centerX ? offset.getDx() - d : offset.getDx());
        float y = offset.getDy() > centerY ? offset.getDy() + d : (offset.getDy() < centerY ? offset.getDy() - d : offset.getDy());
        return new Offset(x, y);
    }

    private static final Activity captureToBitmap$getActivity(Context $this$captureToBitmap_u24getActivity) {
        Activity activity;
        Context context = $this$captureToBitmap_u24getActivity;
        if (context instanceof Activity) {
            activity = (Activity)$this$captureToBitmap_u24getActivity;
        } else if (context instanceof ContextWrapper) {
            Context context2 = ((ContextWrapper)$this$captureToBitmap_u24getActivity).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"this.baseContext");
            activity = BitmapHelpersKt.captureToBitmap$getActivity(context2);
        } else {
            activity = null;
        }
        return activity;
    }
}

