/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.semantics.SemanticsConfiguration;
import androidx.ui.core.semantics.SemanticsConfigurationKt;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.foundation.selection.ToggleableState;
import androidx.ui.foundation.semantics.FoundationSemanticsProperties;
import androidx.ui.semantics.SemanticsActions;
import androidx.ui.semantics.SemanticsProperties;
import androidx.ui.semantics.SemanticsPropertyKey;
import androidx.ui.test.SemanticsMatcher;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u0006\u0010\f\u001a\u00020\u0006\u001a\u0006\u0010\r\u001a\u00020\u0006\u001a\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0006\u0010\u000f\u001a\u00020\u0006\u001a\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0012\u001a\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0012\u001a\u0006\u0010\u001b\u001a\u00020\u0006\u001a\u0006\u0010\u001c\u001a\u00020\u0006\u001a\u0006\u0010\u001d\u001a\u00020\u0006\u001a\u0006\u0010\u001e\u001a\u00020\u0006\u001a\u0006\u0010\u001f\u001a\u00020\u0006\u001a\u0006\u0010 \u001a\u00020\u0006\u001a\u0006\u0010!\u001a\u00020\u0006\u001a\u0006\u0010\"\u001a\u00020\u0006\u001a\u0006\u0010#\u001a\u00020\u0006\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006$"}, d2={"ancestors", "", "Landroidx/ui/core/semantics/SemanticsNode;", "getAncestors", "(Landroidx/ui/core/semantics/SemanticsNode;)Ljava/lang/Iterable;", "hasAnyAncestorThat", "Landroidx/ui/test/SemanticsMatcher;", "matcher", "hasAnyChildThat", "hasAnyDescendantThat", "hasAnySiblingThat", "hasClickAction", "hasNoClickAction", "hasNoScrollAction", "hasParentThat", "hasScrollAction", "hasSubstring", "substring", "", "ignoreCase", "", "hasTestTag", "testTag", "hasText", "text", "hasValue", "value", "isHidden", "isInMutuallyExclusiveGroup", "isNotHidden", "isOff", "isOn", "isSelectable", "isSelected", "isToggleable", "isUnselected", "ui-test_release"})
public final class FiltersKt {
    @NotNull
    public static final SemanticsMatcher isToggleable() {
        return SemanticsMatcher.Companion.keyIsDefined(FoundationSemanticsProperties.INSTANCE.getToggleableState());
    }

    @NotNull
    public static final SemanticsMatcher isOn() {
        return SemanticsMatcher.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getToggleableState(), ToggleableState.On);
    }

    @NotNull
    public static final SemanticsMatcher isOff() {
        return SemanticsMatcher.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getToggleableState(), ToggleableState.Off);
    }

    @NotNull
    public static final SemanticsMatcher isSelectable() {
        return SemanticsMatcher.Companion.keyIsDefined(FoundationSemanticsProperties.INSTANCE.getSelected());
    }

    @NotNull
    public static final SemanticsMatcher isSelected() {
        return SemanticsMatcher.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getSelected(), true);
    }

    @NotNull
    public static final SemanticsMatcher isUnselected() {
        return SemanticsMatcher.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getSelected(), false);
    }

    @NotNull
    public static final SemanticsMatcher hasClickAction() {
        return SemanticsMatcher.Companion.keyIsDefined(SemanticsActions.Companion.getOnClick());
    }

    @NotNull
    public static final SemanticsMatcher hasNoClickAction() {
        return SemanticsMatcher.Companion.keyNotDefined(SemanticsActions.Companion.getOnClick());
    }

    @NotNull
    public static final SemanticsMatcher hasScrollAction() {
        return SemanticsMatcher.Companion.keyIsDefined(SemanticsActions.Companion.getScrollTo());
    }

    @NotNull
    public static final SemanticsMatcher hasNoScrollAction() {
        return SemanticsMatcher.Companion.keyNotDefined(SemanticsActions.Companion.getScrollTo());
    }

    @NotNull
    public static final SemanticsMatcher hasText(@NotNull String text, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return SemanticsMatcher.Companion.fromCondition(SemanticsProperties.INSTANCE.getAccessibilityLabel().getName() + " = '" + text + "' (ignoreCase: " + ignoreCase + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(text, ignoreCase){
            private final /* synthetic */ String $text;
            private final /* synthetic */ boolean $ignoreCase;
            {
                this.$text = $text;
                this.$ignoreCase = $ignoreCase;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"<this>");
                return StringsKt.equals((String)((String)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)semanticsNode.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getAccessibilityLabel())), (String)this.$text, (boolean)this.$ignoreCase);
            }
        }));
    }

    public static /* synthetic */ SemanticsMatcher hasText$default(String text, boolean ignoreCase, int n, Object object) {
        if ((n & 2) != 0) {
            ignoreCase = false;
        }
        return FiltersKt.hasText(text, ignoreCase);
    }

    @NotNull
    public static final SemanticsMatcher hasSubstring(@NotNull String substring, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        return SemanticsMatcher.Companion.fromCondition(SemanticsProperties.INSTANCE.getAccessibilityLabel().getName() + ".contains(" + substring + ", " + ignoreCase + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(substring, ignoreCase){
            private final /* synthetic */ String $substring;
            private final /* synthetic */ boolean $ignoreCase;
            {
                this.$substring = $substring;
                this.$ignoreCase = $ignoreCase;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"<this>");
                String string = (String)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)semanticsNode.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getAccessibilityLabel());
                Boolean bl = string == null ? (Boolean)null : Boolean.valueOf(StringsKt.contains((CharSequence)string, (CharSequence)this.$substring, (boolean)this.$ignoreCase));
                return bl == null ? false : bl;
            }
        }));
    }

    public static /* synthetic */ SemanticsMatcher hasSubstring$default(String substring, boolean ignoreCase, int n, Object object) {
        if ((n & 2) != 0) {
            ignoreCase = false;
        }
        return FiltersKt.hasSubstring(substring, ignoreCase);
    }

    @NotNull
    public static final SemanticsMatcher hasValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return SemanticsMatcher.Companion.expectValue(SemanticsProperties.INSTANCE.getAccessibilityValue(), value);
    }

    @NotNull
    public static final SemanticsMatcher hasTestTag(@NotNull String testTag) {
        Intrinsics.checkNotNullParameter((Object)testTag, (String)"testTag");
        return SemanticsMatcher.Companion.expectValue(SemanticsProperties.INSTANCE.getTestTag(), testTag);
    }

    @NotNull
    public static final SemanticsMatcher isInMutuallyExclusiveGroup() {
        return SemanticsMatcher.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getInMutuallyExclusiveGroup(), true);
    }

    @NotNull
    public static final SemanticsMatcher isHidden() {
        return SemanticsMatcher.Companion.expectValue(SemanticsProperties.INSTANCE.getHidden(), true);
    }

    @NotNull
    public static final SemanticsMatcher isNotHidden() {
        return SemanticsMatcher.Companion.expectValue(SemanticsProperties.INSTANCE.getHidden(), false);
    }

    @NotNull
    public static final SemanticsMatcher hasParentThat(@NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return SemanticsMatcher.Companion.fromCondition("hasParentThat(" + matcher.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(matcher){
            private final /* synthetic */ SemanticsMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                Boolean bl;
                Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"<this>");
                SemanticsNode semanticsNode2 = semanticsNode.getParent();
                if (semanticsNode2 == null) {
                    bl = null;
                } else {
                    SemanticsNode semanticsNode3 = semanticsNode2;
                    SemanticsMatcher semanticsMatcher = this.$matcher;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    SemanticsNode $this$invoke_u24lambda_u2d0 = semanticsNode3;
                    boolean bl4 = false;
                    bl = semanticsMatcher.matches($this$invoke_u24lambda_u2d0);
                }
                Boolean bl5 = bl;
                return bl5 == null ? false : bl5;
            }
        }));
    }

    @NotNull
    public static final SemanticsMatcher hasAnyChildThat(@NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return SemanticsMatcher.Companion.fromCondition("hasAnyChildThat(" + matcher.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(matcher){
            private final /* synthetic */ SemanticsMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"<this>");
                return this.$matcher.matchesAny(semanticsNode.getChildren());
            }
        }));
    }

    @NotNull
    public static final SemanticsMatcher hasAnySiblingThat(@NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return SemanticsMatcher.Companion.fromCondition("hasAnySiblingThat(" + matcher.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(matcher){
            private final /* synthetic */ SemanticsMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                Boolean bl;
                Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"<this>");
                SemanticsNode node = semanticsNode;
                SemanticsNode semanticsNode2 = semanticsNode.getParent();
                if (semanticsNode2 == null) {
                    bl = null;
                } else {
                    boolean bl2;
                    block5: {
                        SemanticsNode semanticsNode3 = semanticsNode2;
                        SemanticsMatcher semanticsMatcher = this.$matcher;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        SemanticsNode $this$invoke_u24lambda_u2d1 = semanticsNode3;
                        boolean bl5 = false;
                        Iterable<SemanticsNode> $this$any$iv = semanticsMatcher.match($this$invoke_u24lambda_u2d1.getChildren());
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            Iterator<SemanticsNode> iterator2 = $this$any$iv.iterator();
                            while (iterator2.hasNext()) {
                                SemanticsNode element$iv;
                                SemanticsNode it = element$iv = iterator2.next();
                                boolean bl6 = false;
                                if (!(it.getId() != node.getId())) continue;
                                bl2 = true;
                                break block5;
                            }
                            bl2 = false;
                        }
                    }
                    bl = bl2;
                }
                Boolean bl7 = bl;
                return bl7 == null ? false : bl7;
            }
        }));
    }

    @NotNull
    public static final SemanticsMatcher hasAnyAncestorThat(@NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return SemanticsMatcher.Companion.fromCondition("hasAnyAncestorThat(" + matcher.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(matcher){
            private final /* synthetic */ SemanticsMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"<this>");
                return this.$matcher.matchesAny(FiltersKt.getAncestors(semanticsNode));
            }
        }));
    }

    @NotNull
    public static final SemanticsMatcher hasAnyDescendantThat(@NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return SemanticsMatcher.Companion.fromCondition("hasAnyDescendantThat(" + matcher.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(matcher){
            private final /* synthetic */ SemanticsMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode semanticsNode) {
                Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"<this>");
                return FiltersKt.access$hasAnyDescendantThat$checkIfSubtreeMatches(this.$matcher, semanticsNode);
            }
        }));
    }

    @NotNull
    public static final Iterable<SemanticsNode> getAncestors(@NotNull SemanticsNode $this$ancestors) {
        Intrinsics.checkNotNullParameter((Object)$this$ancestors, (String)"<this>");
        return new Iterable<SemanticsNode>($this$ancestors){
            private final /* synthetic */ SemanticsNode $this;
            {
                this.$this = $receiver;
            }

            @NotNull
            public Iterator<SemanticsNode> iterator() {
                return new Iterator<SemanticsNode>(this.$this){
                    private SemanticsNode next;
                    private final /* synthetic */ SemanticsNode $this;
                    {
                        this.$this = $receiver;
                        this.next = this.$this.getParent();
                    }

                    @Nullable
                    public final SemanticsNode getNext() {
                        return this.next;
                    }

                    public final void setNext(@Nullable SemanticsNode semanticsNode) {
                        this.next = semanticsNode;
                    }

                    public boolean hasNext() {
                        return this.getNext() != null;
                    }

                    @NotNull
                    public SemanticsNode next() {
                        SemanticsNode semanticsNode = this.getNext();
                        Intrinsics.checkNotNull((Object)semanticsNode);
                        boolean bl = false;
                        boolean bl2 = false;
                        SemanticsNode it = semanticsNode;
                        boolean bl3 = false;
                        this.setNext(it.getParent());
                        return semanticsNode;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    private static final boolean hasAnyDescendantThat$checkIfSubtreeMatches(SemanticsMatcher matcher, SemanticsNode node) {
        boolean bl;
        block4: {
            if (matcher.matchesAny(node.getChildren())) {
                return true;
            }
            Iterable $this$any$iv = node.getChildren();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SemanticsNode it = (SemanticsNode)element$iv;
                    boolean bl2 = false;
                    if (!FiltersKt.hasAnyDescendantThat$checkIfSubtreeMatches(matcher, it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$hasAnyDescendantThat$checkIfSubtreeMatches(SemanticsMatcher semanticsMatcher, SemanticsNode semanticsNode) {
        return FiltersKt.hasAnyDescendantThat$checkIfSubtreeMatches(semanticsMatcher, semanticsNode);
    }
}

