/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.ComponentNode;
import androidx.ui.core.ComponentNodesKt;
import androidx.ui.core.LayoutCoordinates;
import androidx.ui.core.LayoutNode;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.core.semantics.SemanticsNodeKt;
import androidx.ui.semantics.AccessibilityAction;
import androidx.ui.semantics.SemanticsActions;
import androidx.ui.semantics.SemanticsPropertyKey;
import androidx.ui.test.ErrorMessagesKt;
import androidx.ui.test.FiltersKt;
import androidx.ui.test.GestureScope;
import androidx.ui.test.GestureScopeKt;
import androidx.ui.test.PartialGestureScope;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.SynchronizationKt;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxPosition;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0018\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00060\u00050\u0004\u001aB\u0010\u0000\u001a\u00020\u0001\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00050\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00010\n\u001a\n\u0010\u000b\u001a\u00020\u0002*\u00020\u0002\u001a#\u0010\f\u001a\u00020\u0002*\u00020\u00022\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\u0002\b\u000f\u001a#\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\u0002\b\u000f\u001a\n\u0010\u0012\u001a\u00020\u0002*\u00020\u0002\u00a8\u0006\u0013"}, d2={"callSemanticsAction", "", "Landroidx/ui/test/SemanticsNodeInteraction;", "key", "Landroidx/ui/semantics/SemanticsPropertyKey;", "Landroidx/ui/semantics/AccessibilityAction;", "Lkotlin/Function0;", "T", "Lkotlin/Function;", "invocation", "Lkotlin/Function1;", "doClick", "doGesture", "block", "Landroidx/ui/test/GestureScope;", "Lkotlin/ExtensionFunctionType;", "doPartialGesture", "Landroidx/ui/test/PartialGestureScope;", "doScrollTo", "ui-test_release"})
public final class ActionsKt {
    @NotNull
    public static final SemanticsNodeInteraction doClick(@NotNull SemanticsNodeInteraction $this$doClick) {
        Intrinsics.checkNotNullParameter((Object)$this$doClick, (String)"<this>");
        return ActionsKt.doGesture($this$doClick, (Function1<? super GestureScope, Unit>)((Function1)new Function1<GestureScope, Unit>(){

            public final void invoke(@NotNull GestureScope gestureScope) {
                Intrinsics.checkNotNullParameter((Object)gestureScope, (String)"<this>");
                GestureScopeKt.sendClick(gestureScope);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SemanticsNodeInteraction doScrollTo(@NotNull SemanticsNodeInteraction $this$doScrollTo) {
        long l;
        void val1$iv$iv;
        void y$iv;
        void x$iv;
        void $this$px$iv32;
        void $this$px$iv22;
        float f;
        Intrinsics.checkNotNullParameter((Object)$this$doScrollTo, (String)"<this>");
        String errorMessageOnFail = "Failed to perform doScrollTo.";
        SemanticsNode node = $this$doScrollTo.fetchSemanticsNode(errorMessageOnFail);
        SemanticsNode semanticsNode = SemanticsNodeKt.findClosestParentNode((SemanticsNode)node, (Function1)((Function1)new Function1<SemanticsNode, Boolean>(){

            public final boolean invoke(@NotNull SemanticsNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FiltersKt.hasScrollAction().matches(it);
            }
        }));
        if (semanticsNode == null) {
            throw new AssertionError((Object)"Semantic Node has no parent layout with a Scroll SemanticsAction");
        }
        SemanticsNode scrollableSemanticsNode2 = semanticsNode;
        PxPosition globalPosition = node.getGlobalPosition();
        LayoutNode layoutNode2 = ComponentNodesKt.findLastLayoutChild((ComponentNode)scrollableSemanticsNode2.getComponentNode(), (Function1)((Function1)new Function1<LayoutNode, Boolean>(){

            public final boolean invoke(@NotNull LayoutNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return true;
            }
        }));
        if (layoutNode2 == null) {
            throw new AssertionError((Object)"No Layout Node found!");
        }
        LayoutNode layoutNode3 = layoutNode2;
        boolean bl = false;
        LayoutCoordinates layoutCoordinates = layoutNode3.getCoordinates();
        boolean $i$f$getPx = false;
        float $this$px$iv22 = f = Px.constructor-impl((float)((float)$this$px$iv22));
        $i$f$getPx = false;
        boolean $i$f$getPx2 = false;
        float $this$px$iv32 = f = Px.constructor-impl((float)((float)$this$px$iv32));
        boolean bl2 = false;
        void var10_15 = x$iv;
        void val2$iv$iv = y$iv;
        boolean $i$f$packFloats = false;
        void var13_18 = val1$iv$iv;
        boolean bl3 = false;
        long v1$iv$iv = Float.floatToIntBits((float)var13_18);
        void var17_21 = val2$iv$iv;
        boolean bl4 = false;
        long v2$iv$iv = Float.floatToIntBits((float)var17_21);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxPosition pxPosition = new PxPosition(l2);
        PxPosition position = layoutCoordinates.localToGlobal(pxPosition);
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(scrollableSemanticsNode2, globalPosition, position){
            private final /* synthetic */ SemanticsNode $scrollableSemanticsNode;
            private final /* synthetic */ PxPosition $globalPosition;
            private final /* synthetic */ PxPosition $position;
            {
                this.$scrollableSemanticsNode = $scrollableSemanticsNode;
                this.$globalPosition = $globalPosition;
                this.$position = $position;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$iv;
                void this_$iv52;
                float f;
                void this_$iv42;
                void other$iv;
                void $this$iv22;
                void this_$iv32;
                float f2;
                void this_$iv22;
                PxPosition pxPosition = this.$globalPosition;
                Function2 function2 = (Function2)((AccessibilityAction)this.$scrollableSemanticsNode.getConfig().get(SemanticsActions.Companion.getScrollTo())).getAction();
                boolean $i$f$getX22 = false;
                long value$iv$iv = this_$iv22.getValue();
                boolean $i$f$unpackFloat1 = false;
                FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
                int n = (int)(value$iv$iv >> 32);
                int n2 = 0;
                float $this$px$iv$iv22 = Float.intBitsToFloat(n);
                boolean $i$f$getPx = false;
                float this_$iv22 = f2 = Px.constructor-impl((float)$this$px$iv$iv22);
                PxPosition $i$f$getX22 = this.$position;
                boolean $i$f$getX = false;
                long value$iv$iv2 = this_$iv32.getValue();
                boolean $i$f$unpackFloat32 = false;
                FloatCompanionObject floatCompanionObject2 = FloatCompanionObject.INSTANCE;
                n2 = (int)(value$iv$iv2 >> 32);
                boolean $this$px$iv$iv22 = false;
                float $this$px$iv$iv = Float.intBitsToFloat(n2);
                boolean $i$f$getPx2 = false;
                float this_$iv32 = f2 = Px.constructor-impl((float)$this$px$iv$iv);
                boolean bl = false;
                f2 = Px.constructor-impl((float)($this$iv22 - other$iv));
                PxPosition $this$iv22 = this.$globalPosition;
                Px px = Px.box-impl((float)f2);
                boolean $i$f$getY22 = false;
                value$iv$iv = this_$iv42.getValue();
                boolean $i$f$unpackFloat2 = false;
                FloatCompanionObject $i$f$unpackFloat32 = FloatCompanionObject.INSTANCE;
                int n3 = (int)(value$iv$iv & 0xFFFFFFFFL);
                n2 = 0;
                float $this$px$iv$iv3 = Float.intBitsToFloat(n3);
                $i$f$getPx = false;
                float this_$iv42 = f = Px.constructor-impl((float)$this$px$iv$iv3);
                PxPosition $i$f$getY22 = this.$position;
                boolean $i$f$getY = false;
                value$iv$iv2 = this_$iv52.getValue();
                boolean $i$f$unpackFloat22 = false;
                FloatCompanionObject floatCompanionObject3 = FloatCompanionObject.INSTANCE;
                n2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
                boolean bl2 = false;
                $this$px$iv$iv = Float.intBitsToFloat(n2);
                $i$f$getPx2 = false;
                float this_$iv52 = f = Px.constructor-impl((float)$this$px$iv$iv);
                $i$f$minus-NgWp0Z8 = false;
                f = Px.constructor-impl((float)($this$iv - other$iv));
                function2.invoke((Object)px, (Object)Px.box-impl((float)f));
            }
        });
        return $this$doScrollTo;
    }

    @NotNull
    public static final SemanticsNodeInteraction doGesture(@NotNull SemanticsNodeInteraction $this$doGesture, @NotNull Function1<? super GestureScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$doGesture, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        GestureScope scope = new GestureScope($this$doGesture);
        block.invoke((Object)scope);
        return $this$doGesture;
    }

    @NotNull
    public static final SemanticsNodeInteraction doPartialGesture(@NotNull SemanticsNodeInteraction $this$doPartialGesture, @NotNull Function1<? super PartialGestureScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$doPartialGesture, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        PartialGestureScope scope = new PartialGestureScope($this$doPartialGesture);
        block.invoke((Object)scope);
        return $this$doPartialGesture;
    }

    public static final <T extends Function<? extends Unit>> void callSemanticsAction(@NotNull SemanticsNodeInteraction $this$callSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<T>> key, @NotNull Function1<? super T, Unit> invocation) {
        Intrinsics.checkNotNullParameter((Object)$this$callSemanticsAction, (String)"<this>");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(invocation, (String)"invocation");
        SemanticsNode node = $this$callSemanticsAction.fetchSemanticsNode("Failed to call " + key.getName() + " action.");
        if (!node.getConfig().contains(key)) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage("Failed to call " + key.getName() + " action as it is not defined on the node.", $this$callSemanticsAction.getSelector$ui_test_release(), node));
        }
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(invocation, node, key){
            private final /* synthetic */ Function1<T, Unit> $invocation;
            private final /* synthetic */ SemanticsNode $node;
            private final /* synthetic */ SemanticsPropertyKey<AccessibilityAction<T>> $key;
            {
                this.$invocation = $invocation;
                this.$node = $node;
                this.$key = $key;
                super(0);
            }

            public final void invoke() {
                this.$invocation.invoke((Object)((AccessibilityAction)this.$node.getConfig().get(this.$key)).getAction());
            }
        });
    }

    public static final void callSemanticsAction(@NotNull SemanticsNodeInteraction $this$callSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<Function0<Unit>>> key) {
        Intrinsics.checkNotNullParameter((Object)$this$callSemanticsAction, (String)"<this>");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        ActionsKt.callSemanticsAction($this$callSemanticsAction, key, (Function1)new Function1<Function0<? extends Unit>, Unit>(){

            public final void invoke(@NotNull Function0<Unit> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.invoke();
            }
        });
    }
}

