/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import android.util.DisplayMetrics;
import androidx.ui.core.ComponentNode;
import androidx.ui.core.ComponentNodesKt;
import androidx.ui.core.LayoutCoordinates;
import androidx.ui.core.LayoutNode;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.geometry.OffsetKt;
import androidx.ui.geometry.Rect;
import androidx.ui.semantics.AccessibilityRangeInfo;
import androidx.ui.test.ErrorMessagesKt;
import androidx.ui.test.FiltersKt;
import androidx.ui.test.SemanticsMatcher;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.SemanticsNodeInteractionCollection;
import androidx.ui.test.android.SynchronizedTreeCollector;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxBounds;
import androidx.ui.unit.PxPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\n\u001a\u00020\t*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\u000b\u001a\u00020\t*\u00020\t2\u0006\u0010\f\u001a\u00020\r\u001a\n\u0010\u000e\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u000f\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0010\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0011\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0012\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0013\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0014\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0015\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0016\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0017\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0018\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0019\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u001a\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u001b\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u001c\u001a\u00020\u0005*\u00020\u0005\u001a\u0012\u0010\u001d\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0012\u0010 \u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u001e\u001a\u00020!\u001a\u0012\u0010\"\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f\u001a\f\u0010#\u001a\u00020\u0001*\u00020\u0005H\u0002\u001a\u0014\u0010$\u001a\u00020\u0001*\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006&"}, d2={"isInScreenBounds", "", "rectangle", "Landroidx/ui/unit/PxBounds;", "assert", "Landroidx/ui/test/SemanticsNodeInteraction;", "matcher", "Landroidx/ui/test/SemanticsMatcher;", "assertAll", "Landroidx/ui/test/SemanticsNodeInteractionCollection;", "assertAny", "assertCountEquals", "expectedSize", "", "assertHasClickAction", "assertHasNoClickAction", "assertIsDisplayed", "assertIsEnabled", "assertIsHidden", "assertIsInMutuallyExclusiveGroup", "assertIsNotDisplayed", "assertIsNotEnabled", "assertIsNotHidden", "assertIsOff", "assertIsOn", "assertIsSelectable", "assertIsSelected", "assertIsToggleable", "assertIsUnselected", "assertLabelEquals", "value", "", "assertRangeInfoEquals", "Landroidx/ui/semantics/AccessibilityRangeInfo;", "assertValueEquals", "checkIsDisplayed", "contains", "Landroidx/ui/core/LayoutNode;", "ui-test_release"})
public final class AssertionsKt {
    @NotNull
    public static final SemanticsNodeInteraction assertIsHidden(@NotNull SemanticsNodeInteraction $this$assertIsHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsHidden, (String)"<this>");
        return AssertionsKt.assert($this$assertIsHidden, FiltersKt.isHidden());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotHidden(@NotNull SemanticsNodeInteraction $this$assertIsNotHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsNotHidden, (String)"<this>");
        return AssertionsKt.assert($this$assertIsNotHidden, FiltersKt.isNotHidden());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsDisplayed(@NotNull SemanticsNodeInteraction $this$assertIsDisplayed) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsDisplayed, (String)"<this>");
        if (!AssertionsKt.checkIsDisplayed($this$assertIsDisplayed)) {
            throw new AssertionError((Object)"Assert failed: The component is not displayed!");
        }
        return $this$assertIsDisplayed;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotDisplayed(@NotNull SemanticsNodeInteraction $this$assertIsNotDisplayed) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsNotDisplayed, (String)"<this>");
        if (AssertionsKt.checkIsDisplayed($this$assertIsNotDisplayed)) {
            throw new AssertionError((Object)"Assert failed: The component is displayed!");
        }
        return $this$assertIsNotDisplayed;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsEnabled(@NotNull SemanticsNodeInteraction $this$assertIsEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsEnabled, (String)"<this>");
        return AssertionsKt.assert($this$assertIsEnabled, FiltersKt.isEnabled());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotEnabled(@NotNull SemanticsNodeInteraction $this$assertIsNotEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsNotEnabled, (String)"<this>");
        return AssertionsKt.assert($this$assertIsNotEnabled, FiltersKt.isNotEnabled());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsOn(@NotNull SemanticsNodeInteraction $this$assertIsOn) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsOn, (String)"<this>");
        return AssertionsKt.assert($this$assertIsOn, FiltersKt.isOn());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsOff(@NotNull SemanticsNodeInteraction $this$assertIsOff) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsOff, (String)"<this>");
        return AssertionsKt.assert($this$assertIsOff, FiltersKt.isOff());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsSelected(@NotNull SemanticsNodeInteraction $this$assertIsSelected) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsSelected, (String)"<this>");
        return AssertionsKt.assert($this$assertIsSelected, FiltersKt.isSelected());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsUnselected(@NotNull SemanticsNodeInteraction $this$assertIsUnselected) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsUnselected, (String)"<this>");
        return AssertionsKt.assert($this$assertIsUnselected, FiltersKt.isUnselected());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsToggleable(@NotNull SemanticsNodeInteraction $this$assertIsToggleable) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsToggleable, (String)"<this>");
        return AssertionsKt.assert($this$assertIsToggleable, FiltersKt.isToggleable());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsSelectable(@NotNull SemanticsNodeInteraction $this$assertIsSelectable) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsSelectable, (String)"<this>");
        return AssertionsKt.assert($this$assertIsSelectable, FiltersKt.isSelectable());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsInMutuallyExclusiveGroup(@NotNull SemanticsNodeInteraction $this$assertIsInMutuallyExclusiveGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsInMutuallyExclusiveGroup, (String)"<this>");
        return AssertionsKt.assert($this$assertIsInMutuallyExclusiveGroup, FiltersKt.isInMutuallyExclusiveGroup());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertLabelEquals(@NotNull SemanticsNodeInteraction $this$assertLabelEquals, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertLabelEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert($this$assertLabelEquals, FiltersKt.hasText$default(value, false, 2, null));
    }

    @NotNull
    public static final SemanticsNodeInteraction assertValueEquals(@NotNull SemanticsNodeInteraction $this$assertValueEquals, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertValueEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert($this$assertValueEquals, FiltersKt.hasValue(value));
    }

    @NotNull
    public static final SemanticsNodeInteraction assertRangeInfoEquals(@NotNull SemanticsNodeInteraction $this$assertRangeInfoEquals, @NotNull AccessibilityRangeInfo value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertRangeInfoEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert($this$assertRangeInfoEquals, FiltersKt.hasRangeInfo(value));
    }

    @NotNull
    public static final SemanticsNodeInteraction assertHasClickAction(@NotNull SemanticsNodeInteraction $this$assertHasClickAction) {
        Intrinsics.checkNotNullParameter((Object)$this$assertHasClickAction, (String)"<this>");
        return AssertionsKt.assert($this$assertHasClickAction, FiltersKt.hasClickAction());
    }

    @NotNull
    public static final SemanticsNodeInteraction assertHasNoClickAction(@NotNull SemanticsNodeInteraction $this$assertHasNoClickAction) {
        Intrinsics.checkNotNullParameter((Object)$this$assertHasNoClickAction, (String)"<this>");
        return AssertionsKt.assert($this$assertHasNoClickAction, FiltersKt.hasNoClickAction());
    }

    @NotNull
    public static final SemanticsNodeInteraction assert(@NotNull SemanticsNodeInteraction $this$assert, @NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)$this$assert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String errorMessageOnFail = "Failed to assert the following: (" + matcher.getDescription() + ")";
        SemanticsNode node = $this$assert.fetchSemanticsNode(errorMessageOnFail);
        if (!matcher.matches(node)) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForMatcherFail($this$assert.getSelector$ui_test_release(), node, matcher));
        }
        return $this$assert;
    }

    @NotNull
    public static final SemanticsNodeInteractionCollection assertCountEquals(@NotNull SemanticsNodeInteractionCollection $this$assertCountEquals, int expectedSize) {
        Intrinsics.checkNotNullParameter((Object)$this$assertCountEquals, (String)"<this>");
        String errorOnFail = "Failed to assert count of nodes.";
        List<SemanticsNode> matchedNodes = $this$assertCountEquals.fetchSemanticsNodes(errorOnFail);
        if (matchedNodes.size() != expectedSize) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForCountMismatch(errorOnFail, $this$assertCountEquals.getSelector$ui_test_release(), matchedNodes, expectedSize));
        }
        return $this$assertCountEquals;
    }

    @NotNull
    public static final SemanticsNodeInteractionCollection assertAny(@NotNull SemanticsNodeInteractionCollection $this$assertAny, @NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)$this$assertAny, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String errorOnFail = "Failed to assertAny(" + matcher.getDescription() + ")";
        List<SemanticsNode> nodes = $this$assertAny.fetchSemanticsNodes(errorOnFail);
        if (nodes.isEmpty()) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForAtLeastOneNodeExpected(errorOnFail, $this$assertAny.getSelector$ui_test_release()));
        }
        if (!matcher.matchesAny((Iterable<SemanticsNode>)nodes)) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForAssertAnyFail($this$assertAny.getSelector$ui_test_release(), nodes, matcher));
        }
        return $this$assertAny;
    }

    @NotNull
    public static final SemanticsNodeInteractionCollection assertAll(@NotNull SemanticsNodeInteractionCollection $this$assertAll, @NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)$this$assertAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String errorOnFail = "Failed to assertAll(" + matcher.getDescription() + ")";
        List<SemanticsNode> nodes = $this$assertAll.fetchSemanticsNodes(errorOnFail);
        boolean bl = false;
        List violations = new ArrayList();
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SemanticsNode it = (SemanticsNode)element$iv;
            boolean bl2 = false;
            if (matcher.matches(it)) continue;
            violations.add(it);
        }
        Collection collection = violations;
        boolean bl3 = false;
        if (!collection.isEmpty()) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForAssertAllFail($this$assertAll.getSelector$ui_test_release(), violations, matcher));
        }
        return $this$assertAll;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkIsDisplayed(SemanticsNodeInteraction $this$checkIsDisplayed) {
        void $this$px$iv;
        float $this$iv$iv;
        String errorMessageOnFail = "Failed to perform isDisplayed check.";
        SemanticsNode node = $this$checkIsDisplayed.fetchSemanticsNode(errorMessageOnFail);
        if (ComponentNodesKt.findClosestParentNode((ComponentNode)node.getComponentNode(), (Function1)((Function1)new Function1<ComponentNode, Boolean>(){

            public final boolean invoke(@NotNull ComponentNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it instanceof LayoutNode && !((LayoutNode)it).isPlaced();
            }
        })) != null) {
            return false;
        }
        PxBounds globalRect = node.getGlobalBounds();
        if (!AssertionsKt.isInScreenBounds(globalRect)) {
            return false;
        }
        PxBounds $this$width$iv22 = globalRect;
        boolean $i$f$getWidth = false;
        float f = $this$width$iv22.getRight();
        float other$iv$iv = $this$width$iv22.getLeft();
        boolean bl = false;
        boolean $this$width$iv22 = false;
        float f2 = Px.constructor-impl((float)($this$iv$iv - other$iv$iv));
        boolean $i$f$getPx = false;
        float f3 = Px.constructor-impl((float)((float)$this$px$iv));
        if (Px.compareTo-NgWp0Z8((float)f2, (float)f3) <= 0) return false;
        PxBounds $this$height$iv22 = globalRect;
        boolean $i$f$getHeight = false;
        $this$iv$iv = $this$height$iv22.getBottom();
        other$iv$iv = $this$height$iv22.getTop();
        bl = false;
        boolean $this$height$iv22 = false;
        f2 = Px.constructor-impl((float)($this$iv$iv - other$iv$iv));
        $i$f$getPx = false;
        f3 = Px.constructor-impl((float)((float)$this$px$iv));
        if (Px.compareTo-NgWp0Z8((float)f2, (float)f3) <= 0) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInScreenBounds(@NotNull PxBounds rectangle) {
        PxPosition this_$iv;
        boolean $this$px$iv;
        long l;
        void val1$iv$iv;
        void x$iv22;
        void $this$px$iv2;
        float $this$iv$iv;
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        PxBounds $this$width$iv22 = rectangle;
        boolean $i$f$getWidth = false;
        float f = $this$width$iv22.getRight();
        float other$iv$iv = $this$width$iv22.getLeft();
        boolean bl = false;
        boolean $this$width$iv22 = false;
        float f2 = Px.constructor-impl((float)($this$iv$iv - other$iv$iv));
        boolean $i$f$getPx = false;
        float f3 = Px.constructor-impl((float)((float)$this$px$iv2));
        if (Px.equals-impl0((float)f2, (float)f3)) {
            PxBounds $this$height$iv22 = rectangle;
            boolean $i$f$getHeight = false;
            $this$iv$iv = $this$height$iv22.getBottom();
            other$iv$iv = $this$height$iv22.getTop();
            bl = false;
            boolean $this$height$iv22 = false;
            f2 = Px.constructor-impl((float)($this$iv$iv - other$iv$iv));
            $i$f$getPx = false;
            f3 = Px.constructor-impl((float)((float)$this$px$iv2));
            if (Px.equals-impl0((float)f2, (float)f3)) {
                return false;
            }
        }
        DisplayMetrics displayMetrics = SynchronizedTreeCollector.INSTANCE.collectOwners$ui_test_release().findActivity().getResources().getDisplayMetrics();
        int $this$px$iv222 = displayMetrics.widthPixels;
        boolean $i$f$getPx2 = false;
        float $this$px$iv222 = Px.constructor-impl((float)$this$px$iv222);
        int $this$px$iv3 = displayMetrics.heightPixels;
        boolean $i$f$getPx3 = false;
        float y$iv = Px.constructor-impl((float)$this$px$iv3);
        boolean bl2 = false;
        void var6_20 = x$iv22;
        float val2$iv$iv = y$iv;
        boolean $i$f$packFloats = false;
        void var9_25 = val1$iv$iv;
        boolean bl3 = false;
        long v1$iv$iv = Float.floatToIntBits((float)var9_25);
        float f4 = val2$iv$iv;
        boolean bl4 = false;
        long v2$iv$iv = Float.floatToIntBits(f4);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxPosition bottomRight = new PxPosition(l2);
        boolean x$iv22 = false;
        f2 = rectangle.getTop();
        $i$f$getPx = false;
        f3 = Px.constructor-impl((float)((float)$this$px$iv));
        if (Px.compareTo-NgWp0Z8((float)f2, (float)f3) < 0) return false;
        $this$px$iv = false;
        f2 = rectangle.getLeft();
        $i$f$getPx = false;
        f3 = Px.constructor-impl((float)((float)$this$px$iv));
        if (Px.compareTo-NgWp0Z8((float)f2, (float)f3) < 0) return false;
        PxPosition $this$px$iv32 = bottomRight;
        f2 = rectangle.getRight();
        boolean $i$f$getX = false;
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv >> 32);
        bl3 = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n);
        boolean $i$f$getPx4 = false;
        f3 = Px.constructor-impl((float)$this$px$iv$iv);
        if (Px.compareTo-NgWp0Z8((float)f2, (float)f3) > 0) return false;
        this_$iv = bottomRight;
        f2 = rectangle.getBottom();
        boolean $i$f$getY = false;
        value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat2 = false;
        floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv & 0xFFFFFFFFL);
        bl3 = false;
        $this$px$iv$iv = Float.intBitsToFloat(n);
        $i$f$getPx4 = false;
        f3 = Px.constructor-impl((float)$this$px$iv$iv);
        if (Px.compareTo-NgWp0Z8((float)f2, (float)f3) > 0) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean contains(LayoutNode $this$contains, PxBounds rectangle) {
        int $receiver$iv;
        PxPosition this_$iv;
        PxPosition globalPositionTopLeft;
        long l;
        void val1$iv$iv;
        void y$iv22;
        void x$iv;
        void $this$px$iv32;
        void $this$px$iv22;
        float f;
        boolean bl = false;
        LayoutCoordinates layoutCoordinates = $this$contains.getCoordinates();
        boolean $i$f$getPx = false;
        float $this$px$iv22 = f = Px.constructor-impl((float)((float)$this$px$iv22));
        $i$f$getPx = false;
        boolean $i$f$getPx2 = false;
        float $this$px$iv32 = f = Px.constructor-impl((float)((float)$this$px$iv32));
        boolean bl2 = false;
        void var6_14 = x$iv;
        void val2$iv$iv = y$iv22;
        boolean $i$f$packFloats = false;
        void var9_20 = val1$iv$iv;
        int n = 0;
        long v1$iv$iv = Float.floatToIntBits((float)var9_20);
        void var13_25 = val2$iv$iv;
        boolean bl3 = false;
        long v2$iv$iv = Float.floatToIntBits((float)var13_25);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxPosition pxPosition = new PxPosition(l2);
        PxPosition y$iv22 = globalPositionTopLeft = layoutCoordinates.localToGlobal(pxPosition);
        layoutCoordinates = Rect.Companion;
        boolean $i$f$getX = false;
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv >> 32);
        boolean bl4 = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n);
        boolean $i$f$getPx3 = false;
        float f2 = Px.constructor-impl((float)$this$px$iv$iv);
        this_$iv = globalPositionTopLeft;
        boolean $i$f$getY = false;
        value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat2 = false;
        floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv & 0xFFFFFFFFL);
        bl4 = false;
        $this$px$iv$iv = Float.intBitsToFloat(n);
        $i$f$getPx3 = false;
        float f3 = Px.constructor-impl((float)$this$px$iv$iv);
        int this_$iv2 = $this$contains.getWidth();
        boolean bl5 = false;
        int $this$px$iv$iv2 = $receiver$iv;
        boolean $i$f$getPx4 = false;
        float f4 = Px.constructor-impl((float)$this$px$iv$iv2);
        $receiver$iv = $this$contains.getHeight();
        bl5 = false;
        $this$px$iv$iv2 = $receiver$iv;
        $i$f$getPx4 = false;
        float f5 = Px.constructor-impl((float)$this$px$iv$iv2);
        Rect rect = layoutCoordinates.fromLTWH(f2, f3, f4 += 1.0f, f5 + 1.0f);
        return rect.contains-RIqb49o(OffsetKt.Offset((float)rectangle.getLeft(), (float)rectangle.getTop())) && rect.contains-RIqb49o(OffsetKt.Offset((float)rectangle.getRight(), (float)rectangle.getBottom()));
    }
}

