/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.semantics.SemanticsConfiguration;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.semantics.SemanticsPropertyKey;
import androidx.ui.test.SemanticsMatcher;
import androidx.ui.test.SemanticsSelector;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxBounds;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a&\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a0\u0010\r\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a \u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a \u0010\u0013\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0001H\u0000\u001a \u0010\u0015\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0006H\u0000\u001a&\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u001c*\u00060\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\f\u0010!\u001a\u00020\u0001*\u00020\u0006H\u0000\u001a\u0012\u0010!\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00060\"H\u0000\u00a8\u0006#"}, d2={"buildErrorMessageForAssertAllFail", "", "selector", "Landroidx/ui/test/SemanticsSelector;", "nodesNotMatching", "", "Landroidx/ui/core/semantics/SemanticsNode;", "assertionMatcher", "Landroidx/ui/test/SemanticsMatcher;", "buildErrorMessageForAssertAnyFail", "nodes", "buildErrorMessageForAtLeastOneNodeExpected", "errorMessage", "buildErrorMessageForCountMismatch", "foundNodes", "expectedCount", "", "buildErrorMessageForMatcherFail", "node", "buildErrorMessageForNodeMissingInTree", "lastSeenSemantics", "buildGeneralErrorMessage", "buildIndexErrorMessage", "index", "pxBoundsToShortString", "bounds", "Landroidx/ui/unit/PxBounds;", "appendConfigInfo", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "config", "Landroidx/ui/core/semantics/SemanticsConfiguration;", "toStringInfo", "", "ui-test_release"})
public final class ErrorMessagesKt {
    @NotNull
    public static final String buildErrorMessageForCountMismatch(@NotNull String errorMessage, @Nullable SemanticsSelector selector, @NotNull List<SemanticsNode> foundNodes, int expectedCount) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter(foundNodes, (String)"foundNodes");
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        sb.append("\n");
        sb.append("Reason: ");
        switch (expectedCount) {
            case 0: {
                sb.append("Did not expect any node");
                break;
            }
            case 1: {
                sb.append("Expected exactly '1' node");
                break;
            }
            default: {
                sb.append("Expected '" + expectedCount + "' nodes");
            }
        }
        if (foundNodes.isEmpty()) {
            sb.append(" but could not find any");
        } else {
            sb.append(" but found '" + foundNodes.size() + "'");
        }
        if (selector != null) {
            if (foundNodes.size() <= 1) {
                sb.append(" node that satisfies: (" + selector.getDescription() + ")");
            } else {
                sb.append(" nodes that satisfy: (" + selector.getDescription() + ")");
            }
        } else {
            sb.append(".");
        }
        StringsKt.appendln((StringBuilder)sb);
        Object object = foundNodes;
        boolean bl = false;
        if (!object.isEmpty()) {
            boolean bl2;
            String string;
            if (foundNodes.size() == 1) {
                object = sb;
                string = "Node found:";
                bl2 = false;
                StringBuilder stringBuilder = ((StringBuilder)object).append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
            } else {
                object = sb;
                string = "Nodes found:";
                bl2 = false;
                StringBuilder stringBuilder = ((StringBuilder)object).append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
            }
            object = sb;
            string = ErrorMessagesKt.toStringInfo((Collection<SemanticsNode>)foundNodes);
            bl2 = false;
            StringBuilder stringBuilder = ((StringBuilder)object).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
        }
        object = String.valueOf(sb);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
        return object;
    }

    @NotNull
    public static final String buildErrorMessageForNodeMissingInTree(@NotNull String errorMessage, @NotNull SemanticsSelector selector, @NotNull String lastSeenSemantics) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)lastSeenSemantics, (String)"lastSeenSemantics");
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        sb.append("\n");
        CharSequence charSequence = sb;
        String string = "The node is no longer in the tree, last known semantics:";
        boolean bl = false;
        StringBuilder stringBuilder = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        charSequence = sb;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = charSequence.append(lastSeenSemantics);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        sb.append("Original selector: ");
        charSequence = sb;
        String string2 = selector.getDescription();
        bl = false;
        StringBuilder stringBuilder3 = charSequence.append(string2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        charSequence = String.valueOf(sb);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @NotNull
    public static final String buildErrorMessageForMatcherFail(@NotNull SemanticsSelector selector, @NotNull SemanticsNode node, @NotNull SemanticsMatcher assertionMatcher) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)assertionMatcher, (String)"assertionMatcher");
        return ErrorMessagesKt.buildGeneralErrorMessage("Failed to assert that node satisfies the following condition: (" + assertionMatcher.getDescription() + ")", selector, node);
    }

    @NotNull
    public static final String buildErrorMessageForAssertAnyFail(@NotNull SemanticsSelector selector, @NotNull List<SemanticsNode> nodes, @NotNull SemanticsMatcher assertionMatcher) {
        StringBuilder sb;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)assertionMatcher, (String)"assertionMatcher");
        CharSequence charSequence = sb = new StringBuilder();
        String string = "Failed to assertAny(" + assertionMatcher.getDescription() + ")";
        boolean bl = false;
        StringBuilder stringBuilder = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        charSequence = sb;
        string = "None of the following nodes match:";
        bl = false;
        StringBuilder stringBuilder2 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        charSequence = sb;
        string = ErrorMessagesKt.toStringInfo((Collection<SemanticsNode>)nodes);
        bl = false;
        StringBuilder stringBuilder3 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        sb.append("Selector used: '");
        sb.append(selector.getDescription());
        charSequence = sb;
        string = "'";
        bl = false;
        StringBuilder stringBuilder4 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        charSequence = String.valueOf(sb);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @NotNull
    public static final String buildErrorMessageForAssertAllFail(@NotNull SemanticsSelector selector, @NotNull List<SemanticsNode> nodesNotMatching, @NotNull SemanticsMatcher assertionMatcher) {
        StringBuilder sb;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter(nodesNotMatching, (String)"nodesNotMatching");
        Intrinsics.checkNotNullParameter((Object)assertionMatcher, (String)"assertionMatcher");
        CharSequence charSequence = sb = new StringBuilder();
        String string = "Failed to assertAll(" + assertionMatcher.getDescription() + ")";
        boolean bl = false;
        StringBuilder stringBuilder = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        sb.append("Found '" + nodesNotMatching.size() + "' ");
        sb.append(nodesNotMatching.size() == 1 ? "node" : "nodes");
        charSequence = sb;
        string = " not matching:";
        bl = false;
        StringBuilder stringBuilder2 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        charSequence = sb;
        string = ErrorMessagesKt.toStringInfo((Collection<SemanticsNode>)nodesNotMatching);
        bl = false;
        StringBuilder stringBuilder3 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        sb.append("Selector used: '");
        sb.append(selector.getDescription());
        charSequence = sb;
        string = "'";
        bl = false;
        StringBuilder stringBuilder4 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        charSequence = String.valueOf(sb);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @NotNull
    public static final String buildErrorMessageForAtLeastOneNodeExpected(@NotNull String errorMessage, @NotNull SemanticsSelector selector) {
        StringBuilder sb;
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        CharSequence charSequence = sb = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder = charSequence.append(errorMessage);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        sb.append("Assert needs to receive at least 1 node but 0 nodes were found for selector: ");
        sb.append("'");
        sb.append(selector.getDescription());
        charSequence = sb;
        String string = "'";
        boolean bl2 = false;
        StringBuilder stringBuilder2 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        charSequence = String.valueOf(sb);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @NotNull
    public static final String buildGeneralErrorMessage(@NotNull String errorMessage, @NotNull SemanticsSelector selector, @NotNull SemanticsNode node) {
        StringBuilder sb;
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        CharSequence charSequence = sb = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder = charSequence.append(errorMessage);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        charSequence = sb;
        String string = "Semantics of the node:";
        boolean bl2 = false;
        StringBuilder stringBuilder2 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        charSequence = sb;
        string = ErrorMessagesKt.toStringInfo(node);
        bl2 = false;
        StringBuilder stringBuilder3 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        sb.append("Selector used: (");
        sb.append(selector.getDescription());
        charSequence = sb;
        string = ")";
        bl2 = false;
        StringBuilder stringBuilder4 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        charSequence = String.valueOf(sb);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @NotNull
    public static final String buildIndexErrorMessage(int index, @NotNull SemanticsSelector selector, @NotNull List<SemanticsNode> nodes) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        StringBuilder sb = new StringBuilder();
        sb.append("Can't retrieve node at index '" + index + "' of '");
        sb.append(selector.getDescription());
        CharSequence charSequence = sb;
        String string = "'";
        boolean bl = false;
        StringBuilder stringBuilder = ((StringBuilder)charSequence).append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        if (nodes.isEmpty()) {
            charSequence = sb;
            string = "There are no existing nodes for that selector.";
            bl = false;
            StringBuilder stringBuilder2 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
        } else if (nodes.size() == 1) {
            charSequence = sb;
            string = "There is 1 node only:";
            bl = false;
            StringBuilder stringBuilder3 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
            charSequence = sb;
            string = ErrorMessagesKt.toStringInfo((Collection<SemanticsNode>)nodes);
            bl = false;
            StringBuilder stringBuilder4 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
        } else {
            charSequence = sb;
            string = "There are '" + nodes.size() + "' nodes only:";
            bl = false;
            StringBuilder stringBuilder5 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
            charSequence = sb;
            string = ErrorMessagesKt.toStringInfo((Collection<SemanticsNode>)nodes);
            bl = false;
            StringBuilder stringBuilder6 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
        }
        charSequence = String.valueOf(sb);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @NotNull
    public static final String toStringInfo(@NotNull Collection<SemanticsNode> $this$toStringInfo) {
        Intrinsics.checkNotNullParameter($this$toStringInfo, (String)"<this>");
        Ref.ObjectRef sb = new Ref.ObjectRef();
        sb.element = new StringBuilder();
        Ref.IntRef i = new Ref.IntRef();
        i.element = 1;
        Iterable $this$forEach$iv = $this$toStringInfo;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SemanticsNode it = (SemanticsNode)element$iv;
            boolean bl = false;
            if ($this$toStringInfo.size() > 1) {
                ((StringBuilder)sb.element).append(i.element);
                ((StringBuilder)sb.element).append(") ");
            }
            ((StringBuilder)sb.element).append(ErrorMessagesKt.toStringInfo(it));
            if (i.element < $this$toStringInfo.size()) {
                StringsKt.appendln((StringBuilder)((StringBuilder)sb.element));
            }
            ++i.element;
            int cfr_ignored_0 = i.element;
        }
        String string = String.valueOf((StringBuilder)sb.element);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String toStringInfo(@NotNull SemanticsNode $this$toStringInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$toStringInfo, (String)"<this>");
        StringBuilder sb = new StringBuilder();
        sb.append("Id: " + $this$toStringInfo.getId() + ", Position: ");
        CharSequence charSequence = sb;
        String string = ErrorMessagesKt.pxBoundsToShortString($this$toStringInfo.getGlobalBounds());
        boolean bl = false;
        StringBuilder stringBuilder = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        ErrorMessagesKt.appendConfigInfo(sb, $this$toStringInfo.getConfig());
        charSequence = String.valueOf(sb);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    private static final String pxBoundsToShortString(PxBounds bounds) {
        return "LTRB(" + Px.toString-impl((float)bounds.getLeft()) + ", " + Px.toString-impl((float)bounds.getTop()) + ", " + Px.toString-impl((float)bounds.getRight()) + ", " + Px.toString-impl((float)bounds.getBottom()) + ")";
    }

    private static final void appendConfigInfo(StringBuilder $this$appendConfigInfo, SemanticsConfiguration config) {
        String prefix = "- ";
        String separator = "\n";
        int startLength = $this$appendConfigInfo.length();
        Iterator iterator2 = config.iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
            boolean bl = false;
            SemanticsPropertyKey key = (SemanticsPropertyKey)entry2.getKey();
            Map.Entry entry3 = entry;
            boolean bl2 = false;
            Object value = entry3.getValue();
            $this$appendConfigInfo.append(prefix);
            $this$appendConfigInfo.append(key.getName());
            $this$appendConfigInfo.append(" = '");
            $this$appendConfigInfo.append(value);
            $this$appendConfigInfo.append("'");
            $this$appendConfigInfo.append(separator);
        }
        if (config.isSemanticBoundary()) {
            $this$appendConfigInfo.append(prefix);
            $this$appendConfigInfo.append("Boundary = 'true'");
            $this$appendConfigInfo.append(separator);
        }
        if (config.isMergingSemanticsOfDescendants()) {
            $this$appendConfigInfo.append(prefix);
            $this$appendConfigInfo.append("MergeDescendants = 'true'");
            $this$appendConfigInfo.append(separator);
        }
        if ($this$appendConfigInfo.length() > startLength) {
            $this$appendConfigInfo.setLength($this$appendConfigInfo.length() - separator.length());
        }
    }
}

