/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.ViewGroup;
import android.view.Window;
import androidx.activity.ComponentActivity;
import androidx.annotation.RequiresApi;
import androidx.compose.Composable;
import androidx.compose.Composer;
import androidx.compose.ComposerValidator;
import androidx.compose.Composition;
import androidx.compose.Recomposer;
import androidx.compose.ScopeUpdateScope;
import androidx.test.rule.ActivityTestRule;
import androidx.ui.animation.TransitionKt;
import androidx.ui.core.WrapperKt;
import androidx.ui.geometry.Rect;
import androidx.ui.test.AnimationClockTestRule;
import androidx.ui.test.ComposeTestCase;
import androidx.ui.test.ComposeTestCaseSetup;
import androidx.ui.test.ComposeTestRule;
import androidx.ui.test.SynchronizationKt;
import androidx.ui.test.android.AndroidComposeTestCaseSetup;
import androidx.ui.test.android.AndroidComposeTestRule;
import androidx.ui.test.android.AndroidOwnerRegistry;
import androidx.ui.test.android.ComposeIdlingResourceKt;
import androidx.ui.test.android.WindowCaptureKt;
import androidx.ui.unit.Density;
import androidx.ui.unit.DensityKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u00010B$\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\tJ\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020%H\u0017J \u0010&\u001a\u00020'2\u0011\u0010(\u001a\r\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\u0002\b)H\u0016\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-H\u0016J \u0010.\u001a\u00020\u001a2\u0011\u0010(\u001a\r\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\u0002\b)H\u0016\u00a2\u0006\u0002\u0010/R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00061"}, d2={"Landroidx/ui/test/android/AndroidComposeTestRule;", "T", "Landroidx/activity/ComponentActivity;", "Landroidx/ui/test/ComposeTestRule;", "activityTestRule", "Landroidx/test/rule/ActivityTestRule;", "recomposer", "Landroidx/compose/Recomposer;", "disableTransitions", "", "getActivityTestRule", "()Landroidx/test/rule/ActivityTestRule;", "clockTestRule", "Landroidx/ui/test/AnimationClockTestRule;", "getClockTestRule", "()Landroidx/ui/test/AnimationClockTestRule;", "density", "Landroidx/ui/unit/Density;", "getDensity", "()Landroidx/ui/unit/Density;", "displayMetrics", "Landroid/util/DisplayMetrics;", "getDisplayMetrics", "()Landroid/util/DisplayMetrics;", "disposeContentHook", "Lkotlin/Function0;", "", "handler", "Landroid/os/Handler;", "getRecomposer", "()Landroidx/compose/Recomposer;", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "captureScreenOnIdle", "Landroid/graphics/Bitmap;", "forGivenContent", "Landroidx/ui/test/ComposeTestCaseSetup;", "composable", "Landroidx/compose/Composable;", "(Lkotlin/jvm/functions/Function1;)Landroidx/ui/test/ComposeTestCaseSetup;", "forGivenTestCase", "testCase", "Landroidx/ui/test/ComposeTestCase;", "setContent", "(Lkotlin/jvm/functions/Function1;)V", "AndroidComposeStatement", "ui-test_release"})
public final class AndroidComposeTestRule<T extends ComponentActivity>
implements ComposeTestRule {
    private final ActivityTestRule<T> activityTestRule;
    private final Recomposer recomposer;
    private final boolean disableTransitions;
    private final AnimationClockTestRule clockTestRule;
    private final Handler handler;
    private Function0<Unit> disposeContentHook;

    public AndroidComposeTestRule(@NotNull ActivityTestRule<T> activityTestRule, @Nullable Recomposer recomposer, boolean disableTransitions) {
        Intrinsics.checkNotNullParameter(activityTestRule, (String)"activityTestRule");
        this.activityTestRule = activityTestRule;
        this.recomposer = recomposer;
        this.disableTransitions = disableTransitions;
        this.clockTestRule = new AnimationClockTestRule();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public /* synthetic */ AndroidComposeTestRule(ActivityTestRule activityTestRule, Recomposer recomposer, boolean disableTransitions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            recomposer = null;
        }
        if ((n & 4) != 0) {
            disableTransitions = false;
        }
        this(activityTestRule, recomposer, disableTransitions);
    }

    @NotNull
    public final ActivityTestRule<T> getActivityTestRule() {
        return this.activityTestRule;
    }

    @Nullable
    public final Recomposer getRecomposer() {
        return this.recomposer;
    }

    @Override
    @NotNull
    public AnimationClockTestRule getClockTestRule() {
        return this.clockTestRule;
    }

    @Override
    @NotNull
    public Density getDensity() {
        ComponentActivity componentActivity = (ComponentActivity)this.getActivityTestRule().getActivity();
        Intrinsics.checkNotNullExpressionValue((Object)componentActivity, (String)"activityTestRule.activity");
        return DensityKt.Density((Context)((Context)componentActivity));
    }

    @Override
    @NotNull
    public DisplayMetrics getDisplayMetrics() {
        DisplayMetrics displayMetrics = ((ComponentActivity)this.getActivityTestRule().getActivity()).getResources().getDisplayMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"activityTestRule.activity.resources.displayMetrics");
        return displayMetrics;
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @Nullable Description description) {
        Statement activityTestRuleStatement;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Statement statement = activityTestRuleStatement = this.getActivityTestRule().apply(base, description);
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"activityTestRuleStatement");
        AndroidComposeStatement composeTestRuleStatement = new AndroidComposeStatement(statement);
        return this.getClockTestRule().apply(composeTestRuleStatement, description);
    }

    @Override
    public void setContent(@NotNull Function1<? super Composer<?>, Unit> composable) {
        Intrinsics.checkNotNullParameter(composable, (String)"composable");
        boolean bl = this.disposeContentHook == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot call setContent twice per test!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(this, composable){
            private final /* synthetic */ AndroidComposeTestRule<T> $this;
            private final /* synthetic */ Function1<Composer<?>, Unit> $composable;
            {
                this.$this = $receiver;
                this.$composable = $composable;
                super(0);
            }

            public final void invoke() {
                ComponentActivity componentActivity = (ComponentActivity)this.$this.getActivityTestRule().getActivity();
                Intrinsics.checkNotNullExpressionValue((Object)componentActivity, (String)"activityTestRule.activity");
                ComponentActivity componentActivity2 = componentActivity;
                componentActivity = this.$this.getRecomposer();
                Composition composition = WrapperKt.setContent((ComponentActivity)componentActivity2, (Recomposer)(componentActivity == null ? Recomposer.Companion.current() : componentActivity), this.$composable);
                ViewGroup contentViewGroup = (ViewGroup)((ComponentActivity)this.$this.getActivityTestRule().getActivity()).findViewById(0x1020002);
                contentViewGroup.getChildAt(0).restoreHierarchyState(new SparseArray());
                AndroidComposeTestRule.access$setDisposeContentHook$p(this.$this, (Function0)new Function0<Unit>(composition){
                    private final /* synthetic */ Composition $composition;
                    {
                        this.$composition = $composition;
                        super(0);
                    }

                    public final void invoke() {
                        this.$composition.dispose();
                    }
                });
            }
        });
        if (!SynchronizationKt.isOnUiThread()) {
            SynchronizationKt.waitForIdle();
        }
    }

    @Override
    @NotNull
    public ComposeTestCaseSetup forGivenContent(@NotNull Function1<? super Composer<?>, Unit> composable) {
        Intrinsics.checkNotNullParameter(composable, (String)"composable");
        return this.forGivenTestCase(new ComposeTestCase(composable){
            private final /* synthetic */ Function1<Composer<?>, Unit> $composable;
            {
                this.$composable = $composable;
            }

            /*
             * WARNING - void declaration
             */
            @Composable
            public void emitContent(@Nullable Composer<?> $composer) {
                void this_$iv;
                $composer.startRestartGroup(-802665162);
                ScopeUpdateScope scopeUpdateScope = $composer;
                Object object = this.$composable;
                ScopeUpdateScope scopeUpdateScope2 = $composer;
                Integer key$iv = 1778170701;
                boolean $i$f$call = false;
                this_$iv.startGroup((Object)key$iv);
                ComposerValidator $this$emitContent_u24lambda_u2d0 = (ComposerValidator)this_$iv;
                boolean bl = false;
                if ($this$emitContent_u24lambda_u2d0.changed(object) || !this_$iv.getSkipping()) {
                    boolean bl2 = false;
                    object.invoke(scopeUpdateScope);
                } else {
                    this_$iv.skipToGroupEnd();
                }
                this_$iv.endGroup();
                scopeUpdateScope = $composer.endRestartGroup();
                object = this;
                if (scopeUpdateScope != null) {
                    scopeUpdateScope.updateScope((Function1)new Function1<Composer<?>, Unit>(object){
                        private final /* synthetic */ forGivenContent.1 $tmp1_rcvr;
                        {
                            this.$tmp1_rcvr = $tmp1_rcvr;
                            super(1);
                        }

                        public final void invoke(@Nullable Composer<N> $composer) {
                            this.$tmp1_rcvr.emitContent($composer);
                        }
                    });
                }
            }
        });
    }

    @Override
    @NotNull
    public ComposeTestCaseSetup forGivenTestCase(@NotNull ComposeTestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        ComponentActivity componentActivity = (ComponentActivity)this.getActivityTestRule().getActivity();
        Intrinsics.checkNotNullExpressionValue((Object)componentActivity, (String)"activityTestRule.activity");
        return new AndroidComposeTestCaseSetup(testCase, componentActivity);
    }

    @Override
    @RequiresApi(value=26)
    @NotNull
    public Bitmap captureScreenOnIdle() {
        SynchronizationKt.waitForIdle();
        ViewGroup contentView = (ViewGroup)((ComponentActivity)this.getActivityTestRule().getActivity()).findViewById(0x1020002);
        Rect screenRect = Rect.Companion.fromLTWH(0.0f, 0.0f, (float)contentView.getWidth(), (float)contentView.getHeight());
        Window window = ((ComponentActivity)this.getActivityTestRule().getActivity()).getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activityTestRule.activity.window");
        return WindowCaptureKt.captureRegionToBitmap(screenRect, this.handler, window);
    }

    public static final /* synthetic */ void access$setDisposeContentHook$p(AndroidComposeTestRule androidComposeTestRule, Function0 function0) {
        androidComposeTestRule.disposeContentHook = function0;
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0001J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/ui/test/android/AndroidComposeTestRule$AndroidComposeStatement;", "Lorg/junit/runners/model/Statement;", "base", "afterEvaluate", "", "beforeEvaluate", "evaluate", "ui-test_release"})
    public final class AndroidComposeStatement
    extends Statement {
        private final Statement base;

        public AndroidComposeStatement(Statement base) {
            Intrinsics.checkNotNullParameter((Object)AndroidComposeTestRule.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            this.base = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() {
            this.beforeEvaluate();
            try {
                this.base.evaluate();
            }
            finally {
                this.afterEvaluate();
            }
        }

        private final void beforeEvaluate() {
            TransitionKt.setTransitionsEnabled((!AndroidComposeTestRule.this.disableTransitions ? 1 : 0) != 0);
            AndroidOwnerRegistry.INSTANCE.setupRegistry$ui_test_release();
            ComposeIdlingResourceKt.registerComposeWithEspresso();
        }

        private final void afterEvaluate() {
            TransitionKt.setTransitionsEnabled((boolean)true);
            AndroidOwnerRegistry.INSTANCE.tearDownRegistry$ui_test_release();
            if (AndroidComposeTestRule.this.disposeContentHook != null) {
                SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(AndroidComposeTestRule.this){
                    private final /* synthetic */ AndroidComposeTestRule<T> $this;
                    {
                        this.$this = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        try {
                            Function0 function0 = AndroidComposeTestRule.access$getDisposeContentHook$p(this.$this);
                            Intrinsics.checkNotNull((Object)function0);
                            function0.invoke();
                        }
                        catch (Exception e) {
                        }
                        AndroidComposeTestRule.access$setDisposeContentHook$p(this.$this, null);
                    }
                });
            }
        }
    }
}

