/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import android.util.DisplayMetrics;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.ui.core.AndroidOwner;
import androidx.ui.core.LayoutNode;
import androidx.ui.core.LayoutNodeKt;
import androidx.ui.core.Owner;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.semantics.AccessibilityRangeInfo;
import androidx.ui.test.ErrorMessagesKt;
import androidx.ui.test.FiltersKt;
import androidx.ui.test.SemanticsMatcher;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.SemanticsNodeInteractionCollection;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxBounds;
import androidx.ui.unit.PxPosition;
import androidx.ui.unit.PxSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\t\u001a\u00020\b*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\n\u001a\u00020\b*\u00020\b2\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u001c\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0006\u001a\u0012\u0010\u001e\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001f\u001a\u0012\u0010 \u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0006\u001a\f\u0010!\u001a\u00020\"*\u00020\u0001H\u0002\u001a\f\u0010#\u001a\u00020\"*\u00020$H\u0002\u00a8\u0006%"}, d2={"assert", "Landroidx/ui/test/SemanticsNodeInteraction;", "matcher", "Landroidx/ui/test/SemanticsMatcher;", "messagePrefixOnError", "Lkotlin/Function0;", "", "assertAll", "Landroidx/ui/test/SemanticsNodeInteractionCollection;", "assertAny", "assertCountEquals", "expectedSize", "", "assertHasClickAction", "assertHasNoClickAction", "assertIsDisplayed", "assertIsEnabled", "assertIsHidden", "assertIsInMutuallyExclusiveGroup", "assertIsNotDisplayed", "assertIsNotEnabled", "assertIsNotHidden", "assertIsOff", "assertIsOn", "assertIsSelectable", "assertIsSelected", "assertIsToggleable", "assertIsUnselected", "assertLabelEquals", "value", "assertRangeInfoEquals", "Landroidx/ui/semantics/AccessibilityRangeInfo;", "assertValueEquals", "checkIsDisplayed", "", "isInScreenBounds", "Landroidx/ui/core/semantics/SemanticsNode;", "ui-test_release"})
public final class AssertionsKt {
    @NotNull
    public static final SemanticsNodeInteraction assertIsHidden(@NotNull SemanticsNodeInteraction $this$assertIsHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsHidden, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsHidden, FiltersKt.isHidden(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotHidden(@NotNull SemanticsNodeInteraction $this$assertIsNotHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsNotHidden, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsNotHidden, FiltersKt.isNotHidden(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsDisplayed(@NotNull SemanticsNodeInteraction $this$assertIsDisplayed) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsDisplayed, (String)"<this>");
        if (!AssertionsKt.checkIsDisplayed($this$assertIsDisplayed)) {
            throw new AssertionError((Object)"Assert failed: The component is not displayed!");
        }
        return $this$assertIsDisplayed;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotDisplayed(@NotNull SemanticsNodeInteraction $this$assertIsNotDisplayed) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsNotDisplayed, (String)"<this>");
        if (AssertionsKt.checkIsDisplayed($this$assertIsNotDisplayed)) {
            throw new AssertionError((Object)"Assert failed: The component is displayed!");
        }
        return $this$assertIsNotDisplayed;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsEnabled(@NotNull SemanticsNodeInteraction $this$assertIsEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsEnabled, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsEnabled, FiltersKt.isEnabled(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotEnabled(@NotNull SemanticsNodeInteraction $this$assertIsNotEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsNotEnabled, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsNotEnabled, FiltersKt.isNotEnabled(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsOn(@NotNull SemanticsNodeInteraction $this$assertIsOn) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsOn, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsOn, FiltersKt.isOn(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsOff(@NotNull SemanticsNodeInteraction $this$assertIsOff) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsOff, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsOff, FiltersKt.isOff(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsSelected(@NotNull SemanticsNodeInteraction $this$assertIsSelected) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsSelected, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsSelected, FiltersKt.isSelected(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsUnselected(@NotNull SemanticsNodeInteraction $this$assertIsUnselected) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsUnselected, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsUnselected, FiltersKt.isUnselected(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsToggleable(@NotNull SemanticsNodeInteraction $this$assertIsToggleable) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsToggleable, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsToggleable, FiltersKt.isToggleable(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsSelectable(@NotNull SemanticsNodeInteraction $this$assertIsSelectable) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsSelectable, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsSelectable, FiltersKt.isSelectable(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsInMutuallyExclusiveGroup(@NotNull SemanticsNodeInteraction $this$assertIsInMutuallyExclusiveGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsInMutuallyExclusiveGroup, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsInMutuallyExclusiveGroup, FiltersKt.isInMutuallyExclusiveGroup(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertLabelEquals(@NotNull SemanticsNodeInteraction $this$assertLabelEquals, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertLabelEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert$default($this$assertLabelEquals, FiltersKt.hasText$default(value, false, 2, null), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertValueEquals(@NotNull SemanticsNodeInteraction $this$assertValueEquals, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertValueEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert$default($this$assertValueEquals, FiltersKt.hasValue(value), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertRangeInfoEquals(@NotNull SemanticsNodeInteraction $this$assertRangeInfoEquals, @NotNull AccessibilityRangeInfo value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertRangeInfoEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert$default($this$assertRangeInfoEquals, FiltersKt.hasRangeInfo(value), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertHasClickAction(@NotNull SemanticsNodeInteraction $this$assertHasClickAction) {
        Intrinsics.checkNotNullParameter((Object)$this$assertHasClickAction, (String)"<this>");
        return AssertionsKt.assert$default($this$assertHasClickAction, FiltersKt.hasClickAction(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertHasNoClickAction(@NotNull SemanticsNodeInteraction $this$assertHasNoClickAction) {
        Intrinsics.checkNotNullParameter((Object)$this$assertHasNoClickAction, (String)"<this>");
        return AssertionsKt.assert$default($this$assertHasNoClickAction, FiltersKt.hasNoClickAction(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assert(@NotNull SemanticsNodeInteraction $this$assert, @NotNull SemanticsMatcher matcher, @Nullable Function0<String> messagePrefixOnError) {
        SemanticsNode node;
        Intrinsics.checkNotNullParameter((Object)$this$assert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String errorMessageOnFail = "Failed to assert the following: (" + matcher.getDescription() + ")";
        if (messagePrefixOnError != null) {
            errorMessageOnFail = (String)messagePrefixOnError.invoke() + "\n" + errorMessageOnFail;
        }
        if (!matcher.matches(node = $this$assert.fetchSemanticsNode(errorMessageOnFail))) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(errorMessageOnFail, $this$assert.getSelector$ui_test_release(), node));
        }
        return $this$assert;
    }

    public static /* synthetic */ SemanticsNodeInteraction assert$default(SemanticsNodeInteraction $this$assert_u24default, SemanticsMatcher matcher, Function0 messagePrefixOnError, int n, Object object) {
        if ((n & 2) != 0) {
            messagePrefixOnError = null;
        }
        return AssertionsKt.assert($this$assert_u24default, matcher, (Function0<String>)messagePrefixOnError);
    }

    @NotNull
    public static final SemanticsNodeInteractionCollection assertCountEquals(@NotNull SemanticsNodeInteractionCollection $this$assertCountEquals, int expectedSize) {
        Intrinsics.checkNotNullParameter((Object)$this$assertCountEquals, (String)"<this>");
        String errorOnFail = "Failed to assert count of nodes.";
        List<SemanticsNode> matchedNodes = $this$assertCountEquals.fetchSemanticsNodes(errorOnFail);
        if (matchedNodes.size() != expectedSize) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForCountMismatch(errorOnFail, $this$assertCountEquals.getSelector$ui_test_release(), matchedNodes, expectedSize));
        }
        return $this$assertCountEquals;
    }

    @NotNull
    public static final SemanticsNodeInteractionCollection assertAny(@NotNull SemanticsNodeInteractionCollection $this$assertAny, @NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)$this$assertAny, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String errorOnFail = "Failed to assertAny(" + matcher.getDescription() + ")";
        List<SemanticsNode> nodes = $this$assertAny.fetchSemanticsNodes(errorOnFail);
        if (nodes.isEmpty()) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForAtLeastOneNodeExpected(errorOnFail, $this$assertAny.getSelector$ui_test_release()));
        }
        if (!matcher.matchesAny((Iterable<SemanticsNode>)nodes)) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForAssertAnyFail($this$assertAny.getSelector$ui_test_release(), nodes, matcher));
        }
        return $this$assertAny;
    }

    @NotNull
    public static final SemanticsNodeInteractionCollection assertAll(@NotNull SemanticsNodeInteractionCollection $this$assertAll, @NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)$this$assertAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String errorOnFail = "Failed to assertAll(" + matcher.getDescription() + ")";
        List<SemanticsNode> nodes = $this$assertAll.fetchSemanticsNodes(errorOnFail);
        boolean bl = false;
        List violations = new ArrayList();
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SemanticsNode it = (SemanticsNode)element$iv;
            boolean bl2 = false;
            if (matcher.matches(it)) continue;
            violations.add(it);
        }
        Collection collection = violations;
        boolean bl3 = false;
        if (!collection.isEmpty()) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForAssertAllFail($this$assertAll.getSelector$ui_test_release(), violations, matcher));
        }
        return $this$assertAll;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkIsDisplayed(SemanticsNodeInteraction $this$checkIsDisplayed) {
        void $this$px$iv;
        float $this$iv$iv;
        AndroidOwner androidOwner;
        String errorMessageOnFail = "Failed to perform isDisplayed check.";
        SemanticsNode node = $this$checkIsDisplayed.fetchSemanticsNode(errorMessageOnFail);
        LayoutNode layoutNode = node.getComponentNode();
        if (AssertionsKt.checkIsDisplayed$isNotPlaced(layoutNode)) return false;
        if (LayoutNodeKt.findClosestParentNode((LayoutNode)layoutNode, (Function1)((Function1)new Function1<LayoutNode, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull LayoutNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return AssertionsKt.access$checkIsDisplayed$isNotPlaced(p0);
            }

            @NotNull
            public final String getSignature() {
                return "checkIsDisplayed$isNotPlaced(Landroidx/ui/core/LayoutNode;)Z";
            }

            @NotNull
            public final String getName() {
                return "isNotPlaced";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Object.class);
            }
        })) != null) {
            return false;
        }
        Owner owner = layoutNode.getOwner();
        AndroidOwner androidOwner2 = androidOwner = owner instanceof AndroidOwner ? (AndroidOwner)owner : null;
        if (androidOwner != null) {
            owner = androidOwner;
            boolean bl = false;
            boolean bl2 = false;
            Owner it = owner;
            boolean bl3 = false;
            if (!ViewMatchers.isDisplayed().matches((Object)it.getView())) {
                return false;
            }
        }
        PxBounds globalRect = node.getGlobalBounds();
        if (!AssertionsKt.isInScreenBounds(node)) {
            return false;
        }
        PxBounds $this$width$iv22 = globalRect;
        boolean $i$f$getWidth = false;
        float f = $this$width$iv22.getRight();
        float other$iv$iv = $this$width$iv22.getLeft();
        boolean bl = false;
        boolean $this$width$iv22 = false;
        float f2 = Px.constructor-impl((float)($this$iv$iv - other$iv$iv));
        boolean $i$f$getPx = false;
        float f3 = Px.constructor-impl((float)((float)$this$px$iv));
        if (Px.compareTo-NgWp0Z8((float)f2, (float)f3) <= 0) return false;
        PxBounds $this$height$iv22 = globalRect;
        boolean $i$f$getHeight = false;
        $this$iv$iv = $this$height$iv22.getBottom();
        other$iv$iv = $this$height$iv22.getTop();
        bl = false;
        boolean $this$height$iv22 = false;
        f2 = Px.constructor-impl((float)($this$iv$iv - other$iv$iv));
        $i$f$getPx = false;
        f3 = Px.constructor-impl((float)((float)$this$px$iv));
        if (Px.compareTo-NgWp0Z8((float)f2, (float)f3) <= 0) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isInScreenBounds(SemanticsNode $this$isInScreenBounds) {
        void this_$iv$iv52;
        float f;
        void other$iv$iv;
        void $this$iv$iv;
        void this_$iv$iv32;
        float f2;
        void topLeft$iv;
        long l;
        void val1$iv$iv;
        void width$iv;
        void $this$px$iv;
        float $this$iv$iv2;
        PxBounds nodeBounds;
        PxBounds $this$width$iv22 = nodeBounds = $this$isInScreenBounds.getGlobalBounds();
        boolean $i$f$getWidth = false;
        float f3 = $this$width$iv22.getRight();
        float other$iv$iv2 = $this$width$iv22.getLeft();
        boolean bl = false;
        boolean $this$width$iv22 = false;
        float f4 = Px.constructor-impl((float)($this$iv$iv2 - other$iv$iv2));
        boolean $i$f$getPx = false;
        float f5 = Px.constructor-impl((float)((float)$this$px$iv));
        if (Px.equals-impl0((float)f4, (float)f5)) {
            PxBounds $this$height$iv22 = nodeBounds;
            boolean $i$f$getHeight = false;
            $this$iv$iv2 = $this$height$iv22.getBottom();
            other$iv$iv2 = $this$height$iv22.getTop();
            bl = false;
            boolean $this$height$iv22 = false;
            f4 = Px.constructor-impl((float)($this$iv$iv2 - other$iv$iv2));
            $i$f$getPx = false;
            f5 = Px.constructor-impl((float)((float)$this$px$iv));
            if (Px.equals-impl0((float)f4, (float)f5)) {
                return false;
            }
        }
        if (($i$f$getPx = $this$isInScreenBounds.getComponentNode().getOwner()) == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.ui.core.AndroidOwner");
        }
        DisplayMetrics displayMetrics = ((AndroidOwner)$i$f$getPx).getView().getResources().getDisplayMetrics();
        PxPosition $this$iv$iv22 = PxPosition.Companion.getOrigin();
        int $this$px$iv22 = displayMetrics.widthPixels;
        boolean $i$f$getPx2 = false;
        float $this$px$iv22 = Px.constructor-impl((float)$this$px$iv22);
        int $this$px$iv3 = displayMetrics.heightPixels;
        boolean $i$f$getPx3 = false;
        float height$iv = Px.constructor-impl((float)$this$px$iv3);
        boolean bl2 = false;
        void var8_24 = width$iv;
        float val2$iv$iv = height$iv;
        boolean $i$f$packFloats = false;
        void var11_34 = val1$iv$iv;
        boolean bl3 = false;
        long v1$iv$iv = Float.floatToIntBits((float)var11_34);
        float f6 = val2$iv$iv;
        boolean bl4 = false;
        long v2$iv$iv = Float.floatToIntBits(f6);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxSize size$iv = new PxSize(l2);
        boolean $i$f$PxBounds = false;
        void this_$iv$iv = topLeft$iv;
        boolean $i$f$getX = false;
        long value$iv$iv$iv = this_$iv$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv$iv >> 32);
        int n2 = 0;
        float $this$px$iv$iv$iv = Float.intBitsToFloat(n);
        boolean $i$f$getPx4 = false;
        float f7 = Px.constructor-impl((float)$this$px$iv$iv$iv);
        this_$iv$iv = topLeft$iv;
        boolean $i$f$getY = false;
        value$iv$iv$iv = this_$iv$iv.getValue();
        boolean $i$f$unpackFloat2 = false;
        floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv$iv & 0xFFFFFFFFL);
        n2 = 0;
        $this$px$iv$iv$iv = Float.intBitsToFloat(n);
        $i$f$getPx4 = false;
        float f8 = Px.constructor-impl((float)$this$px$iv$iv$iv);
        this_$iv$iv = topLeft$iv;
        $i$f$getX = false;
        value$iv$iv$iv = this_$iv$iv.getValue();
        $i$f$unpackFloat1 = false;
        floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv$iv >> 32);
        n2 = 0;
        $this$px$iv$iv$iv = Float.intBitsToFloat(n);
        $i$f$getPx4 = false;
        float this_$iv$iv2 = f2 = Px.constructor-impl((float)$this$px$iv$iv$iv);
        PxSize $i$f$getX2 = size$iv;
        boolean $i$f$getWidth2 = false;
        long value$iv$iv$iv2 = this_$iv$iv32.getValue();
        boolean $i$f$unpackFloat32 = false;
        FloatCompanionObject floatCompanionObject2 = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv$iv2 >> 32);
        boolean $this$px$iv$iv$iv2 = false;
        float $this$px$iv$iv$iv3 = Float.intBitsToFloat(n2);
        boolean $i$f$getPx5 = false;
        float this_$iv$iv32 = f2 = Px.constructor-impl((float)$this$px$iv$iv$iv3);
        boolean bl5 = false;
        f2 = Px.constructor-impl((float)($this$iv$iv + other$iv$iv));
        $this$iv$iv = topLeft$iv;
        $i$f$getY2 = false;
        value$iv$iv$iv = this_$iv$iv4.getValue();
        $i$f$unpackFloat2 = false;
        FloatCompanionObject $i$f$unpackFloat32 = FloatCompanionObject.INSTANCE;
        int n3 = (int)(value$iv$iv$iv & 0xFFFFFFFFL);
        n2 = 0;
        $this$px$iv$iv$iv = Float.intBitsToFloat(n3);
        $i$f$getPx = false;
        float this_$iv$iv4 = f = Px.constructor-impl((float)$this$px$iv$iv$iv);
        PxSize $i$f$getY2 = size$iv;
        boolean $i$f$getHeight = false;
        value$iv$iv$iv2 = this_$iv$iv52.getValue();
        boolean $i$f$unpackFloat22 = false;
        FloatCompanionObject floatCompanionObject3 = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv$iv2 & 0xFFFFFFFFL);
        boolean bl6 = false;
        $this$px$iv$iv$iv = Float.intBitsToFloat(n2);
        $i$f$getPx5 = false;
        float this_$iv$iv52 = f = Px.constructor-impl((float)$this$px$iv$iv$iv);
        bl5 = false;
        f = Px.constructor-impl((float)($this$iv$iv + other$iv$iv));
        DefaultConstructorMarker defaultConstructorMarker = null;
        float f9 = f;
        float f10 = f2;
        float f11 = f8;
        float f12 = f7;
        PxBounds screenBounds = new PxBounds(f12, f11, f10, f9, defaultConstructorMarker);
        return Px.compareTo-NgWp0Z8((float)nodeBounds.getTop(), (float)screenBounds.getTop()) >= 0 && Px.compareTo-NgWp0Z8((float)nodeBounds.getLeft(), (float)screenBounds.getLeft()) >= 0 && Px.compareTo-NgWp0Z8((float)nodeBounds.getRight(), (float)screenBounds.getRight()) <= 0 && Px.compareTo-NgWp0Z8((float)nodeBounds.getBottom(), (float)screenBounds.getBottom()) <= 0;
    }

    private static final boolean checkIsDisplayed$isNotPlaced(LayoutNode node) {
        return !node.isPlaced();
    }

    public static final /* synthetic */ boolean access$checkIsDisplayed$isNotPlaced(LayoutNode layoutNode) {
        return AssertionsKt.checkIsDisplayed$isNotPlaced(layoutNode);
    }
}

