/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.AndroidOwner;
import androidx.ui.core.Owner;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.input.CommitTextEditOp;
import androidx.ui.input.DeleteAllEditOp;
import androidx.ui.input.EditOperation;
import androidx.ui.input.ImeAction;
import androidx.ui.test.ActionsKt;
import androidx.ui.test.AssertionsKt;
import androidx.ui.test.ErrorMessagesKt;
import androidx.ui.test.FiltersKt;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.SynchronizationKt;
import androidx.ui.test.TextInputServiceForTests;
import androidx.ui.text.TextSemanticsProperties;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0000\u001a\u001a\u0010\r\u001a\u00020\u0001*\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0000\u00a8\u0006\u0011"}, d2={"doClearText", "", "Landroidx/ui/test/SemanticsNodeInteraction;", "alreadyHasFocus", "", "doReplaceText", "text", "", "doSendImeAction", "doSendText", "getTextInputServiceOrDie", "Landroidx/ui/test/TextInputServiceForTests;", "Landroidx/ui/core/AndroidOwner;", "sendTextInputCommand", "command", "", "Landroidx/ui/input/EditOperation;", "ui-test_release"})
public final class TextActionsKt {
    public static final void doClearText(@NotNull SemanticsNodeInteraction $this$doClearText, boolean alreadyHasFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$doClearText, (String)"<this>");
        if (!alreadyHasFocus) {
            ActionsKt.doClick($this$doClearText);
        }
        TextActionsKt.sendTextInputCommand($this$doClearText, CollectionsKt.listOf((Object)new DeleteAllEditOp()));
    }

    public static /* synthetic */ void doClearText$default(SemanticsNodeInteraction $this$doClearText_u24default, boolean alreadyHasFocus, int n, Object object) {
        if ((n & 1) != 0) {
            alreadyHasFocus = false;
        }
        TextActionsKt.doClearText($this$doClearText_u24default, alreadyHasFocus);
    }

    public static final void doSendText(@NotNull SemanticsNodeInteraction $this$doSendText, @NotNull String text, boolean alreadyHasFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$doSendText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!alreadyHasFocus) {
            ActionsKt.doClick($this$doSendText);
        }
        TextActionsKt.sendTextInputCommand($this$doSendText, CollectionsKt.listOf((Object)new CommitTextEditOp(text, 1)));
    }

    public static /* synthetic */ void doSendText$default(SemanticsNodeInteraction $this$doSendText_u24default, String text, boolean alreadyHasFocus, int n, Object object) {
        if ((n & 2) != 0) {
            alreadyHasFocus = false;
        }
        TextActionsKt.doSendText($this$doSendText_u24default, text, alreadyHasFocus);
    }

    public static final void doReplaceText(@NotNull SemanticsNodeInteraction $this$doReplaceText, @NotNull String text, boolean alreadyHasFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$doReplaceText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!alreadyHasFocus) {
            ActionsKt.doClick($this$doReplaceText);
        }
        Object[] objectArray = new EditOperation[]{(EditOperation)new DeleteAllEditOp(), (EditOperation)new CommitTextEditOp(text, 1)};
        TextActionsKt.sendTextInputCommand($this$doReplaceText, CollectionsKt.listOf((Object[])objectArray));
    }

    public static /* synthetic */ void doReplaceText$default(SemanticsNodeInteraction $this$doReplaceText_u24default, String text, boolean alreadyHasFocus, int n, Object object) {
        if ((n & 2) != 0) {
            alreadyHasFocus = false;
        }
        TextActionsKt.doReplaceText($this$doReplaceText_u24default, text, alreadyHasFocus);
    }

    public static final void doSendImeAction(@NotNull SemanticsNodeInteraction $this$doSendImeAction, boolean alreadyHasFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$doSendImeAction, (String)"<this>");
        if (!alreadyHasFocus) {
            ActionsKt.doClick($this$doSendImeAction);
        }
        String errorOnFail = "Failed to send IME action.";
        SemanticsNode node = $this$doSendImeAction.fetchSemanticsNode(errorOnFail);
        AssertionsKt.assert($this$doSendImeAction, FiltersKt.hasInputMethodsSupport(), (Function0<String>)((Function0)new Function0<String>(errorOnFail){
            private final /* synthetic */ String $errorOnFail;
            {
                this.$errorOnFail = $errorOnFail;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$errorOnFail;
            }
        }));
        ImeAction actionSpecified2 = (ImeAction)node.getConfig().getOrElse(TextSemanticsProperties.INSTANCE.getImeAction(), (Function0)new Function0<ImeAction>(){

            @NotNull
            public final ImeAction invoke() {
                return ImeAction.Unspecified;
            }
        });
        if (Intrinsics.areEqual((Object)actionSpecified2, (Object)ImeAction.Unspecified)) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage("Failed to send IME action as current node does not specify any.", $this$doSendImeAction.getSelector$ui_test_release(), node));
        }
        Owner owner = node.getComponentNode().getOwner();
        if (owner == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.ui.core.AndroidOwner");
        }
        AndroidOwner owner2 = (AndroidOwner)owner;
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(owner2, actionSpecified2){
            private final /* synthetic */ AndroidOwner $owner;
            private final /* synthetic */ ImeAction $actionSpecified;
            {
                this.$owner = $owner;
                this.$actionSpecified = $actionSpecified;
                super(0);
            }

            public final void invoke() {
                TextInputServiceForTests textInputService = TextActionsKt.getTextInputServiceOrDie(this.$owner);
                Function1<ImeAction, Unit> function1 = textInputService.getOnImeActionPerformed();
                if (function1 == null) {
                    throw new IllegalStateException("No input session started. Missing a focus?");
                }
                Function1<ImeAction, Unit> onImeActionPerformed = function1;
                onImeActionPerformed.invoke((Object)this.$actionSpecified);
            }
        });
    }

    public static /* synthetic */ void doSendImeAction$default(SemanticsNodeInteraction $this$doSendImeAction_u24default, boolean alreadyHasFocus, int n, Object object) {
        if ((n & 1) != 0) {
            alreadyHasFocus = false;
        }
        TextActionsKt.doSendImeAction($this$doSendImeAction_u24default, alreadyHasFocus);
    }

    public static final void sendTextInputCommand(@NotNull SemanticsNodeInteraction $this$sendTextInputCommand, @NotNull List<? extends EditOperation> command) {
        Intrinsics.checkNotNullParameter((Object)$this$sendTextInputCommand, (String)"<this>");
        Intrinsics.checkNotNullParameter(command, (String)"command");
        String errorOnFail = "Failed to send text input.";
        SemanticsNode node = $this$sendTextInputCommand.fetchSemanticsNode(errorOnFail);
        Owner owner = node.getComponentNode().getOwner();
        if (owner == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.ui.core.AndroidOwner");
        }
        AndroidOwner owner2 = (AndroidOwner)owner;
        AssertionsKt.assert($this$sendTextInputCommand, FiltersKt.hasInputMethodsSupport(), (Function0<String>)((Function0)new Function0<String>(errorOnFail){
            private final /* synthetic */ String $errorOnFail;
            {
                this.$errorOnFail = $errorOnFail;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$errorOnFail;
            }
        }));
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(owner2, command){
            private final /* synthetic */ AndroidOwner $owner;
            private final /* synthetic */ List<EditOperation> $command;
            {
                this.$owner = $owner;
                this.$command = $command;
                super(0);
            }

            public final void invoke() {
                TextInputServiceForTests textInputService = TextActionsKt.getTextInputServiceOrDie(this.$owner);
                Function1<List<? extends EditOperation>, Unit> function1 = textInputService.getOnEditCommand();
                if (function1 == null) {
                    throw new IllegalStateException("No input session started. Missing a focus?");
                }
                Function1<List<? extends EditOperation>, Unit> onEditCommand = function1;
                onEditCommand.invoke(this.$command);
            }
        });
    }

    @NotNull
    public static final TextInputServiceForTests getTextInputServiceOrDie(@NotNull AndroidOwner $this$getTextInputServiceOrDie) {
        Intrinsics.checkNotNullParameter((Object)$this$getTextInputServiceOrDie, (String)"<this>");
        TextInputServiceForTests textInputServiceForTests = (TextInputServiceForTests)$this$getTextInputServiceOrDie.getTextInputService();
        if (textInputServiceForTests == null) {
            throw new IllegalStateException("Text input service wrapper not set up! Did you use ComposeTestRule?");
        }
        return textInputServiceForTests;
    }
}

