/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.MotionEvent;
import androidx.ui.test.GestureToken;
import androidx.ui.test.InputDispatcher;
import androidx.ui.unit.Duration;
import androidx.ui.unit.Durations;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxPosition;
import androidx.ui.util.MathHelpersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.LongRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000f\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0002,-B\u0014\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J6\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010!\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J:\u0010\"\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0018\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00150\u00030\u001f2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tH\u0002J8\u0010&\u001a\u00020\u00052\u0018\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00150\u00030\u001f2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0\u001fH\u0016J\u0018\u0010)\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Landroidx/ui/test/android/AndroidInputDispatcher;", "Landroidx/ui/test/InputDispatcher;", "sendEvent", "Lkotlin/Function1;", "Landroid/view/MotionEvent;", "", "handler", "Landroid/os/Handler;", "nextDownTime", "", "delay", "duration", "Landroidx/ui/unit/Duration;", "generateDownTime", "moveNextDownTime", "sendAndRecycleEvent", "event", "sendCancel", "token", "Landroidx/ui/test/GestureToken;", "position", "Landroidx/ui/unit/PxPosition;", "sendClick", "sendDown", "sendMotionEvent", "downTime", "eventTime", "action", "", "actionIndex", "coordinates", "", "sendMove", "sendNextMotionEvent", "sendPartialSwipes", "fs", "t0", "tN", "sendSwipes", "curves", "keyTimes", "sendUp", "sleepUntil", "time", "Companion", "TestRule", "ui-test_release"})
public final class AndroidInputDispatcher
implements InputDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Function1<MotionEvent, Unit> sendEvent;
    private final Handler handler;
    private long nextDownTime;
    private static boolean dispatchInRealTime = true;
    private static long eventPeriod = Durations.inMilliseconds((Duration)Durations.getMilliseconds((int)10));
    private static final long DownTimeNotSet = -1L;

    public AndroidInputDispatcher(@NotNull Function1<? super MotionEvent, Unit> sendEvent) {
        Intrinsics.checkNotNullParameter(sendEvent, (String)"sendEvent");
        this.sendEvent = sendEvent;
        this.handler = new Handler(Looper.getMainLooper());
        this.nextDownTime = -1L;
    }

    private final long generateDownTime(Duration duration) {
        long downTime = this.nextDownTime == -1L ? SystemClock.uptimeMillis() : this.nextDownTime;
        this.nextDownTime = downTime + Durations.inMilliseconds((Duration)duration);
        return downTime;
    }

    private final void moveNextDownTime(Duration duration) {
        this.generateDownTime(duration);
    }

    @Override
    public void delay(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        boolean bl = duration.compareTo(Duration.Companion.getZero()) >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"duration of a delay can only be positive, not ", (Object)duration);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.moveNextDownTime(duration);
        this.sleepUntil(this.nextDownTime);
    }

    @Override
    public void sendClick(@NotNull PxPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        long downTime = this.generateDownTime(Durations.getMilliseconds((long)eventPeriod));
        this.sendMotionEvent(downTime, downTime, 0, position);
        this.sendMotionEvent(downTime, downTime + eventPeriod, 1, position);
    }

    @Override
    @NotNull
    public GestureToken sendDown(@NotNull PxPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        long downTime = this.generateDownTime(Durations.getMilliseconds((int)0));
        this.sendMotionEvent(downTime, downTime, 0, position);
        return new GestureToken(downTime, position);
    }

    @Override
    public void sendMove(@NotNull GestureToken token, @NotNull PxPosition position) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.sendNextMotionEvent(token, 2, position);
    }

    @Override
    public void sendUp(@NotNull GestureToken token, @NotNull PxPosition position) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.sendNextMotionEvent(token, 1, position);
        token.setFinished$ui_test_release(true);
    }

    @Override
    public void sendCancel(@NotNull GestureToken token, @NotNull PxPosition position) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.sendNextMotionEvent(token, 3, position);
        token.setFinished$ui_test_release(true);
    }

    private final void sendNextMotionEvent(GestureToken token, int action, PxPosition position) {
        boolean bl = !token.getFinished$ui_test_release();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Can't send an event to a gesture that already had an up or cancel event";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.moveNextDownTime(Durations.getMilliseconds((long)eventPeriod));
        GestureToken gestureToken = token;
        gestureToken.setEventTime$ui_test_release(gestureToken.getEventTime$ui_test_release() + eventPeriod);
        token.setLastPosition$ui_test_release(position);
        this.sendMotionEvent(token.getDownTime$ui_test_release(), token.getEventTime$ui_test_release(), action, position);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendSwipes(@NotNull List<? extends Function1<? super Long, PxPosition>> curves, @NotNull Duration duration, @NotNull List<Long> keyTimes) {
        void $this$mapTo$iv$iv;
        boolean bl;
        boolean $i$a$-all-AndroidInputDispatcher$sendSwipes$62;
        boolean bl2;
        long endTime;
        long startTime;
        block14: {
            boolean bl3;
            boolean $i$f$all;
            block13: {
                Intrinsics.checkNotNullParameter(curves, (String)"curves");
                Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
                Intrinsics.checkNotNullParameter(keyTimes, (String)"keyTimes");
                startTime = 0L;
                endTime = Durations.inMilliseconds((Duration)duration);
                boolean bl4 = duration.compareTo(Durations.getMilliseconds((int)1)) >= 0;
                boolean bl5 = false;
                bl2 = false;
                if (!bl4) {
                    boolean bl622 = false;
                    String string = Intrinsics.stringPlus((String)"duration must be at least 1 millisecond, not ", (Object)duration);
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                LongRange validRange = new LongRange(startTime, endTime);
                Iterable $this$all$iv = keyTimes;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        long it = ((Number)element$iv).longValue();
                        boolean bl7 = false;
                        if (validRange.contains(it)) continue;
                        bl3 = false;
                        break block13;
                    }
                    bl3 = true;
                }
            }
            boolean $this$all$iv = bl3;
            $i$f$all = false;
            boolean bl622 = false;
            if (!$this$all$iv) {
                boolean bl8 = false;
                String bl622 = "keyTimes contains timestamps out of range [" + startTime + ".." + endTime + "]: " + keyTimes;
                throw (Throwable)new IllegalArgumentException(bl622.toString());
            }
            Sequence $this$all$iv2 = SequencesKt.zipWithNext((Sequence)CollectionsKt.asSequence((Iterable)keyTimes), (Function2)((Function2)new Function2<Long, Long, Boolean>(){

                public final boolean invoke(long a, long b) {
                    return a <= b;
                }
            }));
            $i$f$all = false;
            for (Object element$iv : $this$all$iv2) {
                boolean it = (Boolean)element$iv;
                $i$a$-all-AndroidInputDispatcher$sendSwipes$62 = false;
                if (it) continue;
                bl = false;
                break block14;
            }
            bl = true;
        }
        boolean $this$all$iv2 = bl;
        bl2 = false;
        boolean bl622 = false;
        if (!$this$all$iv2) {
            boolean bl9 = false;
            String bl622 = Intrinsics.stringPlus((String)"keyTimes must be sorted: ", keyTimes);
            throw (Throwable)new IllegalArgumentException(bl622.toString());
        }
        long downTime = this.generateDownTime(duration);
        long upTime = downTime + Durations.inMilliseconds((Duration)duration);
        $i$a$-all-AndroidInputDispatcher$sendSwipes$62 = false;
        List initialPositions = new ArrayList();
        Iterator $i$a$-all-AndroidInputDispatcher$sendSwipes$62 = ((Iterable)curves).iterator();
        int n = 0;
        while ($i$a$-all-AndroidInputDispatcher$sendSwipes$62.hasNext()) {
            int index = n;
            Function1 curve = (Function1)$i$a$-all-AndroidInputDispatcher$sendSwipes$62.next();
            int action = index == 0 ? 0 : 5;
            initialPositions.add((PxPosition)curve.invoke((Object)startTime));
            this.sendMotionEvent(downTime, downTime, action, index, initialPositions);
            ++n;
        }
        long currTime = startTime;
        int key = 0;
        while (currTime < endTime) {
            while (key < keyTimes.size() && ((Number)keyTimes.get(key)).longValue() <= currTime) {
                int curve = key;
                key = curve + 1;
            }
            long tNext = key < keyTimes.size() ? ((Number)keyTimes.get(key)).longValue() : endTime;
            this.sendPartialSwipes(downTime, curves, currTime, tNext);
            currTime = tNext;
        }
        Iterable $this$map$iv = curves;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Function1 function1 = (Function1)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl10 = false;
            PxPosition pxPosition = (PxPosition)it.invoke((Object)endTime);
            collection.add(pxPosition);
        }
        List finalPositions = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        int n2 = ((Collection)curves).size() + -1;
        if (0 <= n2) {
            do {
                int index = n2;
                int action = index > 0 ? 6 : 1;
                this.sendMotionEvent(downTime, upTime, action, index, finalPositions);
                PxPosition cfr_ignored_0 = (PxPosition)finalPositions.remove(index);
            } while (0 <= (n2 += -1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendPartialSwipes(long downTime, List<? extends Function1<? super Long, PxPosition>> fs, long t0, long tN) {
        int step = 0;
        int n = 1;
        int n2 = MathKt.roundToInt((float)((float)(tN - t0) / (float)eventPeriod));
        boolean bl = false;
        int steps = Math.max(n, n2);
        while (true) {
            Collection<PxPosition> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            n = step;
            step = n + 1;
            if (n >= steps) break;
            float progress = (float)step / (float)steps;
            long t = MathHelpersKt.lerp((long)t0, (long)tN, (float)progress);
            Iterable iterable = fs;
            int n3 = 0;
            int n4 = 2;
            long l = downTime + t;
            long l2 = downTime;
            AndroidInputDispatcher androidInputDispatcher = this;
            boolean $i$f$map = false;
            void var15_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Function1 function1 = (Function1)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                PxPosition pxPosition = (PxPosition)it.invoke((Object)t);
                collection.add(pxPosition);
            }
            collection = (List)destination$iv$iv;
            androidInputDispatcher.sendMotionEvent(l2, l, n4, n3, (List<PxPosition>)collection);
        }
    }

    private final void sendMotionEvent(long downTime, long eventTime, int action, int actionIndex, List<PxPosition> coordinates) {
        boolean bl;
        boolean bl2;
        AndroidInputDispatcher androidInputDispatcher;
        long l;
        long l2;
        int n;
        int n2;
        MotionEvent.PointerProperties[] pointerPropertiesArray;
        MotionEvent.PointerProperties pointerProperties;
        int n3;
        this.sleepUntil(eventTime);
        AndroidInputDispatcher androidInputDispatcher2 = this;
        long l3 = downTime;
        long l4 = eventTime;
        int n4 = action + (actionIndex << 8);
        int n5 = coordinates.size();
        int n6 = 0;
        int n7 = coordinates.size();
        MotionEvent.PointerProperties[] pointerPropertiesArray2 = new MotionEvent.PointerProperties[n7];
        while (n6 < n7) {
            n3 = n6++;
            pointerProperties = new MotionEvent.PointerProperties();
            int n8 = n3;
            pointerPropertiesArray = pointerPropertiesArray2;
            n2 = n5;
            n = n4;
            l2 = l4;
            l = l3;
            androidInputDispatcher = androidInputDispatcher2;
            bl2 = false;
            bl = false;
            MotionEvent.PointerProperties $this$sendMotionEvent_u24lambda_u2d9 = pointerProperties;
            boolean bl3 = false;
            $this$sendMotionEvent_u24lambda_u2d9.id = n3;
            MotionEvent.PointerProperties pointerProperties2 = pointerProperties;
            androidInputDispatcher2 = androidInputDispatcher;
            l3 = l;
            l4 = l2;
            n4 = n;
            n5 = n2;
            pointerPropertiesArray[n8] = pointerProperties2;
        }
        MotionEvent.PointerProperties[] pointerPropertiesArray3 = pointerPropertiesArray2;
        n6 = 0;
        n7 = coordinates.size();
        pointerPropertiesArray2 = new MotionEvent.PointerCoords[n7];
        while (n6 < n7) {
            float f;
            PxPosition this_$iv;
            n3 = n6++;
            pointerProperties = new MotionEvent.PointerCoords();
            int n9 = n3;
            MotionEvent.PointerProperties[] pointerPropertiesArray4 = pointerPropertiesArray2;
            pointerPropertiesArray = pointerPropertiesArray3;
            n2 = n5;
            n = n4;
            l2 = l4;
            l = l3;
            androidInputDispatcher = androidInputDispatcher2;
            bl2 = false;
            bl = false;
            MotionEvent.PointerProperties $this$sendMotionEvent_u24lambda_u2d10 = pointerProperties;
            boolean bl4 = false;
            PxPosition pxPosition = coordinates.get(n3);
            MotionEvent.PointerProperties pointerProperties3 = $this$sendMotionEvent_u24lambda_u2d10;
            boolean $i$f$getX = false;
            long value$iv$iv = this_$iv.getValue();
            boolean $i$f$unpackFloat1 = false;
            FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
            int n10 = (int)(value$iv$iv >> 32);
            boolean bl5 = false;
            float $this$px$iv$iv = Float.intBitsToFloat(n10);
            boolean $i$f$getPx = false;
            pointerProperties3.x = f = Px.constructor-impl((float)$this$px$iv$iv);
            this_$iv = coordinates.get(n3);
            pointerProperties3 = $this$sendMotionEvent_u24lambda_u2d10;
            boolean $i$f$getY = false;
            value$iv$iv = this_$iv.getValue();
            boolean $i$f$unpackFloat2 = false;
            floatCompanionObject = FloatCompanionObject.INSTANCE;
            n10 = (int)(value$iv$iv & 0xFFFFFFFFL);
            bl5 = false;
            $this$px$iv$iv = Float.intBitsToFloat(n10);
            $i$f$getPx = false;
            pointerProperties3.y = f = Px.constructor-impl((float)$this$px$iv$iv);
            MotionEvent.PointerProperties pointerProperties4 = pointerProperties;
            androidInputDispatcher2 = androidInputDispatcher;
            l3 = l;
            l4 = l2;
            n4 = n;
            n5 = n2;
            pointerPropertiesArray3 = pointerPropertiesArray;
            pointerPropertiesArray4[n9] = pointerProperties4;
        }
        MotionEvent motionEvent = MotionEvent.obtain((long)l3, (long)l4, (int)n4, (int)n5, (MotionEvent.PointerProperties[])pointerPropertiesArray3, (MotionEvent.PointerCoords[])pointerPropertiesArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)0, (int)0, (int)0, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)motionEvent, (String)"obtain(\n                downTime,\n                eventTime,\n                action + (actionIndex shl MotionEvent.ACTION_POINTER_INDEX_SHIFT),\n                coordinates.size,\n                Array(coordinates.size) {\n                    MotionEvent.PointerProperties().apply { id = it }\n                },\n                Array(coordinates.size) {\n                    MotionEvent.PointerCoords().apply {\n                        x = coordinates[it].x.value\n                        y = coordinates[it].y.value\n                    }\n                },\n                0,\n                0,\n                0f,\n                0f,\n                0,\n                0,\n                0,\n                0\n            )");
        androidInputDispatcher2.sendAndRecycleEvent(motionEvent);
    }

    private final void sendMotionEvent(long downTime, long eventTime, int action, PxPosition position) {
        this.sendMotionEvent(downTime, eventTime, action, 0, CollectionsKt.listOf((Object)position));
    }

    private final void sleepUntil(long time) {
        long currTime;
        if (dispatchInRealTime && (currTime = SystemClock.uptimeMillis()) < time) {
            SystemClock.sleep((long)(time - currTime));
        }
    }

    private final void sendAndRecycleEvent(MotionEvent event) {
        CountDownLatch latch = new CountDownLatch(1);
        this.handler.post(new Runnable(this, event, latch){
            private final /* synthetic */ AndroidInputDispatcher $this;
            private final /* synthetic */ MotionEvent $event;
            private final /* synthetic */ CountDownLatch $latch;
            {
                this.$this = $receiver;
                this.$event = $event;
                this.$latch = $latch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                try {
                    AndroidInputDispatcher.access$getSendEvent$p(this.$this).invoke((Object)this.$event);
                }
                finally {
                    this.$event.recycle();
                    this.$latch.countDown();
                }
            }
        });
        boolean bl = latch.await(5L, TimeUnit.SECONDS);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Event " + event + " was not dispatched in 5 seconds";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    public void sendSwipe(@NotNull Function1<? super Long, PxPosition> curve, @NotNull Duration duration, @NotNull List<Long> keyTimes) {
        InputDispatcher.DefaultImpls.sendSwipe((InputDispatcher)this, curve, duration, keyTimes);
    }

    @Override
    public void sendSwipe(@NotNull PxPosition start, @NotNull PxPosition end, @NotNull Duration duration) {
        InputDispatcher.DefaultImpls.sendSwipe((InputDispatcher)this, start, end, duration);
    }

    public static final /* synthetic */ Function1 access$getSendEvent$p(AndroidInputDispatcher androidInputDispatcher) {
        return androidInputDispatcher.sendEvent;
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/ui/test/android/AndroidInputDispatcher$Companion;", "", "DownTimeNotSet", "", "dispatchInRealTime", "", "eventPeriod", "ui-test_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0010"}, d2={"Landroidx/ui/test/android/AndroidInputDispatcher$TestRule;", "Lorg/junit/rules/TestRule;", "disableDispatchInRealTime", "", "eventPeriodOverride", "", "eventPeriod", "getEventPeriod", "()J", "Ljava/lang/Long;", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "ModifyingStatement", "ui-test_release"})
    public static final class TestRule
    implements org.junit.rules.TestRule {
        private final boolean disableDispatchInRealTime;
        private final Long eventPeriodOverride;

        public TestRule(boolean disableDispatchInRealTime, @Nullable Long eventPeriodOverride) {
            this.disableDispatchInRealTime = disableDispatchInRealTime;
            this.eventPeriodOverride = eventPeriodOverride;
        }

        public /* synthetic */ TestRule(boolean disableDispatchInRealTime, Long eventPeriodOverride, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                disableDispatchInRealTime = false;
            }
            if ((n & 2) != 0) {
                eventPeriodOverride = null;
            }
            this(disableDispatchInRealTime, eventPeriodOverride);
        }

        public final long getEventPeriod() {
            return eventPeriod;
        }

        @NotNull
        public Statement apply(@NotNull Statement base, @Nullable Description description) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            return new ModifyingStatement(base);
        }

        public TestRule() {
            this(false, null, 3, null);
        }

        @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0001J\b\u0010\u0003\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/ui/test/android/AndroidInputDispatcher$TestRule$ModifyingStatement;", "Lorg/junit/runners/model/Statement;", "base", "evaluate", "", "ui-test_release"})
        public final class ModifyingStatement
        extends Statement {
            private final Statement base;

            public ModifyingStatement(Statement base) {
                Intrinsics.checkNotNullParameter((Object)TestRule.this, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)base, (String)"base");
                this.base = base;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() {
                if (TestRule.this.disableDispatchInRealTime) {
                    dispatchInRealTime = false;
                }
                if (TestRule.this.eventPeriodOverride != null) {
                    eventPeriod = TestRule.this.eventPeriodOverride;
                }
                try {
                    this.base.evaluate();
                }
                finally {
                    if (TestRule.this.disableDispatchInRealTime) {
                        dispatchInRealTime = true;
                    }
                    if (TestRule.this.eventPeriodOverride != null) {
                        eventPeriod = 10L;
                    }
                }
            }
        }
    }
}

