/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.PixelCopy;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.ui.core.AndroidOwner;
import androidx.ui.core.Owner;
import androidx.ui.geometry.Rect;
import androidx.ui.test.android.WindowCaptureKt;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0001\u00a8\u0006\n"}, d2={"captureRegionToBitmap", "Landroid/graphics/Bitmap;", "captureRect", "Landroidx/ui/geometry/Rect;", "handler", "Landroid/os/Handler;", "window", "Landroid/view/Window;", "owner", "Landroidx/ui/core/Owner;", "ui-test_release"})
public final class WindowCaptureKt {
    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureRegionToBitmap(@NotNull Rect captureRect, @NotNull Owner owner) {
        Intrinsics.checkNotNullParameter((Object)captureRect, (String)"captureRect");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Context context = ((AndroidOwner)owner).getView().getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"owner as AndroidOwner).view.context");
        Activity activity = WindowCaptureKt.captureRegionToBitmap$getActivity(context);
        Intrinsics.checkNotNull((Object)activity);
        Window window = activity.getWindow();
        Handler handler = new Handler(Looper.getMainLooper());
        context = window;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"window");
        return WindowCaptureKt.captureRegionToBitmap(captureRect, handler, (Window)context);
    }

    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureRegionToBitmap(@NotNull Rect captureRect, @NotNull Handler handler, @NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)captureRect, (String)"captureRect");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        CountDownLatch drawLatch = new CountDownLatch(1);
        View view = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
        View decorView = view;
        handler.post(new Runnable(decorView, drawLatch, handler){
            private final /* synthetic */ View $decorView;
            private final /* synthetic */ CountDownLatch $drawLatch;
            private final /* synthetic */ Handler $handler;
            {
                this.$decorView = $decorView;
                this.$drawLatch = $drawLatch;
                this.$handler = $handler;
            }

            public final void run() {
                if (Build.VERSION.SDK_INT >= 29) {
                    Runnable runnable = new Runnable(this.$drawLatch){
                        private final /* synthetic */ CountDownLatch $drawLatch;
                        {
                            this.$drawLatch = $drawLatch;
                        }

                        public final void run() {
                            this.$drawLatch.countDown();
                        }
                    };
                    this.$decorView.getViewTreeObserver().registerFrameCommitCallback(runnable);
                } else {
                    this.$decorView.getViewTreeObserver().addOnDrawListener(new ViewTreeObserver.OnDrawListener(this.$handler, this.$drawLatch, this.$decorView){
                        private boolean handled;
                        private final /* synthetic */ Handler $handler;
                        private final /* synthetic */ CountDownLatch $drawLatch;
                        private final /* synthetic */ View $decorView;
                        {
                            this.$handler = $handler;
                            this.$drawLatch = $drawLatch;
                            this.$decorView = $decorView;
                        }

                        public final boolean getHandled() {
                            return this.handled;
                        }

                        public final void setHandled(boolean bl) {
                            this.handled = bl;
                        }

                        public void onDraw() {
                            if (!this.getHandled()) {
                                this.setHandled(true);
                                this.$handler.post(new Runnable(this.$drawLatch, this.$decorView, this){
                                    private final /* synthetic */ CountDownLatch $drawLatch;
                                    private final /* synthetic */ View $decorView;
                                    private final /* synthetic */ captureRegionToBitmap.2 $this;
                                    {
                                        this.$drawLatch = $drawLatch;
                                        this.$decorView = $decorView;
                                        this.$this = $receiver;
                                    }

                                    public final void run() {
                                        this.$drawLatch.countDown();
                                        this.$decorView.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this.$this);
                                    }
                                });
                            }
                        }
                    });
                }
                this.$decorView.invalidate();
            }
        });
        if (!drawLatch.await(1L, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Failed waiting for DecorView redraw!");
        }
        Bitmap destBitmap = Bitmap.createBitmap((int)MathKt.roundToInt((float)captureRect.getWidth()), (int)MathKt.roundToInt((float)captureRect.getHeight()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        android.graphics.Rect srcRect = new android.graphics.Rect(MathKt.roundToInt((float)captureRect.getLeft()), MathKt.roundToInt((float)captureRect.getTop()), MathKt.roundToInt((float)captureRect.getRight()), MathKt.roundToInt((float)captureRect.getBottom()));
        CountDownLatch latch = new CountDownLatch(1);
        Ref.IntRef copyResult = new Ref.IntRef();
        copyResult.element = 0;
        PixelCopy.OnPixelCopyFinishedListener onCopyFinished2 = new PixelCopy.OnPixelCopyFinishedListener(copyResult, latch){
            private final /* synthetic */ Ref.IntRef $copyResult;
            private final /* synthetic */ CountDownLatch $latch;
            {
                this.$copyResult = $copyResult;
                this.$latch = $latch;
            }

            public void onPixelCopyFinished(int result) {
                this.$copyResult.element = result;
                this.$latch.countDown();
            }
        };
        Bitmap bitmap = destBitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"destBitmap");
        PixelCopy.request((Window)window, (android.graphics.Rect)srcRect, (Bitmap)bitmap, (PixelCopy.OnPixelCopyFinishedListener)onCopyFinished2, (Handler)handler);
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Failed waiting for PixelCopy!");
        }
        if (copyResult.element != 0) {
            throw new AssertionError((Object)"PixelCopy failed!");
        }
        bitmap = destBitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"destBitmap");
        return bitmap;
    }

    private static final Activity captureRegionToBitmap$getActivity(Context $this$captureRegionToBitmap_u24getActivity) {
        Activity activity;
        Context context = $this$captureRegionToBitmap_u24getActivity;
        if (context instanceof Activity) {
            activity = (Activity)$this$captureRegionToBitmap_u24getActivity;
        } else if (context instanceof ContextWrapper) {
            Context context2 = ((ContextWrapper)$this$captureRegionToBitmap_u24getActivity).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"this.baseContext");
            activity = WindowCaptureKt.captureRegionToBitmap$getActivity(context2);
        } else {
            activity = null;
        }
        return activity;
    }
}

