/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import android.view.View;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.ui.core.AndroidOwner;
import androidx.ui.core.LayoutNode;
import androidx.ui.core.LayoutNodeKt;
import androidx.ui.core.Owner;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Rect;
import androidx.ui.semantics.AccessibilityRangeInfo;
import androidx.ui.test.ErrorMessagesKt;
import androidx.ui.test.FiltersKt;
import androidx.ui.test.SemanticsMatcher;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.SemanticsNodeInteractionCollection;
import androidx.ui.unit.PxBounds;
import androidx.ui.unit.PxKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\t\u001a\u00020\b*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\n\u001a\u00020\b*\u00020\b2\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u001c\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0006\u001a\u0012\u0010\u001e\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001f\u001a\u0012\u0010 \u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0006\u001a\u0012\u0010!\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0006\u001a\f\u0010\"\u001a\u00020#*\u00020\u0001H\u0002\u001a\f\u0010$\u001a\u00020#*\u00020%H\u0002\u001a\f\u0010&\u001a\u00020'*\u00020%H\u0002\u00a8\u0006("}, d2={"assert", "Landroidx/ui/test/SemanticsNodeInteraction;", "matcher", "Landroidx/ui/test/SemanticsMatcher;", "messagePrefixOnError", "Lkotlin/Function0;", "", "assertAll", "Landroidx/ui/test/SemanticsNodeInteractionCollection;", "assertAny", "assertCountEquals", "expectedSize", "", "assertHasClickAction", "assertHasNoClickAction", "assertIsDisplayed", "assertIsEnabled", "assertIsHidden", "assertIsInMutuallyExclusiveGroup", "assertIsNotDisplayed", "assertIsNotEnabled", "assertIsNotHidden", "assertIsOff", "assertIsOn", "assertIsSelectable", "assertIsSelected", "assertIsToggleable", "assertIsUnselected", "assertLabelEquals", "value", "assertRangeInfoEquals", "Landroidx/ui/semantics/AccessibilityRangeInfo;", "assertTextEquals", "assertValueEquals", "checkIsDisplayed", "", "isInScreenBounds", "Landroidx/ui/core/semantics/SemanticsNode;", "nodeBoundsInWindow", "Landroidx/ui/geometry/Rect;", "ui-test_release"})
public final class AssertionsKt {
    @NotNull
    public static final SemanticsNodeInteraction assertIsHidden(@NotNull SemanticsNodeInteraction $this$assertIsHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsHidden, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsHidden, FiltersKt.isHidden(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotHidden(@NotNull SemanticsNodeInteraction $this$assertIsNotHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsNotHidden, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsNotHidden, FiltersKt.isNotHidden(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsDisplayed(@NotNull SemanticsNodeInteraction $this$assertIsDisplayed) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsDisplayed, (String)"<this>");
        if (!AssertionsKt.checkIsDisplayed($this$assertIsDisplayed)) {
            throw new AssertionError((Object)"Assert failed: The component is not displayed!");
        }
        return $this$assertIsDisplayed;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotDisplayed(@NotNull SemanticsNodeInteraction $this$assertIsNotDisplayed) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsNotDisplayed, (String)"<this>");
        if (AssertionsKt.checkIsDisplayed($this$assertIsNotDisplayed)) {
            throw new AssertionError((Object)"Assert failed: The component is displayed!");
        }
        return $this$assertIsNotDisplayed;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsEnabled(@NotNull SemanticsNodeInteraction $this$assertIsEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsEnabled, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsEnabled, FiltersKt.isEnabled(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotEnabled(@NotNull SemanticsNodeInteraction $this$assertIsNotEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsNotEnabled, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsNotEnabled, FiltersKt.isNotEnabled(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsOn(@NotNull SemanticsNodeInteraction $this$assertIsOn) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsOn, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsOn, FiltersKt.isOn(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsOff(@NotNull SemanticsNodeInteraction $this$assertIsOff) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsOff, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsOff, FiltersKt.isOff(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsSelected(@NotNull SemanticsNodeInteraction $this$assertIsSelected) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsSelected, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsSelected, FiltersKt.isSelected(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsUnselected(@NotNull SemanticsNodeInteraction $this$assertIsUnselected) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsUnselected, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsUnselected, FiltersKt.isUnselected(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsToggleable(@NotNull SemanticsNodeInteraction $this$assertIsToggleable) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsToggleable, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsToggleable, FiltersKt.isToggleable(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsSelectable(@NotNull SemanticsNodeInteraction $this$assertIsSelectable) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsSelectable, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsSelectable, FiltersKt.isSelectable(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsInMutuallyExclusiveGroup(@NotNull SemanticsNodeInteraction $this$assertIsInMutuallyExclusiveGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsInMutuallyExclusiveGroup, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsInMutuallyExclusiveGroup, FiltersKt.isInMutuallyExclusiveGroup(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertLabelEquals(@NotNull SemanticsNodeInteraction $this$assertLabelEquals, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertLabelEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert$default($this$assertLabelEquals, FiltersKt.hasLabel$default(value, false, 2, null), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertTextEquals(@NotNull SemanticsNodeInteraction $this$assertTextEquals, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertTextEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert$default($this$assertTextEquals, FiltersKt.hasText$default(value, false, 2, null), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertValueEquals(@NotNull SemanticsNodeInteraction $this$assertValueEquals, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertValueEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert$default($this$assertValueEquals, FiltersKt.hasValue(value), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertRangeInfoEquals(@NotNull SemanticsNodeInteraction $this$assertRangeInfoEquals, @NotNull AccessibilityRangeInfo value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertRangeInfoEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert$default($this$assertRangeInfoEquals, FiltersKt.hasRangeInfo(value), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertHasClickAction(@NotNull SemanticsNodeInteraction $this$assertHasClickAction) {
        Intrinsics.checkNotNullParameter((Object)$this$assertHasClickAction, (String)"<this>");
        return AssertionsKt.assert$default($this$assertHasClickAction, FiltersKt.hasClickAction(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertHasNoClickAction(@NotNull SemanticsNodeInteraction $this$assertHasNoClickAction) {
        Intrinsics.checkNotNullParameter((Object)$this$assertHasNoClickAction, (String)"<this>");
        return AssertionsKt.assert$default($this$assertHasNoClickAction, FiltersKt.hasNoClickAction(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assert(@NotNull SemanticsNodeInteraction $this$assert, @NotNull SemanticsMatcher matcher, @Nullable Function0<String> messagePrefixOnError) {
        SemanticsNode node;
        Intrinsics.checkNotNullParameter((Object)$this$assert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String errorMessageOnFail = "Failed to assert the following: (" + matcher.getDescription() + ")";
        if (messagePrefixOnError != null) {
            errorMessageOnFail = (String)messagePrefixOnError.invoke() + "\n" + errorMessageOnFail;
        }
        if (!matcher.matches(node = $this$assert.fetchSemanticsNode(errorMessageOnFail))) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(errorMessageOnFail, $this$assert.getSelector$ui_test_release(), node));
        }
        return $this$assert;
    }

    public static /* synthetic */ SemanticsNodeInteraction assert$default(SemanticsNodeInteraction $this$assert_u24default, SemanticsMatcher matcher, Function0 messagePrefixOnError, int n, Object object) {
        if ((n & 2) != 0) {
            messagePrefixOnError = null;
        }
        return AssertionsKt.assert($this$assert_u24default, matcher, (Function0<String>)messagePrefixOnError);
    }

    @NotNull
    public static final SemanticsNodeInteractionCollection assertCountEquals(@NotNull SemanticsNodeInteractionCollection $this$assertCountEquals, int expectedSize) {
        Intrinsics.checkNotNullParameter((Object)$this$assertCountEquals, (String)"<this>");
        String errorOnFail = "Failed to assert count of nodes.";
        List<SemanticsNode> matchedNodes = $this$assertCountEquals.fetchSemanticsNodes(errorOnFail);
        if (matchedNodes.size() != expectedSize) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForCountMismatch(errorOnFail, $this$assertCountEquals.getSelector$ui_test_release(), matchedNodes, expectedSize));
        }
        return $this$assertCountEquals;
    }

    @NotNull
    public static final SemanticsNodeInteractionCollection assertAny(@NotNull SemanticsNodeInteractionCollection $this$assertAny, @NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)$this$assertAny, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String errorOnFail = "Failed to assertAny(" + matcher.getDescription() + ")";
        List<SemanticsNode> nodes = $this$assertAny.fetchSemanticsNodes(errorOnFail);
        if (nodes.isEmpty()) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForAtLeastOneNodeExpected(errorOnFail, $this$assertAny.getSelector$ui_test_release()));
        }
        if (!matcher.matchesAny((Iterable<SemanticsNode>)nodes)) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForAssertAnyFail($this$assertAny.getSelector$ui_test_release(), nodes, matcher));
        }
        return $this$assertAny;
    }

    @NotNull
    public static final SemanticsNodeInteractionCollection assertAll(@NotNull SemanticsNodeInteractionCollection $this$assertAll, @NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)$this$assertAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String errorOnFail = "Failed to assertAll(" + matcher.getDescription() + ")";
        List<SemanticsNode> nodes = $this$assertAll.fetchSemanticsNodes(errorOnFail);
        boolean bl = false;
        List violations = new ArrayList();
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SemanticsNode it = (SemanticsNode)element$iv;
            boolean bl2 = false;
            if (matcher.matches(it)) continue;
            violations.add(it);
        }
        Collection collection = violations;
        boolean bl3 = false;
        if (!collection.isEmpty()) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForAssertAllFail($this$assertAll.getSelector$ui_test_release(), violations, matcher));
        }
        return $this$assertAll;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkIsDisplayed(SemanticsNodeInteraction $this$checkIsDisplayed) {
        AndroidOwner androidOwner;
        String errorMessageOnFail = "Failed to perform isDisplayed check.";
        SemanticsNode node = $this$checkIsDisplayed.fetchSemanticsNode(errorMessageOnFail);
        LayoutNode layoutNode = node.getComponentNode();
        if (AssertionsKt.checkIsDisplayed$isNotPlaced(layoutNode)) return false;
        if (LayoutNodeKt.findClosestParentNode((LayoutNode)layoutNode, (Function1)((Function1)new Function1<LayoutNode, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull LayoutNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return AssertionsKt.access$checkIsDisplayed$isNotPlaced(p0);
            }

            @NotNull
            public final String getSignature() {
                return "checkIsDisplayed$isNotPlaced(Landroidx/ui/core/LayoutNode;)Z";
            }

            @NotNull
            public final String getName() {
                return "isNotPlaced";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Object.class);
            }
        })) != null) {
            return false;
        }
        Owner owner = layoutNode.getOwner();
        AndroidOwner androidOwner2 = androidOwner = owner instanceof AndroidOwner ? (AndroidOwner)owner : null;
        if (androidOwner != null) {
            owner = androidOwner;
            boolean bl = false;
            boolean bl2 = false;
            Owner it = owner;
            boolean bl3 = false;
            if (!ViewMatchers.isDisplayed().matches((Object)it.getView())) {
                return false;
            }
        }
        PxBounds globalRect = node.getGlobalBounds();
        if (!AssertionsKt.isInScreenBounds(node)) {
            return false;
        }
        PxBounds $this$width$iv = globalRect;
        boolean $i$f$getWidth = false;
        if (!($this$width$iv.getRight() - $this$width$iv.getLeft() > 0.0f)) return false;
        PxBounds $this$height$iv = globalRect;
        boolean $i$f$getHeight = false;
        if (!($this$height$iv.getBottom() - $this$height$iv.getTop() > 0.0f)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Rect nodeBoundsInWindow(SemanticsNode $this$nodeBoundsInWindow) {
        long l;
        void x$iv;
        Owner owner = $this$nodeBoundsInWindow.getComponentNode().getOwner();
        if (owner == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.ui.core.AndroidOwner");
        }
        View composeView = ((AndroidOwner)owner).getView();
        int[] nArray = new int[]{0, 0};
        boolean bl = false;
        boolean bl2 = false;
        int[] it = nArray;
        boolean bl3 = false;
        composeView.getLocationInWindow(it);
        float f = it[0];
        float y$iv = it[1];
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var12_12 = x$iv;
        boolean bl4 = false;
        long v1$iv$iv = Float.floatToIntBits((float)var12_12);
        float f2 = y$iv;
        boolean bl5 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        Offset rootLocationInWindow = new Offset(l2);
        return PxKt.toRect((PxBounds)$this$nodeBoundsInWindow.getBoundsInRoot()).shift(rootLocationInWindow);
    }

    private static final boolean isInScreenBounds(SemanticsNode $this$isInScreenBounds) {
        Owner owner = $this$isInScreenBounds.getComponentNode().getOwner();
        if (owner == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.ui.core.AndroidOwner");
        }
        View composeView = ((AndroidOwner)owner).getView();
        Rect nodeBoundsInWindow = AssertionsKt.nodeBoundsInWindow($this$isInScreenBounds);
        if (nodeBoundsInWindow.getWidth() == 0.0f || nodeBoundsInWindow.getHeight() == 0.0f) {
            return false;
        }
        android.graphics.Rect globalRootRect = new android.graphics.Rect();
        if (!composeView.getGlobalVisibleRect(globalRootRect)) {
            return false;
        }
        return nodeBoundsInWindow.getTop() >= (float)globalRootRect.top && nodeBoundsInWindow.getLeft() >= (float)globalRootRect.left && nodeBoundsInWindow.getRight() <= (float)globalRootRect.right && nodeBoundsInWindow.getBottom() <= (float)globalRootRect.bottom;
    }

    private static final boolean checkIsDisplayed$isNotPlaced(LayoutNode node) {
        return !node.isPlaced();
    }

    public static final /* synthetic */ boolean access$checkIsDisplayed$isNotPlaced(LayoutNode layoutNode) {
        return AssertionsKt.checkIsDisplayed$isNotPlaced(layoutNode);
    }
}

