/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.semantics.SemanticsConfiguration;
import androidx.ui.core.semantics.SemanticsConfigurationKt;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.foundation.selection.ToggleableState;
import androidx.ui.foundation.semantics.FoundationSemanticsProperties;
import androidx.ui.input.ImeAction;
import androidx.ui.semantics.AccessibilityRangeInfo;
import androidx.ui.semantics.SemanticsActions;
import androidx.ui.semantics.SemanticsProperties;
import androidx.ui.semantics.SemanticsPropertyKey;
import androidx.ui.test.SemanticsMatcher;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.TextSemanticsProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0018\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e\u001a\u0006\u0010\u000f\u001a\u00020\u0006\u001a\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\u0006\u0010\u0015\u001a\u00020\u0006\u001a\u0006\u0010\u0016\u001a\u00020\u0006\u001a\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0006\u0010\u001b\u001a\u00020\u0006\u001a\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0012\u001a\u0018\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0012\u001a\u0006\u0010$\u001a\u00020\u0006\u001a\u0006\u0010%\u001a\u00020\u0006\u001a\u0006\u0010&\u001a\u00020\u0006\u001a\u0006\u0010'\u001a\u00020\u0006\u001a\u0006\u0010(\u001a\u00020\u0006\u001a\u0006\u0010)\u001a\u00020\u0006\u001a\u0006\u0010*\u001a\u00020\u0006\u001a\u0006\u0010+\u001a\u00020\u0006\u001a\u0006\u0010,\u001a\u00020\u0006\u001a\u0006\u0010-\u001a\u00020\u0006\u001a\u0006\u0010.\u001a\u00020\u0006\u001a\u0006\u0010/\u001a\u00020\u0006\u001a\u0006\u00100\u001a\u00020\u0006\u001a\u0006\u00101\u001a\u00020\u0006\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u00062"}, d2={"ancestors", "", "Landroidx/ui/core/semantics/SemanticsNode;", "getAncestors", "(Landroidx/ui/core/semantics/SemanticsNode;)Ljava/lang/Iterable;", "hasAnyAncestorThat", "Landroidx/ui/test/SemanticsMatcher;", "matcher", "hasAnyChildThat", "hasAnyDescendantThat", "hasAnySiblingThat", "hasClickAction", "hasImeAction", "actionType", "Landroidx/ui/input/ImeAction;", "hasInputMethodsSupport", "hasLabel", "label", "", "ignoreCase", "", "hasNoClickAction", "hasNoScrollAction", "hasParentThat", "hasRangeInfo", "rangeInfo", "Landroidx/ui/semantics/AccessibilityRangeInfo;", "hasScrollAction", "hasSubstring", "substring", "hasTestTag", "testTag", "hasText", "text", "hasValue", "value", "isDialog", "isEnabled", "isHidden", "isInMutuallyExclusiveGroup", "isNotEnabled", "isNotHidden", "isOff", "isOn", "isPopup", "isRoot", "isSelectable", "isSelected", "isToggleable", "isUnselected", "ui-test_release"})
public final class FiltersKt {
    @NotNull
    public static final SemanticsMatcher isEnabled() {
        return SemanticsMatcher.Companion.expectValue(SemanticsProperties.INSTANCE.getEnabled(), true);
    }

    @NotNull
    public static final SemanticsMatcher isNotEnabled() {
        return SemanticsMatcher.Companion.expectValue(SemanticsProperties.INSTANCE.getEnabled(), false);
    }

    @NotNull
    public static final SemanticsMatcher isToggleable() {
        return SemanticsMatcher.Companion.keyIsDefined(FoundationSemanticsProperties.INSTANCE.getToggleableState());
    }

    @NotNull
    public static final SemanticsMatcher isOn() {
        return SemanticsMatcher.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getToggleableState(), ToggleableState.On);
    }

    @NotNull
    public static final SemanticsMatcher isOff() {
        return SemanticsMatcher.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getToggleableState(), ToggleableState.Off);
    }

    @NotNull
    public static final SemanticsMatcher isSelectable() {
        return SemanticsMatcher.Companion.keyIsDefined(FoundationSemanticsProperties.INSTANCE.getSelected());
    }

    @NotNull
    public static final SemanticsMatcher isSelected() {
        return SemanticsMatcher.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getSelected(), true);
    }

    @NotNull
    public static final SemanticsMatcher isUnselected() {
        return SemanticsMatcher.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getSelected(), false);
    }

    @NotNull
    public static final SemanticsMatcher hasClickAction() {
        return SemanticsMatcher.Companion.keyIsDefined(SemanticsActions.INSTANCE.getOnClick());
    }

    @NotNull
    public static final SemanticsMatcher hasNoClickAction() {
        return SemanticsMatcher.Companion.keyNotDefined(SemanticsActions.INSTANCE.getOnClick());
    }

    @NotNull
    public static final SemanticsMatcher hasScrollAction() {
        return SemanticsMatcher.Companion.keyIsDefined(SemanticsActions.INSTANCE.getScrollTo());
    }

    @NotNull
    public static final SemanticsMatcher hasNoScrollAction() {
        return SemanticsMatcher.Companion.keyNotDefined(SemanticsActions.INSTANCE.getScrollTo());
    }

    @NotNull
    public static final SemanticsMatcher hasLabel(@NotNull String label, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return new SemanticsMatcher(SemanticsProperties.INSTANCE.getAccessibilityLabel().getName() + " = '" + label + "' (ignoreCase: " + ignoreCase + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(label, ignoreCase){
            private final /* synthetic */ String $label;
            private final /* synthetic */ boolean $ignoreCase;
            {
                this.$label = $label;
                this.$ignoreCase = $ignoreCase;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.equals((String)((String)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)it.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getAccessibilityLabel())), (String)this.$label, (boolean)this.$ignoreCase);
            }
        }));
    }

    public static /* synthetic */ SemanticsMatcher hasLabel$default(String label, boolean ignoreCase, int n, Object object) {
        if ((n & 2) != 0) {
            ignoreCase = false;
        }
        return FiltersKt.hasLabel(label, ignoreCase);
    }

    @NotNull
    public static final SemanticsMatcher hasText(@NotNull String text, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new SemanticsMatcher(SemanticsProperties.INSTANCE.getText().getName() + " = '" + text + "' (ignoreCase: " + ignoreCase + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(text, ignoreCase){
            private final /* synthetic */ String $text;
            private final /* synthetic */ boolean $ignoreCase;
            {
                this.$text = $text;
                this.$ignoreCase = $ignoreCase;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AnnotatedString annotatedString = (AnnotatedString)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)it.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getText());
                return StringsKt.equals((String)(annotatedString == null ? (String)null : annotatedString.getText()), (String)this.$text, (boolean)this.$ignoreCase);
            }
        }));
    }

    public static /* synthetic */ SemanticsMatcher hasText$default(String text, boolean ignoreCase, int n, Object object) {
        if ((n & 2) != 0) {
            ignoreCase = false;
        }
        return FiltersKt.hasText(text, ignoreCase);
    }

    @NotNull
    public static final SemanticsMatcher hasSubstring(@NotNull String substring, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        return new SemanticsMatcher(SemanticsProperties.INSTANCE.getText().getName() + ".contains(" + substring + ", " + ignoreCase + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(substring, ignoreCase){
            private final /* synthetic */ String $substring;
            private final /* synthetic */ boolean $ignoreCase;
            {
                this.$substring = $substring;
                this.$ignoreCase = $ignoreCase;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AnnotatedString annotatedString = (AnnotatedString)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)it.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getText());
                String string = annotatedString == null ? (String)null : annotatedString.getText();
                Boolean bl = string == null ? (Boolean)null : Boolean.valueOf(StringsKt.contains((CharSequence)string, (CharSequence)this.$substring, (boolean)this.$ignoreCase));
                return bl == null ? false : bl;
            }
        }));
    }

    public static /* synthetic */ SemanticsMatcher hasSubstring$default(String substring, boolean ignoreCase, int n, Object object) {
        if ((n & 2) != 0) {
            ignoreCase = false;
        }
        return FiltersKt.hasSubstring(substring, ignoreCase);
    }

    @NotNull
    public static final SemanticsMatcher hasValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return SemanticsMatcher.Companion.expectValue(SemanticsProperties.INSTANCE.getAccessibilityValue(), value);
    }

    @NotNull
    public static final SemanticsMatcher hasRangeInfo(@NotNull AccessibilityRangeInfo rangeInfo) {
        Intrinsics.checkNotNullParameter((Object)rangeInfo, (String)"rangeInfo");
        return SemanticsMatcher.Companion.expectValue(SemanticsProperties.INSTANCE.getAccessibilityRangeInfo(), rangeInfo);
    }

    @NotNull
    public static final SemanticsMatcher hasTestTag(@NotNull String testTag) {
        Intrinsics.checkNotNullParameter((Object)testTag, (String)"testTag");
        return SemanticsMatcher.Companion.expectValue(SemanticsProperties.INSTANCE.getTestTag(), testTag);
    }

    @NotNull
    public static final SemanticsMatcher isInMutuallyExclusiveGroup() {
        return SemanticsMatcher.Companion.expectValue(FoundationSemanticsProperties.INSTANCE.getInMutuallyExclusiveGroup(), true);
    }

    @NotNull
    public static final SemanticsMatcher isHidden() {
        return SemanticsMatcher.Companion.expectValue(SemanticsProperties.INSTANCE.getHidden(), true);
    }

    @NotNull
    public static final SemanticsMatcher isNotHidden() {
        return SemanticsMatcher.Companion.expectValue(SemanticsProperties.INSTANCE.getHidden(), false);
    }

    @NotNull
    public static final SemanticsMatcher isDialog() {
        return SemanticsMatcher.Companion.keyIsDefined(FoundationSemanticsProperties.INSTANCE.getIsDialog());
    }

    @NotNull
    public static final SemanticsMatcher isPopup() {
        return SemanticsMatcher.Companion.keyIsDefined(SemanticsProperties.INSTANCE.getIsPopup());
    }

    @NotNull
    public static final SemanticsMatcher hasImeAction(@NotNull ImeAction actionType) {
        Intrinsics.checkNotNullParameter((Object)actionType, (String)"actionType");
        return SemanticsMatcher.Companion.expectValue(TextSemanticsProperties.INSTANCE.getImeAction(), actionType);
    }

    @NotNull
    public static final SemanticsMatcher hasInputMethodsSupport() {
        return SemanticsMatcher.Companion.expectValue(TextSemanticsProperties.INSTANCE.getSupportsInputMethods(), true);
    }

    @NotNull
    public static final SemanticsMatcher isRoot() {
        return new SemanticsMatcher("isRoot", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(){

            public final boolean invoke(@NotNull SemanticsNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.isRoot();
            }
        }));
    }

    @NotNull
    public static final SemanticsMatcher hasParentThat(@NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new SemanticsMatcher("hasParentThat(" + matcher.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(matcher){
            private final /* synthetic */ SemanticsMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode it) {
                Boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SemanticsNode semanticsNode = it.getParent();
                if (semanticsNode == null) {
                    bl = null;
                } else {
                    SemanticsNode semanticsNode2 = semanticsNode;
                    SemanticsMatcher semanticsMatcher = this.$matcher;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    SemanticsNode $this$invoke_u24lambda_u2d0 = semanticsNode2;
                    boolean bl4 = false;
                    bl = semanticsMatcher.matches($this$invoke_u24lambda_u2d0);
                }
                Boolean bl5 = bl;
                return bl5 == null ? false : bl5;
            }
        }));
    }

    @NotNull
    public static final SemanticsMatcher hasAnyChildThat(@NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new SemanticsMatcher("hasAnyChildThat(" + matcher.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(matcher){
            private final /* synthetic */ SemanticsMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$matcher.matchesAny(it.getChildren());
            }
        }));
    }

    @NotNull
    public static final SemanticsMatcher hasAnySiblingThat(@NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new SemanticsMatcher("hasAnySiblingThat(" + matcher.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(matcher){
            private final /* synthetic */ SemanticsMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull SemanticsNode it) {
                Boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SemanticsNode node = it;
                SemanticsNode semanticsNode = it.getParent();
                if (semanticsNode == null) {
                    bl = null;
                } else {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    SemanticsNode semanticsNode2 = semanticsNode;
                    SemanticsMatcher semanticsMatcher = this.$matcher;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    SemanticsNode $this$invoke_u24lambda_u2d1 = semanticsNode2;
                    boolean bl4 = false;
                    Iterable iterable = $this$invoke_u24lambda_u2d1.getChildren();
                    SemanticsMatcher semanticsMatcher2 = semanticsMatcher;
                    boolean $i$f$filter = false;
                    void var14_13 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        SemanticsNode child2 = (SemanticsNode)element$iv$iv;
                        boolean bl5 = false;
                        if (!(child2.getId() != node.getId())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List list = (List)destination$iv$iv;
                    bl = semanticsMatcher2.matchesAny(list);
                }
                Boolean bl6 = bl;
                return bl6 == null ? false : bl6;
            }
        }));
    }

    @NotNull
    public static final SemanticsMatcher hasAnyAncestorThat(@NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new SemanticsMatcher("hasAnyAncestorThat(" + matcher.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(matcher){
            private final /* synthetic */ SemanticsMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$matcher.matchesAny(FiltersKt.getAncestors(it));
            }
        }));
    }

    @NotNull
    public static final SemanticsMatcher hasAnyDescendantThat(@NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return new SemanticsMatcher("hasAnyDescendantThat(" + matcher.getDescription() + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)new Function1<SemanticsNode, Boolean>(matcher){
            private final /* synthetic */ SemanticsMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            public final boolean invoke(@NotNull SemanticsNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FiltersKt.access$hasAnyDescendantThat$checkIfSubtreeMatches(this.$matcher, it);
            }
        }));
    }

    @NotNull
    public static final Iterable<SemanticsNode> getAncestors(@NotNull SemanticsNode $this$ancestors) {
        Intrinsics.checkNotNullParameter((Object)$this$ancestors, (String)"<this>");
        return new Iterable<SemanticsNode>($this$ancestors){
            private final /* synthetic */ SemanticsNode $this;
            {
                this.$this = $receiver;
            }

            @NotNull
            public Iterator<SemanticsNode> iterator() {
                return new Iterator<SemanticsNode>(this.$this){
                    private SemanticsNode next;
                    private final /* synthetic */ SemanticsNode $this;
                    {
                        this.$this = $receiver;
                        this.next = this.$this.getParent();
                    }

                    @Nullable
                    public final SemanticsNode getNext() {
                        return this.next;
                    }

                    public final void setNext(@Nullable SemanticsNode semanticsNode) {
                        this.next = semanticsNode;
                    }

                    public boolean hasNext() {
                        return this.getNext() != null;
                    }

                    @NotNull
                    public SemanticsNode next() {
                        SemanticsNode semanticsNode = this.getNext();
                        Intrinsics.checkNotNull((Object)semanticsNode);
                        boolean bl = false;
                        boolean bl2 = false;
                        SemanticsNode it = semanticsNode;
                        boolean bl3 = false;
                        this.setNext(it.getParent());
                        return semanticsNode;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    private static final boolean hasAnyDescendantThat$checkIfSubtreeMatches(SemanticsMatcher matcher, SemanticsNode node) {
        boolean bl;
        block3: {
            if (matcher.matchesAny(node.getChildren())) {
                return true;
            }
            List $this$fastAny$iv = node.getChildren();
            boolean $i$f$fastAny = false;
            List $this$fastForEach$iv$iv = $this$fastAny$iv;
            boolean $i$f$fastForEach = false;
            int n = 0;
            int n2 = ((Collection)$this$fastForEach$iv$iv).size() + -1;
            if (n <= n2) {
                do {
                    Object item$iv$iv;
                    int index$iv$iv = n++;
                    Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl2 = false;
                    SemanticsNode it = (SemanticsNode)it$iv;
                    boolean bl3 = false;
                    if (!FiltersKt.hasAnyDescendantThat$checkIfSubtreeMatches(matcher, it)) continue;
                    bl = true;
                    break block3;
                } while (n <= n2);
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$hasAnyDescendantThat$checkIfSubtreeMatches(SemanticsMatcher semanticsMatcher, SemanticsNode semanticsNode) {
        return FiltersKt.hasAnyDescendantThat$checkIfSubtreeMatches(semanticsMatcher, semanticsNode);
    }
}

