/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.annotation.FloatRange;
import androidx.ui.core.gesture.ConstantsKt;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.OffsetKt;
import androidx.ui.test.BaseGestureScope;
import androidx.ui.test.GestureScope;
import androidx.ui.test.InputDispatcher;
import androidx.ui.test.PartialGestureScope;
import androidx.ui.unit.Duration;
import androidx.ui.unit.Durations;
import androidx.ui.unit.IntSize;
import androidx.ui.unit.PxBounds;
import androidx.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0015\u001a4\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u0003092\u0006\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u0003H\u0002\u001a\u0012\u0010?\u001a\u00020\t*\u00020\u00052\u0006\u0010@\u001a\u00020\t\u001a\u001a\u0010A\u001a\u00020B*\u00020C2\u0006\u0010D\u001a\u00020\u001f2\u0006\u0010E\u001a\u00020\t\u001a\u001a\u0010F\u001a\u00020B*\u00020C2\u0006\u0010D\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020\t\u001a\u001e\u0010G\u001a\u00020\t*\u00020\u00052\b\b\u0003\u0010H\u001a\u00020\u00032\b\b\u0003\u0010I\u001a\u00020\u0003\u001a\n\u0010J\u001a\u00020B*\u00020C\u001a\u0014\u0010K\u001a\u00020B*\u00020L2\b\b\u0002\u0010@\u001a\u00020\t\u001a\u001e\u0010M\u001a\u00020B*\u00020L2\b\b\u0002\u0010@\u001a\u00020\t2\b\b\u0002\u0010N\u001a\u00020\u0001\u001a\u0012\u0010O\u001a\u00020B*\u00020C2\u0006\u0010@\u001a\u00020\t\u001a\u001a\u0010O\u001a\u00020B*\u00020C2\u0006\u0010D\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020\t\u001a\u001e\u0010P\u001a\u00020B*\u00020L2\b\b\u0002\u0010@\u001a\u00020\t2\b\b\u0002\u0010;\u001a\u00020\u0001\u001a\n\u0010Q\u001a\u00020B*\u00020C\u001a\u0012\u0010R\u001a\u00020B*\u00020C2\u0006\u0010E\u001a\u00020\t\u001a\u001a\u0010R\u001a\u00020B*\u00020C2\u0006\u0010D\u001a\u00020\u001f2\u0006\u0010E\u001a\u00020\t\u001a\u0012\u0010S\u001a\u00020B*\u00020C2\u0006\u0010@\u001a\u00020\t\u001a\u001a\u0010S\u001a\u00020B*\u00020C2\u0006\u0010D\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020\t\u001a4\u0010T\u001a\u00020B*\u00020L2\u0006\u0010U\u001a\u00020\t2\u0006\u0010V\u001a\u00020\t2\u0006\u0010W\u001a\u00020\t2\u0006\u0010X\u001a\u00020\t2\b\b\u0002\u0010;\u001a\u00020\u0001\u001a$\u0010Y\u001a\u00020B*\u00020L2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\b\b\u0002\u0010;\u001a\u00020\u0001\u001a\n\u0010Z\u001a\u00020B*\u00020L\u001a\n\u0010[\u001a\u00020B*\u00020L\u001a\n\u0010\\\u001a\u00020B*\u00020L\u001a\n\u0010]\u001a\u00020B*\u00020L\u001a.\u0010^\u001a\u00020B*\u00020L2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\b\b\u0001\u0010_\u001a\u00020\u00032\b\b\u0002\u0010;\u001a\u00020\u0001\u001a\u0014\u0010`\u001a\u00020B*\u00020C2\b\b\u0002\u0010D\u001a\u00020\u001f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\u00020\u0003*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\t*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\"\u0015\u0010\u000e\u001a\u00020\t*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\"\u0015\u0010\u0010\u001a\u00020\t*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\"\u0015\u0010\u0012\u001a\u00020\t*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000b\"\u0015\u0010\u0014\u001a\u00020\t*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000b\"\u0016\u0010\u0016\u001a\u00020\u0003*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007\"\u0016\u0010\u0018\u001a\u00020\u0003*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007\"\u0015\u0010\u001a\u001a\u00020\u001b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\"\u0016\u0010\u001e\u001a\u00020\u001f*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"\u001c\u0010\"\u001a\u00020\u0003*\u00020\u00058\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b#\u0010$\u001a\u0004\b%\u0010\u0007\"\u0016\u0010&\u001a\u00020\u0003*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0007\"\u0015\u0010(\u001a\u00020)*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\"\u001c\u0010,\u001a\u00020\u0003*\u00020\u00058\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b-\u0010$\u001a\u0004\b.\u0010\u0007\"\u0015\u0010/\u001a\u00020\t*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u000b\"\u001b\u00101\u001a\u00020\t*\u00020\u00058F\u00a2\u0006\f\u0012\u0004\b2\u0010$\u001a\u0004\b3\u0010\u000b\"\u0015\u00104\u001a\u00020\t*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u000b\"\u0016\u00106\u001a\u00020\u001f*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b7\u0010!\u00a8\u0006a"}, d2={"doubleClickDelay", "Landroidx/ui/unit/Duration;", "edgeFuzzFactor", "", "bottom", "Landroidx/ui/test/BaseGestureScope;", "getBottom", "(Landroidx/ui/test/BaseGestureScope;)F", "bottomCenter", "Landroidx/ui/geometry/Offset;", "getBottomCenter", "(Landroidx/ui/test/BaseGestureScope;)Landroidx/ui/geometry/Offset;", "bottomLeft", "getBottomLeft", "bottomRight", "getBottomRight", "center", "getCenter", "centerLeft", "getCenterLeft", "centerRight", "getCenterRight", "centerX", "getCenterX", "centerY", "getCenterY", "globalBounds", "Landroidx/ui/unit/PxBounds;", "getGlobalBounds", "(Landroidx/ui/test/BaseGestureScope;)Landroidx/ui/unit/PxBounds;", "height", "", "getHeight", "(Landroidx/ui/test/BaseGestureScope;)I", "left", "getLeft$annotations", "(Landroidx/ui/test/BaseGestureScope;)V", "getLeft", "right", "getRight", "size", "Landroidx/ui/unit/IntSize;", "getSize", "(Landroidx/ui/test/BaseGestureScope;)Landroidx/ui/unit/IntSize;", "top", "getTop$annotations", "getTop", "topCenter", "getTopCenter", "topLeft", "getTopLeft$annotations", "getTopLeft", "topRight", "getTopRight", "width", "getWidth", "createFunctionForVelocity", "Lkotlin/Function1;", "", "duration", "start", "end", "velocity", "localToGlobal", "position", "movePointerBy", "", "Landroidx/ui/test/PartialGestureScope;", "pointerId", "delta", "movePointerTo", "percentOffset", "x", "y", "sendCancel", "sendClick", "Landroidx/ui/test/GestureScope;", "sendDoubleClick", "delay", "sendDown", "sendLongClick", "sendMove", "sendMoveBy", "sendMoveTo", "sendPinch", "start0", "end0", "start1", "end1", "sendSwipe", "sendSwipeDown", "sendSwipeLeft", "sendSwipeRight", "sendSwipeUp", "sendSwipeWithVelocity", "endVelocity", "sendUp", "ui-test_release"})
public final class GestureScopeKt {
    private static final float edgeFuzzFactor = 0.083f;
    private static final Duration doubleClickDelay = Durations.getMilliseconds((int)145);

    @NotNull
    public static final IntSize getSize(@NotNull BaseGestureScope $this$size) {
        Intrinsics.checkNotNullParameter((Object)$this$size, (String)"<this>");
        return $this$size.getSemanticsNode$ui_test_release().getSize();
    }

    public static final int getWidth(@NotNull BaseGestureScope $this$width) {
        Intrinsics.checkNotNullParameter((Object)$this$width, (String)"<this>");
        boolean $i$f$getWidth = false;
        return GestureScopeKt.getSize($this$width).getWidth();
    }

    public static final int getHeight(@NotNull BaseGestureScope $this$height) {
        Intrinsics.checkNotNullParameter((Object)$this$height, (String)"<this>");
        boolean $i$f$getHeight = false;
        return GestureScopeKt.getSize($this$height).getHeight();
    }

    public static final float getLeft(@NotNull BaseGestureScope $this$left) {
        Intrinsics.checkNotNullParameter((Object)$this$left, (String)"<this>");
        boolean $i$f$getLeft = false;
        return 0.0f;
    }

    public static /* synthetic */ void getLeft$annotations(@NotNull BaseGestureScope $this$getLeft_u24annotations) {
    }

    public static final float getTop(@NotNull BaseGestureScope $this$top) {
        Intrinsics.checkNotNullParameter((Object)$this$top, (String)"<this>");
        boolean $i$f$getTop = false;
        return 0.0f;
    }

    public static /* synthetic */ void getTop$annotations(@NotNull BaseGestureScope $this$getTop_u24annotations) {
    }

    public static final float getCenterX(@NotNull BaseGestureScope $this$centerX) {
        Intrinsics.checkNotNullParameter((Object)$this$centerX, (String)"<this>");
        boolean $i$f$getCenterX = false;
        BaseGestureScope $this$width$iv = $this$centerX;
        boolean $i$f$getWidth = false;
        return (float)GestureScopeKt.getSize($this$width$iv).getWidth() / 2.0f;
    }

    public static final float getCenterY(@NotNull BaseGestureScope $this$centerY) {
        Intrinsics.checkNotNullParameter((Object)$this$centerY, (String)"<this>");
        boolean $i$f$getCenterY = false;
        BaseGestureScope $this$height$iv = $this$centerY;
        boolean $i$f$getHeight = false;
        return (float)GestureScopeKt.getSize($this$height$iv).getHeight() / 2.0f;
    }

    public static final float getRight(@NotNull BaseGestureScope $this$right) {
        Intrinsics.checkNotNullParameter((Object)$this$right, (String)"<this>");
        boolean $i$f$getRight = false;
        BaseGestureScope $this$width$iv = $this$right;
        boolean $i$f$getWidth = false;
        int n = GestureScopeKt.getSize($this$width$iv).getWidth();
        boolean bl = false;
        boolean bl2 = false;
        int it = n;
        boolean bl3 = false;
        return it == 0 ? 0.0f : (float)it - 1.0f;
    }

    public static final float getBottom(@NotNull BaseGestureScope $this$bottom) {
        Intrinsics.checkNotNullParameter((Object)$this$bottom, (String)"<this>");
        boolean $i$f$getBottom = false;
        BaseGestureScope $this$height$iv = $this$bottom;
        boolean $i$f$getHeight = false;
        int n = GestureScopeKt.getSize($this$height$iv).getHeight();
        boolean bl = false;
        boolean bl2 = false;
        int it = n;
        boolean bl3 = false;
        return it == 0 ? 0.0f : (float)it - 1.0f;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Offset getTopLeft(@NotNull BaseGestureScope $this$topLeft) {
        long l;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$topLeft, (String)"<this>");
        BaseGestureScope $this$left$iv22 = $this$topLeft;
        boolean $i$f$getLeft = false;
        float $this$left$iv22 = 0.0f;
        BaseGestureScope $this$top$iv = $this$topLeft;
        boolean $i$f$getTop = false;
        float y$iv = 0.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_8 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_8);
        float f = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new Offset(l2);
    }

    public static /* synthetic */ void getTopLeft$annotations(@NotNull BaseGestureScope $this$getTopLeft_u24annotations) {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Offset getTopCenter(@NotNull BaseGestureScope $this$topCenter) {
        long l;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$topCenter, (String)"<this>");
        BaseGestureScope $this$centerX$iv22 = $this$topCenter;
        boolean $i$f$getCenterX = false;
        BaseGestureScope $this$width$iv$iv = $this$centerX$iv22;
        boolean $i$f$getWidth = false;
        float $this$centerX$iv22 = (float)GestureScopeKt.getSize($this$width$iv$iv).getWidth() / 2.0f;
        BaseGestureScope $this$top$iv = $this$topCenter;
        boolean $i$f$getTop = false;
        float y$iv = 0.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_9 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_9);
        float f = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new Offset(l2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Offset getTopRight(@NotNull BaseGestureScope $this$topRight) {
        long l;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$topRight, (String)"<this>");
        BaseGestureScope $this$right$iv22 = $this$topRight;
        boolean $i$f$getRight = false;
        BaseGestureScope $this$width$iv$iv22 = $this$right$iv22;
        boolean $i$f$getWidth = false;
        int $this$width$iv$iv22 = GestureScopeKt.getSize($this$width$iv$iv22).getWidth();
        $i$f$getWidth = false;
        boolean bl = false;
        int it$iv = $this$width$iv$iv22;
        boolean bl2 = false;
        float $this$right$iv22 = it$iv == 0 ? 0.0f : (float)it$iv - 1.0f;
        BaseGestureScope $this$top$iv = $this$topRight;
        boolean $i$f$getTop = false;
        float y$iv = 0.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_10 = x$iv;
        boolean bl3 = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_10);
        float f = y$iv;
        boolean bl4 = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new Offset(l2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Offset getCenterLeft(@NotNull BaseGestureScope $this$centerLeft) {
        long l;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$centerLeft, (String)"<this>");
        BaseGestureScope $this$left$iv22 = $this$centerLeft;
        boolean $i$f$getLeft = false;
        float $this$left$iv22 = 0.0f;
        BaseGestureScope $this$centerY$iv = $this$centerLeft;
        boolean $i$f$getCenterY = false;
        BaseGestureScope $this$height$iv$iv = $this$centerY$iv;
        boolean $i$f$getHeight = false;
        float y$iv = (float)GestureScopeKt.getSize($this$height$iv$iv).getHeight() / 2.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_10 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_10);
        float f = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new Offset(l2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Offset getCenter(@NotNull BaseGestureScope $this$center) {
        long l;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$center, (String)"<this>");
        BaseGestureScope $this$centerX$iv22 = $this$center;
        boolean $i$f$getCenterX = false;
        BaseGestureScope $this$width$iv$iv = $this$centerX$iv22;
        boolean $i$f$getWidth = false;
        float $this$centerX$iv22 = (float)GestureScopeKt.getSize($this$width$iv$iv).getWidth() / 2.0f;
        BaseGestureScope $this$centerY$iv = $this$center;
        boolean $i$f$getCenterY = false;
        BaseGestureScope $this$height$iv$iv = $this$centerY$iv;
        boolean $i$f$getHeight = false;
        float y$iv = (float)GestureScopeKt.getSize($this$height$iv$iv).getHeight() / 2.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_12 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_12);
        float f = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new Offset(l2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Offset getCenterRight(@NotNull BaseGestureScope $this$centerRight) {
        long l;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$centerRight, (String)"<this>");
        BaseGestureScope $this$right$iv22 = $this$centerRight;
        boolean $i$f$getRight = false;
        BaseGestureScope $this$width$iv$iv22 = $this$right$iv22;
        boolean $i$f$getWidth = false;
        int $this$width$iv$iv22 = GestureScopeKt.getSize($this$width$iv$iv22).getWidth();
        $i$f$getWidth = false;
        boolean bl = false;
        int it$iv = $this$width$iv$iv22;
        boolean bl2 = false;
        float $this$right$iv22 = it$iv == 0 ? 0.0f : (float)it$iv - 1.0f;
        BaseGestureScope $this$centerY$iv = $this$centerRight;
        boolean $i$f$getCenterY = false;
        BaseGestureScope $this$height$iv$iv = $this$centerY$iv;
        boolean $i$f$getHeight = false;
        float y$iv = (float)GestureScopeKt.getSize($this$height$iv$iv).getHeight() / 2.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_12 = x$iv;
        boolean bl3 = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_12);
        float f = y$iv;
        boolean bl4 = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new Offset(l2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Offset getBottomLeft(@NotNull BaseGestureScope $this$bottomLeft) {
        long l;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$bottomLeft, (String)"<this>");
        BaseGestureScope $this$left$iv22 = $this$bottomLeft;
        boolean $i$f$getLeft = false;
        float $this$left$iv22 = 0.0f;
        BaseGestureScope $this$bottom$iv = $this$bottomLeft;
        boolean $i$f$getBottom = false;
        BaseGestureScope $this$height$iv$iv22 = $this$bottom$iv;
        boolean $i$f$getHeight = false;
        int $this$height$iv$iv22 = GestureScopeKt.getSize($this$height$iv$iv22).getHeight();
        boolean bl = false;
        boolean bl2 = false;
        int it$iv = $this$height$iv$iv22;
        boolean bl3 = false;
        float y$iv = it$iv == 0 ? 0.0f : (float)it$iv - 1.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_10 = x$iv;
        bl2 = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_10);
        float f = y$iv;
        boolean bl4 = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new Offset(l2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Offset getBottomCenter(@NotNull BaseGestureScope $this$bottomCenter) {
        long l;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$bottomCenter, (String)"<this>");
        BaseGestureScope $this$centerX$iv22 = $this$bottomCenter;
        boolean $i$f$getCenterX = false;
        BaseGestureScope $this$width$iv$iv = $this$centerX$iv22;
        boolean $i$f$getWidth = false;
        float $this$centerX$iv22 = (float)GestureScopeKt.getSize($this$width$iv$iv).getWidth() / 2.0f;
        BaseGestureScope $this$bottom$iv = $this$bottomCenter;
        boolean $i$f$getBottom = false;
        BaseGestureScope $this$height$iv$iv22 = $this$bottom$iv;
        boolean $i$f$getHeight = false;
        int $this$height$iv$iv22 = GestureScopeKt.getSize($this$height$iv$iv22).getHeight();
        boolean bl = false;
        boolean bl2 = false;
        int it$iv = $this$height$iv$iv22;
        boolean bl3 = false;
        float y$iv = it$iv == 0 ? 0.0f : (float)it$iv - 1.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_12 = x$iv;
        bl2 = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_12);
        float f = y$iv;
        boolean bl4 = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new Offset(l2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Offset getBottomRight(@NotNull BaseGestureScope $this$bottomRight) {
        long l;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$bottomRight, (String)"<this>");
        BaseGestureScope $this$right$iv22 = $this$bottomRight;
        boolean $i$f$getRight = false;
        BaseGestureScope $this$width$iv$iv22 = $this$right$iv22;
        boolean $i$f$getWidth = false;
        int $this$width$iv$iv22 = GestureScopeKt.getSize($this$width$iv$iv22).getWidth();
        $i$f$getWidth = false;
        boolean bl = false;
        int it$iv = $this$width$iv$iv22;
        boolean bl2 = false;
        float $this$right$iv22 = it$iv == 0 ? 0.0f : (float)it$iv - 1.0f;
        BaseGestureScope $this$bottom$iv = $this$bottomRight;
        boolean $i$f$getBottom = false;
        BaseGestureScope $this$height$iv$iv22 = $this$bottom$iv;
        boolean $i$f$getHeight = false;
        int $this$height$iv$iv22 = GestureScopeKt.getSize($this$height$iv$iv22).getHeight();
        bl = false;
        boolean bl3 = false;
        int it$iv2 = $this$height$iv$iv22;
        boolean bl4 = false;
        float y$iv = it$iv2 == 0 ? 0.0f : (float)it$iv2 - 1.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var5_12 = x$iv;
        bl3 = false;
        long v1$iv$iv = Float.floatToIntBits((float)var5_12);
        float f = y$iv;
        boolean bl5 = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new Offset(l2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Offset percentOffset(@NotNull BaseGestureScope $this$percentOffset, @FloatRange(from=-1.0, to=1.0) float x, @FloatRange(from=-1.0, to=1.0) float y) {
        long l;
        void x$iv;
        void $this$height$iv;
        void $this$width$iv22;
        Intrinsics.checkNotNullParameter((Object)$this$percentOffset, (String)"<this>");
        BaseGestureScope baseGestureScope = $this$percentOffset;
        float f = x;
        boolean $i$f$getWidth22 = false;
        int n = GestureScopeKt.getSize((BaseGestureScope)$this$width$iv22).getWidth();
        float $this$width$iv22 = f * (float)n;
        BaseGestureScope $i$f$getWidth22 = $this$percentOffset;
        f = y;
        boolean $i$f$getHeight = false;
        n = GestureScopeKt.getSize((BaseGestureScope)$this$height$iv).getHeight();
        float y$iv = f * (float)n;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var7_12 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var7_12);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new Offset(l2);
    }

    public static /* synthetic */ Offset percentOffset$default(BaseGestureScope $this$percentOffset_u24default, float x, float y, int n, Object object) {
        if ((n & 1) != 0) {
            x = 0.0f;
        }
        if ((n & 2) != 0) {
            y = 0.0f;
        }
        return GestureScopeKt.percentOffset($this$percentOffset_u24default, x, y);
    }

    @NotNull
    public static final PxBounds getGlobalBounds(@NotNull BaseGestureScope $this$globalBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$globalBounds, (String)"<this>");
        return $this$globalBounds.getSemanticsNode$ui_test_release().getGlobalBounds();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Offset localToGlobal(@NotNull BaseGestureScope $this$localToGlobal, @NotNull Offset position) {
        long l;
        void y$iv;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$localToGlobal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        PxBounds bounds = GestureScopeKt.getGlobalBounds($this$localToGlobal);
        float f = bounds.getLeft();
        float f2 = bounds.getTop();
        Offset offset = position;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var7_8 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var7_8);
        void var11_11 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits((float)var11_11);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        Offset offset2 = new Offset(l2);
        return offset.plus(offset2);
    }

    public static final void sendClick(@NotNull GestureScope $this$sendClick, @NotNull Offset position) {
        Intrinsics.checkNotNullParameter((Object)$this$sendClick, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        $this$sendClick.getInputDispatcher$ui_test_release().sendClick(GestureScopeKt.localToGlobal($this$sendClick, position));
    }

    public static /* synthetic */ void sendClick$default(GestureScope $this$sendClick_u24default, Offset position, int n, Object object) {
        if ((n & 1) != 0) {
            position = GestureScopeKt.getCenter($this$sendClick_u24default);
        }
        GestureScopeKt.sendClick($this$sendClick_u24default, position);
    }

    public static final void sendLongClick(@NotNull GestureScope $this$sendLongClick, @NotNull Offset position, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)$this$sendLongClick, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        boolean bl = duration.compareTo(ConstantsKt.getLongPressTimeout()) >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Long click must have a duration of at least " + Durations.inMilliseconds((Duration)ConstantsKt.getLongPressTimeout()) + "ms";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        GestureScopeKt.sendSwipe($this$sendLongClick, position, position, duration);
    }

    public static /* synthetic */ void sendLongClick$default(GestureScope $this$sendLongClick_u24default, Offset position, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            position = GestureScopeKt.getCenter($this$sendLongClick_u24default);
        }
        if ((n & 2) != 0) {
            duration = ConstantsKt.getLongPressTimeout().plus(Durations.getMilliseconds((int)100));
        }
        GestureScopeKt.sendLongClick($this$sendLongClick_u24default, position, duration);
    }

    public static final void sendDoubleClick(@NotNull GestureScope $this$sendDoubleClick, @NotNull Offset position, @NotNull Duration delay) {
        Intrinsics.checkNotNullParameter((Object)$this$sendDoubleClick, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        boolean bl = delay.compareTo(ConstantsKt.getDoubleTapTimeout().minus(Durations.getMilliseconds((int)10))) <= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Time between clicks in double click can be at most " + ConstantsKt.getDoubleTapTimeout().minus(Durations.getMilliseconds((int)10)) + "ms";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Offset globalPosition = GestureScopeKt.localToGlobal($this$sendDoubleClick, position);
        $this$sendDoubleClick.getInputDispatcher$ui_test_release().sendClick(globalPosition);
        $this$sendDoubleClick.getInputDispatcher$ui_test_release().delay(delay);
        $this$sendDoubleClick.getInputDispatcher$ui_test_release().sendClick(globalPosition);
    }

    public static /* synthetic */ void sendDoubleClick$default(GestureScope $this$sendDoubleClick_u24default, Offset position, Duration delay, int n, Object object) {
        if ((n & 1) != 0) {
            position = GestureScopeKt.getCenter($this$sendDoubleClick_u24default);
        }
        if ((n & 2) != 0) {
            delay = doubleClickDelay;
        }
        GestureScopeKt.sendDoubleClick($this$sendDoubleClick_u24default, position, delay);
    }

    public static final void sendSwipe(@NotNull GestureScope $this$sendSwipe, @NotNull Offset start, @NotNull Offset end, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)$this$sendSwipe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Offset globalStart = GestureScopeKt.localToGlobal($this$sendSwipe, start);
        Offset globalEnd = GestureScopeKt.localToGlobal($this$sendSwipe, end);
        $this$sendSwipe.getInputDispatcher$ui_test_release().sendSwipe(globalStart, globalEnd, duration);
    }

    public static /* synthetic */ void sendSwipe$default(GestureScope $this$sendSwipe_u24default, Offset start, Offset end, Duration duration, int n, Object object) {
        if ((n & 4) != 0) {
            duration = Durations.getMilliseconds((int)200);
        }
        GestureScopeKt.sendSwipe($this$sendSwipe_u24default, start, end, duration);
    }

    public static final void sendPinch(@NotNull GestureScope $this$sendPinch, @NotNull Offset start0, @NotNull Offset end0, @NotNull Offset start1, @NotNull Offset end1, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)$this$sendPinch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)start0, (String)"start0");
        Intrinsics.checkNotNullParameter((Object)end0, (String)"end0");
        Intrinsics.checkNotNullParameter((Object)start1, (String)"start1");
        Intrinsics.checkNotNullParameter((Object)end1, (String)"end1");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Offset globalStart0 = GestureScopeKt.localToGlobal($this$sendPinch, start0);
        Offset globalEnd0 = GestureScopeKt.localToGlobal($this$sendPinch, end0);
        Offset globalStart1 = GestureScopeKt.localToGlobal($this$sendPinch, start1);
        Offset globalEnd1 = GestureScopeKt.localToGlobal($this$sendPinch, end1);
        float durationFloat = Durations.inMilliseconds((Duration)duration);
        Object[] objectArray = new Function1[]{(Function1)new Function1<Long, Offset>(globalStart0, globalEnd0, durationFloat){
            private final /* synthetic */ Offset $globalStart0;
            private final /* synthetic */ Offset $globalEnd0;
            private final /* synthetic */ float $durationFloat;
            {
                this.$globalStart0 = $globalStart0;
                this.$globalEnd0 = $globalEnd0;
                this.$durationFloat = $durationFloat;
                super(1);
            }

            @NotNull
            public final Offset invoke(long it) {
                return OffsetKt.lerp((Offset)this.$globalStart0, (Offset)this.$globalEnd0, (float)((float)it / this.$durationFloat));
            }
        }, (Function1)new Function1<Long, Offset>(globalStart1, globalEnd1, durationFloat){
            private final /* synthetic */ Offset $globalStart1;
            private final /* synthetic */ Offset $globalEnd1;
            private final /* synthetic */ float $durationFloat;
            {
                this.$globalStart1 = $globalStart1;
                this.$globalEnd1 = $globalEnd1;
                this.$durationFloat = $durationFloat;
                super(1);
            }

            @NotNull
            public final Offset invoke(long it) {
                return OffsetKt.lerp((Offset)this.$globalStart1, (Offset)this.$globalEnd1, (float)((float)it / this.$durationFloat));
            }
        }};
        InputDispatcher.sendSwipes$default($this$sendPinch.getInputDispatcher$ui_test_release(), CollectionsKt.listOf((Object[])objectArray), duration, null, 4, null);
    }

    public static /* synthetic */ void sendPinch$default(GestureScope $this$sendPinch_u24default, Offset start0, Offset end0, Offset start1, Offset end1, Duration duration, int n, Object object) {
        if ((n & 0x10) != 0) {
            duration = Durations.getMilliseconds((int)400);
        }
        GestureScopeKt.sendPinch($this$sendPinch_u24default, start0, end0, start1, end1, duration);
    }

    public static final void sendSwipeWithVelocity(@NotNull GestureScope $this$sendSwipeWithVelocity, @NotNull Offset start, @NotNull Offset end, @FloatRange(from=0.0) float endVelocity, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)$this$sendSwipeWithVelocity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        boolean bl = endVelocity >= 0.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Velocity cannot be " + endVelocity + ", it must be positive";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = InputDispatcher.Companion.getEventPeriod() < Durations.inMilliseconds((Duration)Durations.getMilliseconds((int)40));
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl52 = false;
            String string = "InputDispatcher.eventPeriod must be smaller than 40ms in order to generate velocities";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        float f = 2.5f * (float)InputDispatcher.Companion.getEventPeriod();
        bl3 = false;
        int minimumDuration = MathKt.roundToInt((float)((float)Math.ceil(f)));
        boolean bl6 = duration.compareTo(Durations.getMilliseconds((int)minimumDuration)) >= 0;
        bl3 = false;
        boolean bl52 = false;
        if (!bl6) {
            boolean bl7 = false;
            String bl52 = "Duration must be at least " + minimumDuration + "ms because velocity requires at least 3 input events";
            throw (Throwable)new IllegalArgumentException(bl52.toString());
        }
        Offset globalStart = GestureScopeKt.localToGlobal($this$sendSwipeWithVelocity, start);
        Offset globalEnd = GestureScopeKt.localToGlobal($this$sendSwipeWithVelocity, end);
        Offset delta = end.minus(start);
        float f2 = delta.getY();
        float f3 = delta.getX();
        boolean bl8 = false;
        float theta = (float)Math.atan2(f2, f3);
        boolean bl9 = false;
        float vx = (float)Math.cos(theta) * endVelocity / (float)1000;
        bl8 = false;
        float vy = (float)Math.sin(theta) * endVelocity / (float)1000;
        long durationMs = Durations.inMilliseconds((Duration)duration);
        Function1<Long, Float> fx = GestureScopeKt.createFunctionForVelocity(durationMs, globalStart.getX(), globalEnd.getX(), vx);
        Function1<Long, Float> fy = GestureScopeKt.createFunctionForVelocity(durationMs, globalStart.getY(), globalEnd.getY(), vy);
        InputDispatcher.sendSwipe$default($this$sendSwipeWithVelocity.getInputDispatcher$ui_test_release(), (Function1)new Function1<Long, Offset>(fx, fy){
            private final /* synthetic */ Function1<Long, Float> $fx;
            private final /* synthetic */ Function1<Long, Float> $fy;
            {
                this.$fx = $fx;
                this.$fy = $fy;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Offset invoke(long t) {
                long l;
                void x$iv;
                float f = ((Number)this.$fx.invoke((Object)t)).floatValue();
                float y$iv = ((Number)this.$fy.invoke((Object)t)).floatValue();
                boolean $i$f$Offset = false;
                boolean $i$f$packFloats = false;
                void var7_6 = x$iv;
                boolean bl = false;
                long v1$iv$iv = Float.floatToIntBits((float)var7_6);
                float f2 = y$iv;
                boolean bl2 = false;
                long v2$iv$iv = Float.floatToIntBits(f2);
                long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
                return new Offset(l2);
            }
        }, duration, null, 4, null);
    }

    public static /* synthetic */ void sendSwipeWithVelocity$default(GestureScope $this$sendSwipeWithVelocity_u24default, Offset start, Offset end, float endVelocity, Duration duration, int n, Object object) {
        if ((n & 8) != 0) {
            duration = Durations.getMilliseconds((int)200);
        }
        GestureScopeKt.sendSwipeWithVelocity($this$sendSwipeWithVelocity_u24default, start, end, endVelocity, duration);
    }

    public static final void sendSwipeUp(@NotNull GestureScope $this$sendSwipeUp) {
        long l;
        long l2;
        Intrinsics.checkNotNullParameter((Object)$this$sendSwipeUp, (String)"<this>");
        float x = GestureScopeKt.getCenter($this$sendSwipeUp).getX();
        float y0 = MathKt.roundToInt((float)((float)GestureScopeKt.getSize($this$sendSwipeUp).getHeight() * 0.917f));
        float y1 = 0.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        float f = x;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits(f);
        float f2 = y0;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l3 = l2 = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        Offset start = new Offset(l3);
        boolean $i$f$Offset2 = false;
        boolean $i$f$packFloats2 = false;
        float f3 = x;
        boolean bl3 = false;
        long v1$iv$iv2 = Float.floatToIntBits(f3);
        float f4 = y1;
        boolean bl4 = false;
        long v2$iv$iv2 = Float.floatToIntBits(f4);
        long l4 = l = v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL;
        Offset end = new Offset(l4);
        GestureScopeKt.sendSwipe($this$sendSwipeUp, start, end, Durations.getMilliseconds((int)200));
    }

    public static final void sendSwipeDown(@NotNull GestureScope $this$sendSwipeDown) {
        long l;
        long l2;
        Intrinsics.checkNotNullParameter((Object)$this$sendSwipeDown, (String)"<this>");
        float x = GestureScopeKt.getCenter($this$sendSwipeDown).getX();
        float y0 = MathKt.roundToInt((float)((float)GestureScopeKt.getSize($this$sendSwipeDown).getHeight() * 0.083f));
        float y1 = GestureScopeKt.getSize($this$sendSwipeDown).getHeight();
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        float f = x;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits(f);
        float f2 = y0;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l3 = l2 = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        Offset start = new Offset(l3);
        boolean $i$f$Offset2 = false;
        boolean $i$f$packFloats2 = false;
        float f3 = x;
        boolean bl3 = false;
        long v1$iv$iv2 = Float.floatToIntBits(f3);
        float f4 = y1;
        boolean bl4 = false;
        long v2$iv$iv2 = Float.floatToIntBits(f4);
        long l4 = l = v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL;
        Offset end = new Offset(l4);
        GestureScopeKt.sendSwipe($this$sendSwipeDown, start, end, Durations.getMilliseconds((int)200));
    }

    public static final void sendSwipeLeft(@NotNull GestureScope $this$sendSwipeLeft) {
        long l;
        long l2;
        Intrinsics.checkNotNullParameter((Object)$this$sendSwipeLeft, (String)"<this>");
        float x0 = (float)GestureScopeKt.getSize($this$sendSwipeLeft).getWidth() * 0.917f;
        float x1 = 0.0f;
        float y = GestureScopeKt.getCenter($this$sendSwipeLeft).getY();
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        float f = x0;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits(f);
        float f2 = y;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l3 = l2 = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        Offset start = new Offset(l3);
        boolean $i$f$Offset2 = false;
        boolean $i$f$packFloats2 = false;
        float f3 = x1;
        boolean bl3 = false;
        long v1$iv$iv2 = Float.floatToIntBits(f3);
        float f4 = y;
        boolean bl4 = false;
        long v2$iv$iv2 = Float.floatToIntBits(f4);
        long l4 = l = v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL;
        Offset end = new Offset(l4);
        GestureScopeKt.sendSwipe($this$sendSwipeLeft, start, end, Durations.getMilliseconds((int)200));
    }

    public static final void sendSwipeRight(@NotNull GestureScope $this$sendSwipeRight) {
        long l;
        long l2;
        Intrinsics.checkNotNullParameter((Object)$this$sendSwipeRight, (String)"<this>");
        float x0 = MathKt.roundToInt((float)((float)GestureScopeKt.getSize($this$sendSwipeRight).getWidth() * 0.083f));
        float x1 = GestureScopeKt.getSize($this$sendSwipeRight).getWidth();
        float y = GestureScopeKt.getCenter($this$sendSwipeRight).getY();
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        float f = x0;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits(f);
        float f2 = y;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l3 = l2 = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        Offset start = new Offset(l3);
        boolean $i$f$Offset2 = false;
        boolean $i$f$packFloats2 = false;
        float f3 = x1;
        boolean bl3 = false;
        long v1$iv$iv2 = Float.floatToIntBits(f3);
        float f4 = y;
        boolean bl4 = false;
        long v2$iv$iv2 = Float.floatToIntBits(f4);
        long l4 = l = v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL;
        Offset end = new Offset(l4);
        GestureScopeKt.sendSwipe($this$sendSwipeRight, start, end, Durations.getMilliseconds((int)200));
    }

    private static final Function1<Long, Float> createFunctionForVelocity(long duration, float start, float end, float velocity) {
        float a = (start - end + velocity * (float)duration) / (float)(duration * duration);
        Function1 function2 = (Function1)new Function1<Long, Float>(duration, a, velocity, end){
            private final /* synthetic */ long $duration;
            private final /* synthetic */ float $a;
            private final /* synthetic */ float $velocity;
            private final /* synthetic */ float $end;
            {
                this.$duration = $duration;
                this.$a = $a;
                this.$velocity = $velocity;
                this.$end = $end;
                super(1);
            }

            public final float invoke(long t) {
                long tMinusDuration = t - this.$duration;
                return this.$a * (float)tMinusDuration * (float)tMinusDuration + this.$velocity * (float)tMinusDuration + this.$end;
            }
        };
        float f = ((Number)function2.invoke((Object)1L)).floatValue() - start;
        boolean bl = false;
        float f2 = Math.signum(f);
        f = end - start;
        float f3 = f2;
        bl = false;
        float f4 = Math.signum(f);
        if (f3 == f4) {
            return function2;
        }
        long cutOffTime = duration - (long)100;
        float cutOffValue = ((Number)function2.invoke((Object)cutOffTime)).floatValue();
        float f5 = cutOffValue - start;
        boolean bl2 = false;
        float f6 = Math.signum(f5);
        f5 = end - start;
        f3 = f6;
        bl2 = false;
        f4 = Math.signum(f5);
        boolean bl3 = f3 == f4;
        bl2 = false;
        boolean bl4 = false;
        if (!bl3) {
            boolean bl5 = false;
            String string = "Creating a gesture between " + start + " and " + end + " with a duration of " + duration + " and a resulting velocity of " + velocity + " results in a movement that goes outside of the range [" + start + ".." + end + "]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (Function1)new Function1<Long, Float>(cutOffTime, start, cutOffValue, (Function1<? super Long, Float>)function2){
            private final /* synthetic */ long $cutOffTime;
            private final /* synthetic */ float $start;
            private final /* synthetic */ float $cutOffValue;
            private final /* synthetic */ Function1<Long, Float> $function;
            {
                this.$cutOffTime = $cutOffTime;
                this.$start = $start;
                this.$cutOffValue = $cutOffValue;
                this.$function = $function;
                super(1);
            }

            public final float invoke(long t) {
                return t < this.$cutOffTime ? MathHelpersKt.lerp((float)this.$start, (float)this.$cutOffValue, (float)((float)t / (float)this.$cutOffTime)) : ((Number)this.$function.invoke((Object)t)).floatValue();
            }
        };
    }

    public static final void sendDown(@NotNull PartialGestureScope $this$sendDown, int pointerId, @NotNull Offset position) {
        Intrinsics.checkNotNullParameter((Object)$this$sendDown, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Offset globalPosition = GestureScopeKt.localToGlobal($this$sendDown, position);
        $this$sendDown.getInputDispatcher$ui_test_release().sendDown(pointerId, globalPosition);
    }

    public static final void sendDown(@NotNull PartialGestureScope $this$sendDown, @NotNull Offset position) {
        Intrinsics.checkNotNullParameter((Object)$this$sendDown, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        GestureScopeKt.sendDown($this$sendDown, 0, position);
    }

    public static final void sendMoveTo(@NotNull PartialGestureScope $this$sendMoveTo, int pointerId, @NotNull Offset position) {
        Intrinsics.checkNotNullParameter((Object)$this$sendMoveTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        GestureScopeKt.movePointerTo($this$sendMoveTo, pointerId, position);
        GestureScopeKt.sendMove($this$sendMoveTo);
    }

    public static final void sendMoveTo(@NotNull PartialGestureScope $this$sendMoveTo, @NotNull Offset position) {
        Intrinsics.checkNotNullParameter((Object)$this$sendMoveTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        GestureScopeKt.sendMoveTo($this$sendMoveTo, 0, position);
    }

    public static final void movePointerTo(@NotNull PartialGestureScope $this$movePointerTo, int pointerId, @NotNull Offset position) {
        Intrinsics.checkNotNullParameter((Object)$this$movePointerTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Offset globalPosition = GestureScopeKt.localToGlobal($this$movePointerTo, position);
        $this$movePointerTo.getInputDispatcher$ui_test_release().movePointer(pointerId, globalPosition);
    }

    public static final void sendMoveBy(@NotNull PartialGestureScope $this$sendMoveBy, int pointerId, @NotNull Offset delta) {
        Intrinsics.checkNotNullParameter((Object)$this$sendMoveBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        GestureScopeKt.movePointerBy($this$sendMoveBy, pointerId, delta);
        GestureScopeKt.sendMove($this$sendMoveBy);
    }

    public static final void sendMoveBy(@NotNull PartialGestureScope $this$sendMoveBy, @NotNull Offset delta) {
        Intrinsics.checkNotNullParameter((Object)$this$sendMoveBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        GestureScopeKt.sendMoveBy($this$sendMoveBy, 0, delta);
    }

    public static final void movePointerBy(@NotNull PartialGestureScope $this$movePointerBy, int pointerId, @NotNull Offset delta) {
        Intrinsics.checkNotNullParameter((Object)$this$movePointerBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        Offset offset = $this$movePointerBy.getInputDispatcher$ui_test_release().getCurrentPosition(pointerId);
        Offset globalPosition = (offset == null ? Offset.Companion.getZero() : offset).plus(delta);
        $this$movePointerBy.getInputDispatcher$ui_test_release().movePointer(pointerId, globalPosition);
    }

    public static final void sendMove(@NotNull PartialGestureScope $this$sendMove) {
        Intrinsics.checkNotNullParameter((Object)$this$sendMove, (String)"<this>");
        InputDispatcher.sendMove$default($this$sendMove.getInputDispatcher$ui_test_release(), 0L, 1, null);
    }

    public static final void sendUp(@NotNull PartialGestureScope $this$sendUp, int pointerId) {
        Intrinsics.checkNotNullParameter((Object)$this$sendUp, (String)"<this>");
        InputDispatcher.sendUp$default($this$sendUp.getInputDispatcher$ui_test_release(), pointerId, 0L, 2, null);
    }

    public static /* synthetic */ void sendUp$default(PartialGestureScope $this$sendUp_u24default, int pointerId, int n, Object object) {
        if ((n & 1) != 0) {
            pointerId = 0;
        }
        GestureScopeKt.sendUp($this$sendUp_u24default, pointerId);
    }

    public static final void sendCancel(@NotNull PartialGestureScope $this$sendCancel) {
        Intrinsics.checkNotNullParameter((Object)$this$sendCancel, (String)"<this>");
        InputDispatcher.sendCancel$default($this$sendCancel.getInputDispatcher$ui_test_release(), 0L, 1, null);
    }
}

