/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.activity.ComponentActivity;
import androidx.compose.Composer;
import androidx.compose.Composition;
import androidx.compose.CompositionFrameClock;
import androidx.compose.FrameManager;
import androidx.compose.Recomposer;
import androidx.compose.frames.FramesKt;
import androidx.compose.internal.RestartableFunctionKt;
import androidx.ui.core.AndroidOwner;
import androidx.ui.core.WrapperKt;
import androidx.ui.test.ComposeBenchmarkScope;
import androidx.ui.test.ComposeBenchmarkScopeKt;
import androidx.ui.test.ComposeTestCase;
import androidx.ui.test.android.AndroidComposeTestCaseRunner;
import androidx.ui.test.android.AndroidComposeTestCaseRunnerKt;
import androidx.ui.test.android.DrawCapture;
import androidx.ui.test.android.PictureCapture;
import androidx.ui.test.android.RenderNodeCapture;
import androidx.ui.test.android.SimulationState;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001CB\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020)H\u0016J\b\u0010,\u001a\u00020)H\u0016J\b\u0010-\u001a\u00020)H\u0016J\b\u0010.\u001a\u00020)H\u0016J\b\u0010/\u001a\u00020)H\u0016J\b\u00100\u001a\u00020)H\u0016J\b\u00101\u001a\u00020)H\u0016J\r\u00102\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020$H\u0002J\b\u00105\u001a\u00020\u000fH\u0016J\b\u00106\u001a\u00020\u000fH\u0002J\b\u00107\u001a\u00020)H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020)H\u0016J\b\u0010=\u001a\u00020)H\u0016J\u0018\u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020\u00162\u0006\u0010@\u001a\u00020\u0016H\u0016J\b\u0010A\u001a\u00020)H\u0016J\b\u0010B\u001a\u00020)H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010%\u001a\u0004\u0018\u00010$2\b\u0010\u000e\u001a\u0004\u0018\u00010$@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006D"}, d2={"Landroidx/ui/test/android/AndroidComposeTestCaseRunner;", "T", "Landroidx/ui/test/ComposeTestCase;", "Landroidx/ui/test/ComposeBenchmarkScope;", "testCaseFactory", "Lkotlin/Function0;", "activity", "Landroidx/activity/ComponentActivity;", "canvas", "Landroid/graphics/Canvas;", "capture", "Landroidx/ui/test/android/DrawCapture;", "composition", "Landroidx/compose/Composition;", "<set-?>", "", "didLastRecomposeHaveChanges", "getDidLastRecomposeHaveChanges", "()Z", "frameClock", "Landroidx/ui/test/android/AndroidComposeTestCaseRunner$AutoFrameClock;", "measuredHeight", "", "getMeasuredHeight", "()I", "measuredWidth", "getMeasuredWidth", "recomposer", "Landroidx/compose/Recomposer;", "screenHeightSpec", "screenWithSpec", "simulationState", "Landroidx/ui/test/android/SimulationState;", "supportsRenderNode", "testCase", "Landroidx/ui/test/ComposeTestCase;", "Landroid/view/View;", "view", "getView$ui_test_release", "()Landroid/view/View;", "capturePreviewPictureToActivity", "", "createTestCase", "disposeContent", "doFrame", "draw", "drawFinish", "drawPrepare", "drawToBitmap", "emitContent", "getTestCase", "()Landroidx/ui/test/ComposeTestCase;", "getView", "hasPendingChanges", "hasPendingChangesInFrame", "invalidateViews", "launchRecomposeIn", "Lkotlinx/coroutines/Job;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "layout", "measure", "measureWithSpec", "widthSpec", "heightSpec", "recompose", "requestLayout", "AutoFrameClock", "ui-test_release"})
public final class AndroidComposeTestCaseRunner<T extends ComposeTestCase>
implements ComposeBenchmarkScope<T> {
    private final Function0<T> testCaseFactory;
    private final ComponentActivity activity;
    private View view;
    private Composition composition;
    private boolean didLastRecomposeHaveChanges;
    private final boolean supportsRenderNode;
    private final int screenWithSpec;
    private final int screenHeightSpec;
    private final DrawCapture capture;
    private Canvas canvas;
    private final AutoFrameClock frameClock;
    private final Recomposer recomposer;
    private SimulationState simulationState;
    private T testCase;

    public AndroidComposeTestCaseRunner(@NotNull Function0<? extends T> testCaseFactory, @NotNull ComponentActivity activity) {
        Intrinsics.checkNotNullParameter(testCaseFactory, (String)"testCaseFactory");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.testCaseFactory = testCaseFactory;
        this.activity = activity;
        this.supportsRenderNode = Build.VERSION.SDK_INT >= 29;
        this.capture = this.supportsRenderNode ? (DrawCapture)new RenderNodeCapture() : (DrawCapture)new PictureCapture();
        this.frameClock = new AutoFrameClock(0L, 1, null);
        this.recomposer = new Recomposer();
        this.simulationState = SimulationState.Initialized;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int height = displayMetrics.heightPixels;
        int width = displayMetrics.widthPixels;
        this.screenWithSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE);
        this.screenHeightSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE);
    }

    @Override
    public int getMeasuredWidth() {
        View view = this.getView$ui_test_release();
        Intrinsics.checkNotNull((Object)view);
        return view.getMeasuredWidth();
    }

    @Override
    public int getMeasuredHeight() {
        View view = this.getView$ui_test_release();
        Intrinsics.checkNotNull((Object)view);
        return view.getMeasuredHeight();
    }

    @Nullable
    public final View getView$ui_test_release() {
        return this.view;
    }

    @Override
    public boolean getDidLastRecomposeHaveChanges() {
        return this.didLastRecomposeHaveChanges;
    }

    @Override
    public void createTestCase() {
        boolean bl = this.getView$ui_test_release() == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Content was already set!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.testCase == null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Content was already set!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.testCase = (ComposeTestCase)this.testCaseFactory.invoke();
        this.simulationState = SimulationState.TestCaseCreated;
    }

    @Override
    public void emitContent() {
        boolean bl = this.getView$ui_test_release() == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Content was already set!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.testCase != null && Intrinsics.areEqual((Object)((Object)this.simulationState), (Object)((Object)SimulationState.TestCaseCreated));
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Need to call onPreEmitContent before emitContent!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.composition = WrapperKt.setContent((ComponentActivity)this.activity, (Recomposer)this.recomposer, (Function3)((Function3)RestartableFunctionKt.restartableFunctionInstance((int)-1071318395, (boolean)true, (Object)new Function3<Composer<?>, Integer, Integer, Unit>(this){
            private final /* synthetic */ AndroidComposeTestCaseRunner<T> $this;
            {
                this.$this = $receiver;
                super(3);
            }

            public final void invoke(@Nullable Composer<?> $composer, int $key, int $changed) {
                if (($changed & 3 ^ 2) != 0 || !$composer.getSkipping()) {
                    ComposeTestCase composeTestCase = AndroidComposeTestCaseRunner.access$getTestCase$p(this.$this);
                    Intrinsics.checkNotNull((Object)composeTestCase);
                    composeTestCase.emitContent($composer, -1795628898, 0);
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        })));
        AndroidOwner androidOwner = AndroidComposeTestCaseRunnerKt.access$findAndroidOwner((Activity)this.activity);
        Intrinsics.checkNotNull((Object)androidOwner);
        View ownerView = androidOwner.getView();
        ownerView.restoreHierarchyState(new SparseArray());
        this.view = ownerView;
        FrameManager.INSTANCE.nextFrame();
        this.simulationState = SimulationState.EmitContentDone;
    }

    @Override
    public boolean hasPendingChanges() {
        if (this.recomposer.hasPendingChanges() || this.hasPendingChangesInFrame()) {
            FrameManager.INSTANCE.nextFrame();
        }
        return this.recomposer.hasPendingChanges();
    }

    private final boolean hasPendingChangesInFrame() {
        return FramesKt.getInFrame() && FramesKt.currentFrame().hasPendingChanges();
    }

    @Override
    public void measure() {
        this.getView().measure(this.screenWithSpec, this.screenHeightSpec);
        this.simulationState = SimulationState.MeasureDone;
    }

    @Override
    public void measureWithSpec(int widthSpec, int heightSpec) {
        this.getView().measure(widthSpec, heightSpec);
        this.simulationState = SimulationState.MeasureDone;
    }

    @Override
    public void drawPrepare() {
        boolean bl = Intrinsics.areEqual((Object)((Object)this.simulationState), (Object)((Object)SimulationState.LayoutDone)) || Intrinsics.areEqual((Object)((Object)this.simulationState), (Object)((Object)SimulationState.DrawDone));
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Draw can be only executed after layout or draw, current state is '" + (Object)((Object)this.simulationState) + "'";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.canvas = this.capture.beginRecording(this.getView().getWidth(), this.getView().getHeight());
        this.simulationState = SimulationState.DrawPrepared;
    }

    @Override
    public void draw() {
        boolean bl = Intrinsics.areEqual((Object)((Object)this.simulationState), (Object)((Object)SimulationState.DrawPrepared));
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "You need to call 'drawPrepare' before calling 'draw'.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.getView().draw(this.canvas);
        this.simulationState = SimulationState.DrawInProgress;
    }

    @Override
    public void drawFinish() {
        boolean bl = Intrinsics.areEqual((Object)((Object)this.simulationState), (Object)((Object)SimulationState.DrawInProgress));
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "You need to call 'draw' before calling 'drawFinish'.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.capture.endRecording();
        this.simulationState = SimulationState.DrawDone;
    }

    @Override
    public void drawToBitmap() {
        this.drawPrepare();
        this.draw();
        this.drawFinish();
    }

    @Override
    public void requestLayout() {
        this.getView().requestLayout();
    }

    @Override
    public void layout() {
        boolean bl = Intrinsics.areEqual((Object)((Object)this.simulationState), (Object)((Object)SimulationState.MeasureDone));
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Layout can be only executed after measure, current state is '" + (Object)((Object)this.simulationState) + "'";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        View view = this.getView();
        view.layout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        this.simulationState = SimulationState.LayoutDone;
    }

    @Override
    public void recompose() {
        if (this.hasPendingChanges()) {
            this.didLastRecomposeHaveChanges = true;
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Unit>(this, (Continuation<? super recompose.1>)((Continuation)null)){
                private int label;
                private CoroutineScope p$;
                private AndroidComposeTestCaseRunner<T> $this;
                {
                    this.$this = $this;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = AndroidComposeTestCaseRunner.access$getRecomposer$p(this.$this).recomposeAndApplyChanges(this.p$, (CompositionFrameClock)AndroidComposeTestCaseRunner.access$getFrameClock$p(this.$this), 1L, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Unit> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.p$ = (CoroutineScope)value;
                    return (Continuation)function2;
                }

                public final R invoke(P1 p1, P2 p2) {
                    Continuation<Unit> continuation = this.create(p1, (Continuation)p2);
                    return (R)(continuation).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        } else {
            this.didLastRecomposeHaveChanges = false;
        }
        this.simulationState = SimulationState.RecomposeDone;
    }

    @Override
    @NotNull
    public Job launchRecomposeIn(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        return BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Unit>(this, (Continuation<? super launchRecomposeIn.1>)((Continuation)null)){
            private int label;
            private CoroutineScope p$;
            private AndroidComposeTestCaseRunner<T> $this;
            {
                this.$this = $this;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = AndroidComposeTestCaseRunner.access$getRecomposer$p(this.$this).runRecomposeAndApplyChanges((CompositionFrameClock)AndroidComposeTestCaseRunner.access$getFrameClock$p(this.$this), (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Unit> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.p$ = (CoroutineScope)value;
                return (Continuation)function2;
            }

            public final R invoke(P1 p1, P2 p2) {
                Continuation<Unit> continuation = this.create(p1, (Continuation)p2);
                return (R)(continuation).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void doFrame() {
        if (this.getView$ui_test_release() == null) {
            ComposeBenchmarkScopeKt.setupContent(this);
        }
        this.recompose();
        this.measure();
        this.layout();
        this.drawToBitmap();
    }

    @Override
    public void invalidateViews() {
        AndroidComposeTestCaseRunnerKt.access$invalidateViews(this.getView());
    }

    @Override
    public void disposeContent() {
        if (this.getView$ui_test_release() == null) {
            return;
        }
        Composition composition = this.composition;
        if (composition != null) {
            composition.dispose();
        }
        ViewGroup viewGroup = (ViewGroup)this.activity.findViewById(0x1020002);
        if (viewGroup == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup rootView = viewGroup;
        rootView.removeAllViews();
        this.view = null;
        this.testCase = null;
        this.simulationState = SimulationState.Initialized;
    }

    @Override
    public void capturePreviewPictureToActivity() {
        Bitmap bitmap;
        boolean bl = this.getMeasuredWidth() > 0 && this.getMeasuredHeight() > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Preview can't be used on empty view. Did you run measure & layout before calling it?";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Picture picture = new Picture();
        Canvas canvas = picture.beginRecording(this.getView().getMeasuredWidth(), this.getView().getMeasuredHeight());
        Intrinsics.checkNotNullExpressionValue((Object)canvas, (String)"picture.beginRecording(getView().measuredWidth, getView().measuredHeight)");
        Canvas canvas2 = canvas;
        this.getView().draw(canvas2);
        picture.endRecording();
        ImageView imageView = new ImageView((Context)this.activity);
        if (Build.VERSION.SDK_INT >= 28) {
            Bitmap bitmap2 = Bitmap.createBitmap((Picture)picture);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(picture)");
            bitmap = bitmap2;
        } else {
            int width = RangesKt.coerceAtLeast((int)picture.getWidth(), (int)1);
            int height = RangesKt.coerceAtLeast((int)picture.getHeight(), (int)1);
            Bitmap bitmap3 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(width, height, Bitmap.Config.ARGB_8888)");
            bitmap = bitmap3;
            new Canvas(bitmap).drawPicture(picture);
        }
        imageView.setImageBitmap(bitmap);
        this.activity.setContentView((View)imageView);
    }

    private final View getView() {
        boolean bl = this.getView$ui_test_release() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "View was not set! Call setupContent first!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        View view = this.getView$ui_test_release();
        Intrinsics.checkNotNull((Object)view);
        return view;
    }

    @Override
    @NotNull
    public T getTestCase() {
        T t = this.testCase;
        Intrinsics.checkNotNull(t);
        return t;
    }

    public static final /* synthetic */ ComposeTestCase access$getTestCase$p(AndroidComposeTestCaseRunner androidComposeTestCaseRunner) {
        return androidComposeTestCaseRunner.testCase;
    }

    public static final /* synthetic */ Recomposer access$getRecomposer$p(AndroidComposeTestCaseRunner androidComposeTestCaseRunner) {
        return androidComposeTestCaseRunner.recomposer;
    }

    public static final /* synthetic */ AutoFrameClock access$getFrameClock$p(AndroidComposeTestCaseRunner androidComposeTestCaseRunner) {
        return androidComposeTestCaseRunner.frameClock;
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\n\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003J+\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0001\u0010\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00070\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000b"}, d2={"Landroidx/ui/test/android/AndroidComposeTestCaseRunner$AutoFrameClock;", "Landroidx/compose/CompositionFrameClock;", "singleFrameTimeNanos", "", "lastFrameTime", "Ljava/util/concurrent/atomic/AtomicLong;", "withFrameNanos", "R", "onFrame", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ui-test_release"})
    private static final class AutoFrameClock
    implements CompositionFrameClock {
        private final long singleFrameTimeNanos;
        private final AtomicLong lastFrameTime;

        public AutoFrameClock(long singleFrameTimeNanos) {
            this.singleFrameTimeNanos = singleFrameTimeNanos;
            this.lastFrameTime = new AtomicLong(0L);
        }

        public /* synthetic */ AutoFrameClock(long singleFrameTimeNanos, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                singleFrameTimeNanos = 16000000L;
            }
            this(singleFrameTimeNanos);
        }

        @Nullable
        public <R> Object withFrameNanos(@NotNull Function1<? super Long, ? extends R> onFrame, @NotNull Continuation<? super R> $completion) {
            return onFrame.invoke((Object)Boxing.boxLong((long)this.lastFrameTime.getAndAdd(this.singleFrameTimeNanos)));
        }

        @Deprecated(message="renamed to withFrameNanos", replaceWith=@ReplaceWith(expression="withFrameNanos(onFrame)", imports={}))
        @Nullable
        public <R> Object awaitFrameNanos(@NotNull Function1<? super Long, ? extends R> onFrame, @NotNull Continuation<? super R> $completion) {
            InlineMarker.mark((int)0);
            Object object = CompositionFrameClock.DefaultImpls.awaitFrameNanos((CompositionFrameClock)this, onFrame, $completion);
            InlineMarker.mark((int)1);
            return object;
        }

        public AutoFrameClock() {
            this(0L, 1, null);
        }
    }
}

