/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.ViewGroup;
import androidx.activity.ComponentActivity;
import androidx.compose.Composer;
import androidx.compose.Composition;
import androidx.compose.Recomposer;
import androidx.test.core.app.ActivityScenario;
import androidx.test.ext.junit.rules.ActivityScenarioRule;
import androidx.ui.animation.TransitionKt;
import androidx.ui.core.WrapperKt;
import androidx.ui.foundation.TextFieldKt;
import androidx.ui.input.PlatformTextInputService;
import androidx.ui.input.TextInputServiceKt;
import androidx.ui.test.AnimationClockTestRule;
import androidx.ui.test.ComposeTestCase;
import androidx.ui.test.ComposeTestCaseSetup;
import androidx.ui.test.ComposeTestRule;
import androidx.ui.test.ExperimentalTesting;
import androidx.ui.test.SynchronizationKt;
import androidx.ui.test.TextInputServiceForTests;
import androidx.ui.test.android.AndroidComposeTestCaseSetup;
import androidx.ui.test.android.AndroidOwnerRegistry;
import androidx.ui.test.android.ComposeIdlingResourceKt;
import androidx.ui.test.android.FirstDrawRegistry;
import androidx.ui.unit.Density;
import androidx.ui.unit.DensityKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001-B.\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\tJ\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0017J\r\u0010'\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010(J \u0010)\u001a\u00020\u001b2\u0011\u0010*\u001a\r\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\b+H\u0016\u00a2\u0006\u0002\u0010,R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Landroidx/ui/test/android/AndroidComposeTestRule;", "T", "Landroidx/activity/ComponentActivity;", "Landroidx/ui/test/ComposeTestRule;", "activityRule", "Landroidx/test/ext/junit/rules/ActivityScenarioRule;", "recomposer", "Landroidx/compose/Recomposer;", "disableTransitions", "", "disableBlinkingCursor", "getActivityRule", "()Landroidx/test/ext/junit/rules/ActivityScenarioRule;", "clockTestRule", "Landroidx/ui/test/AnimationClockTestRule;", "getClockTestRule", "()Landroidx/ui/test/AnimationClockTestRule;", "density", "Landroidx/ui/unit/Density;", "getDensity", "()Landroidx/ui/unit/Density;", "displayMetrics", "Landroid/util/DisplayMetrics;", "getDisplayMetrics", "()Landroid/util/DisplayMetrics;", "disposeContentHook", "Lkotlin/Function0;", "", "getRecomposer", "()Landroidx/compose/Recomposer;", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "forGivenTestCase", "Landroidx/ui/test/ComposeTestCaseSetup;", "testCase", "Landroidx/ui/test/ComposeTestCase;", "getActivity", "()Landroidx/activity/ComponentActivity;", "setContent", "composable", "Landroidx/compose/Composable;", "(Lkotlin/jvm/functions/Function3;)V", "AndroidComposeStatement", "ui-test_release"})
public final class AndroidComposeTestRule<T extends ComponentActivity>
implements ComposeTestRule {
    private final ActivityScenarioRule<T> activityRule;
    private final Recomposer recomposer;
    private final boolean disableTransitions;
    private final boolean disableBlinkingCursor;
    private final AnimationClockTestRule clockTestRule;
    private Function0<Unit> disposeContentHook;

    public AndroidComposeTestRule(@NotNull ActivityScenarioRule<T> activityRule, @Nullable Recomposer recomposer, boolean disableTransitions, boolean disableBlinkingCursor) {
        Intrinsics.checkNotNullParameter(activityRule, (String)"activityRule");
        this.activityRule = activityRule;
        this.recomposer = recomposer;
        this.disableTransitions = disableTransitions;
        this.disableBlinkingCursor = disableBlinkingCursor;
        this.clockTestRule = new AnimationClockTestRule();
    }

    public /* synthetic */ AndroidComposeTestRule(ActivityScenarioRule activityRule, Recomposer recomposer, boolean disableTransitions, boolean disableBlinkingCursor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            recomposer = null;
        }
        if ((n & 4) != 0) {
            disableTransitions = false;
        }
        if ((n & 8) != 0) {
            disableBlinkingCursor = true;
        }
        this(activityRule, recomposer, disableTransitions, disableBlinkingCursor);
    }

    @NotNull
    public final ActivityScenarioRule<T> getActivityRule() {
        return this.activityRule;
    }

    @Nullable
    public final Recomposer getRecomposer() {
        return this.recomposer;
    }

    private final T getActivity() {
        Ref.ObjectRef activity = new Ref.ObjectRef();
        activity.element = null;
        if ((ComponentActivity)activity.element == null) {
            this.getActivityRule().getScenario().onActivity(new ActivityScenario.ActivityAction<T>(activity){
                private final /* synthetic */ Ref.ObjectRef<T> $activity;
                {
                    this.$activity = $activity;
                }

                public final void perform(@Nullable T it) {
                    this.$activity.element = it;
                }
            });
            if ((ComponentActivity)activity.element == null) {
                throw new IllegalStateException("Activity was not set in the ActivityScenarioRule!");
            }
        }
        Intrinsics.checkNotNull((Object)((ComponentActivity)activity.element));
        return (T)((ComponentActivity)activity.element);
    }

    @Override
    @NotNull
    public AnimationClockTestRule getClockTestRule() {
        return this.clockTestRule;
    }

    @Override
    @NotNull
    public Density getDensity() {
        return DensityKt.Density$default((float)this.getActivity().getResources().getDisplayMetrics().density, (float)0.0f, (int)2, null);
    }

    @Override
    @NotNull
    public DisplayMetrics getDisplayMetrics() {
        DisplayMetrics displayMetrics = this.getActivity().getResources().getDisplayMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"getActivity().resources.displayMetrics");
        return displayMetrics;
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @Nullable Description description) {
        Statement activityTestRuleStatement;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Statement statement = activityTestRuleStatement = this.getActivityRule().apply(base, description);
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"activityTestRuleStatement");
        AndroidComposeStatement composeTestRuleStatement = new AndroidComposeStatement(statement);
        return this.getClockTestRule().apply(composeTestRuleStatement, description);
    }

    @Override
    public void setContent(@NotNull Function3<? super Composer<?>, ? super Integer, ? super Integer, Unit> composable) {
        Intrinsics.checkNotNullParameter(composable, (String)"composable");
        boolean bl = this.disposeContentHook == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot call setContent twice per test!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Ref.ObjectRef activity = new Ref.ObjectRef();
        activity.element = null;
        this.getActivityRule().getScenario().onActivity(new ActivityScenario.ActivityAction<T>(activity){
            private final /* synthetic */ Ref.ObjectRef<T> $activity;
            {
                this.$activity = $activity;
            }

            public final void perform(@Nullable T it) {
                T t = it;
                Intrinsics.checkNotNullExpressionValue(t, (String)"it");
                this.$activity.element = t;
            }
        });
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(activity, this, composable){
            private final /* synthetic */ Ref.ObjectRef<T> $activity;
            private final /* synthetic */ AndroidComposeTestRule<T> $this;
            private final /* synthetic */ Function3<Composer<?>, Integer, Integer, Unit> $composable;
            {
                this.$activity = $activity;
                this.$this = $receiver;
                this.$composable = $composable;
                super(0);
            }

            public final void invoke() {
                if ((ComponentActivity)this.$activity.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"activity");
                    throw null;
                }
                Recomposer recomposer = this.$this.getRecomposer();
                Composition composition = WrapperKt.setContent((ComponentActivity)((ComponentActivity)this.$activity.element), (Recomposer)(recomposer == null ? Recomposer.Companion.current() : recomposer), this.$composable);
                if ((ComponentActivity)this.$activity.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"activity");
                    throw null;
                }
                ViewGroup contentViewGroup = (ViewGroup)((ComponentActivity)this.$activity.element).findViewById(0x1020002);
                contentViewGroup.getChildAt(0).restoreHierarchyState(new SparseArray());
                AndroidComposeTestRule.access$setDisposeContentHook$p(this.$this, (Function0)new Function0<Unit>(composition){
                    private final /* synthetic */ Composition $composition;
                    {
                        this.$composition = $composition;
                        super(0);
                    }

                    public final void invoke() {
                        this.$composition.dispose();
                    }
                });
            }
        });
        if (!SynchronizationKt.isOnUiThread()) {
            SynchronizationKt.waitForIdle();
        }
    }

    @Override
    @ExperimentalTesting
    @NotNull
    public ComposeTestCaseSetup forGivenTestCase(@NotNull ComposeTestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        return new AndroidComposeTestCaseSetup(testCase, (ComponentActivity)this.getActivity());
    }

    public static final /* synthetic */ void access$setDisposeContentHook$p(AndroidComposeTestRule androidComposeTestRule, Function0 function0) {
        androidComposeTestRule.disposeContentHook = function0;
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0001J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/ui/test/android/AndroidComposeTestRule$AndroidComposeStatement;", "Lorg/junit/runners/model/Statement;", "base", "afterEvaluate", "", "beforeEvaluate", "evaluate", "ui-test_release"})
    public final class AndroidComposeStatement
    extends Statement {
        private final Statement base;

        public AndroidComposeStatement(Statement base) {
            Intrinsics.checkNotNullParameter((Object)AndroidComposeTestRule.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            this.base = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() {
            Function1 oldTextInputFactory = TextInputServiceKt.getTextInputServiceFactory();
            this.beforeEvaluate();
            try {
                this.base.evaluate();
            }
            finally {
                this.afterEvaluate();
                TextInputServiceKt.setTextInputServiceFactory((Function1)oldTextInputFactory);
            }
        }

        private final void beforeEvaluate() {
            TransitionKt.setTransitionsEnabled((!AndroidComposeTestRule.this.disableTransitions ? 1 : 0) != 0);
            TextFieldKt.setBlinkingCursorEnabled((!AndroidComposeTestRule.this.disableBlinkingCursor ? 1 : 0) != 0);
            AndroidOwnerRegistry.INSTANCE.setupRegistry$ui_test_release();
            FirstDrawRegistry.INSTANCE.setupRegistry$ui_test_release();
            ComposeIdlingResourceKt.registerComposeWithEspresso();
            TextInputServiceKt.setTextInputServiceFactory((Function1)((Function1)new Function1<PlatformTextInputService, TextInputServiceForTests>(){

                @NotNull
                public final TextInputServiceForTests invoke(@NotNull PlatformTextInputService it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new TextInputServiceForTests(it);
                }
            }));
        }

        private final void afterEvaluate() {
            TransitionKt.setTransitionsEnabled((boolean)true);
            TextFieldKt.setBlinkingCursorEnabled((boolean)true);
            AndroidOwnerRegistry.INSTANCE.tearDownRegistry$ui_test_release();
            FirstDrawRegistry.INSTANCE.tearDownRegistry$ui_test_release();
            if (AndroidComposeTestRule.this.disposeContentHook != null) {
                SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(AndroidComposeTestRule.this){
                    private final /* synthetic */ AndroidComposeTestRule<T> $this;
                    {
                        this.$this = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        try {
                            Function0 function0 = AndroidComposeTestRule.access$getDisposeContentHook$p(this.$this);
                            Intrinsics.checkNotNull((Object)function0);
                            function0.invoke();
                        }
                        catch (Exception e) {
                        }
                        AndroidComposeTestRule.access$setDisposeContentHook$p(this.$this, null);
                    }
                });
            }
        }
    }
}

