/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.view.View;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.ui.core.AndroidOwner;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0013\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0002\b\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0015\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\r\u0010\u0018\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0019J\r\u0010\u001a\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001bJ\u0015\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001dR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R2\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Landroidx/ui/test/android/AndroidOwnerRegistry;", "", "isSetUp", "", "()Z", "owners", "", "Landroidx/ui/core/AndroidOwner;", "kotlin.jvm.PlatformType", "", "registryListeners", "Landroidx/ui/test/android/AndroidOwnerRegistry$OnRegistrationChangedListener;", "addOnRegistrationChangedListener", "", "listener", "dispatchOnRegistrationChanged", "owner", "isRegistered", "getOwners", "getUnfilteredOwners", "onAndroidOwnerCreated", "registerOwner", "registerOwner$ui_test_release", "removeOnRegistrationChangedListener", "setupRegistry", "setupRegistry$ui_test_release", "tearDownRegistry", "tearDownRegistry$ui_test_release", "unregisterOwner", "unregisterOwner$ui_test_release", "OnRegistrationChangedListener", "OwnerAttachedListener", "ui-test_release"})
public final class AndroidOwnerRegistry {
    @NotNull
    public static final AndroidOwnerRegistry INSTANCE = new AndroidOwnerRegistry();
    private static final Set<AndroidOwner> owners = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<OnRegistrationChangedListener> registryListeners;

    private AndroidOwnerRegistry() {
    }

    public final boolean isSetUp() {
        return Intrinsics.areEqual((Object)AndroidOwner.Companion.getOnAndroidOwnerCreatedCallback(), (Object)new Function1<AndroidOwner, Unit>(this){

            public final void invoke(@NotNull AndroidOwner p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AndroidOwnerRegistry.access$onAndroidOwnerCreated((AndroidOwnerRegistry)this.receiver, p0);
            }

            @NotNull
            public final String getSignature() {
                return "onAndroidOwnerCreated(Landroidx/ui/core/AndroidOwner;)V";
            }

            @NotNull
            public final String getName() {
                return "onAndroidOwnerCreated";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(AndroidOwnerRegistry.class);
            }
        });
    }

    public final void setupRegistry$ui_test_release() {
        AndroidOwner.Companion.setOnAndroidOwnerCreatedCallback((Function1)new Function1<AndroidOwner, Unit>(this){

            public final void invoke(@NotNull AndroidOwner p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AndroidOwnerRegistry.access$onAndroidOwnerCreated((AndroidOwnerRegistry)this.receiver, p0);
            }

            @NotNull
            public final String getSignature() {
                return "onAndroidOwnerCreated(Landroidx/ui/core/AndroidOwner;)V";
            }

            @NotNull
            public final String getName() {
                return "onAndroidOwnerCreated";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(AndroidOwnerRegistry.class);
            }
        });
    }

    public final void tearDownRegistry$ui_test_release() {
        AndroidOwner.Companion.setOnAndroidOwnerCreatedCallback((Function1)null);
    }

    private final void onAndroidOwnerCreated(AndroidOwner owner) {
        owner.getView().addOnAttachStateChangeListener((View.OnAttachStateChangeListener)new OwnerAttachedListener(owner));
    }

    @NotNull
    public final Set<AndroidOwner> getUnfilteredOwners() {
        Set<AndroidOwner> set = owners;
        Intrinsics.checkNotNullExpressionValue(set, (String)"owners");
        return CollectionsKt.toSet((Iterable)set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<AndroidOwner> getOwners() {
        void var2_3;
        void $this$filterTo$iv;
        Iterable<Object> iterable = owners;
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"owners");
        iterable = iterable;
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            AndroidOwner it = (AndroidOwner)element$iv;
            boolean bl2 = false;
            AndroidOwner.ViewTreeOwners viewTreeOwners = it.getViewTreeOwners();
            LifecycleOwner lifecycleOwner = viewTreeOwners == null ? (LifecycleOwner)null : viewTreeOwners.getLifecycleOwner();
            Lifecycle lifecycle = lifecycleOwner == null ? (Lifecycle)null : lifecycleOwner.getLifecycle();
            if (!Intrinsics.areEqual((Object)(lifecycle == null ? (Lifecycle.State)null : lifecycle.getCurrentState()), (Object)Lifecycle.State.RESUMED)) continue;
            destination$iv.add(element$iv);
        }
        return (Set)var2_3;
    }

    public final void addOnRegistrationChangedListener(@NotNull OnRegistrationChangedListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        registryListeners.add(listener2);
    }

    public final void removeOnRegistrationChangedListener(@NotNull OnRegistrationChangedListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        registryListeners.remove(listener2);
    }

    private final void dispatchOnRegistrationChanged(AndroidOwner owner, boolean isRegistered) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)registryListeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnRegistrationChangedListener it = (OnRegistrationChangedListener)element$iv;
            boolean bl = false;
            it.onRegistrationChanged(owner, isRegistered);
        }
    }

    public final void registerOwner$ui_test_release(@NotNull AndroidOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Set<AndroidOwner> set = owners;
        Intrinsics.checkNotNullExpressionValue(set, (String)"owners");
        set.add(owner);
        this.dispatchOnRegistrationChanged(owner, true);
    }

    public final void unregisterOwner$ui_test_release(@NotNull AndroidOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Set<AndroidOwner> set = owners;
        Intrinsics.checkNotNullExpressionValue(set, (String)"owners");
        set.remove(owner);
        this.dispatchOnRegistrationChanged(owner, false);
    }

    public static final /* synthetic */ void access$onAndroidOwnerCreated(AndroidOwnerRegistry $this, AndroidOwner androidOwner) {
        $this.onAndroidOwnerCreated(androidOwner);
    }

    static {
        boolean bl = false;
        registryListeners = new LinkedHashSet();
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Landroidx/ui/test/android/AndroidOwnerRegistry$OnRegistrationChangedListener;", "", "onRegistrationChanged", "", "owner", "Landroidx/ui/core/AndroidOwner;", "registered", "", "ui-test_release"})
    public static interface OnRegistrationChangedListener {
        public void onRegistrationChanged(@NotNull AndroidOwner var1, boolean var2);
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/ui/test/android/AndroidOwnerRegistry$OwnerAttachedListener;", "Landroid/view/View$OnAttachStateChangeListener;", "owner", "Landroidx/ui/core/AndroidOwner;", "onViewAttachedToWindow", "", "view", "Landroid/view/View;", "onViewDetachedFromWindow", "ui-test_release"})
    private static final class OwnerAttachedListener
    implements View.OnAttachStateChangeListener {
        private final AndroidOwner owner;

        public OwnerAttachedListener(@NotNull AndroidOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.owner = owner;
        }

        public void onViewAttachedToWindow(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            INSTANCE.registerOwner$ui_test_release(this.owner);
        }

        public void onViewDetachedFromWindow(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            INSTANCE.unregisterOwner$ui_test_release(this.owner);
        }
    }
}

