/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.PixelCopy;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.ui.test.android.WindowCaptureKt;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u00a8\u0006\u0006"}, d2={"captureRegionToBitmap", "Landroid/graphics/Bitmap;", "captureRectInWindow", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "ui-test_release"})
public final class WindowCaptureKt {
    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureRegionToBitmap(@NotNull Rect captureRectInWindow, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)captureRectInWindow, (String)"captureRectInWindow");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        Activity activity = WindowCaptureKt.captureRegionToBitmap$getActivity(context);
        Intrinsics.checkNotNull((Object)activity);
        Window window = activity.getWindow();
        context = Looper.getMainLooper();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getMainLooper()");
        Handler handler = new Handler((Looper)context);
        CountDownLatch drawLatch = new CountDownLatch(1);
        Object object = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"window.decorView");
        View decorView = object;
        object = new Runnable(decorView, drawLatch, handler){
            private final /* synthetic */ View $decorView;
            private final /* synthetic */ CountDownLatch $drawLatch;
            private final /* synthetic */ Handler $handler;
            {
                this.$decorView = $decorView;
                this.$drawLatch = $drawLatch;
                this.$handler = $handler;
            }

            public final void run() {
                if (Build.VERSION.SDK_INT >= 29) {
                    Runnable runnable = new Runnable(this.$drawLatch){
                        private final /* synthetic */ CountDownLatch $drawLatch;
                        {
                            this.$drawLatch = $drawLatch;
                        }

                        public final void run() {
                            this.$drawLatch.countDown();
                        }
                    };
                    this.$decorView.getViewTreeObserver().registerFrameCommitCallback(runnable);
                } else {
                    this.$decorView.getViewTreeObserver().addOnDrawListener(new ViewTreeObserver.OnDrawListener(this.$handler, this.$drawLatch, this.$decorView){
                        private boolean handled;
                        private final /* synthetic */ Handler $handler;
                        private final /* synthetic */ CountDownLatch $drawLatch;
                        private final /* synthetic */ View $decorView;
                        {
                            this.$handler = $handler;
                            this.$drawLatch = $drawLatch;
                            this.$decorView = $decorView;
                        }

                        public final boolean getHandled() {
                            return this.handled;
                        }

                        public final void setHandled(boolean bl) {
                            this.handled = bl;
                        }

                        public void onDraw() {
                            if (!this.getHandled()) {
                                this.setHandled(true);
                                Runnable runnable = new Runnable(this.$drawLatch, this.$decorView, this){
                                    private final /* synthetic */ CountDownLatch $drawLatch;
                                    private final /* synthetic */ View $decorView;
                                    private final /* synthetic */ captureRegionToBitmap.2 $this;
                                    {
                                        this.$drawLatch = $drawLatch;
                                        this.$decorView = $decorView;
                                        this.$this = $receiver;
                                    }

                                    public final void run() {
                                        this.$drawLatch.countDown();
                                        this.$decorView.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this.$this);
                                    }
                                };
                                this.$handler.post(runnable);
                            }
                        }
                    });
                }
                this.$decorView.invalidate();
            }
        };
        handler.post((Runnable)object);
        if (!drawLatch.await(1L, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Failed waiting for DecorView redraw!");
        }
        Bitmap destBitmap = Bitmap.createBitmap((int)captureRectInWindow.width(), (int)captureRectInWindow.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        CountDownLatch latch = new CountDownLatch(1);
        Ref.IntRef copyResult = new Ref.IntRef();
        copyResult.element = 0;
        PixelCopy.OnPixelCopyFinishedListener onCopyFinished2 = new PixelCopy.OnPixelCopyFinishedListener(copyResult, latch){
            private final /* synthetic */ Ref.IntRef $copyResult;
            private final /* synthetic */ CountDownLatch $latch;
            {
                this.$copyResult = $copyResult;
                this.$latch = $latch;
            }

            public final void onPixelCopyFinished(int result) {
                this.$copyResult.element = result;
                this.$latch.countDown();
            }
        };
        Window window2 = window;
        Intrinsics.checkNotNullExpressionValue((Object)window2, (String)"window");
        Window window3 = window2;
        window2 = destBitmap;
        Intrinsics.checkNotNullExpressionValue((Object)window2, (String)"destBitmap");
        PixelCopy.request((Window)window3, (Rect)captureRectInWindow, (Bitmap)window2, (PixelCopy.OnPixelCopyFinishedListener)onCopyFinished2, (Handler)handler);
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Failed waiting for PixelCopy!");
        }
        if (copyResult.element != 0) {
            throw new AssertionError((Object)"PixelCopy failed!");
        }
        window2 = destBitmap;
        Intrinsics.checkNotNullExpressionValue((Object)window2, (String)"destBitmap");
        return window2;
    }

    private static final Activity captureRegionToBitmap$getActivity(Context $this$captureRegionToBitmap_u24getActivity) {
        Activity activity;
        Context context = $this$captureRegionToBitmap_u24getActivity;
        if (context instanceof Activity) {
            activity = (Activity)$this$captureRegionToBitmap_u24getActivity;
        } else if (context instanceof ContextWrapper) {
            Context context2 = ((ContextWrapper)$this$captureRegionToBitmap_u24getActivity).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"this.baseContext");
            activity = WindowCaptureKt.captureRegionToBitmap$getActivity(context2);
        } else {
            activity = null;
        }
        return activity;
    }
}

