/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import android.graphics.Bitmap;
import android.graphics.Path;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.RequiresApi;
import androidx.ui.core.AndroidOwner;
import androidx.ui.core.Owner;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.SizeKt;
import androidx.ui.graphics.AndroidPath;
import androidx.ui.graphics.AndroidPathKt;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.Outline;
import androidx.ui.graphics.OutlineKt;
import androidx.ui.graphics.RectangleShapeKt;
import androidx.ui.graphics.Shape;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.android.WindowCaptureKt;
import androidx.ui.unit.Density;
import androidx.ui.unit.IntOffset;
import androidx.ui.unit.IntSize;
import androidx.ui.unit.PxBounds;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=16, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u001a(\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u001aB\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u0011\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a>\u0010\u0015\u001a\u00020\t*\u00020\n2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172#\u0010\u0018\u001a\u001f\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0011\u00f8\u0001\u0000\u001a\u0084\u0001\u0010\u001d\u001a\u00020\t*\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\f2\b\b\u0002\u0010$\u001a\u00020!2\b\b\u0002\u0010%\u001a\u00020\u00042\b\b\u0002\u0010&\u001a\u00020\u00042\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010'\u001a\u00020\u00042\b\b\u0002\u0010(\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b*\u0010+\u001aP\u0010\u001d\u001a\u00020\t*\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010#\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\f2\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010)\u001a\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b/\u00100\u001a\f\u00101\u001a\u00020\n*\u000202H\u0007\u001a\f\u00101\u001a\u00020\n*\u000203H\u0007\u001a\u0012\u00104\u001a\u000205*\u0002062\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0015\u00107\u001a\u000208*\u00020\u00042\u0006\u00107\u001a\u00020\u0004H\u0082\u0004\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00069"}, d2={"pixelCloserToCenter", "Landroidx/ui/geometry/Offset;", "offset", "shapeSizeX", "", "shapeSizeY", "delta", "pixelFartherFromCenter", "assertPixelColor", "", "Landroid/graphics/Bitmap;", "expected", "Landroidx/ui/graphics/Color;", "x", "", "y", "error", "Lkotlin/Function1;", "", "assertPixelColor-9bBi3KA", "(Landroid/graphics/Bitmap;JIILkotlin/jvm/functions/Function1;)V", "assertPixels", "expectedSize", "Landroidx/ui/unit/IntSize;", "expectedColorProvider", "Landroidx/ui/unit/IntOffset;", "Lkotlin/ParameterName;", "name", "pos", "assertShape", "density", "Landroidx/ui/unit/Density;", "shape", "Landroidx/ui/graphics/Shape;", "shapeColor", "backgroundColor", "backgroundShape", "sizeX", "sizeY", "centerX", "centerY", "shapeOverlapPixelCount", "assertShape-t2RoSCg", "(Landroid/graphics/Bitmap;Landroidx/ui/unit/Density;Landroidx/ui/graphics/Shape;JJLandroidx/ui/graphics/Shape;FFFFFFF)V", "horizontalPadding", "Landroidx/ui/unit/Dp;", "verticalPadding", "assertShape--mmofgM", "(Landroid/graphics/Bitmap;Landroidx/ui/unit/Density;FFJJLandroidx/ui/graphics/Shape;F)V", "captureToBitmap", "Landroid/view/View;", "Landroidx/ui/test/SemanticsNodeInteraction;", "contains", "", "Landroidx/ui/graphics/Path;", "until", "Lkotlin/ranges/IntRange;", "ui-test_release"})
public final class BitmapHelpersKt {
    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureToBitmap(@NotNull SemanticsNodeInteraction $this$captureToBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$captureToBitmap, (String)"<this>");
        SemanticsNode node = $this$captureToBitmap.fetchSemanticsNode("Failed to capture a node to bitmap.");
        PxBounds nodeBounds = node.getBoundsInRoot();
        Rect nodeBoundsRect = new Rect(MathKt.roundToInt((float)nodeBounds.getLeft()), MathKt.roundToInt((float)nodeBounds.getTop()), MathKt.roundToInt((float)nodeBounds.getRight()), MathKt.roundToInt((float)nodeBounds.getBottom()));
        Owner owner = node.getComponentNode().getOwner();
        if (owner == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.ui.core.AndroidOwner");
        }
        View view = ((AndroidOwner)owner).getView();
        int[] nArray = new int[]{0, 0};
        int[] locationInWindow = nArray;
        view.getLocationInWindow(locationInWindow);
        int x = locationInWindow[0];
        int y = locationInWindow[1];
        nodeBoundsRect.offset(x, y);
        return WindowCaptureKt.captureRegionToBitmap(nodeBoundsRect, view);
    }

    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureToBitmap(@NotNull View $this$captureToBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$captureToBitmap, (String)"<this>");
        int[] nArray = new int[]{0, 0};
        int[] locationInWindow = nArray;
        $this$captureToBitmap.getLocationInWindow(locationInWindow);
        int x = locationInWindow[0];
        int y = locationInWindow[1];
        Rect boundsInWindow = new Rect(x, y, x + $this$captureToBitmap.getWidth(), y + $this$captureToBitmap.getHeight());
        return WindowCaptureKt.captureRegionToBitmap(boundsInWindow, $this$captureToBitmap);
    }

    public static final void assertPixels(@NotNull Bitmap $this$assertPixels, @Nullable IntSize expectedSize, @NotNull Function1<? super IntOffset, Color> expectedColorProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$assertPixels, (String)"<this>");
        Intrinsics.checkNotNullParameter(expectedColorProvider, (String)"expectedColorProvider");
        if (expectedSize != null && ($this$assertPixels.getWidth() != expectedSize.getWidth() || $this$assertPixels.getHeight() != expectedSize.getHeight())) {
            throw new AssertionError((Object)("Bitmap size is wrong! Expected '" + expectedSize + "' but got '" + $this$assertPixels.getWidth() + " x " + $this$assertPixels.getHeight() + '\''));
        }
        int n = $this$assertPixels.getWidth();
        int n2 = 0;
        int n3 = n + -1;
        if (n != Integer.MIN_VALUE && n2 <= n3) {
            do {
                int x = n2++;
                int n4 = $this$assertPixels.getHeight();
                int n5 = 0;
                int n6 = n4 + -1;
                if (n4 == Integer.MIN_VALUE || n5 > n6) continue;
                do {
                    int y = n5++;
                    boolean $i$f$IntOffset = false;
                    boolean $i$f$packInts = false;
                    IntOffset pxPos = new IntOffset((long)x << 32 | (long)y & 0xFFFFFFFFL);
                    Color expectedClr = (Color)expectedColorProvider.invoke((Object)pxPos);
                    if (expectedClr == null) continue;
                    BitmapHelpersKt.assertPixelColor-9bBi3KA$default($this$assertPixels, expectedClr.unbox-impl(), x, y, null, 8, null);
                } while (n5 <= n6);
            } while (n2 <= n3);
        }
    }

    public static /* synthetic */ void assertPixels$default(Bitmap bitmap, IntSize intSize, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            intSize = null;
        }
        BitmapHelpersKt.assertPixels(bitmap, intSize, (Function1<? super IntOffset, Color>)function1);
    }

    public static final void assertPixelColor-9bBi3KA(@NotNull Bitmap $this$assertPixelColor, long expected, int x, int y, @NotNull Function1<? super Color, String> error) {
        Intrinsics.checkNotNullParameter((Object)$this$assertPixelColor, (String)"$this$assertPixelColor");
        Intrinsics.checkNotNullParameter(error, (String)"error");
        long color = ColorKt.Color((int)$this$assertPixelColor.getPixel(x, y));
        String errorString = (String)error.invoke((Object)Color.box-impl((long)color));
        Assert.assertEquals((String)errorString, (float)Color.getRed-impl((long)expected), (float)Color.getRed-impl((long)color), (float)0.02f);
        Assert.assertEquals((String)errorString, (float)Color.getGreen-impl((long)expected), (float)Color.getGreen-impl((long)color), (float)0.02f);
        Assert.assertEquals((String)errorString, (float)Color.getBlue-impl((long)expected), (float)Color.getBlue-impl((long)color), (float)0.02f);
        Assert.assertEquals((String)errorString, (float)Color.getAlpha-impl((long)expected), (float)Color.getAlpha-impl((long)color), (float)0.02f);
    }

    public static /* synthetic */ void assertPixelColor-9bBi3KA$default(Bitmap bitmap, long l, int n, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 8) != 0) {
            function1 = (Function1)new Function1<Color, String>(n, n2, l, null){
                private final /* synthetic */ int $x;
                private final /* synthetic */ int $y;
                private final /* synthetic */ long $expected;
                {
                    this.$x = $x;
                    this.$y = $y;
                    this.$expected = $expected;
                    super(1);
                }

                @NotNull
                public final String invoke(long color) {
                    return "Pixel(" + this.$x + ", " + this.$y + ") expected to be " + Color.toString-impl((long)this.$expected) + ", but was " + Color.toString-impl((long)color);
                }
                {
                    this($x, $y, $expected);
                }
            };
        }
        BitmapHelpersKt.assertPixelColor-9bBi3KA(bitmap, l, n, n2, (Function1<? super Color, String>)function1);
    }

    public static final boolean contains(@NotNull androidx.ui.graphics.Path $this$contains, @NotNull Offset offset) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Path path = new Path();
        path.addRect(offset.getX() - 0.01f, offset.getY() - 0.01f, offset.getX() + 0.01f, offset.getY() + 0.01f, Path.Direction.CW);
        androidx.ui.graphics.Path $this$asAndroidPath$iv = $this$contains;
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw (Throwable)new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        if (path.op(((AndroidPath)$this$asAndroidPath$iv).getInternalPath(), Path.Op.INTERSECT)) {
            return !path.isEmpty();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertShape-t2RoSCg(@NotNull Bitmap $this$assertShape, @NotNull Density density, @NotNull Shape shape, long shapeColor, long backgroundColor, @NotNull Shape backgroundShape, float sizeX, float sizeY, float shapeSizeX, float shapeSizeY, float centerX, float centerY, float shapeOverlapPixelCount) {
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$assertShape, (String)"$this$assertShape");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)backgroundShape, (String)"backgroundShape");
        int width = $this$assertShape.getWidth();
        int height = $this$assertShape.getHeight();
        Assert.assertTrue((centerX + sizeX / (float)2 <= (float)width ? 1 : 0) != 0);
        Assert.assertTrue((centerX - sizeX / (float)2 >= 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((centerY + sizeY / (float)2 <= (float)height ? 1 : 0) != 0);
        Assert.assertTrue((centerY - sizeY / (float)2 >= 0.0f ? 1 : 0) != 0);
        Outline outline = shape.createOutline-SwJi8iY(SizeKt.Size((float)shapeSizeX, (float)shapeSizeY), density);
        androidx.ui.graphics.Path path = AndroidPathKt.Path();
        OutlineKt.addOutline((androidx.ui.graphics.Path)path, (Outline)outline);
        float f = centerX - shapeSizeX / 2.0f;
        float y$iv = centerY - shapeSizeY / 2.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var24_23 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var24_23);
        float f2 = y$iv;
        int n = 0;
        long v2$iv$iv = Float.floatToIntBits(f2);
        Offset shapeOffset = new Offset(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
        androidx.ui.graphics.Path backgroundPath = AndroidPathKt.Path();
        OutlineKt.addOutline((androidx.ui.graphics.Path)backgroundPath, (Outline)backgroundShape.createOutline-SwJi8iY(SizeKt.Size((float)sizeX, (float)sizeY), density));
        IntRange intRange = BitmapHelpersKt.until(centerX - sizeX / (float)2, centerX + sizeX / (float)2);
        int n2 = intRange.getFirst();
        int n3 = intRange.getLast();
        int n4 = intRange.getStep();
        if (n4 > 0 && n2 <= n3 || n4 < 0 && n3 <= n2) {
            int x;
            do {
                int y;
                x = n2;
                n2 += n4;
                IntRange intRange2 = BitmapHelpersKt.until(centerY - sizeY / (float)2, centerY + sizeY / (float)2);
                int n5 = intRange2.getFirst();
                int n6 = intRange2.getLast();
                n = intRange2.getStep();
                if ((n <= 0 || n5 > n6) && (n >= 0 || n6 > n5)) continue;
                do {
                    boolean isOutside;
                    void x$iv2;
                    y = n5;
                    n5 += n;
                    float f3 = x;
                    float y$iv2 = y;
                    boolean $i$f$Offset2 = false;
                    boolean $i$f$packFloats2 = false;
                    void var36_42 = x$iv2;
                    boolean bl2 = false;
                    long v1$iv$iv2 = Float.floatToIntBits((float)var36_42);
                    float f4 = y$iv2;
                    boolean bl3 = false;
                    long v2$iv$iv2 = Float.floatToIntBits(f4);
                    Offset point = new Offset(v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL);
                    if (!BitmapHelpersKt.contains(backgroundPath, BitmapHelpersKt.pixelFartherFromCenter(point, sizeX, sizeY, shapeOverlapPixelCount))) continue;
                    Offset offset = point.minus(shapeOffset);
                    boolean isInside = BitmapHelpersKt.contains(path, BitmapHelpersKt.pixelFartherFromCenter(offset, shapeSizeX, shapeSizeY, shapeOverlapPixelCount));
                    boolean bl4 = isOutside = !BitmapHelpersKt.contains(path, BitmapHelpersKt.pixelCloserToCenter(offset, shapeSizeX, shapeSizeY, shapeOverlapPixelCount));
                    if (isInside) {
                        BitmapHelpersKt.assertPixelColor-9bBi3KA$default($this$assertShape, shapeColor, x, y, null, 8, null);
                        continue;
                    }
                    if (!isOutside) continue;
                    BitmapHelpersKt.assertPixelColor-9bBi3KA$default($this$assertShape, backgroundColor, x, y, null, 8, null);
                } while (y != n6);
            } while (x != n3);
        }
    }

    public static /* synthetic */ void assertShape-t2RoSCg$default(Bitmap bitmap, Density density, Shape shape, long l, long l2, Shape shape2, float f, float f2, float f3, float f4, float f5, float f6, float f7, int n, Object object) {
        if ((n & 0x10) != 0) {
            shape2 = RectangleShapeKt.getRectangleShape();
        }
        if ((n & 0x20) != 0) {
            f = bitmap.getWidth();
        }
        if ((n & 0x40) != 0) {
            f2 = bitmap.getHeight();
        }
        if ((n & 0x80) != 0) {
            f3 = f;
        }
        if ((n & 0x100) != 0) {
            f4 = f2;
        }
        if ((n & 0x200) != 0) {
            f5 = (float)bitmap.getWidth() / 2.0f;
        }
        if ((n & 0x400) != 0) {
            f6 = (float)bitmap.getHeight() / 2.0f;
        }
        if ((n & 0x800) != 0) {
            f7 = 1.0f;
        }
        BitmapHelpersKt.assertShape-t2RoSCg(bitmap, density, shape, l, l2, shape2, f, f2, f3, f4, f5, f6, f7);
    }

    public static final void assertShape--mmofgM(@NotNull Bitmap $this$assertShape, @NotNull Density density, float horizontalPadding, float verticalPadding, long backgroundColor, long shapeColor, @NotNull Shape shape, float shapeOverlapPixelCount) {
        Intrinsics.checkNotNullParameter((Object)$this$assertShape, (String)"$this$assertShape");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        boolean bl = false;
        boolean bl2 = false;
        Density $this$assertShape__mmofgM_u24lambda_u2d0 = density;
        boolean bl3 = false;
        float fullHorizontalPadding = $this$assertShape__mmofgM_u24lambda_u2d0.toPx-ipo6vVg(horizontalPadding) * (float)2;
        bl2 = false;
        boolean bl4 = false;
        Density $this$assertShape__mmofgM_u24lambda_u2d1 = density;
        boolean bl5 = false;
        float fullVerticalPadding = $this$assertShape__mmofgM_u24lambda_u2d1.toPx-ipo6vVg(verticalPadding) * (float)2;
        BitmapHelpersKt.assertShape-t2RoSCg$default($this$assertShape, density, shape, shapeColor, backgroundColor, RectangleShapeKt.getRectangleShape(), 0.0f, 0.0f, (float)$this$assertShape.getWidth() - fullHorizontalPadding, (float)$this$assertShape.getHeight() - fullVerticalPadding, 0.0f, 0.0f, shapeOverlapPixelCount, 1632, null);
    }

    public static /* synthetic */ void assertShape--mmofgM$default(Bitmap bitmap, Density density, float f, float f2, long l, long l2, Shape shape, float f3, int n, Object object) {
        if ((n & 0x20) != 0) {
            shape = RectangleShapeKt.getRectangleShape();
        }
        if ((n & 0x40) != 0) {
            f3 = 1.0f;
        }
        BitmapHelpersKt.assertShape--mmofgM(bitmap, density, f, f2, l, l2, shape, f3);
    }

    private static final IntRange until(float $this$until, float until) {
        int from = MathKt.roundToInt((float)$this$until);
        int to = MathKt.roundToInt((float)until);
        if (from <= Integer.MIN_VALUE) {
            return IntRange.Companion.getEMPTY();
        }
        return new IntRange(from, to - 1);
    }

    private static final Offset pixelCloserToCenter(Offset offset, float shapeSizeX, float shapeSizeY, float delta) {
        float x;
        float centerX = shapeSizeX / 2.0f;
        float centerY = shapeSizeY / 2.0f;
        float d = delta;
        float f = offset.getX() > centerX ? offset.getX() - d : (x = offset.getX() < centerX ? offset.getX() + d : offset.getX());
        float y = offset.getY() > centerY ? offset.getY() - d : (offset.getY() < centerY ? offset.getY() + d : offset.getY());
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        float f2 = x;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits(f2);
        float f3 = y;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f3);
        return new Offset(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }

    private static final Offset pixelFartherFromCenter(Offset offset, float shapeSizeX, float shapeSizeY, float delta) {
        float x;
        float centerX = shapeSizeX / 2.0f;
        float centerY = shapeSizeY / 2.0f;
        float d = delta;
        float f = offset.getX() > centerX ? offset.getX() + d : (x = offset.getX() < centerX ? offset.getX() - d : offset.getX());
        float y = offset.getY() > centerY ? offset.getY() + d : (offset.getY() < centerY ? offset.getY() - d : offset.getY());
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        float f2 = x;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits(f2);
        float f3 = y;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f3);
        return new Offset(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }
}

