/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.test.OutputKt;
import androidx.ui.test.SemanticsMatcher;
import androidx.ui.test.SemanticsSelector;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=16, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a&\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a0\u0010\r\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a \u0010\u0011\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0001H\u0000\u001a \u0010\u0013\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0006H\u0000\u001a&\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u00a8\u0006\u0017"}, d2={"buildErrorMessageForAssertAllFail", "", "selector", "Landroidx/ui/test/SemanticsSelector;", "nodesNotMatching", "", "Landroidx/ui/core/semantics/SemanticsNode;", "assertionMatcher", "Landroidx/ui/test/SemanticsMatcher;", "buildErrorMessageForAssertAnyFail", "nodes", "buildErrorMessageForAtLeastOneNodeExpected", "errorMessage", "buildErrorMessageForCountMismatch", "foundNodes", "expectedCount", "", "buildErrorMessageForNodeMissingInTree", "lastSeenSemantics", "buildGeneralErrorMessage", "node", "buildIndexErrorMessage", "index", "ui-test_release"})
public final class ErrorMessagesKt {
    @NotNull
    public static final String buildErrorMessageForCountMismatch(@NotNull String errorMessage, @Nullable SemanticsSelector selector, @NotNull List<SemanticsNode> foundNodes, int expectedCount) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter(foundNodes, (String)"foundNodes");
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        sb.append("\n");
        sb.append("Reason: ");
        switch (expectedCount) {
            case 0: {
                sb.append("Did not expect any node");
                break;
            }
            case 1: {
                sb.append("Expected exactly '1' node");
                break;
            }
            default: {
                sb.append("Expected '" + expectedCount + "' nodes");
            }
        }
        if (foundNodes.isEmpty()) {
            sb.append(" but could not find any");
        } else {
            sb.append(" but found '" + foundNodes.size() + '\'');
        }
        if (selector != null) {
            if (foundNodes.size() <= 1) {
                sb.append(" node that satisfies: (" + selector.getDescription() + ')');
            } else {
                sb.append(" nodes that satisfy: (" + selector.getDescription() + ')');
            }
        } else {
            sb.append(".");
        }
        Object object = sb;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append('\n'), (String)"append('\\n')");
        object = foundNodes;
        bl = false;
        if (!object.isEmpty()) {
            boolean bl2;
            StringBuilder stringBuilder;
            boolean bl3;
            String string;
            if (foundNodes.size() == 1) {
                object = sb;
                string = "Node found:";
                bl3 = false;
                StringBuilder stringBuilder2 = ((StringBuilder)object).append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                stringBuilder = stringBuilder2;
                bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            } else {
                object = sb;
                string = "Nodes found:";
                bl3 = false;
                StringBuilder stringBuilder3 = ((StringBuilder)object).append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                stringBuilder = stringBuilder3;
                bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            }
            object = sb;
            string = OutputKt.printToString$default(foundNodes, 0, 1, null);
            bl3 = false;
            StringBuilder stringBuilder4 = ((StringBuilder)object).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            stringBuilder = stringBuilder4;
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
        object = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
        return object;
    }

    @NotNull
    public static final String buildErrorMessageForNodeMissingInTree(@NotNull String errorMessage, @NotNull SemanticsSelector selector, @NotNull String lastSeenSemantics) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)lastSeenSemantics, (String)"lastSeenSemantics");
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        sb.append("\n");
        CharSequence charSequence = sb;
        String string = "The node is no longer in the tree, last known semantics:";
        boolean bl = false;
        StringBuilder stringBuilder = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        charSequence = sb;
        boolean bl3 = false;
        StringBuilder stringBuilder3 = charSequence.append(lastSeenSemantics);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringBuilder stringBuilder4 = stringBuilder3;
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        sb.append("Original selector: ");
        charSequence = sb;
        String string2 = selector.getDescription();
        boolean bl5 = false;
        StringBuilder stringBuilder5 = charSequence.append(string2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        StringBuilder stringBuilder6 = stringBuilder5;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
        charSequence = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @NotNull
    public static final String buildErrorMessageForAssertAnyFail(@NotNull SemanticsSelector selector, @NotNull List<SemanticsNode> nodes, @NotNull SemanticsMatcher assertionMatcher) {
        StringBuilder sb;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)assertionMatcher, (String)"assertionMatcher");
        CharSequence charSequence = sb = new StringBuilder();
        String string = "Failed to assertAny(" + assertionMatcher.getDescription() + ')';
        boolean bl = false;
        StringBuilder stringBuilder = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        charSequence = sb;
        string = "None of the following nodes match:";
        bl = false;
        StringBuilder stringBuilder3 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        stringBuilder2 = stringBuilder3;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        charSequence = sb;
        string = OutputKt.printToString$default(nodes, 0, 1, null);
        bl = false;
        StringBuilder stringBuilder4 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        stringBuilder2 = stringBuilder4;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        sb.append("Selector used: '");
        sb.append(selector.getDescription());
        charSequence = sb;
        string = "'";
        bl = false;
        StringBuilder stringBuilder5 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        stringBuilder2 = stringBuilder5;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        charSequence = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @NotNull
    public static final String buildErrorMessageForAssertAllFail(@NotNull SemanticsSelector selector, @NotNull List<SemanticsNode> nodesNotMatching, @NotNull SemanticsMatcher assertionMatcher) {
        StringBuilder sb;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter(nodesNotMatching, (String)"nodesNotMatching");
        Intrinsics.checkNotNullParameter((Object)assertionMatcher, (String)"assertionMatcher");
        CharSequence charSequence = sb = new StringBuilder();
        String string = "Failed to assertAll(" + assertionMatcher.getDescription() + ')';
        boolean bl = false;
        StringBuilder stringBuilder = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        sb.append("Found '" + nodesNotMatching.size() + "' ");
        sb.append(nodesNotMatching.size() == 1 ? "node" : "nodes");
        charSequence = sb;
        string = " not matching:";
        bl = false;
        StringBuilder stringBuilder3 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        stringBuilder2 = stringBuilder3;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        charSequence = sb;
        string = OutputKt.printToString$default(nodesNotMatching, 0, 1, null);
        bl = false;
        StringBuilder stringBuilder4 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        stringBuilder2 = stringBuilder4;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        sb.append("Selector used: '");
        sb.append(selector.getDescription());
        charSequence = sb;
        string = "'";
        bl = false;
        StringBuilder stringBuilder5 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        stringBuilder2 = stringBuilder5;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        charSequence = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @NotNull
    public static final String buildErrorMessageForAtLeastOneNodeExpected(@NotNull String errorMessage, @NotNull SemanticsSelector selector) {
        StringBuilder sb;
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        CharSequence charSequence = sb = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder = charSequence.append(errorMessage);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        sb.append("Assert needs to receive at least 1 node but 0 nodes were found for selector: ");
        sb.append("'");
        sb.append(selector.getDescription());
        charSequence = sb;
        String string = "'";
        boolean bl3 = false;
        StringBuilder stringBuilder3 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringBuilder stringBuilder4 = stringBuilder3;
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        charSequence = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @NotNull
    public static final String buildGeneralErrorMessage(@NotNull String errorMessage, @NotNull SemanticsSelector selector, @NotNull SemanticsNode node) {
        StringBuilder sb;
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        CharSequence charSequence = sb = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder = charSequence.append(errorMessage);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        charSequence = sb;
        String string = "Semantics of the node:";
        boolean bl3 = false;
        StringBuilder stringBuilder3 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringBuilder stringBuilder4 = stringBuilder3;
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        charSequence = sb;
        string = OutputKt.printToString$default(node, 0, 1, null);
        bl3 = false;
        StringBuilder stringBuilder5 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        stringBuilder4 = stringBuilder5;
        bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        sb.append("Selector used: (");
        sb.append(selector.getDescription());
        charSequence = sb;
        string = ")";
        bl3 = false;
        StringBuilder stringBuilder6 = charSequence.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        stringBuilder4 = stringBuilder6;
        bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        charSequence = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @NotNull
    public static final String buildIndexErrorMessage(int index, @NotNull SemanticsSelector selector, @NotNull List<SemanticsNode> nodes) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        StringBuilder sb = new StringBuilder();
        sb.append("Can't retrieve node at index '" + index + "' of '");
        sb.append(selector.getDescription());
        CharSequence charSequence = sb;
        String string = "'";
        boolean bl = false;
        StringBuilder stringBuilder = ((StringBuilder)charSequence).append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        if (nodes.isEmpty()) {
            charSequence = sb;
            string = "There are no existing nodes for that selector.";
            bl = false;
            StringBuilder stringBuilder3 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            stringBuilder2 = stringBuilder3;
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        } else if (nodes.size() == 1) {
            charSequence = sb;
            string = "There is 1 node only:";
            bl = false;
            StringBuilder stringBuilder4 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            stringBuilder2 = stringBuilder4;
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            charSequence = sb;
            string = OutputKt.printToString$default(nodes, 0, 1, null);
            bl = false;
            StringBuilder stringBuilder5 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            stringBuilder2 = stringBuilder5;
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        } else {
            charSequence = sb;
            string = "There are '" + nodes.size() + "' nodes only:";
            bl = false;
            StringBuilder stringBuilder6 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            stringBuilder2 = stringBuilder6;
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            charSequence = sb;
            string = OutputKt.printToString$default(nodes, 0, 1, null);
            bl = false;
            StringBuilder stringBuilder7 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
            stringBuilder2 = stringBuilder7;
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        }
        charSequence = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }
}

