/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import android.annotation.SuppressLint;
import android.os.Looper;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.ui.test.SynchronizationKt;
import androidx.ui.test.android.SynchronizedTreeCollector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=16, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u001f\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0005\u00a2\u0006\u0002\u0010\u0006\u001a!\u0010\u0007\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0005H\u0007\u00a2\u0006\u0002\u0010\u0006\u001a!\u0010\b\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0005H\u0007\u00a2\u0006\u0002\u0010\u0006\u001a\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"isOnUiThread", "", "runOnIdle", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "runOnIdleCompose", "runOnUiThread", "waitForIdle", "", "ui-test_release"})
public final class SynchronizationKt {
    @SuppressLint(value={"DocumentExceptions"})
    public static final <T> T runOnUiThread(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (SynchronizationKt.isOnUiThread()) {
            return (T)action.invoke();
        }
        FutureTask task = new FutureTask(new sam.java_util_concurrent_Callable.0(action));
        InstrumentationRegistry.getInstrumentation().runOnMainSync((Runnable)task);
        try {
            return (T)task.get();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            Intrinsics.checkNotNull((Object)throwable);
            throw throwable;
        }
    }

    public static final boolean isOnUiThread() {
        return Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper());
    }

    public static final <T> T runOnIdle(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        SynchronizationKt.waitForIdle();
        return SynchronizationKt.runOnUiThread(action);
    }

    public static final void waitForIdle() {
        SynchronizedTreeCollector.INSTANCE.waitForIdle$ui_test_release();
    }

    @Deprecated(message="Renamed to runOnIdle", replaceWith=@ReplaceWith(expression="runOnIdle(action)", imports={}))
    public static final <T> T runOnIdleCompose(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return SynchronizationKt.runOnIdle(action);
    }
}

