/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.ui.core.AndroidOwner;
import androidx.ui.core.Owner;
import androidx.ui.core.semantics.SemanticsNode;
import androidx.ui.input.CommitTextEditOp;
import androidx.ui.input.DeleteAllEditOp;
import androidx.ui.input.EditOperation;
import androidx.ui.input.ImeAction;
import androidx.ui.test.ActionsKt;
import androidx.ui.test.AssertionsKt;
import androidx.ui.test.ErrorMessagesKt;
import androidx.ui.test.FiltersKt;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.SynchronizationKt;
import androidx.ui.test.TextActionsKt;
import androidx.ui.test.TextInputServiceForTests;
import androidx.ui.text.TextSemanticsProperties;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=16, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u001e\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0016\u0010\b\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u001e\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0000\u001a\u0014\u0010\r\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\u00a8\u0006\u0015"}, d2={"doClearText", "", "Landroidx/ui/test/SemanticsNodeInteraction;", "alreadyHasFocus", "", "doReplaceText", "text", "", "doSendImeAction", "doSendText", "getTextInputServiceOrDie", "Landroidx/ui/test/TextInputServiceForTests;", "Landroidx/ui/core/AndroidOwner;", "performImeAction", "performTextClearance", "performTextInput", "performTextReplacement", "sendTextInputCommand", "command", "", "Landroidx/ui/input/EditOperation;", "ui-test_release"})
public final class TextActionsKt {
    public static final void performTextClearance(@NotNull SemanticsNodeInteraction $this$performTextClearance, boolean alreadyHasFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$performTextClearance, (String)"<this>");
        if (!alreadyHasFocus) {
            ActionsKt.performClick($this$performTextClearance);
        }
        TextActionsKt.sendTextInputCommand($this$performTextClearance, CollectionsKt.listOf((Object)new DeleteAllEditOp()));
    }

    public static /* synthetic */ void performTextClearance$default(SemanticsNodeInteraction semanticsNodeInteraction, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        TextActionsKt.performTextClearance(semanticsNodeInteraction, bl);
    }

    public static final void performTextInput(@NotNull SemanticsNodeInteraction $this$performTextInput, @NotNull String text, boolean alreadyHasFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$performTextInput, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!alreadyHasFocus) {
            ActionsKt.performClick($this$performTextInput);
        }
        TextActionsKt.sendTextInputCommand($this$performTextInput, CollectionsKt.listOf((Object)new CommitTextEditOp(text, 1)));
    }

    public static /* synthetic */ void performTextInput$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        TextActionsKt.performTextInput(semanticsNodeInteraction, string, bl);
    }

    public static final void performTextReplacement(@NotNull SemanticsNodeInteraction $this$performTextReplacement, @NotNull String text, boolean alreadyHasFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$performTextReplacement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!alreadyHasFocus) {
            ActionsKt.performClick($this$performTextReplacement);
        }
        Object[] objectArray = new EditOperation[]{(EditOperation)new DeleteAllEditOp(), (EditOperation)new CommitTextEditOp(text, 1)};
        TextActionsKt.sendTextInputCommand($this$performTextReplacement, CollectionsKt.listOf((Object[])objectArray));
    }

    public static /* synthetic */ void performTextReplacement$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        TextActionsKt.performTextReplacement(semanticsNodeInteraction, string, bl);
    }

    public static final void performImeAction(@NotNull SemanticsNodeInteraction $this$performImeAction, boolean alreadyHasFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$performImeAction, (String)"<this>");
        if (!alreadyHasFocus) {
            ActionsKt.performClick($this$performImeAction);
        }
        String errorOnFail = "Failed to perform IME action.";
        SemanticsNode node = $this$performImeAction.fetchSemanticsNode(errorOnFail);
        AssertionsKt.assert($this$performImeAction, FiltersKt.hasInputMethodsSupport(), (Function0<String>)((Function0)new Function0<String>(errorOnFail){
            private final /* synthetic */ String $errorOnFail;
            {
                this.$errorOnFail = $errorOnFail;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$errorOnFail;
            }
        }));
        ImeAction actionSpecified2 = (ImeAction)node.getConfig().getOrElse(TextSemanticsProperties.INSTANCE.getImeAction(), (Function0)performImeAction.actionSpecified.1.INSTANCE);
        if (actionSpecified2 == ImeAction.Unspecified) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage("Failed to perform IME action as current node does not specify any.", $this$performImeAction.getSelector$ui_test_release(), node));
        }
        Owner owner = node.getComponentNode().getOwner();
        if (owner == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.ui.core.AndroidOwner");
        }
        AndroidOwner owner2 = (AndroidOwner)owner;
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(owner2, actionSpecified2){
            private final /* synthetic */ AndroidOwner $owner;
            private final /* synthetic */ ImeAction $actionSpecified;
            {
                this.$owner = $owner;
                this.$actionSpecified = $actionSpecified;
                super(0);
            }

            public final void invoke() {
                TextInputServiceForTests textInputService = TextActionsKt.getTextInputServiceOrDie(this.$owner);
                Function1<ImeAction, Unit> function1 = textInputService.getOnImeActionPerformed();
                if (function1 == null) {
                    throw new IllegalStateException("No input session started. Missing a focus?");
                }
                Function1<ImeAction, Unit> onImeActionPerformed = function1;
                onImeActionPerformed.invoke((Object)this.$actionSpecified);
            }
        });
    }

    public static /* synthetic */ void performImeAction$default(SemanticsNodeInteraction semanticsNodeInteraction, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        TextActionsKt.performImeAction(semanticsNodeInteraction, bl);
    }

    public static final void sendTextInputCommand(@NotNull SemanticsNodeInteraction $this$sendTextInputCommand, @NotNull List<? extends EditOperation> command) {
        Intrinsics.checkNotNullParameter((Object)$this$sendTextInputCommand, (String)"<this>");
        Intrinsics.checkNotNullParameter(command, (String)"command");
        String errorOnFail = "Failed to perform text input.";
        SemanticsNode node = $this$sendTextInputCommand.fetchSemanticsNode(errorOnFail);
        Owner owner = node.getComponentNode().getOwner();
        if (owner == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.ui.core.AndroidOwner");
        }
        AndroidOwner owner2 = (AndroidOwner)owner;
        AssertionsKt.assert($this$sendTextInputCommand, FiltersKt.hasInputMethodsSupport(), (Function0<String>)((Function0)new Function0<String>(errorOnFail){
            private final /* synthetic */ String $errorOnFail;
            {
                this.$errorOnFail = $errorOnFail;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$errorOnFail;
            }
        }));
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(owner2, command){
            private final /* synthetic */ AndroidOwner $owner;
            private final /* synthetic */ List<EditOperation> $command;
            {
                this.$owner = $owner;
                this.$command = $command;
                super(0);
            }

            public final void invoke() {
                TextInputServiceForTests textInputService = TextActionsKt.getTextInputServiceOrDie(this.$owner);
                Function1<List<? extends EditOperation>, Unit> function1 = textInputService.getOnEditCommand();
                if (function1 == null) {
                    throw new IllegalStateException("No input session started. Missing a focus?");
                }
                Function1<List<? extends EditOperation>, Unit> onEditCommand = function1;
                onEditCommand.invoke(this.$command);
            }
        });
    }

    @NotNull
    public static final TextInputServiceForTests getTextInputServiceOrDie(@NotNull AndroidOwner $this$getTextInputServiceOrDie) {
        Intrinsics.checkNotNullParameter((Object)$this$getTextInputServiceOrDie, (String)"<this>");
        TextInputServiceForTests textInputServiceForTests = (TextInputServiceForTests)$this$getTextInputServiceOrDie.getTextInputService();
        if (textInputServiceForTests == null) {
            throw new IllegalStateException("Text input service wrapper not set up! Did you use ComposeTestRule?");
        }
        return textInputServiceForTests;
    }

    @Deprecated(message="Renamed to performTextClearance", replaceWith=@ReplaceWith(expression="performTextClearance(alreadyHasFocus)", imports={}))
    public static final void doClearText(@NotNull SemanticsNodeInteraction $this$doClearText, boolean alreadyHasFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$doClearText, (String)"<this>");
        TextActionsKt.performTextClearance($this$doClearText, alreadyHasFocus);
    }

    public static /* synthetic */ void doClearText$default(SemanticsNodeInteraction semanticsNodeInteraction, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        TextActionsKt.doClearText(semanticsNodeInteraction, bl);
    }

    @Deprecated(message="Renamed to performTextInput", replaceWith=@ReplaceWith(expression="performTextInput(text, alreadyHasFocus)", imports={}))
    public static final void doSendText(@NotNull SemanticsNodeInteraction $this$doSendText, @NotNull String text, boolean alreadyHasFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$doSendText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TextActionsKt.performTextInput($this$doSendText, text, alreadyHasFocus);
    }

    public static /* synthetic */ void doSendText$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        TextActionsKt.doSendText(semanticsNodeInteraction, string, bl);
    }

    @Deprecated(message="Renamed to performTextReplacement", replaceWith=@ReplaceWith(expression="performTextReplacement(text, alreadyHasFocus)", imports={}))
    public static final void doReplaceText(@NotNull SemanticsNodeInteraction $this$doReplaceText, @NotNull String text, boolean alreadyHasFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$doReplaceText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TextActionsKt.performTextReplacement($this$doReplaceText, text, alreadyHasFocus);
    }

    public static /* synthetic */ void doReplaceText$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        TextActionsKt.doReplaceText(semanticsNodeInteraction, string, bl);
    }

    @Deprecated(message="Renamed to performImeAction", replaceWith=@ReplaceWith(expression="performImeAction(alreadyHasFocus)", imports={}))
    public static final void doSendImeAction(@NotNull SemanticsNodeInteraction $this$doSendImeAction, boolean alreadyHasFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$doSendImeAction, (String)"<this>");
        TextActionsKt.performImeAction($this$doSendImeAction, alreadyHasFocus);
    }

    public static /* synthetic */ void doSendImeAction$default(SemanticsNodeInteraction semanticsNodeInteraction, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        TextActionsKt.doSendImeAction(semanticsNodeInteraction, bl);
    }
}

