/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.view.Choreographer;
import androidx.animation.AnimationClockObserver;
import androidx.animation.ManualAnimationClock;
import androidx.ui.test.SynchronizationKt;
import androidx.ui.test.TestAnimationClock;
import androidx.ui.test.android.AndroidTestAnimationClock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0000J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0006\u0010\u0018\u001a\u00020\u0015J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/ui/test/android/AndroidTestAnimationClock;", "Landroidx/ui/test/TestAnimationClock;", "advancedTime", "", "choreographerPaused", "", "clock", "Landroidx/animation/ManualAnimationClock;", "frameCallback", "Landroid/view/Choreographer$FrameCallback;", "isDispatching", "isDisposed", "isIdle", "()Z", "isPaused", "lock", "", "mainChoreographer", "Landroid/view/Choreographer;", "needsToDispatch", "advanceClock", "", "milliseconds", "advanceClockOnMainThread", "dispose", "handleFrameTimeLocked", "frameTimeMillis", "pauseClock", "postFrameCallbackLocked", "resumeClock", "subscribe", "observer", "Landroidx/animation/AnimationClockObserver;", "unsubscribe", "ui-test_release"})
public final class AndroidTestAnimationClock
implements TestAnimationClock {
    private final Choreographer mainChoreographer;
    private final Object lock;
    private final ManualAnimationClock clock;
    private long advancedTime;
    private boolean needsToDispatch;
    private boolean isDispatching;
    private boolean choreographerPaused;
    private boolean isDisposed;
    private final Choreographer.FrameCallback frameCallback;

    public AndroidTestAnimationClock() {
        Choreographer choreographer = (Choreographer)SynchronizationKt.runOnUiThread(mainChoreographer.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)choreographer, (String)"runOnUiThread {\n        Choreographer.getInstance()\n    }");
        this.mainChoreographer = choreographer;
        this.lock = new Object();
        this.clock = new ManualAnimationClock(0L, false);
        this.frameCallback = new Choreographer.FrameCallback(this){
            private final /* synthetic */ AndroidTestAnimationClock $this;
            {
                this.$this = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void doFrame(long frameTimeNanos) {
                Object object = AndroidTestAnimationClock.access$getLock$p(this.$this);
                AndroidTestAnimationClock androidTestAnimationClock = this.$this;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    if (!AndroidTestAnimationClock.access$getChoreographerPaused$p(androidTestAnimationClock)) {
                        AndroidTestAnimationClock.access$handleFrameTimeLocked(androidTestAnimationClock, frameTimeNanos / (long)1000000 + AndroidTestAnimationClock.access$getAdvancedTime$p(androidTestAnimationClock));
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        };
    }

    @Override
    public boolean isPaused() {
        return this.choreographerPaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdle() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean bl4 = this.choreographerPaused || !this.needsToDispatch;
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(@NotNull AnimationClockObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean bl4 = !this.isDisposed;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Can't subscribe to a disposed clock";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.clock.subscribe(observer);
            if (!this.needsToDispatch) {
                this.postFrameCallbackLocked();
                this.needsToDispatch = true;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public void unsubscribe(@NotNull AnimationClockObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.clock.unsubscribe(observer);
    }

    @Override
    public void advanceClock(long milliseconds) {
        boolean bl = milliseconds >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Can only advance the clock forward";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl2 = this.isPaused();
        bl3 = false;
        boolean bl5 = false;
        boolean it = bl2;
        boolean bl6 = false;
        if (!it) {
            this.pauseClock();
        }
        boolean wasPaused = bl2;
        this.advanceClockOnMainThread(0L);
        if (milliseconds > 0L) {
            this.advanceClockOnMainThread(milliseconds);
        }
        if (!wasPaused) {
            this.resumeClock();
        }
    }

    private final void advanceClockOnMainThread(long milliseconds) {
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(this, milliseconds){
            private final /* synthetic */ AndroidTestAnimationClock $this;
            private final /* synthetic */ long $milliseconds;
            {
                this.$this = $receiver;
                this.$milliseconds = $milliseconds;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Object object = AndroidTestAnimationClock.access$getLock$p(this.$this);
                AndroidTestAnimationClock androidTestAnimationClock = this.$this;
                long l = this.$milliseconds;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    boolean bl4 = !AndroidTestAnimationClock.access$isDispatching$p(androidTestAnimationClock);
                    boolean bl5 = false;
                    boolean bl6 = false;
                    if (!bl4) {
                        boolean bl7 = false;
                        String string = "Can't advance clock while dispatching a frame time";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    AndroidTestAnimationClock androidTestAnimationClock2 = androidTestAnimationClock;
                    AndroidTestAnimationClock.access$setAdvancedTime$p(androidTestAnimationClock2, AndroidTestAnimationClock.access$getAdvancedTime$p(androidTestAnimationClock2) + l);
                    AndroidTestAnimationClock.access$handleFrameTimeLocked(androidTestAnimationClock, AndroidTestAnimationClock.access$getClock$p(androidTestAnimationClock).getClockTimeMillis() + l);
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleFrameTimeLocked(long frameTimeMillis) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.isDispatching = true;
            this.clock.setClockTimeMillis(frameTimeMillis);
            this.needsToDispatch = this.clock.getHasObservers();
            if (this.needsToDispatch) {
                this.postFrameCallbackLocked();
            }
            this.isDispatching = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void postFrameCallbackLocked() {
        if (!this.choreographerPaused) {
            this.mainChoreographer.postFrameCallback(this.frameCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseClock() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.mainChoreographer.removeFrameCallback(this.frameCallback);
            this.choreographerPaused = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeClock() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.choreographerPaused) {
                this.choreographerPaused = false;
                if (this.needsToDispatch) {
                    this.postFrameCallbackLocked();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.mainChoreographer.removeFrameCallback(this.frameCallback);
            this.needsToDispatch = false;
            this.isDisposed = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ Object access$getLock$p(AndroidTestAnimationClock $this) {
        return $this.lock;
    }

    public static final /* synthetic */ boolean access$isDispatching$p(AndroidTestAnimationClock $this) {
        return $this.isDispatching;
    }

    public static final /* synthetic */ void access$setAdvancedTime$p(AndroidTestAnimationClock $this, long l) {
        $this.advancedTime = l;
    }

    public static final /* synthetic */ long access$getAdvancedTime$p(AndroidTestAnimationClock $this) {
        return $this.advancedTime;
    }

    public static final /* synthetic */ void access$handleFrameTimeLocked(AndroidTestAnimationClock $this, long frameTimeMillis) {
        $this.handleFrameTimeLocked(frameTimeMillis);
    }

    public static final /* synthetic */ ManualAnimationClock access$getClock$p(AndroidTestAnimationClock $this) {
        return $this.clock;
    }

    public static final /* synthetic */ boolean access$getChoreographerPaused$p(AndroidTestAnimationClock $this) {
        return $this.choreographerPaused;
    }
}

